/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.quotation.StageUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.customer.AddressCommon;
import de.qfm.erp.common.response.customer.ContactPersonCommon;
import de.qfm.erp.common.response.customer.CustomerCommon;
import de.qfm.erp.common.response.filestore.FileStoreCommon;
import de.qfm.erp.common.response.project.ProjectCommon;
import de.qfm.erp.common.response.project.SubProjectCommon;
import de.qfm.erp.common.response.quotation.AddendumDiscountCommon;
import de.qfm.erp.common.response.quotation.StageCommon;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionSequentialNumberComparator;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.StageMergeResult;
import de.qfm.erp.service.model.internal.invoice.AddendumDiscount;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.quotation.EQuotationFlag;
import de.qfm.erp.service.model.internal.quotation.EStagePositionSortOption;
import de.qfm.erp.service.model.internal.quotation.QStagePositionUpdateBucket;
import de.qfm.erp.service.model.internal.quotation.QStagePositionsUpdateBucket;
import de.qfm.erp.service.model.internal.quotation.QuotationBucket;
import de.qfm.erp.service.model.internal.quotation.StageUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.project.SubProject;
import de.qfm.erp.service.model.jpa.quotation.ECommissionType;
import de.qfm.erp.service.model.jpa.quotation.EER2ExportState;
import de.qfm.erp.service.model.jpa.quotation.EInquiryReceiveType;
import de.qfm.erp.service.model.jpa.quotation.EInquiryType;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EQuotationSubmissionType;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationBoQ;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.quotation.StageInvoiceSupplement;
import de.qfm.erp.service.model.jpa.quotation.StageNotifyUser;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.quotation.StageSignatureUser;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.CustomerMapper;
import de.qfm.erp.service.service.mapper.FileStoreMapper;
import de.qfm.erp.service.service.mapper.ProjectMapper;
import de.qfm.erp.service.service.mapper.StageInvoiceSupplementMapper;
import de.qfm.erp.service.service.mapper.StagePositionMapper;
import de.qfm.erp.service.service.mapper.StageUserMapper;
import de.qfm.erp.service.service.mapper.SubProjectMapper;
import de.qfm.erp.service.service.mapper.UserMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageHeadMapper {
    private static final Logger log = LogManager.getLogger(StageHeadMapper.class);
    public static final Ordering<@Nullable Comparable> SUB_POS_ORDERING = Ordering.natural().nullsLast();
    private final AuthenticationHelper authenticationHelper;
    private final DateTimeHelperService dateTimeHelperService;
    private final UserService userService;
    private final EntityFactory entityFactory;
    private final CustomerMapper customerMapper;
    private final FileStoreMapper fileStoreMapper;
    private final ProjectMapper projectMapper;
    private final SubProjectMapper subProjectMapper;
    private final StageUserMapper stageUserMapper;
    private final StagePositionMapper positionMapper;
    private final UserMapper userMapper;
    private final StageInvoiceSupplementMapper stageInvoiceSupplementMapper;
    @NonNull
    public static final BiConsumer<QuotationPosition, QStagePositionUpdateBucket> NOOP_UB = (laborUnionWageGroupRate, updateentity) -> {};

    @Nonnull
    public StageCommon mapToCommon(@NonNull QuotationBucket bucket, boolean includeAllPos) {
        Invoice finalInvoice;
        Invoice lastInvoice;
        ContactPerson contactPerson;
        Address address;
        Customer customer;
        Address agentInvoiceAddress;
        Customer agentInvoice;
        Address customerInvoiceAddress;
        Customer customerInvoice;
        QEntity entity;
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        Quotation stage = bucket.getQuotation();
        Project project = stage.getProject();
        StageCommon common = new StageCommon();
        BaseMapper.map((EntityBase)stage, (EntityBaseCommon)common);
        common.setId(stage.getId());
        EQStageType stageType = (EQStageType)MoreObjects.firstNonNull((Object)stage.getStageType(), (Object)EQStageType.UNKNOWN);
        common.setStageType(stageType.name());
        EQStageState stageState = (EQStageState)MoreObjects.firstNonNull((Object)stage.getStageState(), (Object)EQStageState.UNKNOWN);
        common.setStageState(stageState.name());
        common.setStageStateSince(stage.getStageStateSince());
        common.setArchiveReason(stage.getArchiveReason());
        EStagePositionSortOption stagePositionSortOption = (EStagePositionSortOption)MoreObjects.firstNonNull((Object)stage.getStagePositionSortOption(), (Object)EStagePositionSortOption.NONE);
        common.setStagePositionSortOption(stagePositionSortOption.name());
        if (null != project) {
            ProjectCommon projectCommon = this.projectMapper.map(project);
            common.setProject(projectCommon);
        }
        if (null != (entity = stage.getQEntity())) {
            common.setQentityId(entity.getId());
            common.setQentityQEntityNumber(entity.getQNumber());
            common.setQentityAlias(entity.getAlias());
        }
        common.setAbsoluteClientHomeFolder(bucket.getAbsoluteClientHomeFolder());
        common.setAbsoluteServerHomeFolder(bucket.getAbsoluteServerHomeFolder());
        SubProject subProject = stage.getSubProject();
        if (null != subProject) {
            SubProjectCommon subProjectCommon = this.subProjectMapper.map(subProject);
            common.setSubProject(subProjectCommon);
        }
        common.setQentityNumber(stage.getQNumber());
        common.setAlias(stage.getAlias());
        String text = StageHelper.stageText((Quotation)stage, (boolean)false);
        common.setText(text);
        common.setVersion(stage.getVersion());
        common.setVersionSince(stage.getVersionSince());
        EStageOrigin origin = (EStageOrigin)MoreObjects.firstNonNull((Object)stage.getOrigin(), (Object)EStageOrigin.UNKNOWN);
        common.setOrigin(origin.name());
        Quotation reference = stage.getReference();
        if (null != reference) {
            common.setReferenceId(reference.getId());
        }
        common.setFlagWithoutDeadline(stage.getFlagWithoutSubmissionDeadline());
        common.setPlannedSubmissionDate(stage.getPlannedSubmissionDate());
        common.setSubmissionDateTime(stage.getSubmissionDateTime());
        common.setSubmissionOfBidDate(stage.getSubmissionOfBidDate());
        common.setProcurementNumber(stage.getProcurementNumber());
        common.setInquiryDate(stage.getInquiryDate());
        common.setBindingPeriodDate(stage.getBindingPeriodDate());
        common.setFlagB2B((Boolean)MoreObjects.firstNonNull((Object)stage.getFlagB2B(), (Object)false));
        common.setFlagPositionGridLocked((Boolean)MoreObjects.firstNonNull((Object)stage.getFlagPositionGridLocked(), (Object)false));
        common.setFlagCrossVersionOrderValue((Boolean)MoreObjects.firstNonNull((Object)stage.getFlagCrossVersionOrderValue(), (Object)false));
        common.setFlagBudgetRelevant((Boolean)MoreObjects.firstNonNull((Object)stage.getFlagBudgetRelevant(), (Object)false));
        EInquiryType inquiryType = (EInquiryType)MoreObjects.firstNonNull((Object)stage.getInquiryType(), (Object)EInquiryType.UNKNOWN);
        common.setInquiryType(inquiryType.name());
        EInquiryReceiveType inquiryReceiveType = (EInquiryReceiveType)MoreObjects.firstNonNull((Object)stage.getInquiryReceiveType(), (Object)EInquiryReceiveType.UNKNOWN);
        common.setInquiryReceiveType(inquiryReceiveType.name());
        EQuotationSubmissionType quotationSubmissionType = (EQuotationSubmissionType)MoreObjects.firstNonNull((Object)stage.getQuotationSubmissionType(), (Object)EQuotationSubmissionType.UNKNOWN);
        common.setQuotationSubmissionType(quotationSubmissionType.name());
        ECommissionType commissionType = (ECommissionType)MoreObjects.firstNonNull((Object)stage.getCommissionType(), (Object)ECommissionType.UNKNOWN);
        common.setCommissionType(commissionType.name());
        common.setCommissionDate(stage.getCommissionDate());
        common.setGracePeriodDate(stage.getGracePeriodDate());
        Iterable addendumDiscounts = bucket.getAddendumDiscounts();
        List addendumDiscountsCommon = (List)IterableHelper.stream((Iterable)addendumDiscounts).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        common.setAddendumDiscounts(addendumDiscountsCommon);
        common.setQuotationName(stage.getQuotationName());
        common.setQuotationNumber(stage.getQuotationNumber());
        common.setAddendumNumber(stage.getAddendumNumber());
        common.setQuotationDate(stage.getQuotationDate());
        common.setQuotationOpeningDate(stage.getQuotationOpeningDate());
        common.setOrderNumber(stage.getOrderNumber());
        common.setOrderDescription(stage.getOrderDescription());
        common.setOrderDescriptionCustomer(stage.getOrderDescriptionCustomer());
        common.setOrderDescriptionInternal(stage.getOrderDescriptionInternal());
        common.setProjectExecutionStartDate(stage.getProjectExecutionStartDate());
        common.setProjectExecutionEndDate(stage.getProjectExecutionEndDate());
        common.setQuotationProjectExecutionStartDate(stage.getQuotationProjectExecutionStartDate());
        common.setQuotationProjectExecutionEndDate(stage.getQuotationProjectExecutionEndDate());
        common.setAccountingFlag(stage.getAccountingFlag());
        common.setAccountingText(stage.getAccountingText());
        common.setCostCenterInternal(stage.getCostCenterInternal());
        common.setCostCenterExternal(stage.getCostCenterExternal());
        QuotationBoQ lastQuotationBoQ = stage.getLastQuotationBoQ();
        if (null != lastQuotationBoQ) {
            FileStore boqFile = lastQuotationBoQ.getBoqFile();
            if (null != boqFile) {
                FileStoreCommon boqFileCommon = this.fileStoreMapper.map(boqFile);
                common.setBoqFile(boqFileCommon);
            }
            common.setBoqProjectName(lastQuotationBoQ.getBoqProjectName());
            common.setBoqProjectLabel(lastQuotationBoQ.getBoqProjectLabel());
            common.setBoqDescription(lastQuotationBoQ.getBoqDescription());
        }
        if (null != (customerInvoice = stage.getCustomerInvoice())) {
            common.setCustomerInvoiceId(customerInvoice.getId());
        }
        if (null != (customerInvoiceAddress = stage.getCustomerInvoiceAddress())) {
            common.setCustomerInvoiceAddressId(customerInvoiceAddress.getId());
        }
        if (null != (agentInvoice = stage.getAgentInvoice())) {
            common.setAgentInvoiceId(agentInvoice.getId());
        }
        if (null != (agentInvoiceAddress = stage.getAgentInvoiceAddress())) {
            common.setAgentInvoiceAddressId(agentInvoiceAddress.getId());
        }
        if (null != (customer = stage.getCustomer())) {
            CustomerCommon customerCommon = this.customerMapper.map(customer, false, false);
            common.setCustomer(customerCommon);
        }
        if (null != (address = stage.getAddress())) {
            AddressCommon addressCommon = this.customerMapper.map(address);
            common.setAddress(addressCommon);
        }
        if (null != (contactPerson = stage.getContactPerson())) {
            ContactPersonCommon contactPersonCommon = this.customerMapper.map(contactPerson);
            common.setContactPerson(contactPersonCommon);
        }
        if (null != (lastInvoice = stage.getLastInvoice())) {
            common.setLastInvoiceId(lastInvoice.getId());
        }
        if (null != (finalInvoice = stage.getFinalInvoice())) {
            common.setFinalInvoiceId(finalInvoice.getId());
        }
        Iterable qStageNotifyUsers = (Iterable)MoreObjects.firstNonNull((Object)stage.getStageNotifyUsers(), (Object)ImmutableSet.of());
        Iterable notifyUsers = (Iterable)IterableHelper.stream((Iterable)qStageNotifyUsers).map(StageNotifyUser::getUser).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        List notifyUsersCommon = this.userMapper.mapUser(notifyUsers);
        common.setNotifyUsers(notifyUsersCommon);
        Iterable stageResponsibleUsers = (Iterable)MoreObjects.firstNonNull((Object)stage.getStageResponsibleUsers(), (Object)ImmutableSet.of());
        Iterable responsibleUsers = (Iterable)IterableHelper.stream((Iterable)stageResponsibleUsers).map(StageResponsibleUser::getUser).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        List responsibleUsersCommon = this.userMapper.mapUser(responsibleUsers);
        common.setResponsibleUsers(responsibleUsersCommon);
        Iterable stageSignatureUsers = (Iterable)MoreObjects.firstNonNull((Object)stage.getStageSignatureUsers(), (Object)ImmutableSet.of());
        Iterable signatureUsers = (Iterable)IterableHelper.stream((Iterable)stageSignatureUsers).map(StageSignatureUser::getUser).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        List signatureUsersCommon = this.userMapper.mapUser(signatureUsers);
        common.setSignatureUsers(signatureUsersCommon);
        Iterable stageInvoiceSupplements = (Iterable)MoreObjects.firstNonNull((Object)stage.getStageInvoiceSupplements(), (Object)ImmutableSet.of());
        List stageInvoiceSupplementCommons = this.stageInvoiceSupplementMapper.map(stageInvoiceSupplements);
        common.setInvoiceSupplements(stageInvoiceSupplementCommons);
        common.setHeadlineG1(stage.getHeadlineG1());
        common.setHeadlineG1Align(stage.getHeadlineG1Align());
        common.setHeadlineG1Length(stage.getHeadlineG1Length());
        common.setHeadlineG1IsNumeric(stage.getHeadlineG1IsNumeric());
        common.setHeadlineG2(stage.getHeadlineG2());
        common.setHeadlineG2Align(stage.getHeadlineG2Align());
        common.setHeadlineG2Length(stage.getHeadlineG2Length());
        common.setHeadlineG2IsNumeric(stage.getHeadlineG2IsNumeric());
        common.setHeadlineG3(stage.getHeadlineG3());
        common.setHeadlineG3Align(stage.getHeadlineG3Align());
        common.setHeadlineG3Length(stage.getHeadlineG3Length());
        common.setHeadlineG3IsNumeric(stage.getHeadlineG3IsNumeric());
        common.setHeadlineG4(stage.getHeadlineG4());
        common.setHeadlineG4Align(stage.getHeadlineG4Align());
        common.setHeadlineG4Length(stage.getHeadlineG4Length());
        common.setHeadlineG4IsNumeric(stage.getHeadlineG4IsNumeric());
        common.setHeadlineG5(stage.getHeadlineG5());
        common.setHeadlineG5Align(stage.getHeadlineG5Align());
        common.setHeadlineG5Length(stage.getHeadlineG5Length());
        common.setHeadlineG5IsNumeric(stage.getHeadlineG5IsNumeric());
        common.setItemFormatG1(stage.getItemFormatG1());
        common.setItemFormatG1Length(stage.getItemFormatG1Length());
        common.setItemFormatG1IsNumeric(stage.getItemFormatG1IsNumeric());
        common.setItemFormatG1Align(stage.getItemFormatG1Align());
        common.setItemFormatG2(stage.getItemFormatG2());
        common.setItemFormatG2Length(stage.getItemFormatG2Length());
        common.setItemFormatG2IsNumeric(stage.getItemFormatG2IsNumeric());
        common.setItemFormatG2Align(stage.getItemFormatG2Align());
        common.setX83ProjectLabel(stage.getX83ProjectLabel());
        common.setX83ProjectName(stage.getX83ProjectName());
        common.setX83ProjectCurrency(stage.getX83ProjectCurrency());
        common.setX83ProjectCurrencyLabel(stage.getX83ProjectCurrencyLabel());
        common.setX83BoqInfoDate(stage.getX83BoqInfoDate());
        common.setX83BoqName(stage.getX83BoqName());
        common.setX83BoqLabel(stage.getX83BoqLabel());
        common.setX83BoqAwardCurrency(stage.getX83BoqAwardCurrency());
        common.setX83BoqAwardCurrencyLabel(stage.getX83BoqAwardCurrencyLabel());
        common.setFlagOrderEnd(stage.getFlagOrderEnd());
        common.setFlagCommissionIdenticalToQuotation(stage.getFlagOrderEqualsQuotation());
        common.setFlagMeasurementWithoutCommissionNumberAllowed(stage.getFlagMeasurementWithoutCommissionNumberAllowed());
        common.setFlagReleaseOrderOrderNumberMandatory(stage.getFlagReleaseOrderOrderNumberMandatory());
        common.setFlagApplyDiscountToFeePositions(stage.getFlagDiscountFeePositions());
        common.setFlagB2B((Boolean)MoreObjects.firstNonNull((Object)stage.getFlagB2B(), (Object)false));
        common.setFlagPositionGridLocked((Boolean)MoreObjects.firstNonNull((Object)stage.getFlagPositionGridLocked(), (Object)false));
        common.setFlagCrossVersionOrderValue((Boolean)MoreObjects.firstNonNull((Object)stage.getFlagCrossVersionOrderValue(), (Object)false));
        common.setFlagBudgetRelevant((Boolean)MoreObjects.firstNonNull((Object)stage.getFlagBudgetRelevant(), (Object)false));
        common.setFinanceCompanyNumber(stage.getFinanceCompanyNumber());
        common.setFinanceAccountingText(stage.getFinanceAccountingText());
        common.setFinanceTimeForPayment(stage.getFinanceTimeForPayment());
        common.setFinanceCashDiscountTime1(stage.getFinanceCashDiscountTime1());
        common.setFinanceCashDiscount1(stage.getFinanceCashDiscount1());
        common.setFinanceCashDiscountTime2(stage.getFinanceCashDiscountTime2());
        common.setFinanceCashDiscount2(stage.getFinanceCashDiscount2());
        common.setFinanceDebtorAccountNumber(stage.getFinanceDebtorAccountNumber());
        common.setFinanceCostUnit(stage.getFinanceCostUnit());
        TaxKey financeTaxKey = stage.getFinanceTaxKey();
        if (null != financeTaxKey) {
            common.setFinanceTaxKeyId(financeTaxKey.getId());
        }
        common.setFinanceTaxKey(stage.getFinanceTaxKeyValue());
        common.setFinanceAccount(stage.getFinanceAccount());
        common.setVatPercent(stage.getVatPercent());
        EInvoiceType financeDefaultInvoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)stage.getFinanceDefaultInvoiceType(), (Object)EInvoiceType.UNKNOWN);
        common.setFinanceDefaultInvoiceType(financeDefaultInvoiceType.name());
        EPdfExtractType pdfExtractType = (EPdfExtractType)MoreObjects.firstNonNull((Object)stage.getPdfExtractType(), (Object)EPdfExtractType.NONE);
        common.setPdfExtractType(pdfExtractType.name());
        common.setFinanceFlagSubcontractor((Boolean)MoreObjects.firstNonNull((Object)stage.getFinanceFlagSubcontractor(), (Object)Boolean.FALSE));
        common.setFinanceRoutingReferenceId(StringUtils.trimToEmpty((String)stage.getFinanceRoutingReferenceId()));
        common.setGeneralDiscount(stage.getGeneralDiscount());
        common.setOtherDiscount(stage.getOtherDiscount());
        common.setCoverLetterSubject1(stage.getCoverLetterSubject1st());
        common.setCoverLetterSubject2(stage.getCoverLetterSubject2nd());
        common.setCoverLetterTitle(stage.getCoverLetterTitle());
        common.setCoverLetterBody1(stage.getCoverLetterBody1());
        common.setCoverLetterBody2(stage.getCoverLetterBody2());
        common.setCoverLetterBody3(stage.getCoverLetterBody3());
        common.setRemarks(stage.getRemarks());
        boolean hasValuePrivilege = this.userService.hasPrivilege(EPrivilege.QUOTATION__ALL_ATTRIBUTES_VISIBLE);
        if (hasValuePrivilege) {
            common.setValueAggregated(stage.getValueAggregated());
            common.setMaterialValueAggregated(stage.getMaterialValueAggregated());
            BigDecimal orderValue = stage.getOrderValue();
            common.setOrderValue(orderValue);
            common.setOrderValueWithDiscount(stage.getOrderValueWithDiscount());
            BigDecimal orderValueEstimate = stage.getOrderValueEstimate();
            common.setOrderValueEstimate(orderValueEstimate);
            common.setPriceAggregated(stage.getPriceAggregated());
            common.setBudgetAllowedOverdraftPercent(stage.getBudgetAllowedOverdraftPercent());
            common.setBudgetAllowedOverdraftValue(stage.getBudgetAllowedOverdraftValue());
            common.setBudget(stage.getBudget());
            common.setMaterialPercentageMin(stage.getMaterialPercentageMin());
            common.setMaterialPercentageStandard(stage.getMaterialPercentageStandard());
            common.setWagePercentageMin(stage.getWagePercentageMin());
            common.setWagePercentageStandard(stage.getWagePercentageStandard());
            common.setFulfillmentSecurityRetentionPercent(stage.getFulfillmentSecurityRetentionPercent());
            common.setWarrantySecurityRetentionPercent(stage.getWarrantySecurityRetentionPercent());
            common.setWageValueAggregated(stage.getWageValueAggregated());
            common.setPriceWithoutDiscountSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getPriceWithoutDiscountSum(), (Object)BigDecimal.ZERO));
            common.setPriceWithDiscountSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getPriceWithDiscountSum(), (Object)BigDecimal.ZERO));
            common.setSquadWageSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getSquadWageSum(), (Object)BigDecimal.ZERO));
            common.setCompanyWageSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getCompanyWageSum(), (Object)BigDecimal.ZERO));
            common.setMaterialPurchasePriceSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getMaterialPurchasePriceSum(), (Object)BigDecimal.ZERO));
            common.setMaterialSellingPriceSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getMaterialSellingPriceSum(), (Object)BigDecimal.ZERO));
            common.setExternalServicePurchasePriceSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getExternalServicePurchasePriceSum(), (Object)BigDecimal.ZERO));
            common.setExternalServiceSellingPriceSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getExternalServiceSellingPriceSum(), (Object)BigDecimal.ZERO));
            common.setWagePercentageWeightedAverage((BigDecimal)MoreObjects.firstNonNull((Object)stage.getWagePercentageWeightedAverage(), (Object)BigDecimal.ZERO));
            common.setMaterialPercentageWeightedAverage((BigDecimal)MoreObjects.firstNonNull((Object)stage.getMaterialPercentageWeightedAverage(), (Object)BigDecimal.ZERO));
            common.setExternalServicePercentageWeightedAverage((BigDecimal)MoreObjects.firstNonNull((Object)stage.getExternalServicePercentageWeightedAverage(), (Object)BigDecimal.ZERO));
            common.setVatValueWithoutDiscountSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getVatValueWithoutDiscountSum(), (Object)BigDecimal.ZERO));
            common.setVatValueWithDiscountSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getVatValueWithDiscountSum(), (Object)BigDecimal.ZERO));
            common.setPriceGrossWithoutDiscountSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getPriceGrossWithoutDiscountSum(), (Object)BigDecimal.ZERO));
            common.setPriceGrossWithDiscountSum((BigDecimal)MoreObjects.firstNonNull((Object)stage.getPriceGrossWithDiscountSum(), (Object)BigDecimal.ZERO));
        }
        common.setPositions(this.positionMapper.mapPositionItemToCommon(bucket, includeAllPos));
        HashSet allQuotationFlags = Sets.newHashSet();
        if (Boolean.TRUE == stage.getFlagB2B()) {
            allQuotationFlags.add(EQuotationFlag.B2B);
        }
        if (Boolean.TRUE == stage.getFlagOrderEnd()) {
            allQuotationFlags.add(EQuotationFlag.ORDER_END);
        }
        if (Boolean.TRUE == stage.getFlagOrderEqualsQuotation()) {
            allQuotationFlags.add(EQuotationFlag.ORDER_EQUALS_QUOTATION);
        }
        if (Boolean.TRUE == stage.getFlagMeasurementWithoutCommissionNumberAllowed()) {
            allQuotationFlags.add(EQuotationFlag.MEASUREMENT_WITHOUT_COMMISSION_ALLOWED);
        }
        ImmutableList flagNames = ImmutableList.copyOf(IterableHelper.stream((Iterable)allQuotationFlags).map(Enum::name).iterator());
        common.setFlags((List)flagNames);
        common.setNotifyUsersText(stage.getStageNotifyUsersText());
        common.setSignatureUsersText(stage.getStageSignatureUsersText());
        common.setResponsibleUsersText(stage.getStageResponsibleUsersText());
        common.setEr2ExportedOn(stage.getEr2ExportedOn());
        common.setEr2ExportedToPath(stage.getEr2ExportedToPath());
        EER2ExportState er2ExportState = (EER2ExportState)MoreObjects.firstNonNull((Object)stage.getEr2ExportState(), (Object)EER2ExportState.UNKNOWN);
        String er2ExportStateStr = er2ExportState.name();
        common.setEr2ExportState(er2ExportStateStr);
        return common;
    }

    @Nonnull
    public Quotation mergeQStage(@NonNull StageUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        StageUpdateRequest updateRequest = (StageUpdateRequest)updateBucket.getRequest();
        Quotation stage = (Quotation)updateBucket.getEntity();
        TaxKey taxKey = updateBucket.getTaxKey();
        Customer customer = updateBucket.getCustomer();
        Address address = updateBucket.getAddress();
        ContactPerson contactPerson = updateBucket.getContactPerson();
        Customer invoiceCustomer = updateBucket.getCustomerInvoice();
        Customer invoiceAgent = updateBucket.getAgentInvoice();
        Address invoiceCustomerAddress = updateBucket.getCustomerInvoiceAddress();
        Address invoiceAgentAddress = updateBucket.getAgentInvoiceAddress();
        SubProject subProject = updateBucket.getSubProject();
        EInquiryType inquiryType = updateBucket.getInquiryType();
        EInquiryReceiveType inquiryReceiveType = updateBucket.getInquiryReceiveType();
        EQuotationSubmissionType quotationSubmissionType = updateBucket.getQuotationSubmissionType();
        ECommissionType commissionType = updateBucket.getCommissionType();
        EInvoiceType defaultInvoiceType = updateBucket.getDefaultInvoiceType();
        EPdfExtractType pdfExtractType = updateBucket.getPdfExtractType();
        EStagePositionSortOption stagePositionSortOptionCand = updateBucket.getStagePositionSortOption();
        EStagePositionSortOption stagePositionSortOption = EStagePositionSortOption.NONE == stagePositionSortOptionCand ? EStagePositionSortOption.AUTOMATIC : stagePositionSortOptionCand;
        stage.setReferenceId(UUID.randomUUID().toString());
        stage.setQuotationName(updateRequest.getQuotationName());
        StageHelper.ensureQuotationNumber((Quotation)stage);
        stage.setAddendumNumber(updateRequest.getAddendumNumber());
        stage.setFlagWithoutSubmissionDeadline((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagWithoutDeadline(), (Object)false));
        LocalDateTime submissionDateTime = updateRequest.getSubmissionDateTime();
        LocalDateTime localSubmissionDateTime = this.dateTimeHelperService.convertToUTCNullSafe(submissionDateTime);
        stage.setSubmissionDateTime(localSubmissionDateTime);
        stage.setProcurementNumber(StringUtils.trimToEmpty((String)updateRequest.getProcurementNumber()));
        stage.setInquiryDate(updateRequest.getInquiryDate());
        stage.setPlannedSubmissionDate(updateRequest.getPlannedSubmissionDate());
        stage.setBindingPeriodDate(updateRequest.getBindingPeriodDate());
        stage.setValueAggregated(updateRequest.getValueAggregated());
        stage.setMaterialValueAggregated(updateRequest.getMaterialValueAggregated());
        stage.setWageValueAggregated(updateRequest.getWageValueAggregated());
        stage.setPriceAggregated(updateRequest.getPriceAggregated());
        stage.setOrderValue(updateRequest.getOrderValue());
        stage.setOrderValueEstimate(updateRequest.getOrderValueEstimate());
        stage.setBudgetAllowedOverdraftValue(updateRequest.getBudgetAllowedOverdraftValue());
        stage.setBudgetAllowedOverdraftPercent(updateRequest.getBudgetAllowedOverdraftPercent());
        stage.setMaterialPercentageMin(updateBucket.getMaterialPercentageMin());
        stage.setMaterialPercentageStandard(updateBucket.getMaterialPercentageStandard());
        stage.setWagePercentageMin(updateBucket.getWagePercentageMin());
        stage.setWagePercentageStandard(updateBucket.getWagePercentageStandard());
        stage.setWarrantySecurityRetentionPercent(updateRequest.getWarrantySecurityRetentionPercent());
        stage.setFulfillmentSecurityRetentionPercent(updateRequest.getFulfillmentSecurityRetentionPercent());
        stage.setAddendumNumber(updateRequest.getAddendumNumber());
        stage.setQuotationDate(updateRequest.getQuotationDate());
        stage.setQuotationOpeningDate(updateRequest.getQuotationOpeningDate());
        stage.setOrderDate(updateRequest.getOrderDate());
        stage.setOrderNumber(updateRequest.getOrderNumber());
        stage.setOrderDescription(StringUtils.left((String)updateRequest.getOrderDescriptionCustomer(), (int)50));
        stage.setOrderDescriptionCustomer(updateRequest.getOrderDescriptionCustomer());
        stage.setOrderDescriptionInternal(updateRequest.getOrderDescriptionInternal());
        stage.setProjectExecutionStartDate(updateRequest.getProjectExecutionStartDate());
        stage.setProjectExecutionEndDate(updateRequest.getProjectExecutionEndDate());
        stage.setQuotationProjectExecutionStartDate(updateRequest.getQuotationProjectExecutionStartDate());
        stage.setQuotationProjectExecutionEndDate(updateRequest.getQuotationProjectExecutionEndDate());
        stage.setInquiryType(inquiryType);
        stage.setInquiryReceiveType(inquiryReceiveType);
        stage.setQuotationSubmissionType(quotationSubmissionType);
        stage.setCommissionType(commissionType);
        stage.setCommissionDate(updateRequest.getCommissionDate());
        stage.setGracePeriodDate(updateRequest.getGracePeriodDate());
        stage.setAccountingFlag(updateRequest.getAccountingFlag());
        stage.setAccountingText(updateRequest.getAccountingText());
        stage.setCostCenterInternal(updateRequest.getCostCenterInternal());
        stage.setCostCenterExternal(updateRequest.getCostCenterExternal());
        stage.setCustomerEmail(updateRequest.getCustomerEmail());
        stage.setCustomer(customer);
        stage.setAddress(address);
        stage.setContactPerson(contactPerson);
        stage.setCustomerInvoice(invoiceCustomer);
        stage.setCustomerInvoiceAddress(invoiceCustomerAddress);
        stage.setAgentInvoice(invoiceAgent);
        stage.setAgentInvoiceAddress(invoiceAgentAddress);
        stage.setSubProject(subProject);
        stage.setFlagConstantCompanyWage((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagConstantCompanyWage(), (Object)false));
        stage.setFlagOrderEnd((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagOrderEnd(), (Object)false));
        stage.setFlagOrderEqualsQuotation((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagOrderEqualsQuotation(), (Object)false));
        stage.setFlagSquadIsAllowedToCreateReleaseOrder((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagSquadIsAllowedToCreateReleaseOrder(), (Object)true));
        if (this.userService.hasPrivilege(EPrivilege.Q_MODULE__STAGE__SET_FLAG_ALLOW_MEASUREMENTS_WITHOUT_COMMISSION)) {
            stage.setFlagMeasurementWithoutCommissionNumberAllowed((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagMeasurementWithoutCommissionNumberAllowed(), (Object)false));
        }
        stage.setFlagReleaseOrderOrderNumberMandatory((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagReleaseOrderOrderNumberMandatory(), (Object)false));
        stage.setFlagAutomaticWageAssignmentAllowed((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagAutomaticWageAssignmentAllowed(), (Object)true));
        stage.setFlagDiscountFeePositions((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagApplyDiscountToFeePositions(), (Object)false));
        stage.setFlagB2B((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagB2B(), (Object)false));
        stage.setFlagPositionGridLocked((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagPositionGridLocked(), (Object)false));
        stage.setFlagBudgetRelevant((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagBudgetRelevant(), (Object)false));
        stage.setFlagCrossVersionOrderValue((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagCrossVersionOrderValue(), (Object)false));
        stage.setFinanceCompanyNumber(updateRequest.getFinanceCompanyNumber());
        stage.setFinanceAccountingText(updateRequest.getFinanceAccountingText());
        stage.setFinanceTimeForPayment(updateRequest.getFinanceTimeForPayment());
        stage.setFinanceCashDiscountTime1(updateRequest.getFinanceCashDiscountTime1());
        stage.setFinanceCashDiscount1(updateRequest.getFinanceCashDiscount1());
        stage.setFinanceCashDiscountTime2(updateRequest.getFinanceCashDiscountTime2());
        stage.setFinanceCashDiscount2(updateRequest.getFinanceCashDiscount2());
        stage.setFinanceDebtorAccountNumber(updateRequest.getFinanceDebtorAccountNumber());
        stage.setFinanceTaxKeyValue(updateRequest.getFinanceTaxKeyValue());
        stage.setFinanceAccount(updateRequest.getFinanceAccount());
        stage.setFinanceCostUnit(updateRequest.getFinanceCostUnit());
        stage.setVatPercent(updateRequest.getVatPercent());
        stage.setFinanceDefaultInvoiceType(defaultInvoiceType);
        stage.setPdfExtractType(pdfExtractType);
        stage.setFinanceFlagSubcontractor((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFinanceFlagSubcontractor(), (Object)Boolean.FALSE));
        stage.setFinanceRoutingReferenceId(StringUtils.trimToEmpty((String)updateRequest.getFinanceRoutingReferenceId()));
        stage.setFinanceTaxKey(taxKey);
        stage.setGeneralDiscount(updateRequest.getGeneralDiscount());
        stage.setOtherDiscount(updateRequest.getOtherDiscount());
        stage.setStagePositionSortOption(stagePositionSortOption);
        String coverLetterSubject1stNew = StringUtils.trimToEmpty((String)updateRequest.getCoverLetterSubject1());
        String coverLetterSubject1stOld = StringUtils.trimToEmpty((String)stage.getCoverLetterSubject1st());
        boolean coverLetterSubject1stChanged = StageHeadMapper.boilerPlateChanged((String)coverLetterSubject1stNew, (String)coverLetterSubject1stOld);
        stage.setCoverLetterSubject1st(coverLetterSubject1stNew);
        stage.setCoverLetterSubject1stChanged(Boolean.valueOf(coverLetterSubject1stChanged));
        String coverLetterSubject2ndNew = StringUtils.trimToEmpty((String)updateRequest.getCoverLetterSubject2());
        String coverLetterSubject2ndOld = StringUtils.trimToEmpty((String)stage.getCoverLetterSubject2nd());
        boolean coverLetterSubject2ndChanged = StageHeadMapper.boilerPlateChanged((String)coverLetterSubject2ndNew, (String)coverLetterSubject2ndOld);
        stage.setCoverLetterSubject2nd(coverLetterSubject2ndNew);
        stage.setCoverLetterSubject2ndChanged(Boolean.valueOf(coverLetterSubject2ndChanged));
        String coverLetterTitleNew = StringUtils.trimToEmpty((String)updateRequest.getCoverLetterTitle());
        String coverLetterTitleOld = StringUtils.trimToEmpty((String)stage.getCoverLetterTitle());
        boolean coverLetterTitleChanged = StageHeadMapper.boilerPlateChanged((String)coverLetterTitleNew, (String)coverLetterTitleOld);
        stage.setCoverLetterTitle(coverLetterTitleNew);
        stage.setCoverLetterTitleChanged(Boolean.valueOf(coverLetterTitleChanged));
        String coverLetterBody1New = StringUtils.trimToEmpty((String)updateRequest.getCoverLetterBody1());
        String coverLetterBody1Old = StringUtils.trimToEmpty((String)stage.getCoverLetterBody1());
        boolean coverLetterBody1Changed = StageHeadMapper.boilerPlateChanged((String)coverLetterBody1New, (String)coverLetterBody1Old);
        stage.setCoverLetterBody1(coverLetterBody1New);
        stage.setCoverLetterBody1Changed(Boolean.valueOf(coverLetterBody1Changed));
        String coverLetterBody2New = StringUtils.trimToEmpty((String)updateRequest.getCoverLetterBody2());
        String coverLetterBody2Old = StringUtils.trimToEmpty((String)stage.getCoverLetterBody2());
        boolean coverLetterBody2Changed = StageHeadMapper.boilerPlateChanged((String)coverLetterBody2New, (String)coverLetterBody2Old);
        stage.setCoverLetterBody2(coverLetterBody2New);
        stage.setCoverLetterBody2Changed(Boolean.valueOf(coverLetterBody2Changed));
        String coverLetterBody3New = StringUtils.trimToEmpty((String)updateRequest.getCoverLetterBody3());
        String coverLetterBody3Old = StringUtils.trimToEmpty((String)stage.getCoverLetterBody3());
        boolean coverLetterBody3Changed = StageHeadMapper.boilerPlateChanged((String)coverLetterBody3New, (String)coverLetterBody3Old);
        stage.setCoverLetterBody3(coverLetterBody3New);
        stage.setCoverLetterBody3Changed(Boolean.valueOf(coverLetterBody3Changed));
        String remarks = StringUtils.trimToEmpty((String)updateRequest.getRemarks());
        stage.setRemarks(remarks);
        this.stageUserMapper.mergeNotifyUsers(updateBucket);
        this.stageUserMapper.mergeResponsibleUsers((Quotation)updateBucket.getEntity(), updateBucket.getResponsibleUsers());
        this.stageUserMapper.mergeStageSignatureUsers(updateBucket);
        this.stageInvoiceSupplementMapper.merge(updateBucket);
        return stage;
    }

    private static boolean boilerPlateChanged(@NonNull String valueNew, @NonNull String valueOld) {
        if (valueNew == null) {
            throw new NullPointerException("valueNew is marked non-null but is null");
        }
        if (valueOld == null) {
            throw new NullPointerException("valueOld is marked non-null but is null");
        }
        return StringUtils.isNotBlank((CharSequence)valueNew) && !StringUtils.equalsIgnoreCase((CharSequence)valueNew, (CharSequence)valueOld);
    }

    @Nonnull
    public MergedBucket<QuotationPosition> mergePositions(@NonNull QStagePositionsUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Quotation stage = updateBucket.getStage();
        EQStageType stageType = stage.getStageType();
        Iterable quotationPositionsToPersist = updateBucket.getPositionUpdateBuckets();
        boolean addendumStageType = Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)stageType);
        BiFunction<QuotationPosition, QStagePositionUpdateBucket, QuotationPosition> mergeFunction = addendumStageType ? (stageType == EQStageType.COMMISSION__ADDENDUM ? (arg_0, arg_1) -> ((StagePositionMapper)this.positionMapper).mergeQStagePositionForAddendumCA(arg_0, arg_1) : (arg_0, arg_1) -> ((StagePositionMapper)this.positionMapper).mergeQStagePositionForAddendumCUA(arg_0, arg_1)) : (arg_0, arg_1) -> ((StagePositionMapper)this.positionMapper).mergeQStagePosition(arg_0, arg_1);
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)stage, Quotation::getQuotationPositions, arg_0 -> ((Quotation)stage).setQuotationPositions(arg_0), (Iterable)quotationPositionsToPersist, QStagePositionUpdateBucket::getId, QuotationPosition::getId, () -> ((EntityFactory)this.entityFactory).quotationPosition(), mergeFunction, QuotationPosition::setQuotation, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP_UB);
        MergedBucket.printMergeBucket((Object)stage, QuotationPosition.class, (MergedBucket)mergedBucket);
        Iterable positionsToBeCheckedForChildren = mergedBucket.existent();
        Stream<QuotationPosition> jumboPositionsToBeHandled = IterableHelper.stream((Iterable)positionsToBeCheckedForChildren).filter(item -> item.getPositionType() == EPositionType.JUMBO);
        jumboPositionsToBeHandled.forEach(jumbo -> {
            Set children = (Set)MoreObjects.firstNonNull((Object)jumbo.getChildren(), (Object)ImmutableSet.of());
            for (QuotationPosition child : children) {
                child.setEntityState(EntityState.VALID);
                child.setQuotation(stage);
                stage.getQuotationPositions().add(child);
            }
        });
        AtomicInteger counter = new AtomicInteger(1);
        Iterable allParents = (Iterable)IterableHelper.stream((Iterable)mergedBucket.all()).filter(item -> !Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)item.getPositionType())).sorted((Comparator<QuotationPosition>)QuotationPositionSequentialNumberComparator.of()).collect(ImmutableList.toImmutableList());
        for (QuotationPosition allParent : allParents) {
            allParent.setSequenceNumberQuotationStandard(Integer.valueOf(counter.getAndIncrement()));
            Set children = (Set)MoreObjects.firstNonNull((Object)allParent.getChildren(), (Object)ImmutableSet.of());
            List childrenSorted = (List)children.stream().sorted((l, r) -> SUB_POS_ORDERING.compare((Object)l.getSubPositionNumber(), (Object)r.getSubPositionNumber())).collect(ImmutableList.toImmutableList());
            for (QuotationPosition child : childrenSorted) {
                child.setSequenceNumberQuotationStandard(Integer.valueOf(counter.getAndIncrement()));
            }
        }
        return mergedBucket;
    }

    @Nonnull
    private AddendumDiscountCommon map(@NonNull AddendumDiscount entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        AddendumDiscountCommon common = new AddendumDiscountCommon();
        BigDecimal generalDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)entity.getGeneralDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal otherDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)entity.getOtherDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal discount = generalDiscount.add(otherDiscount);
        common.setAddendumNumber(((Long)MoreObjects.firstNonNull((Object)entity.getAddendumNumber(), (Object)0L)).longValue());
        common.setDiscount(discount);
        return common;
    }

    @Nonnull
    public StageMergeResult mergeInto(@NonNull Quotation stageFrom, @NonNull Quotation stageTo, @NonNull EQStageType stageTypeNew, boolean stageCopyPositions, boolean resetAddendumNumber) {
        if (stageFrom == null) {
            throw new NullPointerException("stageFrom is marked non-null but is null");
        }
        if (stageTo == null) {
            throw new NullPointerException("stageTo is marked non-null but is null");
        }
        if (stageTypeNew == null) {
            throw new NullPointerException("stageTypeNew is marked non-null but is null");
        }
        if (EStageOrigin.QUANTE_V1 == stageFrom.getOrigin()) {
            stageTo.setQuotationNumber(stageFrom.getQuotationNumber());
        }
        StageHelper.ensureQuotationNumber((Quotation)stageTo);
        stageTo.setQuotationName(stageFrom.getQuotationName());
        stageTo.setVersion(stageFrom.getVersion());
        stageTo.setVersionSince(stageFrom.getVersionSince());
        stageTo.setProject(stageFrom.getProject());
        stageTo.setAddendumNumber(null);
        Long addendumNumber = stageFrom.getAddendumNumber();
        Long copyAddendumNumber = resetAddendumNumber ? null : addendumNumber;
        stageTo.setAddendumNumber(copyAddendumNumber);
        EQStageType stageTypeTo = stageTo.getStageType();
        if (stageTypeTo == EQStageType.COMMISSION__COST_ESTIMATE) {
            stageTo.setCoverLetterSubject1st("");
            stageTo.setCoverLetterSubject1stChanged(Boolean.valueOf(false));
        }
        stageTo.setCoverLetterSubject2nd(stageFrom.getCoverLetterSubject2nd());
        stageTo.setCoverLetterSubject2ndChanged(stageFrom.getCoverLetterSubject2ndChanged());
        stageTo.setCoverLetterTitle(stageFrom.getCoverLetterTitle());
        stageTo.setCoverLetterTitleChanged(stageFrom.getCoverLetterTitleChanged());
        stageTo.setCoverLetterBody1(stageFrom.getCoverLetterBody1());
        stageTo.setCoverLetterBody1Changed(stageFrom.getCoverLetterBody1Changed());
        stageTo.setCoverLetterBody2(stageFrom.getCoverLetterBody2());
        stageTo.setCoverLetterBody2Changed(stageFrom.getCoverLetterBody2Changed());
        stageTo.setCoverLetterBody3(stageFrom.getCoverLetterBody3());
        stageTo.setCoverLetterBody3Changed(stageFrom.getCoverLetterBody3Changed());
        stageTo.setRemarks(StringUtils.trimToEmpty((String)stageFrom.getRemarks()));
        stageTo.setValueAggregated(stageFrom.getValueAggregated());
        stageTo.setMaterialValueAggregated(stageFrom.getMaterialValueAggregated());
        stageTo.setWageValueAggregated(stageFrom.getWageValueAggregated());
        stageTo.setPriceAggregated(stageFrom.getPriceAggregated());
        stageTo.setOrderValue(stageFrom.getOrderValue());
        stageTo.setOrderValueEstimate(stageFrom.getOrderValueEstimate());
        stageTo.setBudgetAllowedOverdraftValue(stageFrom.getBudgetAllowedOverdraftValue());
        stageTo.setBudgetAllowedOverdraftPercent(stageFrom.getBudgetAllowedOverdraftPercent());
        stageTo.setGeneralDiscount(stageFrom.getGeneralDiscount());
        stageTo.setOtherDiscount(stageFrom.getOtherDiscount());
        stageTo.setMaterialPercentageMin(stageFrom.getMaterialPercentageMin());
        stageTo.setMaterialPercentageStandard(stageFrom.getMaterialPercentageStandard());
        stageTo.setWageFactorMin(stageFrom.getWageFactorMin());
        stageTo.setWageFactorMax(stageFrom.getWageFactorMax());
        stageTo.setWagePercentageMin(stageFrom.getWagePercentageMin());
        stageTo.setWagePercentageStandard(stageFrom.getWagePercentageStandard());
        stageTo.setWarrantySecurityRetentionPercent(stageFrom.getWarrantySecurityRetentionPercent());
        stageTo.setFulfillmentSecurityRetentionPercent(stageFrom.getFulfillmentSecurityRetentionPercent());
        stageTo.setQuotationDate(stageFrom.getQuotationDate());
        stageTo.setQuotationOpeningDate(stageFrom.getQuotationOpeningDate());
        stageTo.setOrderDate(stageFrom.getOrderDate());
        stageTo.setOrderNumber(stageFrom.getOrderNumber());
        stageTo.setProjectExecutionStartDate(stageFrom.getProjectExecutionStartDate());
        stageTo.setProjectExecutionEndDate(stageFrom.getProjectExecutionEndDate());
        stageTo.setQuotationProjectExecutionStartDate(stageFrom.getQuotationProjectExecutionStartDate());
        stageTo.setQuotationProjectExecutionEndDate(stageFrom.getQuotationProjectExecutionEndDate());
        stageTo.setAccountingFlag(stageFrom.getAccountingFlag());
        stageTo.setAccountingText(stageFrom.getAccountingText());
        stageTo.setCostCenterInternal(stageFrom.getCostCenterInternal());
        stageTo.setCostCenterExternal(stageFrom.getCostCenterExternal());
        stageTo.setCustomerEmail(stageFrom.getCustomerEmail());
        stageTo.setCustomerShortName(stageFrom.getCustomerShortName());
        stageTo.setCustomerName1(stageFrom.getCustomerName1());
        stageTo.setCustomerName2(stageFrom.getCustomerName2());
        stageTo.setCustomerStreet(stageFrom.getCustomerStreet());
        stageTo.setCustomerStreetNo(stageFrom.getCustomerStreetNo());
        stageTo.setCustomerZipCode(stageFrom.getCustomerZipCode());
        stageTo.setCustomerCity(stageFrom.getCustomerCity());
        stageTo.setCustomerInvoiceShortName(stageFrom.getCustomerInvoiceShortName());
        stageTo.setCustomerInvoiceName1(stageFrom.getCustomerInvoiceName1());
        stageTo.setCustomerInvoiceName2(stageFrom.getCustomerInvoiceName2());
        stageTo.setCustomerInvoiceStreet(stageFrom.getCustomerInvoiceStreet());
        stageTo.setCustomerInvoiceStreetNo(stageFrom.getCustomerInvoiceStreetNo());
        stageTo.setCustomerInvoiceZipCode(stageFrom.getCustomerInvoiceZipCode());
        stageTo.setCustomerInvoiceCity(stageFrom.getCustomerInvoiceCity());
        stageTo.setHeadlineG1Set(stageFrom.getHeadlineG1Set());
        stageTo.setHeadlineG1(stageFrom.getHeadlineG1());
        stageTo.setHeadlineG1Length(stageFrom.getHeadlineG1Length());
        stageTo.setHeadlineG1IsNumeric(stageFrom.getHeadlineG1IsNumeric());
        stageTo.setHeadlineG1Align(stageFrom.getHeadlineG1Align());
        stageTo.setHeadlineG2Set(stageFrom.getHeadlineG2Set());
        stageTo.setHeadlineG2(stageFrom.getHeadlineG2());
        stageTo.setHeadlineG2Length(stageFrom.getHeadlineG2Length());
        stageTo.setHeadlineG2IsNumeric(stageFrom.getHeadlineG2IsNumeric());
        stageTo.setHeadlineG2Align(stageFrom.getHeadlineG2Align());
        stageTo.setHeadlineG3Set(stageFrom.getHeadlineG3Set());
        stageTo.setHeadlineG3(stageFrom.getHeadlineG3());
        stageTo.setHeadlineG3Length(stageFrom.getHeadlineG3Length());
        stageTo.setHeadlineG3IsNumeric(stageFrom.getHeadlineG3IsNumeric());
        stageTo.setHeadlineG3Align(stageFrom.getHeadlineG3Align());
        stageTo.setHeadlineG4Set(stageFrom.getHeadlineG4Set());
        stageTo.setHeadlineG4(stageFrom.getHeadlineG4());
        stageTo.setHeadlineG4Length(stageFrom.getHeadlineG4Length());
        stageTo.setHeadlineG4IsNumeric(stageFrom.getHeadlineG4IsNumeric());
        stageTo.setHeadlineG4Align(stageFrom.getHeadlineG4Align());
        stageTo.setHeadlineG5Set(stageFrom.getHeadlineG5Set());
        stageTo.setHeadlineG5(stageFrom.getHeadlineG5());
        stageTo.setHeadlineG5Length(stageFrom.getHeadlineG5Length());
        stageTo.setHeadlineG5IsNumeric(stageFrom.getHeadlineG5IsNumeric());
        stageTo.setHeadlineG5Align(stageFrom.getHeadlineG5Align());
        stageTo.setItemFormatG1Set(stageFrom.getItemFormatG1Set());
        stageTo.setItemFormatG1(stageFrom.getItemFormatG1());
        stageTo.setItemFormatG1Length(stageFrom.getItemFormatG1Length());
        stageTo.setItemFormatG1IsNumeric(stageFrom.getItemFormatG1IsNumeric());
        stageTo.setItemFormatG1Align(stageFrom.getItemFormatG1Align());
        stageTo.setItemFormatG2Set(stageFrom.getItemFormatG2Set());
        stageTo.setItemFormatG2(stageFrom.getItemFormatG2());
        stageTo.setItemFormatG2Length(stageFrom.getItemFormatG2Length());
        stageTo.setItemFormatG2IsNumeric(stageFrom.getItemFormatG2IsNumeric());
        stageTo.setItemFormatG2Align(stageFrom.getItemFormatG2Align());
        stageTo.setX83ProjectLabel(stageFrom.getX83ProjectLabel());
        stageTo.setX83ProjectName(stageFrom.getX83ProjectName());
        stageTo.setX83ProjectCurrency(stageFrom.getX83ProjectCurrency());
        stageTo.setX83ProjectCurrencyLabel(stageFrom.getX83ProjectCurrencyLabel());
        stageTo.setX83BoqInfoDate(stageFrom.getX83BoqInfoDate());
        stageTo.setX83BoqName(stageFrom.getX83BoqName());
        stageTo.setX83BoqLabel(stageFrom.getX83BoqLabel());
        stageTo.setX83BoqAwardCurrency(stageFrom.getX83BoqAwardCurrency());
        stageTo.setX83BoqAwardCurrencyLabel(stageFrom.getX83BoqAwardCurrencyLabel());
        stageTo.setFlagMeasurementWithoutCommissionNumberAllowed(Boolean.valueOf(false));
        stageTo.setFlagConstantCompanyWage((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagConstantCompanyWage(), (Object)false));
        stageTo.setFlagOrderEnd((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagOrderEnd(), (Object)false));
        stageTo.setFlagOrderEqualsQuotation((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagOrderEqualsQuotation(), (Object)false));
        stageTo.setFlagSquadIsAllowedToCreateReleaseOrder((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagSquadIsAllowedToCreateReleaseOrder(), (Object)true));
        stageTo.setFlagReleaseOrderOrderNumberMandatory((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagReleaseOrderOrderNumberMandatory(), (Object)false));
        stageTo.setFlagAutomaticWageAssignmentAllowed((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagAutomaticWageAssignmentAllowed(), (Object)true));
        stageTo.setFlagDiscountFeePositions((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagDiscountFeePositions(), (Object)false));
        stageTo.setFlagB2B((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagB2B(), (Object)false));
        stageTo.setFlagPositionGridLocked((Boolean)MoreObjects.firstNonNull((Object)stageFrom.getFlagPositionGridLocked(), (Object)false));
        stageTo.setAgentShortName(stageFrom.getAgentShortName());
        stageTo.setAgentName1(stageFrom.getAgentName1());
        stageTo.setAgentName2(stageFrom.getAgentName2());
        stageTo.setAgentStreet(stageFrom.getAgentStreet());
        stageTo.setAgentStreetNo(stageFrom.getAgentStreetNo());
        stageTo.setAgentZipCode(stageFrom.getAgentZipCode());
        stageTo.setAgentCity(stageFrom.getAgentCity());
        stageTo.setAgentInvoiceShortName(stageFrom.getAgentInvoiceShortName());
        stageTo.setAgentInvoiceName1(stageFrom.getAgentInvoiceName1());
        stageTo.setAgentInvoiceName2(stageFrom.getAgentInvoiceName2());
        stageTo.setAgentInvoiceStreet(stageFrom.getAgentInvoiceStreet());
        stageTo.setAgentInvoiceStreetNo(stageFrom.getAgentInvoiceStreetNo());
        stageTo.setAgentInvoiceZipCode(stageFrom.getAgentInvoiceZipCode());
        stageTo.setAgentInvoiceCity(stageFrom.getAgentInvoiceCity());
        stageTo.setFinanceCompanyNumber(stageFrom.getFinanceCompanyNumber());
        stageTo.setFinanceAccountingText(stageFrom.getFinanceAccountingText());
        stageTo.setFinanceTimeForPayment(stageFrom.getFinanceTimeForPayment());
        stageTo.setFinanceCashDiscountTime1(stageFrom.getFinanceCashDiscountTime1());
        stageTo.setFinanceCashDiscount1(stageFrom.getFinanceCashDiscount1());
        stageTo.setFinanceCashDiscountTime2(stageFrom.getFinanceCashDiscountTime2());
        stageTo.setFinanceCashDiscount2(stageFrom.getFinanceCashDiscount2());
        stageTo.setFinanceDebtorAccountNumber(stageFrom.getFinanceDebtorAccountNumber());
        stageTo.setFinanceAccount(stageFrom.getFinanceAccount());
        stageTo.setFinanceCostUnit(stageFrom.getFinanceCostUnit());
        stageTo.setFinanceRoutingReferenceId(stageFrom.getFinanceRoutingReferenceId());
        stageTo.setVatPercent(stageFrom.getVatPercent());
        stageTo.setFinanceDefaultInvoiceType(stageFrom.getFinanceDefaultInvoiceType());
        stageTo.setPdfExtractType((EPdfExtractType)MoreObjects.firstNonNull((Object)stageFrom.getPdfExtractType(), (Object)EPdfExtractType.NONE));
        stageTo.setFinanceTaxKey(stageFrom.getFinanceTaxKey());
        stageTo.setFinanceTaxKeyValue(stageFrom.getFinanceTaxKeyValue());
        stageTo.setFinanceFlagSubcontractor(stageFrom.getFinanceFlagSubcontractor());
        HashSet quotationBoQsNew = Sets.newHashSet();
        Set quotationBoQsOld = (Set)MoreObjects.firstNonNull((Object)stageFrom.getQuotationBoQs(), (Object)ImmutableSet.of());
        for (QuotationBoQ quotationBoQOld : quotationBoQsOld) {
            QuotationBoQ quotationBoQNew = this.entityFactory.quotationBoQ();
            quotationBoQNew.setBoqProjectName(quotationBoQOld.getBoqProjectName());
            quotationBoQNew.setBoqProjectLabel(quotationBoQOld.getBoqProjectLabel());
            quotationBoQNew.setBoqDescription(quotationBoQOld.getBoqDescription());
            quotationBoQNew.setBoqFile(quotationBoQOld.getBoqFile());
            quotationBoQNew.setQuotation(stageTo);
            quotationBoQsNew.add(quotationBoQNew);
        }
        stageTo.setLastQuotationBoQ(stageFrom.getLastQuotationBoQ());
        stageTo.setQuotationBoQs((Set)quotationBoQsNew);
        HashSet quotationPositionsNew = Sets.newHashSet();
        ImmutableMap.Builder quotationPositionMapBuilder = ImmutableMap.builder();
        if (stageCopyPositions) {
            Set quotationPositionsOld = (Set)MoreObjects.firstNonNull((Object)stageFrom.getQuotationPositions(), (Object)ImmutableSet.of());
            for (QuotationPosition quotationPositionOld : quotationPositionsOld) {
                if (null != quotationPositionOld.getParent()) continue;
                QuotationPosition quotationPositionNew = this.entityFactory.quotationPosition();
                QuotationPosition quotationPositionNewMerged = this.positionMapper.mergeInto(quotationPositionOld, quotationPositionNew, stageTypeNew, (Iterable)ImmutableSet.of());
                quotationPositionNewMerged.setQuotation(stageTo);
                quotationPositionsNew.add(quotationPositionNewMerged);
                quotationPositionMapBuilder.put((Object)quotationPositionOld, (Object)quotationPositionNewMerged);
                Set childrenOld = (Set)MoreObjects.firstNonNull((Object)quotationPositionOld.getChildren(), (Object)ImmutableSet.of());
                for (QuotationPosition childOld : childrenOld) {
                    QuotationPosition childNew = this.entityFactory.quotationPosition();
                    QuotationPosition childNewMerged = this.positionMapper.mergeInto(childOld, childNew, stageTypeNew, (Iterable)ImmutableSet.of());
                    childNewMerged.setQuotation(stageTo);
                    childNewMerged.setParent(quotationPositionNew);
                    quotationPositionNew.getChildren().add(childNewMerged);
                    quotationPositionsNew.add(childNewMerged);
                    quotationPositionMapBuilder.put((Object)childOld, (Object)childNewMerged);
                }
            }
        }
        ImmutableMap positionMap = quotationPositionMapBuilder.build();
        for (QuotationPosition quotationPosition : quotationPositionsNew) {
            quotationPosition.setQuotation(stageTo);
        }
        stageTo.setQuotationPositions((Set)quotationPositionsNew);
        HashSet stageNotifyUsersNew = Sets.newHashSet();
        Set stageNotifyUsersOld = (Set)MoreObjects.firstNonNull((Object)stageFrom.getStageNotifyUsers(), (Object)ImmutableSet.of());
        for (StageNotifyUser stageNotifyUserOld : stageNotifyUsersOld) {
            StageNotifyUser stageNotifyUserNew = this.entityFactory.stageNotifyUser();
            stageNotifyUserNew.setUser(stageNotifyUserOld.getUser());
            stageNotifyUserNew.setQuotation(stageTo);
            stageNotifyUsersNew.add(stageNotifyUserNew);
        }
        stageTo.setStageNotifyUsers((Set)stageNotifyUsersNew);
        HashSet stageResponsibleUsersNew = Sets.newHashSet();
        Set stageResponsibleUsersOld = (Set)MoreObjects.firstNonNull((Object)stageFrom.getStageResponsibleUsers(), (Object)ImmutableSet.of());
        for (StageResponsibleUser stageResponsibleUserOld : stageResponsibleUsersOld) {
            StageResponsibleUser stageResponsibleUserNew = this.entityFactory.stageResponsibleUser();
            stageResponsibleUserNew.setUser(stageResponsibleUserOld.getUser());
            stageResponsibleUserNew.setQuotation(stageTo);
            stageResponsibleUsersNew.add(stageResponsibleUserNew);
        }
        stageTo.setStageResponsibleUsers((Set)stageResponsibleUsersNew);
        HashSet stageSignatureUsersNew = Sets.newHashSet();
        Set stageSignatureUsersOld = (Set)MoreObjects.firstNonNull((Object)stageFrom.getStageSignatureUsers(), (Object)ImmutableSet.of());
        for (StageSignatureUser stageSignatureUserOld : stageSignatureUsersOld) {
            StageSignatureUser stageResponsibleUserNew = this.entityFactory.stageSignatureUser();
            stageResponsibleUserNew.setUser(stageSignatureUserOld.getUser());
            stageResponsibleUserNew.setQuotation(stageTo);
            stageSignatureUsersNew.add(stageResponsibleUserNew);
        }
        stageTo.setStageSignatureUsers((Set)stageSignatureUsersNew);
        stageTo.setQEntity(stageFrom.getQEntity());
        stageTo.setReference(stageFrom);
        stageTo.setParent(stageFrom.getParent());
        stageTo.setSubProject(stageFrom.getSubProject());
        stageTo.setCustomer(stageFrom.getCustomer());
        stageTo.setCustomerInvoice(stageFrom.getCustomerInvoice());
        stageTo.setAgent(stageFrom.getAgent());
        stageTo.setAgentInvoice(stageFrom.getAgentInvoice());
        stageTo.setContactPerson(stageFrom.getContactPerson());
        stageTo.setAddress(stageFrom.getAddress());
        stageTo.setCustomerInvoiceAddress(stageFrom.getCustomerInvoiceAddress());
        stageTo.setAgentAddress(stageFrom.getAgentAddress());
        stageTo.setAgentInvoiceAddress(stageFrom.getAgentInvoiceAddress());
        stageTo.setStagePositionSortOption(stageFrom.getStagePositionSortOption());
        stageTo.setOrderDescription(stageFrom.getOrderDescription());
        stageTo.setOrderDescriptionCustomer(stageFrom.getOrderDescriptionCustomer());
        stageTo.setOrderDescriptionInternal(stageFrom.getOrderDescriptionInternal());
        stageTo.setProcurementNumber(stageFrom.getProcurementNumber());
        stageTo.setSubmissionDateTime(stageFrom.getSubmissionDateTime());
        stageTo.setSubmissionOfBidDate(stageFrom.getSubmissionOfBidDate());
        stageTo.setFlagWithoutSubmissionDeadline(stageFrom.getFlagWithoutSubmissionDeadline());
        stageTo.setInquiryDate(stageFrom.getInquiryDate());
        stageTo.setInquiryType(stageFrom.getInquiryType());
        stageTo.setInquiryReceiveType(stageFrom.getInquiryReceiveType());
        stageTo.setPlannedSubmissionDate(stageFrom.getPlannedSubmissionDate());
        stageTo.setQuotationSubmissionType(stageFrom.getQuotationSubmissionType());
        stageTo.setCommissionType(stageFrom.getCommissionType());
        stageTo.setCommissionDate(stageFrom.getCommissionDate());
        stageTo.setBindingPeriodDate(stageFrom.getBindingPeriodDate());
        HashSet stageInvoiceSupplementsNew = Sets.newHashSet();
        Set stageInvoiceSupplementsOld = (Set)MoreObjects.firstNonNull((Object)stageFrom.getStageInvoiceSupplements(), (Object)ImmutableSet.of());
        for (StageInvoiceSupplement stageInvoiceSupplementOld : stageInvoiceSupplementsOld) {
            StageInvoiceSupplement stageInvoiceSupplementNew = this.entityFactory.stageInvoiceSupplement();
            stageInvoiceSupplementNew.setName(stageInvoiceSupplementOld.getName());
            stageInvoiceSupplementNew.setPercent(stageInvoiceSupplementOld.getPercent());
            stageInvoiceSupplementNew.setQuotation(stageTo);
            stageInvoiceSupplementsNew.add(stageInvoiceSupplementNew);
        }
        stageTo.setStageInvoiceSupplements((Set)stageInvoiceSupplementsNew);
        return StageMergeResult.of((Quotation)stageTo, (Map)positionMap);
    }

    public StageHeadMapper(AuthenticationHelper authenticationHelper, DateTimeHelperService dateTimeHelperService, UserService userService, EntityFactory entityFactory, CustomerMapper customerMapper, FileStoreMapper fileStoreMapper, ProjectMapper projectMapper, SubProjectMapper subProjectMapper, StageUserMapper stageUserMapper, StagePositionMapper positionMapper, UserMapper userMapper, StageInvoiceSupplementMapper stageInvoiceSupplementMapper) {
        this.authenticationHelper = authenticationHelper;
        this.dateTimeHelperService = dateTimeHelperService;
        this.userService = userService;
        this.entityFactory = entityFactory;
        this.customerMapper = customerMapper;
        this.fileStoreMapper = fileStoreMapper;
        this.projectMapper = projectMapper;
        this.subProjectMapper = subProjectMapper;
        this.stageUserMapper = stageUserMapper;
        this.positionMapper = positionMapper;
        this.userMapper = userMapper;
        this.stageInvoiceSupplementMapper = stageInvoiceSupplementMapper;
    }
}

