/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.role.RoleUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.role.RoleCommon;
import de.qfm.erp.common.response.role.RolePageCommon;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.role.RoleUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.RolePrivilege;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RoleMapper {
    private static final Logger log = LogManager.getLogger(RoleMapper.class);
    private final EntityFactory entityFactory;

    @Nonnull
    public RoleCommon map(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        return this.map(role, true);
    }

    @Nonnull
    public RoleCommon map(@NonNull Role role, boolean mapPrivileges) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        RoleCommon common = new RoleCommon();
        BaseMapper.map((EntityBase)role, (EntityBaseCommon)common);
        common.setId(role.getId());
        common.setName(StringUtils.trimToEmpty((String)role.getName()));
        common.setRemarks(StringUtils.trimToEmpty((String)role.getRemarks()));
        if (mapPrivileges) {
            List rolePrivileges = (List)MoreObjects.firstNonNull((Object)role.getRolePrivileges(), (Object)ImmutableList.of());
            ImmutableSet privilegeNames = ImmutableSet.copyOf(rolePrivileges.stream().map(RolePrivilege::getPrivilege).filter(item -> !EPrivilege.PRIVILEGES_HIDDEN.contains(item)).filter(Objects::nonNull).map(Enum::name).iterator());
            common.setPrivileges((Set)privilegeNames);
        }
        return common;
    }

    @Nonnull
    public RolePageCommon map(@NonNull Page<Role> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        Pageable pageable = page.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = page.getContent();
        List itemsCommon = (List)content.stream().map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new RolePageCommon(pageNumber, pageSize, totalPages, totalElements, itemsCommon);
    }

    @Nonnull
    public Role merge(@NonNull RoleUpdateBucket roleUpdateBucket) {
        if (roleUpdateBucket == null) {
            throw new NullPointerException("roleUpdateBucket is marked non-null but is null");
        }
        RoleUpdateRequest updateRequest = (RoleUpdateRequest)roleUpdateBucket.getRequest();
        Role role = (Role)roleUpdateBucket.getEntity();
        Iterable privileges = roleUpdateBucket.getPrivileges();
        role.setName(StringUtils.trimToEmpty((String)updateRequest.getName()));
        role.setRemarks(StringUtils.trimToEmpty((String)updateRequest.getRemarks()));
        MergedBucket rolePrivilegeMergedBucket = this.mergeChildren(role, privileges);
        MergedBucket.printMergeBucket((Object)rolePrivilegeMergedBucket, RolePrivilege.class, (MergedBucket)rolePrivilegeMergedBucket);
        return role;
    }

    @Nonnull
    public MergedBucket<RolePrivilege> mergeChildren(@NonNull Role role, @NonNull Iterable<EPrivilege> privileges) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (privileges == null) {
            throw new NullPointerException("privileges is marked non-null but is null");
        }
        Iterable rolePrivilegesExisting = (Iterable)MoreObjects.firstNonNull((Object)role.getRolePrivileges(), (Object)ImmutableList.of());
        Map<EPrivilege, RolePrivilege> privilegesExistingMap = IterableHelper.stream((Iterable)rolePrivilegesExisting).collect(Collectors.toMap(RolePrivilege::getPrivilege, p -> p));
        ImmutableSet privilegesExisting = ImmutableSet.copyOf(privilegesExistingMap.keySet());
        ImmutableSet privilegesToPersist = ImmutableSet.copyOf(privileges);
        Sets.SetView privilegesToAdd = Sets.difference((Set)privilegesToPersist, (Set)privilegesExisting);
        Sets.SetView toRemove = Sets.difference((Set)privilegesExisting, (Set)privilegesToPersist);
        ImmutableList.Builder addedBuilder = ImmutableList.builder();
        for (EPrivilege privilegeToAdd : privilegesToAdd) {
            addedBuilder.add((Object)this.entityFactory.rolePrivilege(privilegeToAdd));
        }
        ImmutableList added = addedBuilder.build();
        ImmutableList.Builder deletedBuilder = ImmutableList.builder();
        for (EPrivilege privilegeToRemove : toRemove) {
            RolePrivilege rolePrivilege = privilegesExistingMap.get(privilegeToRemove);
            deletedBuilder.add((Object)rolePrivilege);
        }
        ImmutableList deleted = deletedBuilder.build();
        if (null == role.getRolePrivileges()) {
            role.setRolePrivileges((List)Lists.newArrayList());
        }
        added.forEach(item -> {
            role.getRolePrivileges().add(item);
            item.setRole(role);
        });
        deleted.forEach(item -> {
            item.setRole(null);
            role.getRolePrivileges().remove(item);
        });
        return MergedBucket.of((Iterable)added, (Iterable)ImmutableList.of(), (Iterable)deleted);
    }

    public RoleMapper(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }
}

