/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.measurement.ReleaseOrderCommon;
import de.qfm.erp.common.response.measurement.ReleaseOrdersCommon;
import de.qfm.erp.service.model.internal.ReleaseOrderSyncBucket;
import de.qfm.erp.service.model.internal.ReleaseOrderUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ReleaseOrderMapper {
    @Nonnull
    public ReleaseOrdersCommon map(@NonNull Page<ReleaseOrder> releaseOrdersPage) {
        if (releaseOrdersPage == null) {
            throw new NullPointerException("releaseOrdersPage is marked non-null but is null");
        }
        long totalElements = releaseOrdersPage.getTotalElements();
        int totalPages = releaseOrdersPage.getTotalPages();
        Pageable pageable = releaseOrdersPage.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = releaseOrdersPage.getContent();
        List commons = (List)content.stream().map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new ReleaseOrdersCommon(pageNumber, pageSize, totalPages, totalElements, commons);
    }

    @Nonnull
    public List<ReleaseOrderCommon> map(@NonNull List<ReleaseOrder> releaseOrders) {
        if (releaseOrders == null) {
            throw new NullPointerException("releaseOrders is marked non-null but is null");
        }
        return (List)releaseOrders.stream().map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public ReleaseOrderCommon map(@NonNull ReleaseOrder releaseOrder) {
        PssReleaseOrder pssReleaseOrder;
        Quotation quotation;
        if (releaseOrder == null) {
            throw new NullPointerException("releaseOrder is marked non-null but is null");
        }
        ReleaseOrderCommon releaseOrderCommon = new ReleaseOrderCommon();
        BaseMapper.map((EntityBase)releaseOrder, (EntityBaseCommon)releaseOrderCommon);
        releaseOrderCommon.setId(releaseOrder.getId());
        releaseOrderCommon.setReferenceId(releaseOrder.getReferenceId());
        releaseOrderCommon.setName(releaseOrder.getName());
        Measurement measurement = releaseOrder.getMeasurement();
        if (null != measurement) {
            releaseOrderCommon.setMeasurementId(measurement.getId());
            releaseOrderCommon.setMeasurementNumber(measurement.getMeasurementNumber());
            User assignedUser = measurement.getAssignedUser();
            if (null != assignedUser) {
                releaseOrderCommon.setMeasurementAssignedUserId(assignedUser.getId());
                releaseOrderCommon.setMeasurementAssignedUserFirstName(assignedUser.getFirstName());
                releaseOrderCommon.setMeasurementAssignedUserLastName(assignedUser.getLastName());
                releaseOrderCommon.setMeasurementAssignedUserPersonalNumber(assignedUser.getPersonalNumber());
            }
        }
        if (null != (quotation = releaseOrder.getQuotation())) {
            releaseOrderCommon.setQuotationId(quotation.getId());
            releaseOrderCommon.setQuotationNumber(quotation.getQuotationNumber());
        }
        if (null != (pssReleaseOrder = releaseOrder.getPssReleaseOrder())) {
            releaseOrderCommon.setState(pssReleaseOrder.getPssState());
            releaseOrderCommon.setPssReleaseOrderId(pssReleaseOrder.getPssId());
            releaseOrderCommon.setExternalPssReleaseOrderId(pssReleaseOrder.getPssId());
        }
        releaseOrderCommon.setOrderNumber(releaseOrder.getOrderNumber());
        return releaseOrderCommon;
    }

    @Nonnull
    public ReleaseOrder merge(@NonNull ReleaseOrderSyncBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        String referenceId = bucket.getReferenceId();
        Measurement measurement = bucket.getMeasurement();
        ReleaseOrder releaseOrder = bucket.getReleaseOrder();
        Quotation quotation = bucket.getQuotation();
        String name = StringUtils.trimToEmpty((String)bucket.getName());
        String orderNumber = StringUtils.trimToEmpty((String)bucket.getOrderNumber());
        PssReleaseOrder pssReleaseOrder = bucket.getPssReleaseOrder();
        return this.merge(referenceId, measurement, quotation, releaseOrder, name, orderNumber, pssReleaseOrder);
    }

    @Nonnull
    public ReleaseOrder merge(@NonNull ReleaseOrderUpdateBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        String referenceId = bucket.getReferenceId();
        Measurement measurement = bucket.getMeasurement();
        Quotation quotation = bucket.getQuotation();
        ReleaseOrder releaseOrder = bucket.getReleaseOrder();
        String name = StringUtils.trimToEmpty((String)bucket.getName());
        String orderNumber = StringUtils.trimToEmpty((String)bucket.getOrderNumber());
        PssReleaseOrder pssReleaseOrder = bucket.getPssReleaseOrder();
        return this.merge(referenceId, measurement, quotation, releaseOrder, name, orderNumber, pssReleaseOrder);
    }

    @Nonnull
    private ReleaseOrder merge(@NonNull String referenceId, @NonNull Measurement measurement, @NonNull Quotation quotation, @NonNull ReleaseOrder releaseOrder, @NonNull String name, @NonNull String orderNumber, @Nullable PssReleaseOrder pssReleaseOrder) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (releaseOrder == null) {
            throw new NullPointerException("releaseOrder is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (orderNumber == null) {
            throw new NullPointerException("orderNumber is marked non-null but is null");
        }
        releaseOrder.setReferenceId(referenceId);
        measurement.setReleaseOrder(releaseOrder);
        releaseOrder.setMeasurement(measurement);
        releaseOrder.setQuotation(quotation);
        releaseOrder.setName(name);
        releaseOrder.setOrderNumber(orderNumber);
        releaseOrder.setPssReleaseOrder(pssReleaseOrder);
        return releaseOrder;
    }
}

