/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.request.quotation.QEntityUpdateRequest;
import de.qfm.erp.common.request.quotation.StageUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.customer.CustomerCommon;
import de.qfm.erp.common.response.project.ProjectCommon;
import de.qfm.erp.common.response.quotation.EntityCommon;
import de.qfm.erp.common.response.quotation.EntityDashboardCommon;
import de.qfm.erp.common.response.quotation.EntityDashboardListCommon;
import de.qfm.erp.common.response.quotation.QEntityAutoCompleteItemCommon;
import de.qfm.erp.common.response.quotation.QEntityAutoCompleteResponse;
import de.qfm.erp.common.response.quotation.QEntityFileCommon;
import de.qfm.erp.common.response.quotation.QEntityTreeItemCommon;
import de.qfm.erp.common.response.quotation.QEntityTreePageCommon;
import de.qfm.erp.common.response.search.EntitySearchItem;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.internal.quotation.EntityCreateBucket;
import de.qfm.erp.service.model.internal.quotation.EntityStatistics;
import de.qfm.erp.service.model.internal.quotation.QEntityUpdateBucket;
import de.qfm.erp.service.model.internal.search.EntitySearchItemBucket;
import de.qfm.erp.service.model.internal.search.Highlight;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.ECommissionType;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.search.EntityIndexEntry;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.CustomerMapper;
import de.qfm.erp.service.service.mapper.HighlightMapper;
import de.qfm.erp.service.service.mapper.ProjectMapper;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.MessageService;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QEntityMapper {
    private static final Logger log = LogManager.getLogger(QEntityMapper.class);
    private final ConfigService configService;
    private final CustomerMapper customerMapper;
    private final ProjectMapper projectMapper;
    private final HighlightMapper highlightMapper;
    private final MessageService messageService;
    public static final Joiner AUTOCOMPLETE_TEXT_JOINER = Joiner.on((char)' ').skipNulls();
    private final CompanyConfig companyConfig;

    @Nonnull
    public EntityCommon mapToCommon(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        return this.map(entity);
    }

    @Nonnull
    private EntityCommon map(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        Quotation primaryStage = entity.getPrimaryStage();
        EntityCommon common = new EntityCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setQentityNumber(entity.getQNumber());
        common.setAlias(entity.getAlias());
        EQEntityState qEntityState = (EQEntityState)MoreObjects.firstNonNull((Object)entity.getQEntityState(), (Object)EQEntityState.UNKNOWN);
        common.setQentityState(qEntityState.name());
        common.setValueAggregated(BigDecimal.valueOf(-100.5));
        common.setDegreeOfFulfilment(BigDecimal.valueOf(-100.5));
        if (null != primaryStage) {
            common.setQStagePrimaryId(primaryStage.getId());
            common.setQStagePrimaryAlias(primaryStage.getAlias());
            common.setQStagePrimaryQEntityNumber(primaryStage.getQNumber());
            Project project = primaryStage.getProject();
            if (null != project) {
                ProjectCommon projectCommon = this.projectMapper.map(project);
                common.setProject(projectCommon);
            }
        }
        common.setRemarksInquiry(StringUtils.trimToEmpty((String)entity.getRemarksInquiry()));
        common.setRemarksCalculation(StringUtils.trimToEmpty((String)entity.getRemarksCalculation()));
        common.setRemarksQuotation(StringUtils.trimToEmpty((String)entity.getRemarksQuotation()));
        common.setRemarksCommission(StringUtils.trimToEmpty((String)entity.getRemarksCommission()));
        common.setRemarksAddendum(StringUtils.trimToEmpty((String)entity.getRemarksAddendum()));
        common.setRemarksCostEstimate(StringUtils.trimToEmpty((String)entity.getRemarksCostEstimate()));
        return common;
    }

    @Nonnull
    public QEntity merge(@NonNull QEntity entity, @NonNull EntityCreateBucket updateBucket) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        entity.setQNumber(StringUtils.trimToEmpty((String)updateBucket.getEntityNumber()));
        entity.setAlias(StringUtils.trimToEmpty((String)updateBucket.getAlias()));
        entity.setQEntityState(updateBucket.getEqEntityState());
        StageUpdateRequest updateRequest = updateBucket.getStageUpdateRequest();
        entity.setRemarksInquiry(StringUtils.trimToEmpty((String)updateRequest.getRemarksInquiry()));
        entity.setRemarksCalculation(StringUtils.trimToEmpty((String)updateRequest.getRemarksCalculation()));
        entity.setRemarksQuotation(StringUtils.trimToEmpty((String)updateRequest.getRemarksQuotation()));
        entity.setRemarksCommission(StringUtils.trimToEmpty((String)updateRequest.getRemarksCommission()));
        entity.setRemarksAddendum(StringUtils.trimToEmpty((String)updateRequest.getRemarksAddendum()));
        entity.setRemarksCostEstimate(StringUtils.trimToEmpty((String)updateRequest.getRemarksCostEstimate()));
        return entity;
    }

    @Nonnull
    public QEntity merge(@NonNull QEntity entity, @NonNull QEntityUpdateBucket updateBucket) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        QEntityUpdateRequest updateRequest = updateBucket.getUpdateRequest();
        entity.setAlias(StringUtils.trimToEmpty((String)updateRequest.getAlias()));
        entity.setRemarksInquiry(StringUtils.trimToEmpty((String)updateRequest.getRemarksInquiry()));
        entity.setRemarksCalculation(StringUtils.trimToEmpty((String)updateRequest.getRemarksCalculation()));
        entity.setRemarksQuotation(StringUtils.trimToEmpty((String)updateRequest.getRemarksQuotation()));
        entity.setRemarksCommission(StringUtils.trimToEmpty((String)updateRequest.getRemarksCommission()));
        entity.setRemarksAddendum(StringUtils.trimToEmpty((String)updateRequest.getRemarksAddendum()));
        entity.setRemarksCostEstimate(StringUtils.trimToEmpty((String)updateRequest.getRemarksCostEstimate()));
        return entity;
    }

    @Nonnull
    public QEntityFileCommon mapToCommon(@NonNull Path rootFolder, @NonNull File file) {
        if (rootFolder == null) {
            throw new NullPointerException("rootFolder is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        Path filePath = file.toPath();
        Path subpath = filePath.subpath(rootFolder.getNameCount(), filePath.getNameCount());
        ImmutableList.Builder refFilePathBuilder = ImmutableList.builder();
        int nameCount = subpath.getNameCount();
        String s = subpath.getFileName().toString();
        for (int i = 0; i < nameCount; ++i) {
            String namePart = subpath.getName(i).toString();
            refFilePathBuilder.add((Object)namePart);
        }
        ImmutableList refFilePath = refFilePathBuilder.build();
        QEntityFileCommon qEntityFileCommon = new QEntityFileCommon();
        LocalDateTime lastModifiedAt = LocalDateTime.ofInstant(Instant.ofEpochMilli(file.lastModified()), ZoneOffset.UTC);
        qEntityFileCommon.setName(s);
        qEntityFileCommon.setPath((List)refFilePath);
        qEntityFileCommon.setFileModifiedOn(lastModifiedAt);
        qEntityFileCommon.setFlagFile(file.isFile());
        qEntityFileCommon.setFlagDirectory(file.isDirectory());
        qEntityFileCommon.setSuffix(StringUtils.substringAfterLast((String)s, (String)"."));
        qEntityFileCommon.setLocalPath(filePath.toAbsolutePath().toString());
        qEntityFileCommon.setReferencePath(subpath.toString());
        return qEntityFileCommon;
    }

    @Nonnull
    public QEntityTreePageCommon mapPageToCommon(Pageable pageable, boolean flagIncludeCostUnits, @NonNull Iterable<EntityStatistics> statistics) {
        if (statistics == null) {
            throw new NullPointerException("statistics is marked non-null but is null");
        }
        long totalElements = Iterables.size(statistics);
        boolean totalPages = true;
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        LinkedHashMap entityById = Maps.newLinkedHashMap();
        for (EntityStatistics statistic : statistics) {
            if (!Objects.equals(statistic.getPrimaryStageId(), statistic.getStageId())) continue;
            entityById.put(statistic.getEntityId(), statistic);
        }
        ImmutableListMultimap statisticsByEntityId = Multimaps.index(Streams.stream(statistics).filter(item -> null != item.getEntityId()).iterator(), EntityStatistics::getEntityId);
        ImmutableListMultimap statisticsByStageId = Multimaps.index(Streams.stream(statistics).filter(item -> null != item.getStageId()).iterator(), EntityStatistics::getStageId);
        Set qEntityIDs = entityById.keySet();
        ImmutableList.Builder treeItemCommonBuilder = ImmutableList.builder();
        for (Long qEntityID : qEntityIDs) {
            EntityStatistics qEntity = (EntityStatistics)entityById.get(qEntityID);
            Iterable qEntityTreeItemCommons = this.mapToCommon(qEntity, flagIncludeCostUnits, (Multimap)statisticsByEntityId, (Multimap)statisticsByStageId);
            treeItemCommonBuilder.addAll(qEntityTreeItemCommons);
        }
        ImmutableList treeItemCommons = treeItemCommonBuilder.build();
        return new QEntityTreePageCommon(pageNumber, pageSize, 1, totalElements, (List)treeItemCommons);
    }

    @Nonnull
    public Iterable<QEntityTreeItemCommon> mapToCommon(@NonNull EntityStatistics qEntity, boolean flagIncludeCostUnits, @NonNull Multimap<Long, EntityStatistics> statisticsByEntityId, @NonNull Multimap<Long, EntityStatistics> statisticsByStageId) {
        if (qEntity == null) {
            throw new NullPointerException("qEntity is marked non-null but is null");
        }
        if (statisticsByEntityId == null) {
            throw new NullPointerException("statisticsByEntityId is marked non-null but is null");
        }
        if (statisticsByStageId == null) {
            throw new NullPointerException("statisticsByStageId is marked non-null but is null");
        }
        Long entityId = qEntity.getEntityId();
        String qNumber = qEntity.getEntityQNumber();
        String alias = qEntity.getEntityAlias();
        String rootPath = (StringUtils.isNotBlank((CharSequence)alias) ? alias : qNumber) + "[E" + entityId + "]";
        Collection entityStatistics = statisticsByEntityId.get((Object)entityId);
        ImmutableSet.Builder stageTypesToIncludeBuilder = ImmutableSet.builder();
        stageTypesToIncludeBuilder.add((Object)EQStageType.COMMISSION);
        if (flagIncludeCostUnits) {
            stageTypesToIncludeBuilder.add((Object)EQStageType.COMMISSION__COST_UNIT);
            stageTypesToIncludeBuilder.add((Object)EQStageType.COMMISSION__COST_UNIT__CE);
        }
        ImmutableSet stageTypesToInclude = stageTypesToIncludeBuilder.build();
        Collection stages = statisticsByEntityId.get((Object)entityId);
        ImmutableSet stagesToInclude = (ImmutableSet)Streams.stream((Iterable)stages).filter(item -> stageTypesToInclude.contains((Object)item.getStageType())).collect(ImmutableSet.toImmutableSet());
        Stream<EntityStatistics> sortedStages = stagesToInclude.stream().sorted((o1, o2) -> StringUtils.compareIgnoreCase((String)o1.getStageQNumber(), (String)o2.getStageQNumber()));
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        sortedStages.forEach(stage -> {
            Long stageId = stage.getStageId();
            Collection stageStatistics = statisticsByStageId.get((Object)stageId);
            childrenBuilder.add((Object)this.treeItem(rootPath, stage, (Iterable)stageStatistics));
        });
        ImmutableList children = childrenBuilder.build();
        QEntityTreeItemCommon parent = this.treeItem(rootPath, qEntity, (Iterable)children, (Iterable)entityStatistics);
        ImmutableList.Builder itemCommonBuilder = ImmutableList.builder();
        itemCommonBuilder.add((Object)parent);
        itemCommonBuilder.addAll((Iterable)children);
        return itemCommonBuilder.build();
    }

    @Nonnull
    private QEntityTreeItemCommon treeItem(@NonNull String treeRoot, @NonNull EntityStatistics entityStatistics, @NonNull Iterable<QEntityTreeItemCommon> children, @NonNull Iterable<EntityStatistics> statistics) {
        BigDecimal budget;
        if (treeRoot == null) {
            throw new NullPointerException("treeRoot is marked non-null but is null");
        }
        if (entityStatistics == null) {
            throw new NullPointerException("entityStatistics is marked non-null but is null");
        }
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        if (statistics == null) {
            throw new NullPointerException("statistics is marked non-null but is null");
        }
        String entityNumber = entityStatistics.getEntityQNumber();
        String stageNumberAlias = entityStatistics.getEntityAlias();
        QEntityTreeItemCommon treeItem = new QEntityTreeItemCommon();
        treeItem.setId(entityStatistics.getEntityId());
        treeItem.setEntityId(entityStatistics.getEntityId());
        treeItem.setStageId(entityStatistics.getStageId());
        treeItem.setVersion(entityStatistics.getVersion());
        treeItem.setVersionSince(entityStatistics.getVersionSince());
        treeItem.setText(StageHelper.stageText((EntityStatistics)entityStatistics));
        treeItem.setUpdatedBy(entityStatistics.getUpdatedBy());
        treeItem.setUpdatedOn(entityStatistics.getUpdatedOn());
        treeItem.setQentityNumber(entityNumber);
        treeItem.setAlias(stageNumberAlias);
        EQEntityState qEntityState = (EQEntityState)MoreObjects.firstNonNull((Object)entityStatistics.getEntityQEntityState(), (Object)EQEntityState.UNKNOWN);
        treeItem.setState(qEntityState.name());
        EQStageType stageType = (EQStageType)MoreObjects.firstNonNull((Object)entityStatistics.getStageType(), (Object)EQStageType.UNKNOWN);
        treeItem.setStageType(stageType.name());
        LocalDate projectExecutionStartDate = entityStatistics.getProjectExecutionStartDate();
        LocalDate projectExecutionEndDate = entityStatistics.getProjectExecutionEndDate();
        treeItem.setProjectExecutionStartDate(projectExecutionStartDate);
        treeItem.setProjectExecutionEndDate(projectExecutionEndDate);
        treeItem.setBindingPeriodDate(entityStatistics.getBindingPeriodDate());
        treeItem.setPlannedSubmissionDate(entityStatistics.getPlannedSubmissionDate());
        treeItem.setProcurementNumber(entityStatistics.getProcurementNumber());
        treeItem.setSubmissionDateTime(entityStatistics.getSubmissionDateTime());
        treeItem.setPriceWithDiscountSum(entityStatistics.getPriceWithDiscountSum());
        treeItem.setPriceWithoutDiscountSum(entityStatistics.getPriceWithoutDiscountSum());
        treeItem.setOrderValue(entityStatistics.getOrderValue());
        treeItem.setOrderValueWithDiscount(entityStatistics.getOrderValueWithDiscount());
        treeItem.setFlagMeasurementWithoutCommissionNumberAllowed(entityStatistics.getFlagMeasurementWithoutCommissionNumberAllowed());
        Optional<EntityStatistics> primaryStageCandidate = Streams.stream(statistics).filter(item -> Objects.equals(item.getStageId(), entityStatistics.getPrimaryStageId())).findFirst();
        if (primaryStageCandidate.isPresent()) {
            EntityStatistics primaryStage = primaryStageCandidate.get();
            treeItem.setOrderDescriptionCustomer(primaryStage.getOrderDescriptionCustomer());
            treeItem.setOrderDescriptionInternal(primaryStage.getOrderDescriptionInternal());
            treeItem.setOrderNumber(primaryStage.getOrderNumber());
            treeItem.setCommissionDate(primaryStage.getCommissionDate());
            ECommissionType commissionType = (ECommissionType)MoreObjects.firstNonNull((Object)primaryStage.getCommissionType(), (Object)ECommissionType.UNKNOWN);
            treeItem.setCommissionType(commissionType.name());
            budget = primaryStage.getBudget();
        } else {
            budget = BigDecimal.ZERO;
        }
        treeItem.setProjectId(entityStatistics.getProjectId());
        treeItem.setProjectName(entityStatistics.getProjectName());
        treeItem.setProjectReferenceId(entityStatistics.getProjectReferenceId());
        treeItem.setPrimaryStageId(entityStatistics.getPrimaryStageId());
        treeItem.setNotifyUsersText(entityStatistics.getNotifyUsersText());
        treeItem.setResponsibleUsersText(entityStatistics.getResponsibleUsersText());
        treeItem.setSignatureUsersText(entityStatistics.getSignatureUsersText());
        Customer customer = entityStatistics.getCustomer();
        if (null != customer) {
            CustomerCommon customerCommon = this.customerMapper.map(customer, false, false);
            treeItem.setCustomer(customerCommon);
        }
        treeItem.setDegreeOfFulfilment(BigDecimal.ONE.negate());
        String invoiceNumbersString = QEntityMapper.invoiceNumbersString(statistics);
        treeItem.setFlagFinalInvoice(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)invoiceNumbersString)));
        treeItem.setFinalInvoiceId(null);
        treeItem.setFinalInvoiceNumber(invoiceNumbersString);
        long calculationAmount = Streams.stream(statistics).filter(item -> item.getStageType() == EQStageType.CALCULATION).count();
        long quotationAmount = Streams.stream(statistics).filter(item -> item.getStageType() == EQStageType.QUOTATION).count();
        long addendumAmount = Streams.stream(statistics).filter(item -> Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)item.getStageType())).count();
        long costUnitAmount = Streams.stream(statistics).filter(item -> Iterables.contains((Iterable)EQStageType.COST_UNIT_TYPES, (Object)item.getStageType())).count();
        long costEstimateAmount = Streams.stream(statistics).filter(item -> item.getStageType() == EQStageType.COMMISSION__COST_ESTIMATE).count();
        treeItem.setCalculationAmount(Long.valueOf(calculationAmount));
        treeItem.setCostEstimateAmount(Long.valueOf(costEstimateAmount));
        treeItem.setAddendumAmount(Long.valueOf(addendumAmount));
        treeItem.setCostUnitAmount(Long.valueOf(costUnitAmount));
        treeItem.setQuotationAmount(Long.valueOf(quotationAmount));
        BigDecimal valueAggregated = Streams.stream(children).map(QEntityTreeItemCommon::getValueAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal orderValueEstimate = Streams.stream(children).map(QEntityTreeItemCommon::getOrderValueEstimate).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        treeItem.setValueAggregated(valueAggregated);
        treeItem.setOrderValueEstimate(orderValueEstimate);
        treeItem.setBudget(budget);
        treeItem.setPath((List)ImmutableList.of((Object)treeRoot));
        return treeItem;
    }

    @Nonnull
    private static String invoiceNumbersString(@NonNull Iterable<EntityStatistics> statistics) {
        if (statistics == null) {
            throw new NullPointerException("statistics is marked non-null but is null");
        }
        ImmutableSet invoiceNumbers = (ImmutableSet)Streams.stream(statistics).map(EntityStatistics::getFinalInvoiceNumber).filter(StringUtils::isNotBlank).collect(ImmutableSet.toImmutableSet());
        return Joiner.on((char)',').join((Iterable)invoiceNumbers);
    }

    @Nonnull
    private QEntityTreeItemCommon treeItem(@NonNull String root, @NonNull EntityStatistics stageStatistics, @NonNull Iterable<EntityStatistics> stageChildStatistics) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (stageStatistics == null) {
            throw new NullPointerException("stageStatistics is marked non-null but is null");
        }
        if (stageChildStatistics == null) {
            throw new NullPointerException("stageChildStatistics is marked non-null but is null");
        }
        Long entityId = stageStatistics.getEntityId();
        Long stageId = stageStatistics.getStageId();
        String stageNumber = stageStatistics.getStageQNumber();
        String stageAlias = stageStatistics.getStageAlias();
        String pathName = (StringUtils.isNotBlank((CharSequence)stageAlias) ? stageAlias : stageNumber) + "[S" + stageId + "]";
        QEntityTreeItemCommon treeItem = new QEntityTreeItemCommon();
        treeItem.setId(stageId);
        treeItem.setUpdatedBy(stageStatistics.getUpdatedBy());
        treeItem.setUpdatedOn(stageStatistics.getUpdatedOn());
        treeItem.setEntityId(entityId);
        treeItem.setStageId(stageId);
        treeItem.setVersion(stageStatistics.getVersion());
        treeItem.setVersionSince(stageStatistics.getVersionSince());
        treeItem.setText(StageHelper.stageText((EntityStatistics)stageStatistics));
        treeItem.setQentityNumber(stageNumber);
        treeItem.setAlias(stageAlias);
        EQStageState stageState = (EQStageState)MoreObjects.firstNonNull((Object)stageStatistics.getStageState(), (Object)EQStageState.UNKNOWN);
        treeItem.setState(stageState.name());
        EQStageType stageType = (EQStageType)MoreObjects.firstNonNull((Object)stageStatistics.getStageType(), (Object)EQStageType.UNKNOWN);
        treeItem.setStageType(stageType.name());
        treeItem.setProjectExecutionStartDate(stageStatistics.getProjectExecutionStartDate());
        treeItem.setProjectExecutionEndDate(stageStatistics.getProjectExecutionEndDate());
        treeItem.setOrderDescriptionCustomer(stageStatistics.getOrderDescriptionCustomer());
        treeItem.setOrderDescriptionInternal(stageStatistics.getOrderDescriptionInternal());
        treeItem.setOrderNumber(stageStatistics.getOrderNumber());
        treeItem.setProjectId(stageStatistics.getProjectId());
        treeItem.setProjectName(stageStatistics.getProjectName());
        treeItem.setProjectReferenceId(stageStatistics.getProjectReferenceId());
        treeItem.setCommissionDate(stageStatistics.getCommissionDate());
        treeItem.setProcurementNumber(stageStatistics.getProcurementNumber());
        ECommissionType commissionType = (ECommissionType)MoreObjects.firstNonNull((Object)stageStatistics.getCommissionType(), (Object)ECommissionType.UNKNOWN);
        treeItem.setCommissionType(commissionType.name());
        treeItem.setSubmissionDateTime(stageStatistics.getSubmissionDateTime());
        treeItem.setPlannedSubmissionDate(stageStatistics.getPlannedSubmissionDate());
        treeItem.setBindingPeriodDate(stageStatistics.getBindingPeriodDate());
        treeItem.setPriceWithDiscountSum(stageStatistics.getPriceWithDiscountSum());
        treeItem.setPriceWithoutDiscountSum(stageStatistics.getPriceWithoutDiscountSum());
        treeItem.setOrderValue(stageStatistics.getOrderValue());
        treeItem.setOrderValueWithDiscount(stageStatistics.getOrderValueWithDiscount());
        treeItem.setFlagMeasurementWithoutCommissionNumberAllowed(stageStatistics.getFlagMeasurementWithoutCommissionNumberAllowed());
        treeItem.setResponsibleUsersText(stageStatistics.getResponsibleUsersText());
        if (1 == Iterables.size(stageChildStatistics)) {
            EntityStatistics statistics = stageChildStatistics.iterator().next();
            treeItem.setFlagFinalInvoice(Boolean.valueOf(null != statistics.getFinalInvoiceId()));
            treeItem.setFinalInvoiceId(statistics.getFinalInvoiceId());
            treeItem.setFinalInvoiceNumber(statistics.getFinalInvoiceNumber());
        } else {
            String invoiceNumbersString = QEntityMapper.invoiceNumbersString(stageChildStatistics);
            treeItem.setFlagFinalInvoice(Boolean.valueOf(StringUtils.isNotBlank((CharSequence)invoiceNumbersString)));
            treeItem.setFinalInvoiceId(null);
            treeItem.setFinalInvoiceNumber(invoiceNumbersString);
        }
        treeItem.setDegreeOfFulfilment(BigDecimal.ONE.negate());
        treeItem.setCalculationAmount(null);
        treeItem.setAddendumAmount(null);
        treeItem.setCostUnitAmount(null);
        treeItem.setQuotationAmount(null);
        treeItem.setValueAggregated((BigDecimal)MoreObjects.firstNonNull((Object)stageStatistics.getValueAggregated(), (Object)BigDecimal.ZERO));
        treeItem.setOrderValueEstimate((BigDecimal)MoreObjects.firstNonNull((Object)stageStatistics.getOrderValueEstimate(), (Object)BigDecimal.ZERO));
        treeItem.setBudget((BigDecimal)MoreObjects.firstNonNull((Object)stageStatistics.getBudget(), (Object)BigDecimal.ZERO));
        Customer customer = stageStatistics.getCustomer();
        if (null != customer) {
            CustomerCommon customerCommon = this.customerMapper.map(customer, false, false);
            treeItem.setCustomer(customerCommon);
        }
        treeItem.setPath((List)ImmutableList.of((Object)root, (Object)pathName));
        return treeItem;
    }

    @Nonnull
    public EntityDashboardListCommon mapToDashboardCommon(@NonNull Iterable<EntityStatistics> entityStatistics) {
        if (entityStatistics == null) {
            throw new NullPointerException("entityStatistics is marked non-null but is null");
        }
        List commons = Streams.stream(entityStatistics).map(arg_0 -> this.mapToDashboardCommon(arg_0)).collect(Collectors.toList());
        return new EntityDashboardListCommon(commons.size(), commons);
    }

    @Nonnull
    public EntityDashboardCommon mapToDashboardCommon(@NonNull EntityStatistics entityStatistics) {
        if (entityStatistics == null) {
            throw new NullPointerException("entityStatistics is marked non-null but is null");
        }
        EntityDashboardCommon common = new EntityDashboardCommon();
        common.setEntityId(entityStatistics.getEntityId());
        common.setQentityNumber(entityStatistics.getEntityQNumber());
        EQEntityState entityQEntityState = (EQEntityState)MoreObjects.firstNonNull((Object)entityStatistics.getEntityQEntityState(), (Object)EQEntityState.UNKNOWN);
        common.setState(entityQEntityState.name());
        common.setAlias(entityStatistics.getEntityAlias());
        common.setPrimaryStageId(entityStatistics.getPrimaryStageId());
        Customer customer = entityStatistics.getCustomer();
        if (null != customer) {
            common.setCustomerId(customer.getId());
            common.setCustomerName(customer.getName());
            common.setCustomerText(common.getCustomerText());
        }
        common.setProjectId(entityStatistics.getProjectId());
        common.setProjectName(entityStatistics.getProjectName());
        common.setProjectReferenceId(entityStatistics.getProjectReferenceId());
        common.setOrderDescriptionCustomer(entityStatistics.getOrderDescriptionCustomer());
        common.setOrderDescriptionInternal(entityStatistics.getOrderDescriptionInternal());
        common.setPriceWithoutDiscountSum(entityStatistics.getPriceWithoutDiscountSum());
        common.setPriceWithDiscountSum(entityStatistics.getPriceWithDiscountSum());
        common.setFlagMeasurementWithoutCommissionNumberAllowed(entityStatistics.getFlagMeasurementWithoutCommissionNumberAllowed());
        common.setOrderValueEstimate(entityStatistics.getOrderValueEstimate());
        common.setPlannedSubmissionDate(entityStatistics.getPlannedSubmissionDate());
        common.setSubmissionDateTime(entityStatistics.getSubmissionDateTime());
        common.setSubmissionOfBidDate(entityStatistics.getSubmissionOfBidDate());
        common.setBindingPeriodDate(entityStatistics.getBindingPeriodDate());
        common.setProcurementNumber(entityStatistics.getProcurementNumber());
        common.setProjectExecutionStartDate(entityStatistics.getProjectExecutionStartDate());
        common.setProjectExecutionEndDate(entityStatistics.getProjectExecutionEndDate());
        common.setResponsibleUsersText(entityStatistics.getResponsibleUsersText());
        return common;
    }

    @Nonnull
    public QEntityAutoCompleteResponse mapAutoComplete(@NonNull Page<QEntity> entitiesPage) {
        if (entitiesPage == null) {
            throw new NullPointerException("entitiesPage is marked non-null but is null");
        }
        int size = entitiesPage.getSize();
        List entities = entitiesPage.getContent();
        List commons = this.mapAutoComplete(entities);
        return new QEntityAutoCompleteResponse(size, commons);
    }

    @Nonnull
    private List<QEntityAutoCompleteItemCommon> mapAutoComplete(@NonNull List<QEntity> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return (List)entities.stream().map(arg_0 -> this.mapAutoComplete(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private QEntityAutoCompleteItemCommon mapAutoComplete(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        QEntityAutoCompleteItemCommon common = new QEntityAutoCompleteItemCommon();
        common.setEntityId(entity.getId());
        String qNumber = entity.getQNumber();
        common.setQentityNumber(qNumber);
        String alias = entity.getAlias();
        common.setAlias(alias);
        LinkedHashSet textParts = Sets.newLinkedHashSet();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            textParts.add(alias);
        }
        if (StringUtils.isNotBlank((CharSequence)qNumber)) {
            textParts.add(qNumber);
        }
        String text = AUTOCOMPLETE_TEXT_JOINER.join((Iterable)textParts);
        common.setText(text);
        return common;
    }

    @Nonnull
    public PageCommon<EntitySearchItem> mapToSearchItem(Page<EntitySearchItemBucket> bucketPage) {
        return BaseMapper.map(bucketPage, arg_0 -> this.mapToSearchItem(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public EntitySearchItem mapToSearchItem(@NonNull EntitySearchItemBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        EntityIndexEntry entity = bucket.getEntityIndexEntry();
        String details = bucket.getDetails();
        Highlight rootHighlight = bucket.getRootHighlight();
        Highlight detailHighlight = bucket.getDetailHighlight();
        String companyName = this.companyConfig.getCompanyName();
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        IndexField field = detailHighlight.getField();
        String fieldName = this.messageService.get(field, new Object[]{companyName, stageOrEntityNumberPrefix});
        Iterable rootHighlightCommon = this.highlightMapper.map(rootHighlight);
        Iterable detailHighlightCommon = this.highlightMapper.map(detailHighlight);
        String entityNumber = entity.getEntityNumber();
        String effectiveEntityNumber = StringUtils.isNotBlank((CharSequence)entityNumber) ? entityNumber : StringUtils.trimToEmpty((String)entity.getEntityAlias());
        return EntitySearchItem.of((long)entity.getId(), (String)effectiveEntityNumber, (Iterable)rootHighlightCommon, (String)details, (String)field.fieldName(), (String)fieldName, (Iterable)detailHighlightCommon);
    }

    public QEntityMapper(ConfigService configService, CustomerMapper customerMapper, ProjectMapper projectMapper, HighlightMapper highlightMapper, MessageService messageService, CompanyConfig companyConfig) {
        this.configService = configService;
        this.customerMapper = customerMapper;
        this.projectMapper = projectMapper;
        this.highlightMapper = highlightMapper;
        this.messageService = messageService;
        this.companyConfig = companyConfig;
    }
}

