/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.businessunit.UserCostCenter;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.jpa.user.UserRole;
import de.qfm.q1.common.request.Q1EmployeeCostCenterModificationItem;
import de.qfm.q1.common.request.Q1EmployeeSyncRequest;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class Q1Mapper {
    private static final Logger log = LogManager.getLogger(Q1Mapper.class);

    @Nonnull
    public Q1EmployeeSyncRequest mapUser(@NonNull User user) {
        UserRole userRole;
        Role role;
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        Q1EmployeeSyncRequest syncRequest = new Q1EmployeeSyncRequest();
        syncRequest.setUsername(user.getUsername());
        syncRequest.setPasswort(user.getPassword());
        Iterable userRoles = (Iterable)MoreObjects.firstNonNull((Object)user.getUserRoles(), (Object)ImmutableSet.of());
        if (!Iterables.isEmpty((Iterable)userRoles) && null != (role = (userRole = (UserRole)Iterables.get((Iterable)userRoles, (int)0)).getRole())) {
            syncRequest.setGrpname(StringUtils.trimToEmpty((String)role.getName()));
        }
        syncRequest.setAnzpos(Long.valueOf(0L));
        syncRequest.setKzBenutzerInfoAnzeige(Long.valueOf(1L));
        syncRequest.setPhone(user.getPhone());
        syncRequest.setCellular(user.getCellular());
        syncRequest.setFax(user.getFax());
        syncRequest.setSocialSecurityNumber(user.getSocialSecurityNumber());
        syncRequest.setEmail(user.getEmail());
        syncRequest.setAnrede(user.getAuthorityToSign());
        syncRequest.setSitz(user.getLocation());
        syncRequest.setLastName(user.getLastName());
        syncRequest.setFirstName(user.getFirstName());
        syncRequest.setPersonalNumber(user.getPersonalNumber());
        User squadLeader = user.getSquadLeader();
        if (null != squadLeader) {
            syncRequest.setSquadLeaderPersonalNumber(squadLeader.getPersonalNumber());
        }
        syncRequest.setManagerPersonalNumber(null);
        syncRequest.setManagerFirstName("");
        syncRequest.setManagerLastName("");
        Iterable userCostCenters = (Iterable)MoreObjects.firstNonNull((Object)user.getUserCostCenters(), (Object)ImmutableSet.of());
        ImmutableList q1EmployeeCostCenterModItems = (ImmutableList)Streams.stream((Iterable)userCostCenters).map(arg_0 -> this.mapCostCenter(arg_0)).collect(ImmutableList.toImmutableList());
        syncRequest.setCostCenters((List)q1EmployeeCostCenterModItems);
        return syncRequest;
    }

    @Nonnull
    private Q1EmployeeCostCenterModificationItem mapCostCenter(@NonNull UserCostCenter userCostCenter) {
        if (userCostCenter == null) {
            throw new NullPointerException("userCostCenter is marked non-null but is null");
        }
        Q1EmployeeCostCenterModificationItem modificationItem = new Q1EmployeeCostCenterModificationItem();
        modificationItem.setId(userCostCenter.getId());
        modificationItem.setCostCenter(userCostCenter.getCostCenter());
        modificationItem.setValidFromDate(userCostCenter.getValidBegin());
        modificationItem.setValidToDate(userCostCenter.getValidEnd());
        return modificationItem;
    }
}

