/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.pss.PssReleaseOrderCommon;
import de.qfm.erp.common.response.pss.PssReleaseOrdersCommon;
import de.qfm.erp.service.model.internal.pss.PssReleaseOrderUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.ExtPssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PssMapper {
    @Nonnull
    public PssReleaseOrdersCommon map(@NonNull Page<PssReleaseOrder> pssReleaseOrdersPage) {
        if (pssReleaseOrdersPage == null) {
            throw new NullPointerException("pssReleaseOrdersPage is marked non-null but is null");
        }
        long totalElements = pssReleaseOrdersPage.getTotalElements();
        int totalPages = pssReleaseOrdersPage.getTotalPages();
        Pageable pageable = pssReleaseOrdersPage.getPageable();
        int pageSize = pageable == Pageable.unpaged() ? Integer.MAX_VALUE : pageable.getPageSize();
        int pageNumber = pageable == Pageable.unpaged() ? 1 : pageable.getPageNumber();
        List content = pssReleaseOrdersPage.getContent();
        List commons = (List)content.stream().map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new PssReleaseOrdersCommon(pageNumber, pageSize, totalPages, totalElements, commons);
    }

    @Nonnull
    public PssReleaseOrderCommon map(@NonNull PssReleaseOrder item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        PssReleaseOrderCommon common = new PssReleaseOrderCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setReferenceId(item.getReferenceId());
        common.setQuotationNumber(item.getQuotationNumber());
        common.setPssReleaseOrderId(item.getPssId());
        String projectNumber = StringUtils.trimToEmpty((String)item.getProjectNumber());
        common.setProjectNumber(projectNumber);
        String releaseOrderNumber = StringUtils.trimToEmpty((String)item.getReleaseOrderNumber());
        common.setReleaseOrderNumber(releaseOrderNumber);
        String place = StringUtils.trimToEmpty((String)item.getPlace());
        common.setPlace(place);
        common.setState(item.getPssState());
        common.setNamePreview(item.getReleaseOrderNamePreviewCurrent());
        common.setNameSelect(item.getReleaseOrderNameSelectCurrent());
        common.setFlagDisabled(item.getFlagDisabled());
        return common;
    }

    @Nonnull
    public PssReleaseOrder merge(@NonNull PssReleaseOrderUpdateBucket pssReleaseOrderUpdateBucket) {
        if (pssReleaseOrderUpdateBucket == null) {
            throw new NullPointerException("pssReleaseOrderUpdateBucket is marked non-null but is null");
        }
        PssReleaseOrder pssReleaseOrder = pssReleaseOrderUpdateBucket.getPssReleaseOrder();
        ExtPssReleaseOrder extPssReleaseOrder = pssReleaseOrderUpdateBucket.getExtPssReleaseOrder();
        String referenceId = StringUtils.trimToEmpty((String)extPssReleaseOrder.getReferenceId());
        String quotationNumber = StringUtils.trimToEmpty((String)extPssReleaseOrder.getQuotationNumber());
        String projectNumber = StringUtils.trimToEmpty((String)extPssReleaseOrder.getProjectNumber());
        String releaseOrderNumber = StringUtils.trimToEmpty((String)extPssReleaseOrder.getReleaseOrderNumber());
        Long externalPssReleaseOrderId = extPssReleaseOrder.getPssId();
        String pssReleaseOrderState = StringUtils.trimToEmpty((String)extPssReleaseOrder.getPssState());
        String pssReleaseOrderDescription = StringUtils.trimToEmpty((String)extPssReleaseOrder.getPlace());
        pssReleaseOrder.setReferenceId(referenceId);
        pssReleaseOrder.setQuotationNumber(quotationNumber);
        pssReleaseOrder.setProjectNumber(projectNumber);
        pssReleaseOrder.setReleaseOrderNumber(releaseOrderNumber);
        pssReleaseOrder.setPssId(externalPssReleaseOrderId);
        pssReleaseOrder.setPssState(pssReleaseOrderState);
        pssReleaseOrder.setPlace(pssReleaseOrderDescription);
        return pssReleaseOrder;
    }
}

