/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.request.employee.payroll.PayrollItemUpdateItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemGroupCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemGroupListCommon;
import de.qfm.erp.common.response.employee.payroll.PayrollMonthItemListCommon;
import de.qfm.erp.common.response.employee.payroll.SquadLeaderWageAggregatedCommon;
import de.qfm.erp.common.response.employee.payroll.SquadLeaderWageCommon;
import de.qfm.erp.common.response.employee.payroll.SquadLeaderWageListCommon;
import de.qfm.erp.common.response.employee.payroll.WagesAssignedToPayrollCommon;
import de.qfm.erp.service.helper.EmployeeHelper;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemsUpdateBucket;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthItemGroupBU;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthItemGroupCC;
import de.qfm.erp.service.model.internal.payroll.ProjectBasedWageIncentiveWageItem;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollMonthMessageKeys;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

@Service
public class PayrollMonthItemMapper {
    public static final String WAGE_ACCOUNT_NAME = "Guthaben";
    private final StandardPersistenceHelper standardPersistenceHelper;
    private final EntityFactory entityFactory;
    private final MessageService messageService;
    private static final Ordering<Comparable<?>> COMPARABLE_ORDERING = Ordering.natural().nullsLast();
    private static final Comparator<PayrollMonthItemCommon> PAYROLL_ITEM_COMPARATOR = (left, right) -> {
        Integer sequentialNumberRight;
        Integer sequentialNumberLeft = left.getSequentialNumber();
        int compareResult1st = COMPARABLE_ORDERING.compare((Object)sequentialNumberLeft, (Object)(sequentialNumberRight = right.getSequentialNumber()));
        if (0 == compareResult1st) {
            Long idLeft = left.getId();
            Long idRight = right.getId();
            return COMPARABLE_ORDERING.compare((Object)idLeft, (Object)idRight);
        }
        return compareResult1st;
    };
    private static final Comparator<SquadLeaderWageCommon> SQUAD_LEADER_WAGE_COMPARATOR = (left, right) -> {
        LocalDate dateRight;
        LocalDate dateLeft = left.getDate();
        int compareResult1st = COMPARABLE_ORDERING.compare((Object)dateLeft, (Object)(dateRight = right.getDate()));
        if (0 == compareResult1st) {
            String nameLeft = left.getFromEmployeeFullName();
            String nameRight = right.getFromEmployeeFullName();
            return COMPARABLE_ORDERING.compare((Object)nameLeft, (Object)nameRight);
        }
        return compareResult1st;
    };

    @Nonnull
    public PayrollMonthItemListCommon mapPayrollMonthItems(@NonNull Iterable<PayrollMonthItem> payrollMonthItems, @NonNull Function<User, Boolean> fnUserReleased) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        if (fnUserReleased == null) {
            throw new NullPointerException("fnUserReleased is marked non-null but is null");
        }
        ImmutableList payrollMonthItemCommons = (ImmutableList)IterableHelper.stream(payrollMonthItems).map(item -> this.mapPayrollMonthItem(item, fnUserReleased)).sorted(PAYROLL_ITEM_COMPARATOR).collect(ImmutableList.toImmutableList());
        return new PayrollMonthItemListCommon(Iterables.size((Iterable)payrollMonthItemCommons), (List)payrollMonthItemCommons);
    }

    @Nonnull
    private PayrollMonthItemCommon mapPayrollMonthItem(@NonNull PayrollMonthItem payrollMonthItem, @NonNull Function<User, Boolean> fnUserReleased) {
        if (payrollMonthItem == null) {
            throw new NullPointerException("payrollMonthItem is marked non-null but is null");
        }
        if (fnUserReleased == null) {
            throw new NullPointerException("fnUserReleased is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthItem.getPayrollMonth();
        User sender = payrollMonth.getUser();
        User recipient = payrollMonthItem.getRecipient();
        PayrollItemType payrollItemType = payrollMonthItem.getPayrollItemType();
        EPayrollItemClazz payrollItemClazz = (EPayrollItemClazz)MoreObjects.firstNonNull((Object)payrollMonthItem.getPayrollItemClazz(), (Object)EPayrollItemClazz.UNKNOWN);
        LocalDate accountingMonth = payrollMonth.getAccountingMonth();
        PayrollMonthItemCommon common = new PayrollMonthItemCommon();
        BaseMapper.map((EntityBase)payrollMonthItem, (EntityBaseCommon)common);
        common.setId(payrollMonthItem.getId());
        common.setReferenceId(payrollMonthItem.getReferenceId());
        common.setPayrollMonthId(payrollMonth.getId());
        if (null != payrollItemType) {
            common.setPayrollItemTypeId(payrollItemType.getId());
            common.setPayrollItemTypeName(payrollItemType.getName());
        }
        common.setPayrollItemClazz(payrollItemClazz.name());
        common.setValue(payrollMonthItem.getValue());
        common.setRemarks(payrollMonthItem.getRemarks());
        common.setSequentialNumber(payrollMonthItem.getSequentialNumber());
        common.setCostCenterSquad(payrollMonthItem.getCostCenterSquad());
        if (payrollItemClazz == EPayrollItemClazz.WAGE_ACCOUNT) {
            senderUserCostCenter = EmployeeHelper.currentCostCenterNotFailing((User)sender, (LocalDate)accountingMonth, (boolean)true).orElse("n/a");
            String recipientUserCostCenter = EmployeeHelper.currentCostCenterNotFailing((User)recipient, (LocalDate)accountingMonth, (boolean)true).orElse("n/a");
            String wageAccountLabel = this.messageService.get(EPayrollMonthMessageKeys.WAGE_ACCOUNT);
            String depositLabel = this.messageService.get(EPayrollMonthMessageKeys.WAGE_ACCOUNT__DEPOSIT);
            String payoutLabel = this.messageService.get(EPayrollMonthMessageKeys.WAGE_ACCOUNT__PAYOUT);
            boolean toWageAccount = payrollMonthItem.getValue().compareTo(BigDecimal.ZERO) < 0;
            String senderFullName = toWageAccount ? sender.getFullName() : wageAccountLabel;
            String recipientFullName = toWageAccount ? wageAccountLabel : recipient.getFullName();
            String remarks = toWageAccount ? depositLabel : payoutLabel;
            common.setSenderUserId(sender.getId());
            common.setSenderUserPersonalNumber(sender.getPersonalNumber());
            common.setSenderUserCostCenter(senderUserCostCenter);
            common.setSenderUserFullName(senderFullName);
            common.setRemarks(remarks);
            common.setRecipientUserId(recipient.getId());
            common.setRecipientUserFullName(recipientFullName);
            common.setRecipientUserPersonalNumber(recipient.getPersonalNumber());
            common.setFlagRecipientUserHasReleased(fnUserReleased.apply(recipient));
            common.setRecipientUserCostCenter(recipientUserCostCenter);
        } else {
            if (null != sender) {
                common.setSenderUserId(sender.getId());
                common.setSenderUserFullName(sender.getFullName());
                common.setSenderUserPersonalNumber(sender.getPersonalNumber());
                senderUserCostCenter = EmployeeHelper.currentCostCenterNotFailing((User)sender, (LocalDate)accountingMonth, (boolean)true).orElse("n/a");
                common.setSenderUserCostCenter(senderUserCostCenter);
            }
            if (null != recipient) {
                common.setRecipientUserId(recipient.getId());
                common.setRecipientUserFullName(recipient.getFullName());
                common.setRecipientUserPersonalNumber(recipient.getPersonalNumber());
                common.setFlagRecipientUserHasReleased(fnUserReleased.apply(recipient));
                String recipientUserCostCenter = EmployeeHelper.currentCostCenterNotFailing((User)recipient, (LocalDate)accountingMonth, (boolean)true).orElse("n/a");
                common.setRecipientUserCostCenter(recipientUserCostCenter);
            }
        }
        Quotation stage = payrollMonthItem.getQuotation();
        if (null != stage) {
            common.setQuotationNumber(stage.getQuotationNumber());
            common.setQuotationId(stage.getId());
            common.setAlias(StringUtils.trimToEmpty((String)stage.getAlias()));
            common.setQentityNumber(StringUtils.trimToEmpty((String)stage.getQNumber()));
        } else {
            common.setQuotationNumber(payrollMonthItem.getQuotationNumber());
        }
        Project project = payrollMonthItem.getProject();
        if (null != project) {
            common.setProjectId(project.getId());
            common.setProjectName(StringUtils.trimToEmpty((String)project.getName()));
            common.setProjectReferenceId(StringUtils.trimToEmpty((String)project.getReferenceId()));
        }
        return common;
    }

    @Nonnull
    public MergedBucket<PayrollMonthItem> merge(@NonNull PayrollMonthItemsUpdateBucket payrollMonthItemsUpdateBucket) {
        if (payrollMonthItemsUpdateBucket == null) {
            throw new NullPointerException("payrollMonthItemsUpdateBucket is marked non-null but is null");
        }
        Iterable payrollMonthItemUpdateBuckets = payrollMonthItemsUpdateBucket.getPayrollMonthItemUpdateBuckets();
        Iterable payrollMonthItems = payrollMonthItemsUpdateBucket.getPayrollMonthItems();
        Map<Long, PayrollMonthItem> payrollMonthItemsExistingById = IterableHelper.stream((Iterable)payrollMonthItems).collect(Collectors.toMap(PayrollMonthItem::getId, item -> item));
        Iterable payrollItemsToAdd = (Iterable)IterableHelper.stream((Iterable)payrollMonthItemUpdateBuckets).filter(item -> null == item.getPayrollMonthItem()).collect(ImmutableList.toImmutableList());
        Map<Long, PayrollMonthItemUpdateBucket> updateBucketsByID = IterableHelper.stream((Iterable)payrollMonthItemUpdateBuckets).filter(item -> null != item.getPayrollMonthItem()).collect(Collectors.toMap(item -> item.getPayrollItemUpdateItem().getId(), item -> item));
        Set<Long> payrollMonthItemIdsExisting = payrollMonthItemsExistingById.keySet();
        Set<Long> payrollMonthItemIdsToUpdate = updateBucketsByID.keySet();
        Sets.SetView toUpdate = Sets.intersection(payrollMonthItemIdsToUpdate, payrollMonthItemIdsExisting);
        Sets.SetView toRemove = Sets.difference(payrollMonthItemIdsExisting, payrollMonthItemIdsToUpdate);
        ImmutableList.Builder addedBuilder = ImmutableList.builder();
        for (PayrollMonthItemUpdateBucket bucket : payrollItemsToAdd) {
            PayrollMonthItem payrollMonthItem = this.entityFactory.payrollMonthItem();
            addedBuilder.add((Object)this.merge(payrollMonthItem, bucket));
        }
        ImmutableList payrollMonthItemsAdded = addedBuilder.build();
        ImmutableList.Builder updatedBuilder = ImmutableList.builder();
        for (Long idToUpdate : toUpdate) {
            PayrollMonthItemUpdateBucket bucket = updateBucketsByID.get(idToUpdate);
            PayrollMonthItem payrollMonthItem = bucket.getPayrollMonthItem();
            if (null == payrollMonthItem) continue;
            updatedBuilder.add((Object)this.merge(payrollMonthItem, bucket));
        }
        ImmutableList payrollMonthItemsUpdated = updatedBuilder.build();
        ImmutableList.Builder deletedBuilder = ImmutableList.builder();
        for (Long idToRemove : toRemove) {
            PayrollMonthItem payrollMonthItem = payrollMonthItemsExistingById.get(idToRemove);
            payrollMonthItem.setEntityState(EntityState.DELETED);
            this.standardPersistenceHelper.deleted((EntityBase)payrollMonthItem);
            deletedBuilder.add((Object)payrollMonthItem);
        }
        ImmutableList payrollMonthItemsDeleted = deletedBuilder.build();
        return MergedBucket.of((Iterable)payrollMonthItemsAdded, (Iterable)payrollMonthItemsUpdated, (Iterable)payrollMonthItemsDeleted);
    }

    @Nonnull
    private PayrollMonthItem merge(@NonNull PayrollMonthItem payrollMonthItem, @NonNull PayrollMonthItemUpdateBucket bucket) {
        if (payrollMonthItem == null) {
            throw new NullPointerException("payrollMonthItem is marked non-null but is null");
        }
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        EPayrollItemClazz payrollItemClazz = bucket.getPayrollItemClazz();
        PayrollItemType payrollItemType = bucket.getPayrollItemType();
        PayrollItemUpdateItem updateItem = bucket.getPayrollItemUpdateItem();
        Quotation quotation = bucket.getQuotation();
        Project project = bucket.getProject();
        User recipient = bucket.getRecipient();
        User sender = bucket.getSender();
        boolean changed = false;
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getPayrollItemType(), () -> payrollItemType, arg_0 -> ((PayrollMonthItem)payrollMonthItem).setPayrollItemType(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getRecipient(), () -> recipient, arg_0 -> ((PayrollMonthItem)payrollMonthItem).setRecipient(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getSender(), () -> sender, arg_0 -> ((PayrollMonthItem)payrollMonthItem).setSender(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getQuotationNumber(), () -> StringUtils.trimToEmpty((String)updateItem.getQuotationNumber()), arg_0 -> ((PayrollMonthItem)payrollMonthItem).setQuotationNumber(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getQuotation(), () -> quotation, arg_0 -> ((PayrollMonthItem)payrollMonthItem).setQuotation(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getPayrollItemClazz(), () -> payrollItemClazz, arg_0 -> ((PayrollMonthItem)payrollMonthItem).setPayrollItemClazz(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getValue(), () -> (BigDecimal)MoreObjects.firstNonNull((Object)updateItem.getValue(), (Object)BigDecimal.ZERO), arg_0 -> ((PayrollMonthItem)payrollMonthItem).setValue(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getRemarks(), () -> StringUtils.trimToEmpty((String)updateItem.getRemarks()), arg_0 -> ((PayrollMonthItem)payrollMonthItem).setRemarks(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getCostCenterSquad(), () -> StringUtils.trimToEmpty((String)updateItem.getCostCenterSquad()), arg_0 -> ((PayrollMonthItem)payrollMonthItem).setCostCenterSquad(arg_0));
        changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getSequentialNumber(), () -> ((PayrollItemUpdateItem)updateItem).getSequentialNumber(), arg_0 -> ((PayrollMonthItem)payrollMonthItem).setSequentialNumber(arg_0));
        if (changed |= BaseMapper.mergeIfDifferent(() -> ((PayrollMonthItem)payrollMonthItem).getProject(), () -> project, arg_0 -> ((PayrollMonthItem)payrollMonthItem).setProject(arg_0))) {
            this.standardPersistenceHelper.updated((EntityBase)payrollMonthItem);
        }
        return payrollMonthItem;
    }

    @Nonnull
    public WagesAssignedToPayrollCommon mapWagesAssignedToPayroll(@NonNull BigDecimal incentiveWageSum, @NonNull BigDecimal calculatedWageSum, @NonNull Iterable<PayrollMonthItem> incentiveWagesAssignedToPayroll, @NonNull Iterable<PayrollMonthItem> wageAccountAssignedToPayroll, @NonNull Iterable<Attendance> squadLeaderAttendancesAssignedToPayroll, @NonNull Function<User, Boolean> fnUserReleased) {
        if (incentiveWageSum == null) {
            throw new NullPointerException("incentiveWageSum is marked non-null but is null");
        }
        if (calculatedWageSum == null) {
            throw new NullPointerException("calculatedWageSum is marked non-null but is null");
        }
        if (incentiveWagesAssignedToPayroll == null) {
            throw new NullPointerException("incentiveWagesAssignedToPayroll is marked non-null but is null");
        }
        if (wageAccountAssignedToPayroll == null) {
            throw new NullPointerException("wageAccountAssignedToPayroll is marked non-null but is null");
        }
        if (squadLeaderAttendancesAssignedToPayroll == null) {
            throw new NullPointerException("squadLeaderAttendancesAssignedToPayroll is marked non-null but is null");
        }
        if (fnUserReleased == null) {
            throw new NullPointerException("fnUserReleased is marked non-null but is null");
        }
        PayrollMonthItemListCommon incentivePMIList = this.mapPayrollMonthItems(incentiveWagesAssignedToPayroll, fnUserReleased);
        PayrollMonthItemListCommon wageAccountPMIList = this.mapPayrollMonthItems(wageAccountAssignedToPayroll, fnUserReleased);
        SquadLeaderWageListCommon squadLeaderWageListCommon = this.mapSquadLeaderWages(squadLeaderAttendancesAssignedToPayroll);
        Pair squadLeaderWagesAggregationResult = this.aggregateAndMapSquadLeaderWages(squadLeaderWageListCommon);
        BigDecimal squadLeaderWagesAmount = (BigDecimal)squadLeaderWagesAggregationResult.getLeft();
        ImmutableList squadLeaderWagesAggregated = ImmutableList.copyOf((Iterable)((Iterable)squadLeaderWagesAggregationResult.getRight()));
        return WagesAssignedToPayrollCommon.of((BigDecimal)incentiveWageSum, (BigDecimal)calculatedWageSum, (PayrollMonthItemListCommon)incentivePMIList, (PayrollMonthItemListCommon)wageAccountPMIList, (SquadLeaderWageListCommon)squadLeaderWageListCommon, (BigDecimal)squadLeaderWagesAmount, (List)squadLeaderWagesAggregated);
    }

    @Nonnull
    private Pair<BigDecimal, Iterable<SquadLeaderWageAggregatedCommon>> aggregateAndMapSquadLeaderWages(@NonNull SquadLeaderWageListCommon squadLeaderWageListCommon) {
        if (squadLeaderWageListCommon == null) {
            throw new NullPointerException("squadLeaderWageListCommon is marked non-null but is null");
        }
        List items = squadLeaderWageListCommon.getItems();
        ImmutableListMultimap index = Multimaps.index((Iterable)items, SquadLeaderWageCommon::getFromEmployeeCostCenter);
        ImmutableMap squadLeaderWageByCC = index.asMap();
        ImmutableList.Builder squadLeaderWagesBuilder = ImmutableList.builder();
        for (Map.Entry entry : squadLeaderWageByCC.entrySet()) {
            String fromCostCenter = (String)entry.getKey();
            ImmutableList squadLeaderWagesInCC = ImmutableList.copyOf((Collection)((Collection)entry.getValue()));
            int size = squadLeaderWagesInCC.size();
            BigDecimal squadLeaderAmount = BigDecimal.valueOf(size);
            squadLeaderWagesBuilder.add((Object)new SquadLeaderWageAggregatedCommon(size, (List)squadLeaderWagesInCC, fromCostCenter, squadLeaderAmount));
        }
        ImmutableList squadLeaderWages = squadLeaderWagesBuilder.build();
        BigDecimal squadLeaderAmount = squadLeaderWages.stream().map(SquadLeaderWageAggregatedCommon::getSquadLeaderAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return Pair.of((Object)squadLeaderAmount, (Object)squadLeaderWages);
    }

    @Nonnull
    public SquadLeaderWageListCommon mapSquadLeaderWages(@NonNull Iterable<Attendance> attendances) {
        if (attendances == null) {
            throw new NullPointerException("attendances is marked non-null but is null");
        }
        ImmutableList squadLeaderWageCommons = (ImmutableList)IterableHelper.stream(attendances).map(arg_0 -> this.mapSquadLeaderWage(arg_0)).sorted(SQUAD_LEADER_WAGE_COMPARATOR).collect(ImmutableList.toImmutableList());
        return new SquadLeaderWageListCommon(Iterables.size((Iterable)squadLeaderWageCommons), (List)squadLeaderWageCommons);
    }

    @Nonnull
    public SquadLeaderWageCommon mapSquadLeaderWage(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        PayrollMonth senderPayrollMonth = attendance.getPayrollMonth();
        LocalDate accountingMonth = senderPayrollMonth.getAccountingMonth();
        User sender = senderPayrollMonth.getUser();
        Long senderUserId = sender.getId();
        Integer senderUserPersonalNumber = sender.getPersonalNumber();
        String senderUserFullName = sender.getFullName();
        String currentCostCenter = EmployeeHelper.currentCostCenterNotFailing((User)sender, (LocalDate)accountingMonth).orElse("n/a");
        LocalDate date = attendance.getDate();
        return SquadLeaderWageCommon.of((Long)senderUserId, (Integer)senderUserPersonalNumber, (String)senderUserFullName, (String)currentCostCenter, (LocalDate)date);
    }

    @Deprecated(forRemoval=true)
    @Nonnull
    public PayrollMonthItemGroupListCommon mapPayrollMonthItemGroupsBU(@NonNull Iterable<PayrollMonthItemGroupBU> payrollMonthItemGroups) {
        if (payrollMonthItemGroups == null) {
            throw new NullPointerException("payrollMonthItemGroups is marked non-null but is null");
        }
        ImmutableList commons = (ImmutableList)IterableHelper.stream(payrollMonthItemGroups).map(arg_0 -> this.mapPayrollMonthItemGroupBU(arg_0)).collect(ImmutableList.toImmutableList());
        return new PayrollMonthItemGroupListCommon(commons.size(), (List)commons);
    }

    @Nonnull
    public PayrollMonthItemGroupListCommon mapPayrollMonthItemGroupsCC(@NonNull Iterable<PayrollMonthItemGroupCC> payrollMonthItemGroups) {
        if (payrollMonthItemGroups == null) {
            throw new NullPointerException("payrollMonthItemGroups is marked non-null but is null");
        }
        ImmutableList commons = (ImmutableList)IterableHelper.stream(payrollMonthItemGroups).map(arg_0 -> this.mapPayrollMonthItemGroupCC(arg_0)).collect(ImmutableList.toImmutableList());
        return new PayrollMonthItemGroupListCommon(commons.size(), (List)commons);
    }

    @Deprecated(forRemoval=true)
    @Nonnull
    public PayrollMonthItemGroupCommon mapPayrollMonthItemGroupBU(@NonNull PayrollMonthItemGroupBU payrollMonthItemGroupBU) {
        if (payrollMonthItemGroupBU == null) {
            throw new NullPointerException("payrollMonthItemGroupBU is marked non-null but is null");
        }
        PayrollMonthItemGroupCommon common = new PayrollMonthItemGroupCommon();
        User recipient = payrollMonthItemGroupBU.getRecipient();
        BusinessUnit recipientBusinessUnit = payrollMonthItemGroupBU.getRecipientBusinessUnit();
        User sender = payrollMonthItemGroupBU.getSender();
        BusinessUnit senderBusinessUnit = payrollMonthItemGroupBU.getSenderBusinessUnit();
        String quotationNumber = StringUtils.trimToEmpty((String)payrollMonthItemGroupBU.getQuotationNumber());
        String remarks = StringUtils.trimToEmpty((String)payrollMonthItemGroupBU.getRemarks());
        BigDecimal value = payrollMonthItemGroupBU.getValue();
        if (null != recipient) {
            common.setRecipientUserId(recipient.getId());
            common.setRecipientUserFullName(recipient.getFullName());
            common.setRecipientUserPersonalNumber(recipient.getPersonalNumber());
        }
        if (null != recipientBusinessUnit) {
            String recipientUserCostCenter = recipientBusinessUnit.getCostCenter();
            common.setRecipientUserCostCenter(recipientUserCostCenter);
        }
        if (null != sender) {
            common.setSenderUserId(sender.getId());
            common.setSenderUserFullName(sender.getFullName());
            common.setSenderUserPersonalNumber(sender.getPersonalNumber());
        }
        if (null != senderBusinessUnit) {
            String senderUserCostCenter = senderBusinessUnit.getCostCenter();
            common.setSenderUserCostCenter(senderUserCostCenter);
        }
        EPayrollItemClazz payrollItemClazz = payrollMonthItemGroupBU.getPayrollItemClazz();
        common.setPayrollItemClazz(payrollItemClazz.name());
        common.setValue(value);
        common.setQuotationNumber(quotationNumber);
        common.setRemarks(remarks);
        Iterable children = payrollMonthItemGroupBU.getChildren();
        if (!Iterables.isEmpty((Iterable)children)) {
            List childrenCommon = this.mapPayrollMonthItemGroupsBU(children).getItems();
            common.setChildren((Iterable)childrenCommon);
        }
        return common;
    }

    @Nonnull
    public PayrollMonthItemGroupCommon mapPayrollMonthItemGroupCC(@NonNull PayrollMonthItemGroupCC payrollMonthItemGroupCC) {
        if (payrollMonthItemGroupCC == null) {
            throw new NullPointerException("payrollMonthItemGroupCC is marked non-null but is null");
        }
        PayrollMonthItemGroupCommon common = new PayrollMonthItemGroupCommon();
        User recipient = payrollMonthItemGroupCC.getRecipient();
        String recipientCostCenter = payrollMonthItemGroupCC.getRecipientCostCenter();
        User sender = payrollMonthItemGroupCC.getSender();
        String senderCostCenter = payrollMonthItemGroupCC.getSenderCostCenter();
        String quotationNumber = StringUtils.trimToEmpty((String)payrollMonthItemGroupCC.getQuotationNumber());
        String remarks = StringUtils.trimToEmpty((String)payrollMonthItemGroupCC.getRemarks());
        BigDecimal value = payrollMonthItemGroupCC.getValue();
        if (null != recipient) {
            common.setRecipientUserId(recipient.getId());
            common.setRecipientUserFullName(recipient.getFullName());
            common.setRecipientUserPersonalNumber(recipient.getPersonalNumber());
        }
        common.setRecipientUserCostCenter(recipientCostCenter);
        if (null != sender) {
            common.setSenderUserId(sender.getId());
            common.setSenderUserFullName(sender.getFullName());
            common.setSenderUserPersonalNumber(sender.getPersonalNumber());
        }
        common.setSenderUserCostCenter(senderCostCenter);
        EPayrollItemClazz payrollItemClazz = payrollMonthItemGroupCC.getPayrollItemClazz();
        common.setPayrollItemClazz(payrollItemClazz.name());
        common.setValue(value);
        common.setQuotationNumber(quotationNumber);
        common.setRemarks(remarks);
        Iterable children = payrollMonthItemGroupCC.getChildren();
        if (!Iterables.isEmpty((Iterable)children)) {
            List childrenCommon = this.mapPayrollMonthItemGroupsCC(children).getItems();
            common.setChildren((Iterable)childrenCommon);
        }
        return common;
    }

    @Nonnull
    public Iterable<ProjectBasedWageIncentiveWageItem> mapToProjectBasedWageIncentiveWageItem(@NonNull Iterable<PayrollMonthItem> payrollMonthItems) {
        if (payrollMonthItems == null) {
            throw new NullPointerException("payrollMonthItems is marked non-null but is null");
        }
        ImmutableList.Builder projectBasedWageIncentiveWageItemBuilder = ImmutableList.builder();
        for (PayrollMonthItem payrollMonthItem : payrollMonthItems) {
            EPayrollItemClazz payrollItemClazz = payrollMonthItem.getPayrollItemClazz();
            if (!Iterables.contains((Iterable)EPayrollItemClazz.PAYOUT_CONSIDER_INCENTIVE, (Object)payrollItemClazz)) continue;
            ProjectBasedWageIncentiveWageItem projectBasedWageIncentiveWageItem = this.mapToProjectBasedWageIncentiveWageItem(payrollMonthItem);
            projectBasedWageIncentiveWageItemBuilder.add((Object)projectBasedWageIncentiveWageItem);
        }
        return projectBasedWageIncentiveWageItemBuilder.build();
    }

    @Nonnull
    public ProjectBasedWageIncentiveWageItem mapToProjectBasedWageIncentiveWageItem(@NonNull PayrollMonthItem payrollMonthItem) {
        String senderFullName;
        String recipientFullName;
        String stageProjectName;
        String stageProjectReferenceId;
        String stageAlias;
        String stageNumber;
        String stageNumberDefault;
        if (payrollMonthItem == null) {
            throw new NullPointerException("payrollMonthItem is marked non-null but is null");
        }
        EPayrollItemClazz payrollItemClazz = (EPayrollItemClazz)MoreObjects.firstNonNull((Object)payrollMonthItem.getPayrollItemClazz(), (Object)EPayrollItemClazz.UNKNOWN);
        User sender = payrollMonthItem.getSender();
        Integer senderPersonalNumber = sender.getPersonalNumber();
        String senderCostCenter = EmployeeHelper.currentCostCenterNotFailing((User)sender, (LocalDate)payrollMonthItem.getPayrollMonth().getAccountingMonth()).orElse("n/a");
        User recipient = payrollMonthItem.getRecipient();
        Integer recipientPersonalNumber = recipient.getPersonalNumber();
        String recipientCostCenter = EmployeeHelper.currentCostCenterNotFailing((User)recipient, (LocalDate)payrollMonthItem.getPayrollMonth().getAccountingMonth()).orElse("n/a");
        BigDecimal amount = (BigDecimal)MoreObjects.firstNonNull((Object)payrollMonthItem.getValue(), (Object)BigDecimal.ZERO);
        String string = stageNumberDefault = payrollItemClazz == EPayrollItemClazz.WAGE_ACCOUNT ? WAGE_ACCOUNT_NAME : "";
        if (payrollItemClazz == EPayrollItemClazz.WAGE_ACCOUNT) {
            Quotation stage = payrollMonthItem.getQuotation();
            stageNumber = null != stage ? stage.getQNumber() : stageNumberDefault;
            Project project = null != stage ? stage.getProject() : null;
            stageAlias = null != stage ? stage.getAlias() : "";
            stageProjectReferenceId = null != project ? project.getReferenceId() : "";
            String string2 = stageProjectName = null != project ? project.getName() : "";
            if (amount.compareTo(BigDecimal.ZERO) > 0) {
                recipientFullName = recipient.getFullName();
                senderFullName = WAGE_ACCOUNT_NAME;
            } else {
                recipientFullName = WAGE_ACCOUNT_NAME;
                senderFullName = sender.getFullName();
            }
        } else if (payrollItemClazz == EPayrollItemClazz.INCENTIVE_PAYMENT) {
            Quotation stage = payrollMonthItem.getQuotation();
            stageNumber = null != stage ? stage.getQNumber() : stageNumberDefault;
            Project project = null != stage ? stage.getProject() : null;
            stageAlias = null != stage ? stage.getAlias() : "";
            stageProjectReferenceId = null != project ? project.getReferenceId() : "";
            stageProjectName = null != project ? project.getName() : "";
            recipientFullName = recipient.getFullName();
            senderFullName = sender.getFullName();
        } else if (payrollItemClazz == EPayrollItemClazz.AUXILIARY_WAGE) {
            Project project = payrollMonthItem.getProject();
            stageNumber = null != project ? project.getCostBearer() : stageNumberDefault;
            PayrollItemType payrollItemType = payrollMonthItem.getPayrollItemType();
            stageAlias = null != payrollItemType ? payrollItemType.getName() : "";
            stageProjectReferenceId = null != project ? project.getReferenceId() : "";
            stageProjectName = null != project ? project.getName() : "";
            recipientFullName = recipient.getFullName();
            senderFullName = sender.getFullName();
        } else {
            stageNumber = "";
            stageAlias = "";
            stageProjectReferenceId = "";
            stageProjectName = "";
            recipientFullName = recipient.getFullName();
            senderFullName = sender.getFullName();
        }
        return ProjectBasedWageIncentiveWageItem.of((Integer)senderPersonalNumber, (String)senderFullName, (String)senderCostCenter, (Integer)recipientPersonalNumber, (String)recipientFullName, (String)recipientCostCenter, (String)stageNumber, (String)stageAlias, (String)stageProjectReferenceId, (String)stageProjectName, (BigDecimal)amount, (EPayrollItemClazz)payrollItemClazz);
    }

    public PayrollMonthItemMapper(StandardPersistenceHelper standardPersistenceHelper, EntityFactory entityFactory, MessageService messageService) {
        this.standardPersistenceHelper = standardPersistenceHelper;
        this.entityFactory = entityFactory;
        this.messageService = messageService;
    }
}

