/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.measurement.MeasurementStateCommon;
import de.qfm.erp.service.helper.IMeasurementComparators;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementStateReason;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MeasurementStateMapper {
    private static final Logger log = LogManager.getLogger(MeasurementStateMapper.class);

    @Nonnull
    public List<MeasurementStateCommon> map(@NonNull Iterable<MeasurementState> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return ImmutableList.copyOf(Streams.stream(entities).sorted(IMeasurementComparators.MEASUREMENT_STATE_COMPARATOR).map(arg_0 -> this.map(arg_0)).iterator());
    }

    @Nonnull
    public MeasurementStateCommon map(@NonNull MeasurementState entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        MeasurementStateCommon common = new MeasurementStateCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        EMeasurementState measurementState = (EMeasurementState)MoreObjects.firstNonNull((Object)entity.getMeasurementState(), (Object)EMeasurementState.UNKNOWN);
        common.setMeasurementState(measurementState.name());
        EMeasurementStateReason measurementStateReason = (EMeasurementStateReason)MoreObjects.firstNonNull((Object)entity.getMeasurementStateReason(), (Object)EMeasurementStateReason.UNKNOWN);
        common.setMeasurementStateReason(measurementStateReason.name());
        common.setMeasurementStateSince(entity.getMeasurementStateSince());
        Measurement measurement = entity.getMeasurement();
        if (null != measurement) {
            common.setMeasurementId(measurement.getId());
        }
        return common;
    }
}

