/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.search.LuceneHelper;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.search.EIndexEntryType;
import de.qfm.erp.service.model.search.EMeasurementIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.MeasurementIndexEntry;
import de.qfm.erp.service.service.mapper.search.MeasurementIndexEntrySerializer;
import de.qfm.erp.service.service.service.ConfigService;
import java.time.LocalDateTime;
import java.util.LinkedHashSet;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementSearchMapper {
    private static final Logger log = LogManager.getLogger(MeasurementSearchMapper.class);
    private static final Joiner ALL_JOINER = Joiner.on((char)' ').skipNulls();
    private static final Joiner ID_JOINER = Joiner.on((char)'_').useForNull("x");
    private static final Splitter NAME_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"-,")).trimResults();
    private final MeasurementIndexEntrySerializer measurementIndexEntrySerializer;
    private final Analyzer indexAnalyzer;
    private final ConfigService configService;

    @Nonnull
    public IndexDocument mapToDocument(@NonNull Measurement measurement, @NonNull EIndexEntryType indexEntryType) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return this.mapToDocument(this.mapToIndexEntry(measurement, indexEntryType));
    }

    @Nonnull
    public Iterable<IndexDocument> mapToDocument(@NonNull Iterable<Measurement> measurements, @NonNull EIndexEntryType indexEntryType) {
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        return (Iterable)Streams.stream(measurements).map(item -> this.mapToIndexEntry(item, indexEntryType)).map(arg_0 -> this.mapToDocument(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public MeasurementIndexEntry mapToIndexEntry(@NonNull Measurement measurement, @NonNull EIndexEntryType indexEntryType) {
        Quotation stage;
        Invoice invoice;
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        MeasurementIndexEntry indexEntry = new MeasurementIndexEntry();
        indexEntry.setId(measurement.getId());
        indexEntry.setIndexEntryType(indexEntryType);
        indexEntry.setCreatedOn(measurement.getCreatedOn());
        indexEntry.setCreatedBy(measurement.getCreatedBy());
        indexEntry.setUpdatedOn(measurement.getUpdatedOn());
        indexEntry.setUpdatedBy(measurement.getUpdatedBy());
        indexEntry.setEntityState(measurement.getEntityState());
        MeasurementState measurementState = measurement.getMeasurementState();
        EMeasurementState eMeasurementState = null != measurementState ? measurementState.getMeasurementState() : EMeasurementState.UNKNOWN;
        indexEntry.setMeasurementState(eMeasurementState);
        EMeasurementType measurementType = measurement.getMeasurementType();
        indexEntry.setMeasurementType(measurementType);
        indexEntry.setMeasurementNumber(measurement.getMeasurementNumber());
        indexEntry.setOriginalMeasurementNumber(measurement.getOriginalMeasurementNumber());
        User assignedUser = measurement.getAssignedUser();
        if (null != assignedUser) {
            indexEntry.setAssignedUserId(assignedUser.getId());
            indexEntry.setAssignedUserFullName(assignedUser.getFullName());
        }
        if (null != (invoice = measurement.getInvoice())) {
            Long id = invoice.getId();
            String invoiceNumber = invoice.getInvoiceNumber();
            indexEntry.setInvoiceId(id);
            indexEntry.setInvoiceNumber(invoiceNumber);
        }
        indexEntry.setConstructionSite(measurement.getConstructionSite());
        ReleaseOrder releaseOrder = measurement.getReleaseOrder();
        if (null != releaseOrder) {
            indexEntry.setReleaseOrderId(releaseOrder.getId());
            indexEntry.setReleaseOrderName(releaseOrder.getName());
            PssReleaseOrder pssReleaseOrder = releaseOrder.getPssReleaseOrder();
            if (null != pssReleaseOrder) {
                indexEntry.setPssReleaseOrderId(pssReleaseOrder.getPssId());
                indexEntry.setPssReleaseOrderName(pssReleaseOrder.getReleaseOrderNamePreviewCurrent());
            }
        }
        if (null != (stage = measurement.getQuotation())) {
            indexEntry.setStageId(stage.getId());
            indexEntry.setQuotationNumber(stage.getQuotationNumber());
            indexEntry.setStageNumber(stage.getQNumber());
            indexEntry.setStageAlias(stage.getAlias());
            QEntity entity = stage.getQEntity();
            if (null != entity) {
                indexEntry.setEntityId(entity.getId());
                indexEntry.setEntityNumber(entity.getQNumber());
                indexEntry.setEntityAlias(entity.getAlias());
            }
        }
        return indexEntry;
    }

    @Nonnull
    public IndexDocument mapToDocument(@Nonnull MeasurementIndexEntry measurementIndexEntry) {
        String source;
        Document document = new Document();
        String documentId = MeasurementSearchMapper.documentId((MeasurementIndexEntry)measurementIndexEntry);
        String type = measurementIndexEntry.getIndexEntryType().name();
        try {
            source = this.measurementIndexEntrySerializer.serialize(measurementIndexEntry);
        }
        catch (JsonProcessingException e) {
            source = "";
        }
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField._ID, (String)documentId).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField._TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        document.add((IndexableField)LuceneHelper.store((IndexField)EMeasurementIndexField._SOURCE, (String)source));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.ENTRY_TYPE, (String)type).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EMeasurementIndexField.MEASUREMENT__CREATED_ON, (LocalDateTime)measurementIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.dateTimeStr((IndexField)EMeasurementIndexField.MEASUREMENT__UPDATED_ON, (LocalDateTime)measurementIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__CREATED_BY, (String)measurementIndexEntry.getCreatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__UPDATED_BY, (String)measurementIndexEntry.getUpdatedBy()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__ENTITY_STATE, (String)measurementIndexEntry.getEntityState().name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__MEASUREMENT_STATE, (String)measurementIndexEntry.getMeasurementState().name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__MEASUREMENT_TYPE, (String)measurementIndexEntry.getMeasurementType().name()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        Iterable names = this.handleName(EMeasurementIndexField.MEASUREMENT__ASSIGNED_USER_FULL_NAME, measurementIndexEntry.getAssignedUserFullName());
        names.forEach(item -> LuceneHelper.tokenized((IndexField)EMeasurementIndexField.MEASUREMENT__ASSIGNED_USER_FULL_NAME, (String)item).ifPresent(arg_0 -> ((Document)document).add(arg_0)));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__MEASUREMENT_NUMBER, (String)measurementIndexEntry.getMeasurementNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__QUOTATION_NUMBER, (String)StringUtils.remove((String)measurementIndexEntry.getQuotationNumber(), (String)"/")).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__QUOTATION_NUMBER, (String)measurementIndexEntry.getQuotationNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__ORIGINAL_MEASUREMENT_NUMBER, (String)measurementIndexEntry.getOriginalMeasurementNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EMeasurementIndexField.MEASUREMENT__CONSTRUCTION_SITE, (String)measurementIndexEntry.getConstructionSite()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.tokenized((IndexField)EMeasurementIndexField.MEASUREMENT__RELEASE_ORDER__NAME, (String)measurementIndexEntry.getReleaseOrderName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__PSS_RELEASE_ORDER__NAME, (String)measurementIndexEntry.getPssReleaseOrderName()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__INVOICE_NUMBER, (String)measurementIndexEntry.getInvoiceNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__STAGE_NUMBER, (String)StringUtils.removeStart((String)measurementIndexEntry.getStageNumber(), (String)this.configService.getStageOrEntityNumberPrefix())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__STAGE_NUMBER, (String)measurementIndexEntry.getStageNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__STAGE_ALIAS, (String)measurementIndexEntry.getStageAlias()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__ENTITY_NUMBER, (String)StringUtils.removeStart((String)measurementIndexEntry.getEntityNumber(), (String)this.configService.getStageOrEntityNumberPrefix())).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__ENTITY_ALIAS, (String)measurementIndexEntry.getEntityAlias()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.notTokenized((IndexField)EMeasurementIndexField.MEASUREMENT__QUOTATION_NUMBER, (String)measurementIndexEntry.getQuotationNumber()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        String allFromDocument = MeasurementSearchMapper.allFromDocument((Document)document);
        LuceneHelper.tokenized((IndexField)EMeasurementIndexField._ALL, (String)allFromDocument).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EMeasurementIndexField.SORT_MEASUREMENT__CREATED_ON, (LocalDateTime)measurementIndexEntry.getCreatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        LuceneHelper.sort((IndexField)EMeasurementIndexField.SORT_MEASUREMENT__UPDATED_ON, (LocalDateTime)measurementIndexEntry.getUpdatedOn()).ifPresent(arg_0 -> ((Document)document).add(arg_0));
        return IndexDocument.of((String)documentId, (String)type, (Document)document);
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull MeasurementIndexEntry measurementIndexEntry) {
        if (measurementIndexEntry == null) {
            throw new NullPointerException("measurementIndexEntry is marked non-null but is null");
        }
        return MeasurementSearchMapper.documentId((EIndexEntryType)measurementIndexEntry.getIndexEntryType(), (Long)measurementIndexEntry.getId());
    }

    @Nonnull
    @VisibleForTesting
    public static String documentId(@NonNull EIndexEntryType indexEntryType, @NonNull Long id) {
        if (indexEntryType == null) {
            throw new NullPointerException("indexEntryType is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return ID_JOINER.join((Object)indexEntryType, (Object)id, new Object[0]);
    }

    @Nonnull
    @VisibleForTesting
    Iterable<String> handleName(@NonNull EMeasurementIndexField field, @NonNull String value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        String normalizedValue = LuceneHelper.normalize((Analyzer)this.indexAnalyzer, (IndexField)field, (String)value);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)normalizedValue);
        Streams.stream((Iterable)NAME_SPLITTER.split((CharSequence)normalizedValue)).filter(StringUtils::isNotBlank).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Nonnull
    private static String allFromDocument(@NonNull Document document) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        LinkedHashSet allFieldValuesCollector = Sets.newLinkedHashSet();
        EMeasurementIndexField.CATCH_ALL_FIELDS.forEach(EIndexField -> {
            String fieldName = EIndexField.fieldName();
            String value = StringUtils.trimToEmpty((String)document.get(fieldName));
            if (StringUtils.isNotBlank((CharSequence)value)) {
                allFieldValuesCollector.add(value);
            }
        });
        return ALL_JOINER.join((Iterable)allFieldValuesCollector);
    }

    public MeasurementSearchMapper(MeasurementIndexEntrySerializer measurementIndexEntrySerializer, Analyzer indexAnalyzer, ConfigService configService) {
        this.measurementIndexEntrySerializer = measurementIndexEntrySerializer;
        this.indexAnalyzer = indexAnalyzer;
        this.configService = configService;
    }
}

