/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.helper.IMeasurementComparators;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import de.qfm.erp.service.model.internal.print.AddendumGroupPrice;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPositionPrintPreliminaryStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPositionPrintStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPositionTransposedPrintGroup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintBucket;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintGrouped;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintInfo;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintPreliminaryStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintStandard;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintTransposed;
import de.qfm.erp.service.model.internal.print.measurement.TransposedItem;
import de.qfm.erp.service.model.internal.transposition.MeasurementTransposedRemark;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.ReleaseOrder;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.mapper.MeasurementMapper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementPrintMapper {
    private UserService userService;
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final Comparator<? super MeasurementPosition> TRANSPOSED_MEASUREMENT_POSITION_COMPARATOR = (left, right) -> {
        int compare1st = Integer.compare(left.getColumnIndexTransposed(), right.getColumnIndexTransposed());
        if (0 != compare1st) {
            return compare1st;
        }
        return StringUtils.compare((String)left.getSurrogatePositionNumber(), (String)right.getSurrogatePositionNumber(), (boolean)false);
    };
    private final MeasurementMapper measurementMapper;
    private final MessageService messageService;

    @Nonnull
    private <T extends MeasurementPrintInfo> T create(@NonNull Supplier<T> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        MeasurementPrintInfo item = (MeasurementPrintInfo)supplier.get();
        item.setCurrency(Currency.getInstance(Locale.GERMANY));
        return (T)item;
    }

    @Nonnull
    public MeasurementPrintGrouped mapGrouped(@NonNull MeasurementPrintBucket measurementPrintBucket, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions) {
        if (measurementPrintBucket == null) {
            throw new NullPointerException("measurementPrintBucket is marked non-null but is null");
        }
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        MeasurementPrintGrouped measurementPrintGrouped = (MeasurementPrintGrouped)this.fromMeasurement(measurementPrintBucket, (MeasurementPrintInfo)((MeasurementPrintGrouped)this.create(MeasurementPrintGrouped::new)));
        Measurement measurement = measurementPrintBucket.getMeasurement();
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        ImmutableSet remarksSorted = ImmutableSet.copyOf(measurementPositions.stream().sorted((l, r) -> Ordering.natural().nullsLast().compare((Object)l.getSequenceNumberMeasurementStandard(), (Object)r.getSequenceNumberMeasurementStandard())).map(item -> StringUtils.trimToEmpty((String)item.getRemarks())).iterator());
        ImmutableListMultimap groupedByRemarkMMap = Multimaps.index((Iterable)measurementPositions, item -> StringUtils.trimToEmpty((String)item.getRemarks()));
        Map groupedByRemarkMap = groupedByRemarkMMap.asMap();
        ImmutableMap.Builder transposedPrintGroupsBuilder = ImmutableMap.builder();
        groupedByRemarkMap.forEach((remark, measurementPosition) -> {
            Iterable transposedItems = this.transposedItems((Iterable)measurementPosition, booleanPrintOptions);
            transposedPrintGroupsBuilder.put((Object)StringUtils.trimToEmpty((String)remark), (Object)MeasurementPositionTransposedPrintGroup.of((String)remark, (Iterable)transposedItems));
        });
        ImmutableMap transposedPrintGroups = transposedPrintGroupsBuilder.build();
        ImmutableList.Builder sortedPrintGroupsBuilder = ImmutableList.builder();
        remarksSorted.forEach(arg_0 -> MeasurementPrintMapper.lambda$mapGrouped$5((Map)transposedPrintGroups, sortedPrintGroupsBuilder, arg_0));
        ImmutableList sortedPrintGroups = sortedPrintGroupsBuilder.build();
        measurementPrintGrouped.setMeasurementPositions((List)sortedPrintGroups);
        return measurementPrintGrouped;
    }

    @Nonnull
    public MeasurementPrintTransposed mapRotated(@NonNull MeasurementPrintBucket measurementPrintBucket, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions) {
        if (measurementPrintBucket == null) {
            throw new NullPointerException("measurementPrintBucket is marked non-null but is null");
        }
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        MeasurementPrintTransposed printTransposed = (MeasurementPrintTransposed)this.fromMeasurement(measurementPrintBucket, (MeasurementPrintInfo)((MeasurementPrintTransposed)this.create(MeasurementPrintTransposed::new)));
        Measurement measurement = measurementPrintBucket.getMeasurement();
        Iterable measurementPositions = (Iterable)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        Iterable measurementTransposedRemarks = this.measurementMapper.mapToInternal(measurement);
        List remarksSortingKept = (List)IterableHelper.stream((Iterable)measurementTransposedRemarks).map(MeasurementTransposedRemark::getRemark).map(StringUtils::trimToEmpty).collect(ImmutableList.toImmutableList());
        Set surrogatePositionNumbersSorted = (Set)IterableHelper.stream((Iterable)measurementPositions).sorted(TRANSPOSED_MEASUREMENT_POSITION_COMPARATOR).map(item -> StringUtils.trimToEmpty((String)item.getSurrogatePositionNumber())).collect(ImmutableSet.toImmutableSet());
        Iterable transposedItems = this.transposedItems(measurementPositions, booleanPrintOptions);
        LinkedHashMap globalMapByRemark = Maps.newLinkedHashMap();
        for (TransposedItem nextTransposedItem : transposedItems) {
            String surrogatePositionNumber = nextTransposedItem.getQuotationSurrogatePositionNumber();
            String remark = nextTransposedItem.getRemark();
            Map mapBySurrogatePositionNumber = globalMapByRemark.getOrDefault(remark, Maps.newLinkedHashMap());
            if (mapBySurrogatePositionNumber.containsKey(surrogatePositionNumber)) {
                TransposedItem existingTransposedItem = (TransposedItem)mapBySurrogatePositionNumber.get(surrogatePositionNumber);
                TransposedItem mergedTransposedItem = existingTransposedItem.merge(nextTransposedItem);
                mapBySurrogatePositionNumber.put(surrogatePositionNumber, mergedTransposedItem);
            } else {
                mapBySurrogatePositionNumber.put(surrogatePositionNumber, nextTransposedItem);
            }
            globalMapByRemark.put(remark, mapBySurrogatePositionNumber);
        }
        printTransposed.setAllRemarks((List)ImmutableList.copyOf((Collection)remarksSortingKept));
        printTransposed.setAllStagePositionNumbers((List)ImmutableList.copyOf((Collection)surrogatePositionNumbersSorted));
        printTransposed.setTransposedItemsByRemark((Map)globalMapByRemark);
        Map nameByPositionNumber = MeasurementPrintMapper.prepareMap((Iterable)transposedItems, TransposedItem::getQuotationSurrogatePositionNumber, TransposedItem::getShortText);
        Map unitByPositionNumber = MeasurementPrintMapper.prepareMap((Iterable)transposedItems, TransposedItem::getQuotationSurrogatePositionNumber, TransposedItem::getUnit);
        printTransposed.setNameByPositionNumber(nameByPositionNumber);
        printTransposed.setUnitByPositionNumber(unitByPositionNumber);
        return printTransposed;
    }

    @Nonnull
    private static Map<String, String> prepareMap(@NonNull Iterable<TransposedItem> transposedItems, @NonNull Function<TransposedItem, String> keyFn, @NonNull Function<TransposedItem, String> valueFn) {
        if (transposedItems == null) {
            throw new NullPointerException("transposedItems is marked non-null but is null");
        }
        if (keyFn == null) {
            throw new NullPointerException("keyFn is marked non-null but is null");
        }
        if (valueFn == null) {
            throw new NullPointerException("valueFn is marked non-null but is null");
        }
        HashMap map = Maps.newHashMap();
        for (TransposedItem transposedItem : transposedItems) {
            String key = keyFn.apply(transposedItem);
            String value = valueFn.apply(transposedItem);
            if (map.containsKey(key)) continue;
            map.put(key, value);
        }
        return ImmutableMap.copyOf((Map)map);
    }

    @Nonnull
    public MeasurementPrintStandard mapStandard(@NonNull MeasurementPrintBucket measurementPrintBucket, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions) {
        if (measurementPrintBucket == null) {
            throw new NullPointerException("measurementPrintBucket is marked non-null but is null");
        }
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        Measurement measurement = measurementPrintBucket.getMeasurement();
        Quotation quotation = measurementPrintBucket.getQuotation();
        MeasurementPrintStandard printStandard = (MeasurementPrintStandard)this.fromMeasurement(measurementPrintBucket, (MeasurementPrintInfo)((MeasurementPrintStandard)this.create(MeasurementPrintStandard::new)));
        printStandard.setHeadlineG1(StringUtils.trimToEmpty((String)quotation.getHeadlineG1()));
        printStandard.setHeadlineG2(StringUtils.trimToEmpty((String)quotation.getHeadlineG2()));
        printStandard.setHeadlineG3(StringUtils.trimToEmpty((String)quotation.getHeadlineG3()));
        printStandard.setHeadlineG4(StringUtils.trimToEmpty((String)quotation.getHeadlineG4()));
        boolean printJumboA = this.printJumboAEnabled(booleanPrintOptions);
        boolean printJumboB = this.printJumboBEnabled(booleanPrintOptions);
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        List measurementPositionPrintStandards = (List)measurementPositions.stream().sorted(IMeasurementComparators.MEASUREMENT_POSITION_COMPARATOR).map(item -> this.mapStandard(item, printJumboA, printJumboB)).collect(ImmutableList.toImmutableList());
        printStandard.setMeasurementPositions(measurementPositionPrintStandards);
        return printStandard;
    }

    @Nonnull
    private Iterable<TransposedItem> transposedItems(@NonNull Iterable<MeasurementPosition> measurementPositions, @NonNull Iterable<EBooleanPrintOption> booleanPrintOptions) {
        if (measurementPositions == null) {
            throw new NullPointerException("measurementPositions is marked non-null but is null");
        }
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        boolean printJumboA = this.printJumboAEnabled(booleanPrintOptions);
        boolean printJumboB = this.printJumboBEnabled(booleanPrintOptions);
        return ImmutableList.copyOf(IterableHelper.stream(measurementPositions).map(item -> this.transposedItem(item, printJumboA, printJumboB)).iterator());
    }

    @Nonnull
    private TransposedItem transposedItem(@NonNull MeasurementPosition measurementPosition, boolean printJumboA, boolean printJumboB) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        TransposedItem transposedItem = new TransposedItem();
        transposedItem.setPositionType(measurementPosition.getPositionType());
        EPositionType positionType = measurementPosition.getPositionType();
        if (printJumboA && EPositionType.JUMBO_INTERNAL_TYPE_A == positionType) {
            BigDecimal priceAggregated = measurementPosition.getPriceAggregated();
            transposedItem.setAmount(priceAggregated);
            transposedItem.setProduct(priceAggregated);
            transposedItem.setQuotationSurrogatePositionNumber(measurementPosition.getJumboPositionSurrogatePositionNumber());
            transposedItem.setUnit(measurementPosition.getJumboPositionUnit());
            transposedItem.setShortText(StringUtils.trimToEmpty((String)measurementPosition.getJumboPositionShortText()));
        } else if (printJumboB && EPositionType.JUMBO_INTERNAL_TYPE_B == positionType) {
            transposedItem.setQuotationSurrogatePositionNumber(measurementPosition.getJumboPositionSurrogatePositionNumber());
            transposedItem.setAmount(measurementPosition.getAmount());
            transposedItem.setProduct(measurementPosition.getProduct());
            transposedItem.setUnit(measurementPosition.getUnit());
            transposedItem.setShortText(StringUtils.trimToEmpty((String)measurementPosition.getJumboPositionShortText()));
        } else {
            transposedItem.setAmount(measurementPosition.getAmount());
            transposedItem.setProduct(measurementPosition.getProduct());
            transposedItem.setQuotationSurrogatePositionNumber(measurementPosition.getSurrogatePositionNumber());
            transposedItem.setUnit(measurementPosition.getUnit());
            transposedItem.setShortText(StringUtils.trimToEmpty((String)measurementPosition.getShortText()));
        }
        transposedItem.setQuotationPositionNumber(measurementPosition.getQuotationPositionNumber());
        transposedItem.setQuotationSubPositionNumber(measurementPosition.getQuotationSubPositionNumber());
        transposedItem.setLongText(measurementPosition.getLongText());
        transposedItem.setInternalSquadWagePerUnit(measurementPosition.getInternalSquadWagePerUnit());
        transposedItem.setInternalSquadWageAggregated(measurementPosition.getInternalSquadWageAggregated());
        String safeRemark = StringUtils.trimToEmpty((String)measurementPosition.getRemarks());
        transposedItem.setRemark(safeRemark);
        return transposedItem;
    }

    @Nonnull
    private <T extends MeasurementPrintInfo> T fromMeasurement(@NonNull MeasurementPrintBucket measurementPrintBucket, @NonNull T meta) {
        if (measurementPrintBucket == null) {
            throw new NullPointerException("measurementPrintBucket is marked non-null but is null");
        }
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        Measurement measurement = measurementPrintBucket.getMeasurement();
        Quotation quotation = measurementPrintBucket.getQuotation();
        Quotation firstQuotation = measurementPrintBucket.getRootQuotation();
        meta.setId(measurement.getId());
        meta.setCreatedOn(measurement.getCreatedOn());
        meta.setUpdatedOn(measurement.getUpdatedOn());
        meta.setDeletedOn(measurement.getDeletedOn());
        meta.setCreatedBy(measurement.getCreatedBy());
        meta.setUpdatedBy(measurement.getUpdatedBy());
        meta.setDeletedBy(measurement.getDeletedBy());
        meta.setEntityState(measurement.getEntityState());
        meta.setRowVersion(Integer.valueOf(measurement.getRowVersion()));
        meta.setMeasurementNumber(measurement.getMeasurementNumber());
        meta.setRemarks(measurement.getRemarks());
        meta.setQuotationId(quotation.getId());
        meta.setQuotationNumber(StringUtils.trimToEmpty((String)quotation.getQuotationNumber()));
        meta.setOrderDescriptionCustomer(StringUtils.trimToEmpty((String)firstQuotation.getOrderDescriptionCustomer()));
        meta.setOrderNumber(StringUtils.trimToEmpty((String)firstQuotation.getOrderNumber()));
        meta.setReleaseOrderName("");
        meta.setPssReleaseOrderState("");
        ReleaseOrder releaseOrder = measurement.getReleaseOrder();
        if (null != releaseOrder) {
            meta.setReleaseOrderName(StringUtils.trimToEmpty((String)releaseOrder.getName()));
            PssReleaseOrder pssReleaseOrder = releaseOrder.getPssReleaseOrder();
            if (null != pssReleaseOrder) {
                meta.setPssReleaseOrderId(pssReleaseOrder.getPssId());
                meta.setPssReleaseOrderState(StringUtils.trimToEmpty((String)pssReleaseOrder.getPssState()));
            }
        }
        meta.setConstructionSite(measurement.getConstructionSite());
        User user = measurement.getAssignedUser();
        if (null != user) {
            meta.setAssignedUserId(user.getId());
            meta.setAssignedUserName(StringUtils.trimToEmpty((String)user.getFullName()));
            meta.setAssignedSquadName(StringUtils.trimToEmpty((String)user.getSquadName()));
            meta.setAssignedSquadPersonalNumber(user.getPersonalNumber());
        } else {
            meta.setAssignedUserName("");
            meta.setAssignedSquadName("");
        }
        meta.setProjectExecutionStartDate(MeasurementPrintMapper.formatDate((LocalDate)measurement.getProjectExecutionStartDate()));
        meta.setProjectExecutionEndDate(MeasurementPrintMapper.formatDate((LocalDate)measurement.getProjectExecutionEndDate()));
        meta.setPersonResponsibleAtCustomer(StringUtils.trimToEmpty((String)measurement.getPersonResponsibleAtCustomer()));
        meta.setCustomerArea(StringUtils.trimToEmpty((String)measurement.getCustomerArea()));
        meta.setWageOverall(measurement.getWageOverall());
        meta.setSquadWageOverall(measurement.getSquadWageOverall());
        meta.setValueOverall(measurement.getValueOverall());
        String measurementTypeTranslated = this.messageService.get((Translatable)measurement.getMeasurementType(), new Object[0]);
        meta.setMeasurementTypeTranslated(measurementTypeTranslated);
        return meta;
    }

    @Nonnull
    private MeasurementPositionPrintStandard mapStandard(@NonNull MeasurementPosition measurementPosition, boolean printJumboA, boolean printJumboB) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        MeasurementPositionPrintStandard printStandard = new MeasurementPositionPrintStandard();
        printStandard.setId(measurementPosition.getId());
        printStandard.setCreatedOn(measurementPosition.getCreatedOn());
        printStandard.setUpdatedOn(measurementPosition.getUpdatedOn());
        printStandard.setDeletedOn(measurementPosition.getDeletedOn());
        printStandard.setCreatedBy(measurementPosition.getCreatedBy());
        printStandard.setUpdatedBy(measurementPosition.getUpdatedBy());
        printStandard.setDeletedBy(measurementPosition.getDeletedBy());
        printStandard.setEntityState(measurementPosition.getEntityState());
        printStandard.setRowVersion(Integer.valueOf(measurementPosition.getRowVersion()));
        printStandard.setRemarks(StringUtils.trimToEmpty((String)measurementPosition.getRemarks()));
        EPositionType positionType = measurementPosition.getPositionType();
        if (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType && printJumboA) {
            BigDecimal priceAggregated = measurementPosition.getPriceAggregated();
            printStandard.setAmount(priceAggregated);
            printStandard.setProduct(priceAggregated);
            printStandard.setFactor1(null);
            printStandard.setFactor2(null);
            printStandard.setFactor3(null);
            printStandard.setSurrogatePositionNumber(measurementPosition.getJumboPositionSurrogatePositionNumber());
            printStandard.setUnit(measurementPosition.getJumboPositionUnit());
            printStandard.setShortText(StringUtils.trimToEmpty((String)measurementPosition.getJumboPositionShortText()));
        } else if (EPositionType.JUMBO_INTERNAL_TYPE_B == positionType && printJumboB) {
            printStandard.setSurrogatePositionNumber(measurementPosition.getJumboPositionSurrogatePositionNumber());
            printStandard.setAmount(measurementPosition.getAmount());
            printStandard.setFactor1(measurementPosition.getFactor1());
            printStandard.setFactor2(measurementPosition.getFactor2());
            printStandard.setFactor3(measurementPosition.getFactor3());
            printStandard.setProduct(measurementPosition.getProduct());
            printStandard.setUnit(StringUtils.trimToEmpty((String)measurementPosition.getUnit()));
            printStandard.setShortText(StringUtils.trimToEmpty((String)measurementPosition.getJumboPositionShortText()));
        } else {
            printStandard.setSurrogatePositionNumber(measurementPosition.getSurrogatePositionNumber());
            printStandard.setAmount(measurementPosition.getAmount());
            printStandard.setFactor1(measurementPosition.getFactor1());
            printStandard.setFactor2(measurementPosition.getFactor2());
            printStandard.setFactor3(measurementPosition.getFactor3());
            printStandard.setProduct(measurementPosition.getProduct());
            printStandard.setUnit(StringUtils.trimToEmpty((String)measurementPosition.getUnit()));
            printStandard.setShortText(StringUtils.trimToEmpty((String)measurementPosition.getShortText()));
        }
        printStandard.setPositionType(positionType);
        printStandard.setGroupingElementLevel1(measurementPosition.getGroupingElementLevel1());
        printStandard.setGroupingElementLevel2(measurementPosition.getGroupingElementLevel2());
        printStandard.setGroupingElementLevel3(measurementPosition.getGroupingElementLevel3());
        printStandard.setGroupingElementLevel4(measurementPosition.getGroupingElementLevel4());
        printStandard.setPositionNumber(measurementPosition.getQuotationPositionNumber());
        printStandard.setSubPositionNumber(measurementPosition.getQuotationSubPositionNumber());
        printStandard.setLongText(StringUtils.trimToEmpty((String)measurementPosition.getLongText()));
        printStandard.setInternalSquadWagePerUnit(measurementPosition.getInternalSquadWagePerUnit());
        printStandard.setInternalSquadWageAggregated(measurementPosition.getInternalSquadWageAggregated());
        printStandard.setSequenceNumberInvoice(measurementPosition.getSequenceNumberInvoice());
        printStandard.setSequenceNumberMeasurementStandard(measurementPosition.getSequenceNumberMeasurementStandard());
        printStandard.setSequenceNumberMeasurementTransposed(measurementPosition.getSequenceNumberMeasurementTransposed());
        return printStandard;
    }

    @Nonnull
    private static String formatDate(@Nullable LocalDate localDate) {
        if (null != localDate) {
            return DATE_FORMATTER.format(localDate);
        }
        return "";
    }

    @Nonnull
    public MeasurementPrintPreliminaryStandard mapPreliminaryStandard(@NonNull Iterable<Measurement> measurements, @NonNull Quotation quotation, @NonNull Map<Long, BigDecimal> addendumDiscounts) {
        if (measurements == null) {
            throw new NullPointerException("measurements is marked non-null but is null");
        }
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (addendumDiscounts == null) {
            throw new NullPointerException("addendumDiscounts is marked non-null but is null");
        }
        ImmutableList allPositions = (ImmutableList)IterableHelper.stream(measurements).map(Measurement::getMeasurementPositions).filter(Objects::nonNull).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        Iterable allMeasurementNumbers = (Iterable)IterableHelper.stream(measurements).map(Measurement::getMeasurementNumber).map(StringUtils::trimToEmpty).sorted(StringUtils::compareIgnoreCase).collect(ImmutableList.toImmutableList());
        LocalDate minDate = IterableHelper.stream(measurements).map(Measurement::getProjectExecutionStartDate).filter(Objects::nonNull).min(LocalDate::compareTo).orElse(LocalDate.MIN);
        LocalDate maxDate = IterableHelper.stream(measurements).map(Measurement::getProjectExecutionEndDate).filter(Objects::nonNull).max(LocalDate::compareTo).orElse(LocalDate.MAX);
        String orderDescription = StringUtils.trimToEmpty((String)quotation.getOrderDescriptionCustomer());
        String orderNumber = StringUtils.trimToEmpty((String)quotation.getOrderNumber());
        String contactPerson = StringUtils.trimToEmpty((String)quotation.getContactPersonOld());
        String quotationNumber = StringUtils.trimToEmpty((String)quotation.getQuotationNumber());
        MeasurementPrintPreliminaryStandard printStandard = new MeasurementPrintPreliminaryStandard();
        printStandard.setCurrency(Currency.getInstance(Locale.GERMANY));
        printStandard.setMeasurementNumbers(allMeasurementNumbers);
        printStandard.setQuotationNumber(quotationNumber);
        printStandard.setOrderDescriptionCustomer(orderDescription);
        printStandard.setOrderNumber(orderNumber);
        printStandard.setReleaseOrderName(orderDescription);
        printStandard.setPersonResponsibleAtCustomer(contactPerson);
        printStandard.setProjectExecutionRange(Range.closed((Comparable)minDate, (Comparable)maxDate));
        printStandard.setProjectExecutionStartDate(DateTimeHelperService.germanDate((LocalDate)minDate));
        printStandard.setProjectExecutionEndDate(DateTimeHelperService.germanDate((LocalDate)maxDate));
        HashMap pricePerAddendumNumberMap = Maps.newHashMap();
        HashMap preliminaryStandardRowsBySPN = Maps.newHashMap();
        for (MeasurementPosition currentPosition : allPositions) {
            BigDecimal product;
            BigDecimal pricePerUnit;
            String shortText;
            String unit;
            String surrogatePositionNumber;
            EPositionType positionType = currentPosition.getPositionType();
            if (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType) {
                surrogatePositionNumber = currentPosition.getJumboPositionSurrogatePositionNumber();
                unit = currentPosition.getJumboPositionUnit();
                shortText = currentPosition.getJumboPositionShortText();
                pricePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)currentPosition.getJumboPositionPricePerUnit(), (Object)BigDecimal.ZERO);
                product = (BigDecimal)MoreObjects.firstNonNull((Object)currentPosition.getPriceAggregated(), (Object)BigDecimal.ZERO);
            } else if (EPositionType.JUMBO_INTERNAL_TYPE_B == positionType) {
                surrogatePositionNumber = currentPosition.getJumboPositionSurrogatePositionNumber();
                unit = currentPosition.getUnit();
                shortText = currentPosition.getShortText();
                pricePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)currentPosition.getPricePerUnit(), (Object)BigDecimal.ZERO);
                product = (BigDecimal)MoreObjects.firstNonNull((Object)currentPosition.getProduct(), (Object)BigDecimal.ZERO);
            } else {
                surrogatePositionNumber = currentPosition.getSurrogatePositionNumber();
                unit = currentPosition.getUnit();
                shortText = currentPosition.getShortText();
                pricePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)currentPosition.getPricePerUnit(), (Object)BigDecimal.ZERO);
                product = (BigDecimal)MoreObjects.firstNonNull((Object)currentPosition.getProduct(), (Object)BigDecimal.ZERO);
            }
            MeasurementPositionPrintPreliminaryStandard preliminaryRow = preliminaryStandardRowsBySPN.getOrDefault(surrogatePositionNumber, new MeasurementPositionPrintPreliminaryStandard());
            BigDecimal productAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)preliminaryRow.getProduct(), (Object)BigDecimal.ZERO);
            preliminaryRow.setSurrogatePositionNumber(surrogatePositionNumber);
            preliminaryRow.setUnit(unit);
            preliminaryRow.setShortText(shortText);
            preliminaryRow.setPricePerUnit(pricePerUnit);
            preliminaryRow.setProduct(productAggregated.add(product));
            BigDecimal priceAggregatedExisting = (BigDecimal)MoreObjects.firstNonNull((Object)preliminaryRow.getPriceAggregated(), (Object)BigDecimal.ZERO);
            BigDecimal priceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)currentPosition.getPriceAggregated(), (Object)BigDecimal.ZERO);
            preliminaryRow.setPriceAggregated(priceAggregatedExisting.add(priceAggregated));
            preliminaryStandardRowsBySPN.put(surrogatePositionNumber, preliminaryRow);
            Long addendumNumber2 = MeasurementHelper.addendumNumber((MeasurementPosition)currentPosition, (boolean)false);
            BigDecimal priceAggregatedExistingForAN = pricePerAddendumNumberMap.getOrDefault(addendumNumber2, BigDecimal.ZERO);
            BigDecimal priceAggregatedNewForAN = priceAggregatedExistingForAN.add(priceAggregated);
            pricePerAddendumNumberMap.put(addendumNumber2, priceAggregatedNewForAN);
        }
        ImmutableList printPreliminaryStandards = ImmutableList.copyOf(preliminaryStandardRowsBySPN.values());
        ImmutableList.Builder groupPriceBuilder = ImmutableList.builder();
        pricePerAddendumNumberMap.forEach((addendumNumber, priceOverall) -> {
            BigDecimal discount = addendumDiscounts.getOrDefault(addendumNumber, BigDecimal.ZERO);
            BigDecimal discountValue = priceOverall.multiply(discount).divide(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP);
            BigDecimal priceOverallWithDiscount = priceOverall.subtract(discountValue).setScale(2, RoundingMode.HALF_UP);
            groupPriceBuilder.add((Object)AddendumGroupPrice.of((Long)addendumNumber, (BigDecimal)priceOverall, (BigDecimal)discount, (BigDecimal)discountValue, (BigDecimal)priceOverallWithDiscount));
        });
        ImmutableList addendumGroupPrices = groupPriceBuilder.build();
        printStandard.setGroupPrices((Iterable)addendumGroupPrices);
        BigDecimal valueOverallWithoutDiscount = IterableHelper.stream((Iterable)printPreliminaryStandards).map(MeasurementPositionPrintPreliminaryStandard::getPriceAggregated).reduce(BigDecimal.ZERO, BigDecimal::add);
        printStandard.setValueOverallWithoutDiscount(valueOverallWithoutDiscount);
        BigDecimal discountValueAggregated = addendumGroupPrices.stream().map(AddendumGroupPrice::getDiscountValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal valueOverallWithDiscount = valueOverallWithoutDiscount.subtract(discountValueAggregated);
        printStandard.setValueOverallWithDiscount(valueOverallWithDiscount);
        ImmutableList preliminaryPositionsSorted = ImmutableList.copyOf(IterableHelper.stream((Iterable)printPreliminaryStandards).sorted((l, r) -> StringUtils.compareIgnoreCase((String)l.getSurrogatePositionNumber(), (String)r.getSurrogatePositionNumber())).iterator());
        printStandard.setPositions((List)preliminaryPositionsSorted);
        return printStandard;
    }

    private boolean printJumboAEnabled(@NonNull Iterable<EBooleanPrintOption> booleanPrintOptions) {
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        return Iterables.contains(booleanPrintOptions, (Object)EBooleanPrintOption.PRINT_JUMBO_A) && this.userService.hasPrivilege(EPrivilege.MEASUREMENT__JUMBO_SUB_POSITION_PRINT);
    }

    private boolean printJumboBEnabled(@NonNull Iterable<EBooleanPrintOption> booleanPrintOptions) {
        if (booleanPrintOptions == null) {
            throw new NullPointerException("booleanPrintOptions is marked non-null but is null");
        }
        return Iterables.contains(booleanPrintOptions, (Object)EBooleanPrintOption.PRINT_JUMBO_B) && this.userService.hasPrivilege(EPrivilege.MEASUREMENT__JUMBO_SUB_POSITION_PRINT);
    }

    public MeasurementPrintMapper(UserService userService, MeasurementMapper measurementMapper, MessageService messageService) {
        this.userService = userService;
        this.measurementMapper = measurementMapper;
        this.messageService = messageService;
    }

    private static /* synthetic */ void lambda$mapGrouped$5(Map transposedPrintGroups, ImmutableList.Builder sortedPrintGroupsBuilder, String remark) {
        if (transposedPrintGroups.containsKey(remark)) {
            sortedPrintGroupsBuilder.add((Object)((MeasurementPositionTransposedPrintGroup)transposedPrintGroups.get(remark)));
        }
    }
}

