/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.request.contract.LaborUnionContractUpdateRequest;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupModificationItem;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupRateUpdateItem;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupUpdateItem;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.contract.LaborUnionContractCommon;
import de.qfm.erp.common.response.contract.LaborUnionContractPageCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupListCommon;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.contract.LaborUnionContractUpdateBucket;
import de.qfm.erp.service.model.internal.contract.LaborUnionWageGroupRateUpdateBucket;
import de.qfm.erp.service.model.internal.contract.LaborUnionWageGroupRatesUpdateBucket;
import de.qfm.erp.service.model.internal.contract.LaborUnionWageGroupsUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroupRate;
import de.qfm.erp.service.model.jpa.generic.EFederalState;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.LaborUnionWageGroupMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class LaborUnionContractMapper {
    private static final Logger log = LogManager.getLogger(LaborUnionContractMapper.class);
    @NonNull
    public static final BiConsumer<LaborUnionWageGroupRate, LaborUnionWageGroupRateUpdateItem> NOOP_UI = (t, v) -> {};
    @NonNull
    public static final BiConsumer<LaborUnionWageGroupRate, LaborUnionWageGroupRateUpdateBucket> NOOP_UB = (t, v) -> {};
    @NonNull
    public static final Predicate<LaborUnionWageGroupRate> NO_FILTER = laborUnionWageGroupRate -> true;
    private final AuthenticationHelper authenticationHelper;
    private final EntityFactory entityFactory;
    private final LaborUnionWageGroupMapper laborUnionWageGroupMapper;

    @Nonnull
    public LaborUnionContractCommon map(@NonNull LaborUnionContract item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        LaborUnionContractCommon common = new LaborUnionContractCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setReferenceId(item.getReferenceId());
        common.setName(item.getName());
        common.setDescription(item.getDescription());
        common.setFlagBadWeatherLogging(item.getFlagBadWeatherLogging());
        common.setName(item.getName());
        EFederalState federalState = (EFederalState)MoreObjects.firstNonNull((Object)item.getFederalState(), (Object)EFederalState.ALL);
        String federalStateString = federalState.name();
        common.setFederalState(federalStateString);
        Set wageGroups = (Set)MoreObjects.firstNonNull((Object)item.getWageGroups(), (Object)ImmutableSet.of());
        LaborUnionWageGroupListCommon wageGroupListCommon = this.laborUnionWageGroupMapper.map((Iterable)wageGroups, NO_FILTER);
        common.setWageGroups(wageGroupListCommon);
        return common;
    }

    @Nonnull
    public LaborUnionContractPageCommon map(@NonNull Page<LaborUnionContract> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return (LaborUnionContractPageCommon)BaseMapper.map(page, arg_0 -> this.map(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new LaborUnionContractPageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public LaborUnionContract merge(@NonNull LaborUnionContractUpdateBucket bucket, @NonNull BiConsumer<LaborUnionWageGroup, LaborUnionWageGroupUpdateItem> mergeLaborUnionWageGroupRatesBiConsumer) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        if (mergeLaborUnionWageGroupRatesBiConsumer == null) {
            throw new NullPointerException("mergeLaborUnionWageGroupRatesBiConsumer is marked non-null but is null");
        }
        LaborUnionContract entity = bucket.getEntity();
        LaborUnionContractUpdateRequest request = bucket.getRequest();
        EFederalState federalState = bucket.getFederalState();
        String name = StringUtils.trimToEmpty((String)request.getName());
        entity.setName(name);
        String description = StringUtils.trimToEmpty((String)request.getDescription());
        entity.setDescription(description);
        entity.setFederalState(federalState);
        entity.setFlagBadWeatherLogging(request.getFlagBadWeatherLogging());
        MergedBucket wageGroupMergedBucket = this.mergeWageGroups(bucket.getWageGroupsUpdateBucket(), mergeLaborUnionWageGroupRatesBiConsumer);
        return entity;
    }

    @Nonnull
    private LaborUnionWageGroup mergeWageGroup(@NonNull LaborUnionWageGroup laborUnionWageGroup, @NonNull LaborUnionWageGroupUpdateItem unionWageGroupRateUpdateItem) {
        if (laborUnionWageGroup == null) {
            throw new NullPointerException("laborUnionWageGroup is marked non-null but is null");
        }
        if (unionWageGroupRateUpdateItem == null) {
            throw new NullPointerException("unionWageGroupRateUpdateItem is marked non-null but is null");
        }
        laborUnionWageGroup.setName(StringUtils.trimToEmpty((String)unionWageGroupRateUpdateItem.getName()));
        return laborUnionWageGroup;
    }

    @Nonnull
    public MergedBucket<LaborUnionWageGroup> mergeWageGroups(@NonNull LaborUnionWageGroupsUpdateBucket laborUnionWageGroupsUpdateBucket, @NonNull BiConsumer<LaborUnionWageGroup, LaborUnionWageGroupUpdateItem> callbackMergeChildFunction) {
        if (laborUnionWageGroupsUpdateBucket == null) {
            throw new NullPointerException("laborUnionWageGroupsUpdateBucket is marked non-null but is null");
        }
        if (callbackMergeChildFunction == null) {
            throw new NullPointerException("callbackMergeChildFunction is marked non-null but is null");
        }
        LaborUnionContract laborUnionContract = laborUnionWageGroupsUpdateBucket.getLaborUnionContract();
        Iterable wageGroupsToPersist = laborUnionWageGroupsUpdateBucket.getLaborUnionWageGroupUpdateItems();
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)laborUnionContract, LaborUnionContract::getWageGroups, arg_0 -> ((LaborUnionContract)laborUnionContract).setWageGroups(arg_0), (Iterable)wageGroupsToPersist, LaborUnionWageGroupModificationItem::getId, LaborUnionWageGroup::getId, () -> ((EntityFactory)this.entityFactory).laborUnionWageGroup(), (arg_0, arg_1) -> this.mergeWageGroup(arg_0, arg_1), LaborUnionWageGroup::setLaborUnionContract, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), callbackMergeChildFunction);
        MergedBucket.printMergeBucket((Object)laborUnionContract, LaborUnionWageGroup.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public MergedBucket<LaborUnionWageGroupRate> mergeWageGroupRates(@NonNull LaborUnionWageGroupRatesUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        LaborUnionWageGroup laborUnionWageGroup = updateBucket.getLaborUnionWageGroup();
        Iterable wageGroupRatesToPersist = updateBucket.getLaborUnionWageGroupRateUpdateBuckets();
        MergedBucket mergedBucket = BaseMapper.merge((EntityBase)laborUnionWageGroup, LaborUnionWageGroup::getWageGroupRates, arg_0 -> ((LaborUnionWageGroup)laborUnionWageGroup).setWageGroupRates(arg_0), (Iterable)wageGroupRatesToPersist, LaborUnionWageGroupRateUpdateBucket::getId, LaborUnionWageGroupRate::getId, () -> ((EntityFactory)this.entityFactory).laborUnionWageGroupRate(), (arg_0, arg_1) -> this.mergeWageGroupRateUB(arg_0, arg_1), LaborUnionWageGroupRate::setLaborUnionWageGroup, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NOOP_UB);
        MergedBucket.printMergeBucket((Object)laborUnionWageGroup, LaborUnionWageGroupRate.class, (MergedBucket)mergedBucket);
        return mergedBucket;
    }

    @Nonnull
    public LaborUnionWageGroupRate mergeWageGroupRateUB(@NonNull LaborUnionWageGroupRate entity, @NonNull LaborUnionWageGroupRateUpdateBucket updateBucket) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        LaborUnionWageGroupRateUpdateItem updateItem = updateBucket.getLaborUnionWageGroupRateUpdateItem();
        entity.setName(StringUtils.trimToEmpty((String)updateItem.getName()));
        entity.setWageRatePerHour(updateItem.getWageRatePerHour());
        entity.setValidBegin(updateBucket.getValidBegin());
        entity.setValidEnd(updateBucket.getValidEnd());
        return entity;
    }

    public LaborUnionContractMapper(AuthenticationHelper authenticationHelper, EntityFactory entityFactory, LaborUnionWageGroupMapper laborUnionWageGroupMapper) {
        this.authenticationHelper = authenticationHelper;
        this.entityFactory = entityFactory;
        this.laborUnionWageGroupMapper = laborUnionWageGroupMapper;
    }
}

