/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.InvoiceHelper;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.model.internal.invoice.CumulativePrintBucket;
import de.qfm.erp.service.model.internal.print.CompanyPrintInfo;
import de.qfm.erp.service.model.internal.print.invoice.InvoiceAddendumDiscountMetaData;
import de.qfm.erp.service.model.internal.print.invoice.InvoiceMetaData;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePositionPrintGroup;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePositionPrintRow;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePrintInfo;
import de.qfm.erp.service.model.internal.print.invoice.InvoiceSupplementMetaData;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.invoice.EInvoicePositionType;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAddendumDiscount;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.invoice.InvoiceSupplement;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.User;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InvoicePrintMapper {
    private static final Logger log = LogManager.getLogger(InvoicePrintMapper.class);

    @Nonnull
    public InvoicePrintInfo invoicePrintInfo(@NonNull ConfigurationCompany sender, @NonNull Invoice primaryInvoice, @NonNull CumulativePrintBucket cumulativePrintBucket, boolean optionPrint13bParagraph, boolean optionPrintSubcontractorParagraph, boolean optionPrintStromnetzParagraph, boolean optionMeasurementPrint, @NonNull String optionAttachments, @NonNull String optionAdditionalAttachments, @NonNull String footerText, boolean optionsPrintCumulativeMeasurements, boolean optionIgnoreAddendum) {
        User assignedSquad;
        User primaryResponsibleUser;
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (primaryInvoice == null) {
            throw new NullPointerException("primaryInvoice is marked non-null but is null");
        }
        if (cumulativePrintBucket == null) {
            throw new NullPointerException("cumulativePrintBucket is marked non-null but is null");
        }
        if (optionAttachments == null) {
            throw new NullPointerException("optionAttachments is marked non-null but is null");
        }
        if (optionAdditionalAttachments == null) {
            throw new NullPointerException("optionAdditionalAttachments is marked non-null but is null");
        }
        if (footerText == null) {
            throw new NullPointerException("footerText is marked non-null but is null");
        }
        boolean optionCumulativePrint = cumulativePrintBucket.isOptionCumulativePrint();
        Iterable cumulativeInvoices = cumulativePrintBucket.getCumulativeInvoices();
        InvoicePrintInfo printInfo = new InvoicePrintInfo();
        printInfo.setCurrency(Currency.getInstance(Locale.GERMANY));
        printInfo.setFlagSecurityRetention((Boolean)MoreObjects.firstNonNull((Object)primaryInvoice.getFlagSecurityRetention(), (Object)false));
        printInfo.setOptionPrint13bParagraph(optionPrint13bParagraph);
        printInfo.setOptionPrintSubcontractorParagraph(optionPrintSubcontractorParagraph);
        printInfo.setOptionPrintStromnetzParagraph(optionPrintStromnetzParagraph);
        printInfo.setOptionCumulativePrint(optionCumulativePrint);
        printInfo.setOptionMeasurementPrint(optionMeasurementPrint);
        printInfo.setOptionMeasurementCumulativePrint(optionsPrintCumulativeMeasurements);
        printInfo.setOptionAddendumPositionWording(optionIgnoreAddendum);
        printInfo.setInvoiceName(StringUtils.trimToEmpty((String)primaryInvoice.getInvoiceName()));
        printInfo.setInvoiceNumber(StringUtils.trimToEmpty((String)primaryInvoice.getInvoiceNumber()));
        String costUnit = InvoiceHelper.costUnitPrint((Invoice)primaryInvoice);
        printInfo.setInternalNumber(StringUtils.trimToEmpty((String)costUnit));
        printInfo.setCustomerNumber(StringUtils.trimToEmpty((String)primaryInvoice.getFinanceDebtorAccountNumber()));
        printInfo.setContactPerson(StringUtils.trimToEmpty((String)primaryInvoice.getContactPerson()));
        printInfo.setOrderDate(primaryInvoice.getOrderDate());
        printInfo.setOrderNumber(StringUtils.trimToEmpty((String)primaryInvoice.getOrderNumber()));
        printInfo.setOrderDescription(StringUtils.trimToEmpty((String)primaryInvoice.getOrderDescription()));
        printInfo.setInternalPartialNumber(primaryInvoice.getInternalPartialFinalNumber());
        printInfo.setCumulativeNumber(primaryInvoice.getCumulativeNumber());
        printInfo.setFinanceTimeForPayment((Integer)MoreObjects.firstNonNull((Object)primaryInvoice.getFinanceTimeForPayment(), (Object)0));
        printInfo.setFinanceCashDiscountTime1(primaryInvoice.getFinanceCashDiscountTime1());
        printInfo.setFinanceCashDiscount1((BigDecimal)MoreObjects.firstNonNull((Object)primaryInvoice.getFinanceCashDiscount1(), (Object)BigDecimal.ZERO));
        printInfo.setFinanceCashDiscountTime2(primaryInvoice.getFinanceCashDiscountTime2());
        printInfo.setFinanceCashDiscount2((BigDecimal)MoreObjects.firstNonNull((Object)primaryInvoice.getFinanceCashDiscount2(), (Object)BigDecimal.ZERO));
        User printedByUser = primaryInvoice.getAccountedByUser();
        if (null != printedByUser) {
            printInfo.setPrintedByUserId(printedByUser.getId());
            printInfo.setPrintedByUserFullName(printedByUser.getFullName());
        }
        if (null != (primaryResponsibleUser = primaryInvoice.getPrimaryResponsibleUser())) {
            printInfo.setPrimaryResponsibleUserId(primaryResponsibleUser.getId());
            printInfo.setPrimaryResponsibleUserFullName(StringUtils.trimToEmpty((String)primaryResponsibleUser.getFullName()));
        }
        if (null != (assignedSquad = primaryInvoice.getAssignedSquad())) {
            printInfo.setAssignedSquadId(assignedSquad.getId());
            printInfo.setAssignedSquadFullName(StringUtils.trimToEmpty((String)assignedSquad.getFullName()));
        }
        printInfo.setCostCenter(StringUtils.trimToEmpty((String)primaryInvoice.getCostCenter()));
        EInvoiceType invoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)primaryInvoice.getInvoiceType(), (Object)EInvoiceType.UNKNOWN);
        printInfo.setInvoiceType(invoiceType);
        printInfo.setInvoiceTypeComment(StringUtils.trimToEmpty((String)primaryInvoice.getInvoiceTypeComment()));
        Invoice referencedByInvoice = primaryInvoice.getReferencedByInvoice();
        if (null != referencedByInvoice) {
            printInfo.setReferenceInvoiceType(referencedByInvoice.getInvoiceType());
            printInfo.setReferenceInvoiceNumber(referencedByInvoice.getInvoiceNumber());
        } else {
            printInfo.setReferenceInvoiceType(EInvoiceType.UNKNOWN);
            printInfo.setReferenceInvoiceNumber("");
        }
        printInfo.setInvoiceDate(primaryInvoice.getInvoiceDate());
        printInfo.setAccountingDate(primaryInvoice.getPostingDate());
        printInfo.setOrderNumber(StringUtils.trimToEmpty((String)primaryInvoice.getOrderNumber()));
        printInfo.setOrderDate(primaryInvoice.getOrderDate());
        printInfo.setVoucherNumber(StringUtils.trimToEmpty((String)primaryInvoice.getVoucherNumber()));
        printInfo.setCreditVoucherNumber(StringUtils.trimToEmpty((String)primaryInvoice.getCreditVoucherNumber()));
        printInfo.setConstructionSite(StringUtils.trimToEmpty((String)primaryInvoice.getConstructionSite()));
        printInfo.setProjectExecutionStartDate(primaryInvoice.getProjectExecutionStartDate());
        printInfo.setProjectExecutionEndDate(primaryInvoice.getProjectExecutionEndDate());
        printInfo.setAdditionalInfoHeader1(StringUtils.trimToEmpty((String)primaryInvoice.getAdditionalInfoHeader1()));
        printInfo.setAdditionalInfoDetail1(StringUtils.trimToEmpty((String)primaryInvoice.getAdditionalInfoDetail1()));
        printInfo.setAdditionalInfoHeader2(StringUtils.trimToEmpty((String)primaryInvoice.getAdditionalInfoHeader2()));
        printInfo.setAdditionalInfoDetail2(StringUtils.trimToEmpty((String)primaryInvoice.getAdditionalInfoDetail2()));
        printInfo.setAdditionalInfoHeader3(StringUtils.trimToEmpty((String)primaryInvoice.getAdditionalInfoHeader3()));
        printInfo.setAdditionalInfoDetail3(StringUtils.trimToEmpty((String)primaryInvoice.getAdditionalInfoDetail3()));
        printInfo.setAttachments(StringUtils.trimToEmpty((String)optionAttachments));
        printInfo.setAdditionalAttachments(StringUtils.trimToEmpty((String)optionAdditionalAttachments));
        printInfo.setFooterText(StringUtils.trimToEmpty((String)footerText));
        CompanyPrintInfo senderCompanyInfo = this.sender(sender);
        printInfo.setSenderPrintInfo(senderCompanyInfo);
        CompanyPrintInfo recipient = this.recipient(primaryInvoice);
        printInfo.setRecipientPrintInfo(recipient);
        CompanyPrintInfo recipientRef = this.recipientRef(primaryInvoice);
        printInfo.setRecipientRefPrintInfo(recipientRef);
        InvoiceMetaData primaryInvoiceData = this.invoiceMetaData(primaryInvoice);
        Iterable secondaryInvoiceData = (Iterable)Streams.stream((Iterable)cumulativeInvoices).map(arg_0 -> this.invoiceMetaData(arg_0)).collect(ImmutableList.toImmutableList());
        printInfo.setPrimaryInvoiceData(primaryInvoiceData);
        printInfo.setSecondaryInvoicesData(secondaryInvoiceData);
        Iterable closingInvoices = (Iterable)MoreObjects.firstNonNull((Object)primaryInvoice.getClosedInvoices(), (Object)ImmutableSet.of());
        Iterable closingInvoiceData = (Iterable)Streams.stream((Iterable)closingInvoices).map(arg_0 -> this.invoiceMetaData(arg_0)).collect(ImmutableList.toImmutableList());
        printInfo.setClosingInvoiceData(closingInvoiceData);
        ImmutableList allInvoices = ImmutableList.builder().add((Object)primaryInvoice).addAll(cumulativeInvoices).build();
        List printGroups = this.printGroupsGrouped((Iterable)allInvoices, optionIgnoreAddendum);
        printInfo.setPositionPrintGroups((Iterable)printGroups);
        printInfo.setVatPercent(InvoicePrintMapper.safeBD((BigDecimal)primaryInvoice.getVatPercent()));
        printInfo.setVatValue(InvoicePrintMapper.safeBD((BigDecimal)primaryInvoice.getVatValue()));
        printInfo.setSubtotalWithoutDiscountValueNet(primaryInvoice.getSubtotalWithoutDiscountValueNet());
        printInfo.setSubtotalWithDiscountValueNet(primaryInvoice.getSubtotalWithDiscountValueNet());
        printInfo.setTotalDiscountValueNet(primaryInvoice.getTotalDiscountValueNet());
        printInfo.setTotalValueNet(primaryInvoice.getTotalValueNet());
        printInfo.setTotalValueGross(primaryInvoice.getTotalValueGross());
        printInfo.setInvoiceDueValueGross(primaryInvoice.getInvoiceDueValueGross());
        printInfo.setWarrantySecurityRetentionPercent(primaryInvoice.getWarrantySecurityRetentionPercent());
        printInfo.setWarrantySecurityRetentionValue(primaryInvoice.getWarrantySecurityRetentionValue());
        printInfo.setFulfillmentSecurityRetentionPercent(primaryInvoice.getFulfillmentSecurityRetentionPercent());
        printInfo.setFulfillmentSecurityRetentionValue(primaryInvoice.getFulfillmentSecurityRetentionValue());
        printInfo.setFulfillmentSecurityRetentionCumulativeValue(primaryInvoice.getFulfillmentSecurityRetentionCumulativeValue());
        Iterable invoiceMeasurements = (Iterable)MoreObjects.firstNonNull((Object)primaryInvoice.getInvoiceMeasurements(), (Object)ImmutableSet.of());
        Iterable measurements = InvoiceHelper.measurements((Iterable)invoiceMeasurements);
        List measurementNumbers = (List)Streams.stream((Iterable)measurements).sorted(Comparator.comparing(Measurement::getId)).map(Measurement::getMeasurementNumber).collect(ImmutableList.toImmutableList());
        printInfo.setMeasurementNumbers((Iterable)measurementNumbers);
        Set invoiceAddendumDiscounts = (Set)MoreObjects.firstNonNull((Object)primaryInvoice.getInvoiceAddendumDiscounts(), (Object)ImmutableSet.of());
        Iterable invoiceAddendumDiscountMetaData = this.invoiceAddendumDiscountMetaData((Iterable)invoiceAddendumDiscounts);
        printInfo.setAddendumDiscountsMetaData(invoiceAddendumDiscountMetaData);
        Set invoiceSupplements = (Set)MoreObjects.firstNonNull((Object)primaryInvoice.getInvoiceSupplements(), (Object)ImmutableSet.of());
        Iterable invoiceSupplementMetaData = this.invoiceSupplementMetaData((Iterable)invoiceSupplements);
        printInfo.setInvoiceSupplementsMetaData(invoiceSupplementMetaData);
        return printInfo;
    }

    @Nonnull
    private Iterable<InvoiceAddendumDiscountMetaData> invoiceAddendumDiscountMetaData(@NonNull Iterable<InvoiceAddendumDiscount> invoiceAddendumDiscounts) {
        if (invoiceAddendumDiscounts == null) {
            throw new NullPointerException("invoiceAddendumDiscounts is marked non-null but is null");
        }
        return (Iterable)Streams.stream(invoiceAddendumDiscounts).map(arg_0 -> this.invoiceMetaData(arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private InvoiceAddendumDiscountMetaData invoiceMetaData(@NonNull InvoiceAddendumDiscount invoiceAddendumDiscount) {
        if (invoiceAddendumDiscount == null) {
            throw new NullPointerException("invoiceAddendumDiscount is marked non-null but is null");
        }
        return InvoiceAddendumDiscountMetaData.of((Long)invoiceAddendumDiscount.getAddendumNumber(), (BigDecimal)invoiceAddendumDiscount.getPercent(), (BigDecimal)invoiceAddendumDiscount.getDiscountableValueNet(), (BigDecimal)invoiceAddendumDiscount.getValueNet(), (int)invoiceAddendumDiscount.getPositionAmount());
    }

    @Nonnull
    private Iterable<InvoiceSupplementMetaData> invoiceSupplementMetaData(@NonNull Iterable<InvoiceSupplement> invoiceSupplements) {
        if (invoiceSupplements == null) {
            throw new NullPointerException("invoiceSupplements is marked non-null but is null");
        }
        return (Iterable)Streams.stream(invoiceSupplements).map(arg_0 -> this.invoiceSupplementMetaData(arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private InvoiceSupplementMetaData invoiceSupplementMetaData(@NonNull InvoiceSupplement invoiceSupplement) {
        if (invoiceSupplement == null) {
            throw new NullPointerException("invoiceSupplement is marked non-null but is null");
        }
        return InvoiceSupplementMetaData.of((String)invoiceSupplement.getName(), (BigDecimal)invoiceSupplement.getPercent(), (BigDecimal)invoiceSupplement.getValue());
    }

    @Nonnull
    private static BigDecimal safeBD(@Nullable BigDecimal value) {
        return (BigDecimal)MoreObjects.firstNonNull((Object)value, (Object)BigDecimal.ZERO);
    }

    @Nonnull
    private InvoiceMetaData invoiceMetaData(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        EInvoiceType invoiceType = (EInvoiceType)MoreObjects.firstNonNull((Object)invoice.getInvoiceType(), (Object)EInvoiceType.UNKNOWN);
        LocalDate invoiceDate = invoice.getInvoiceDate();
        String invoiceTypeComment = StringUtils.trimToEmpty((String)invoice.getInvoiceTypeComment());
        String invoiceNumber = StringUtils.trimToEmpty((String)invoice.getInvoiceNumber());
        BigDecimal totalValueNet = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getTotalValueNet(), (Object)BigDecimal.ZERO);
        BigDecimal vatPercent = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getVatPercent(), (Object)BigDecimal.ZERO);
        BigDecimal vatValue = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getVatValue(), (Object)BigDecimal.ZERO);
        BigDecimal totalValueGross = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getTotalValueGross(), (Object)BigDecimal.ZERO);
        BigDecimal invoiceDueValueGross = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getInvoiceDueValueGross(), (Object)BigDecimal.ZERO);
        BigDecimal warrantySecurityRetentionValue = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getWarrantySecurityRetentionValue(), (Object)BigDecimal.ZERO);
        BigDecimal fulfillmentSecurityRetentionValue = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getFulfillmentSecurityRetentionValue(), (Object)BigDecimal.ZERO);
        BigDecimal fulfillmentSecurityRetentionCumulativeValue = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getFulfillmentSecurityRetentionCumulativeValue(), (Object)BigDecimal.ZERO);
        BigDecimal generalDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getGeneralDiscount(), (Object)BigDecimal.ZERO);
        BigDecimal otherDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getOtherDiscount(), (Object)BigDecimal.ZERO);
        Optional<Integer> internalPartialNumber = Optional.ofNullable(invoice.getInternalPartialNumber());
        Optional<Integer> internalPartialFinalNumber = Optional.ofNullable(invoice.getInternalPartialFinalNumber());
        return InvoiceMetaData.of((EInvoiceState)invoiceState, (EInvoiceType)invoiceType, (String)invoiceTypeComment, (String)invoiceNumber, (LocalDate)invoiceDate, (BigDecimal)totalValueNet, (BigDecimal)vatPercent, (BigDecimal)vatValue, (BigDecimal)totalValueGross, (BigDecimal)invoiceDueValueGross, (BigDecimal)warrantySecurityRetentionValue, (BigDecimal)fulfillmentSecurityRetentionValue, (BigDecimal)fulfillmentSecurityRetentionCumulativeValue, (BigDecimal)generalDiscount, (BigDecimal)otherDiscount, internalPartialNumber, internalPartialFinalNumber);
    }

    @Nonnull
    private List<InvoicePositionPrintGroup> printGroupsGrouped(@NonNull Iterable<Invoice> allInvoices, boolean optionIgnoreAddendum) {
        if (allInvoices == null) {
            throw new NullPointerException("allInvoices is marked non-null but is null");
        }
        ArrayListMultimap measurementMultimap = ArrayListMultimap.create();
        ArrayListMultimap measurementPositionMultimap = ArrayListMultimap.create();
        ArrayListMultimap invoicePositionMultimap = ArrayListMultimap.create();
        ArrayListMultimap invoiceMultimap = ArrayListMultimap.create();
        for (Invoice invoice : allInvoices) {
            Set invoicePositions = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoicePositions(), (Object)ImmutableSet.of());
            for (InvoicePosition invoicePosition : invoicePositions) {
                MeasurementPosition measurementPosition = invoicePosition.getMeasurementPosition();
                if (null != measurementPosition) {
                    Long addendumNumber = MeasurementHelper.addendumNumber((MeasurementPosition)measurementPosition, (boolean)optionIgnoreAddendum);
                    measurementPositionMultimap.put((Object)addendumNumber, (Object)measurementPosition);
                    invoicePositionMultimap.put((Object)addendumNumber, (Object)invoicePosition);
                    invoiceMultimap.put((Object)addendumNumber, (Object)invoice);
                    Measurement measurement = measurementPosition.getMeasurement();
                    if (null == measurement) continue;
                    measurementMultimap.put((Object)addendumNumber, (Object)measurement);
                    continue;
                }
                invoicePositionMultimap.put((Object)Long.MAX_VALUE, (Object)invoicePosition);
                invoiceMultimap.put((Object)Long.MAX_VALUE, (Object)invoice);
            }
        }
        ImmutableSet collectedAddendumNumbers = ImmutableSet.copyOf((Collection)Sets.newTreeSet((Iterable)invoicePositionMultimap.keys()));
        ImmutableList.Builder invoicePositionPrintGroupBuilder = ImmutableList.builder();
        for (Long addendumNumber : collectedAddendumNumbers) {
            Collection measurements = measurementMultimap.get((Object)addendumNumber);
            Collection measurementPositions = measurementPositionMultimap.get((Object)addendumNumber);
            Collection invoices = invoiceMultimap.get((Object)addendumNumber);
            Collection invoicePositions = invoicePositionMultimap.get((Object)addendumNumber);
            BigDecimal invoicePositionsSumNet = invoicePositions.stream().filter(item -> item.getInvoicePositionType() == EInvoicePositionType.CUSTOM).map(InvoicePosition::getPriceAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal measurementPositionsSumNet = measurementPositions.stream().map(MeasurementPosition::getPriceAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumNet = measurementPositionsSumNet.add(invoicePositionsSumNet);
            BigDecimal discountValueNet = invoicePositions.stream().map(InvoicePosition::getDiscountValueAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal priceAggregatedWithDiscount = invoicePositions.stream().map(InvoicePosition::getPriceAggregatedWithDiscount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            List printRows = this.printRows((Iterable)invoicePositions, true, true, true);
            Iterable measurementNumbers = (Iterable)measurements.stream().filter(Objects::nonNull).map(Measurement::getMeasurementNumber).sorted().collect(ImmutableSet.toImmutableSet());
            Iterable invoiceNumbers = (Iterable)invoices.stream().map(Invoice::getInvoiceNumber).filter(Objects::nonNull).sorted().collect(ImmutableSet.toImmutableSet());
            boolean printAsGroup = !Objects.equals(addendumNumber, Long.MAX_VALUE);
            InvoicePositionPrintGroup invoicePositionPrintGroup = InvoicePositionPrintGroup.of((boolean)printAsGroup, (String)"", (Long)addendumNumber, (BigDecimal)invoicePositionsSumNet, (BigDecimal)measurementPositionsSumNet, (BigDecimal)sumNet, (BigDecimal)discountValueNet, (BigDecimal)priceAggregatedWithDiscount, (Iterable)invoiceNumbers, (Iterable)measurementNumbers, (Iterable)printRows);
            invoicePositionPrintGroupBuilder.add((Object)invoicePositionPrintGroup);
        }
        return invoicePositionPrintGroupBuilder.build();
    }

    @Nonnull
    private List<InvoicePositionPrintRow> printRows(@NonNull Iterable<InvoicePosition> invoicePositions, boolean hideZero, boolean groupPositions, boolean printJumbo) {
        if (invoicePositions == null) {
            throw new NullPointerException("invoicePositions is marked non-null but is null");
        }
        ImmutableList.Builder printRowsBuilder = ImmutableList.builder();
        for (InvoicePosition invoicePosition : invoicePositions) {
            InvoicePositionPrintRow printRow = this.printRow(invoicePosition, printJumbo);
            BigDecimal product = (BigDecimal)MoreObjects.firstNonNull((Object)printRow.getProduct(), (Object)BigDecimal.ZERO);
            if (hideZero && BigDecimal.ZERO.compareTo(product) == 0) continue;
            printRowsBuilder.add((Object)printRow);
        }
        ImmutableList printRowsUnGrouped = printRowsBuilder.build();
        if (!groupPositions) {
            return printRowsUnGrouped;
        }
        Function<InvoicePositionPrintRow, String> keyFN = invoicePositionPrintRow -> {
            String positionNumber = invoicePositionPrintRow.getPositionNumber();
            BigDecimal pricePerUnit = invoicePositionPrintRow.getPricePerUnit();
            return positionNumber + "_" + BigDecimalHelper.asString((BigDecimal)pricePerUnit);
        };
        ImmutableListMultimap byKey = Multimaps.index((Iterable)printRowsUnGrouped, keyFN::apply);
        ImmutableList.Builder printRowsGroupedBuilder = ImmutableList.builder();
        Set keys = byKey.keySet();
        for (String key : keys) {
            Collection invoicePositionPrintRows = byKey.get((Object)key);
            if (Iterables.isEmpty((Iterable)invoicePositionPrintRows)) continue;
            InvoicePositionPrintRow identity = (InvoicePositionPrintRow)Iterables.get((Iterable)invoicePositionPrintRows, (int)0);
            if (Iterables.size((Iterable)invoicePositionPrintRows) == 1) {
                printRowsGroupedBuilder.add((Object)identity);
                continue;
            }
            InvoicePositionPrintRow combined = Streams.stream((Iterable)invoicePositionPrintRows).reduce(InvoicePositionPrintRow.empty(), InvoicePositionPrintRow::combine);
            printRowsGroupedBuilder.add((Object)combined);
        }
        return printRowsGroupedBuilder.build();
    }

    @Nonnull
    private InvoicePositionPrintRow printRow(@NonNull InvoicePosition invoicePosition, boolean printJumbo) {
        if (invoicePosition == null) {
            throw new NullPointerException("invoicePosition is marked non-null but is null");
        }
        InvoicePositionPrintRow printRow = new InvoicePositionPrintRow();
        this.applyString(() -> ((InvoicePosition)invoicePosition).getReferenceId(), arg_0 -> ((InvoicePositionPrintRow)printRow).setReferenceId(arg_0));
        this.applyInteger(() -> ((InvoicePosition)invoicePosition).getSequenceNumber(), arg_0 -> ((InvoicePositionPrintRow)printRow).setSequenceNumber(arg_0));
        EInvoicePositionType invoicePositionType = invoicePosition.getInvoicePositionType();
        if (invoicePositionType == EInvoicePositionType.MEASUREMENT_POSITION) {
            MeasurementPosition measurementPosition = invoicePosition.getMeasurementPosition();
            EPositionType positionType = measurementPosition.getPositionType();
            if (printJumbo && (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType || EPositionType.JUMBO_INTERNAL_TYPE_B == positionType)) {
                if (EPositionType.JUMBO_INTERNAL_TYPE_A == positionType) {
                    BigDecimal priceAggregated = measurementPosition.getPriceAggregated();
                    this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionSurrogatePositionNumber(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPositionNumber(arg_0));
                    this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionUnit(), arg_0 -> ((InvoicePositionPrintRow)printRow).setUnit(arg_0));
                    this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionShortText(), arg_0 -> ((InvoicePositionPrintRow)printRow).setShortText(arg_0));
                    this.applyBigDecimal(() -> priceAggregated, arg_0 -> ((InvoicePositionPrintRow)printRow).setProduct(arg_0));
                    this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getJumboPositionPricePerUnit(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPricePerUnit(arg_0));
                    this.applyBigDecimal(() -> priceAggregated, arg_0 -> ((InvoicePositionPrintRow)printRow).setPriceAggregated(arg_0));
                } else if (EPositionType.JUMBO_INTERNAL_TYPE_B == positionType) {
                    this.applyString(() -> ((MeasurementPosition)measurementPosition).getJumboPositionSurrogatePositionNumber(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPositionNumber(arg_0));
                    this.applyString(() -> ((MeasurementPosition)measurementPosition).getUnit(), arg_0 -> ((InvoicePositionPrintRow)printRow).setUnit(arg_0));
                    this.applyString(() -> ((MeasurementPosition)measurementPosition).getShortText(), arg_0 -> ((InvoicePositionPrintRow)printRow).setShortText(arg_0));
                    this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getProduct(), arg_0 -> ((InvoicePositionPrintRow)printRow).setProduct(arg_0));
                    this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getPricePerUnit(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPricePerUnit(arg_0));
                    this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getPriceAggregated(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPriceAggregated(arg_0));
                }
            } else {
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getSurrogatePositionNumber(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPositionNumber(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getUnit(), arg_0 -> ((InvoicePositionPrintRow)printRow).setUnit(arg_0));
                this.applyString(() -> ((MeasurementPosition)measurementPosition).getShortText(), arg_0 -> ((InvoicePositionPrintRow)printRow).setShortText(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getProduct(), arg_0 -> ((InvoicePositionPrintRow)printRow).setProduct(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getPricePerUnit(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPricePerUnit(arg_0));
                this.applyBigDecimal(() -> ((MeasurementPosition)measurementPosition).getPriceAggregated(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPriceAggregated(arg_0));
            }
            this.applyString(() -> ((MeasurementPosition)measurementPosition).getRemarks(), arg_0 -> ((InvoicePositionPrintRow)printRow).setRemarks(arg_0));
        } else if (invoicePositionType == EInvoicePositionType.CUSTOM) {
            this.applyString(() -> ((InvoicePosition)invoicePosition).getPositionNumber(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPositionNumber(arg_0));
            this.applyString(() -> ((InvoicePosition)invoicePosition).getUnit(), arg_0 -> ((InvoicePositionPrintRow)printRow).setUnit(arg_0));
            this.applyString(() -> ((InvoicePosition)invoicePosition).getShortText(), arg_0 -> ((InvoicePositionPrintRow)printRow).setShortText(arg_0));
            this.applyString(() -> ((InvoicePosition)invoicePosition).getRemarks(), arg_0 -> ((InvoicePositionPrintRow)printRow).setRemarks(arg_0));
            this.applyBigDecimal(() -> ((InvoicePosition)invoicePosition).getProduct(), arg_0 -> ((InvoicePositionPrintRow)printRow).setProduct(arg_0));
            this.applyBigDecimal(() -> ((InvoicePosition)invoicePosition).getPricePerUnit(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPricePerUnit(arg_0));
            this.applyBigDecimal(() -> ((InvoicePosition)invoicePosition).getPriceAggregated(), arg_0 -> ((InvoicePositionPrintRow)printRow).setPriceAggregated(arg_0));
        }
        return printRow;
    }

    @Nonnull
    private CompanyPrintInfo sender(@NonNull ConfigurationCompany configurationCompany) {
        if (configurationCompany == null) {
            throw new NullPointerException("configurationCompany is marked non-null but is null");
        }
        CompanyPrintInfo companyPrintInfo = new CompanyPrintInfo();
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyName1(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyName2(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName2(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyStreet(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyStreetNo(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreetNo(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyCity(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerCity(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyZipCode(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerZipCode(arg_0));
        this.applyString(() -> ((ConfigurationCompany)configurationCompany).getCompanyEmail(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerEmail(arg_0));
        return companyPrintInfo;
    }

    @Nonnull
    private CompanyPrintInfo recipient(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        CompanyPrintInfo companyPrintInfo = new CompanyPrintInfo();
        Address invoiceAddress = invoice.getInvoiceAddress();
        if (null != invoiceAddress) {
            companyPrintInfo.setAddressId(invoiceAddress.getId());
        }
        this.applyString(() -> ((Invoice)invoice).getInvoiceName(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
        this.applyString(() -> ((Invoice)invoice).getInvoiceAddressSuffix(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName2(arg_0));
        String invoicePoBox = invoice.getInvoicePoBox();
        if (StringUtils.isNotBlank((CharSequence)invoicePoBox)) {
            this.applyString(() -> "Postfach " + invoice.getInvoicePoBox(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
        } else {
            this.applyString(() -> ((Invoice)invoice).getInvoiceStreet(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
            this.applyString(() -> ((Invoice)invoice).getInvoiceStreetNo(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreetNo(arg_0));
        }
        this.applyString(() -> ((Invoice)invoice).getInvoiceCity(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerCity(arg_0));
        this.applyString(() -> ((Invoice)invoice).getInvoiceZip(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerZipCode(arg_0));
        return companyPrintInfo;
    }

    @Nonnull
    private CompanyPrintInfo recipientRef(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        CompanyPrintInfo companyPrintInfo = new CompanyPrintInfo();
        Address invoiceRefAddress = invoice.getInvoiceRefAddress();
        if (null != invoiceRefAddress) {
            companyPrintInfo.setAddressId(invoiceRefAddress.getId());
        }
        this.applyString(() -> ((Invoice)invoice).getInvoiceRefName(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName1(arg_0));
        this.applyString(() -> ((Invoice)invoice).getInvoiceRefAddressSuffix(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerName2(arg_0));
        String invoicePoBox = invoice.getInvoiceRefPoBox();
        if (StringUtils.isNotBlank((CharSequence)invoicePoBox)) {
            this.applyString(() -> "Postfach " + invoice.getInvoiceRefPoBox(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
        } else {
            this.applyString(() -> ((Invoice)invoice).getInvoiceRefStreet(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreet(arg_0));
            this.applyString(() -> ((Invoice)invoice).getInvoiceRefStreetNo(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerStreetNo(arg_0));
        }
        this.applyString(() -> ((Invoice)invoice).getInvoiceRefCity(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerCity(arg_0));
        this.applyString(() -> ((Invoice)invoice).getInvoiceRefZip(), arg_0 -> ((CompanyPrintInfo)companyPrintInfo).setCustomerZipCode(arg_0));
        return companyPrintInfo;
    }

    private void applyString(@NonNull Supplier<String> supplier, @NonNull Consumer<String> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(StringUtils.trimToEmpty((String)supplier.get()));
    }

    private void applyInteger(@NonNull Supplier<Integer> supplier, @NonNull Consumer<Integer> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(supplier.get());
    }

    private void applyFloat(@NonNull Supplier<Float> supplier, @NonNull Consumer<Float> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept((Float)MoreObjects.firstNonNull((Object)supplier.get(), (Object)Float.valueOf(0.0f)));
    }

    private void applyBigDecimal(@NonNull Supplier<BigDecimal> supplier, @NonNull Consumer<BigDecimal> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(supplier.get());
    }
}

