/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.history.v1.HistoryItemCommon;
import de.qfm.erp.common.response.history.v1.HistoryItemPageCommon;
import de.qfm.erp.service.model.internal.history.EMeasurementHistoryField;
import de.qfm.erp.service.model.internal.history.EStageHistoryField;
import de.qfm.erp.service.model.internal.history.HistoryField;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.history.HistoryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.history.type.EHistoryEntityAction;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.MessageService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class HistoryItemMapper {
    private final EntityFactory entityFactory;
    private static final Iterable<HistoryField> PROTECTED_FIELDS = (Iterable)Stream.concat(Arrays.stream(EMeasurementHistoryField.values()), Arrays.stream(EStageHistoryField.values())).filter(rec$ -> ((HistoryField)rec$).isRequireAllAttributesVisible()).collect(ImmutableSet.toImmutableSet());
    private static final Map<String, HistoryField> TRANSLATABLE_FIELDS_MAP = (Map)Stream.concat(Arrays.stream(EMeasurementHistoryField.values()), Arrays.stream(EStageHistoryField.values())).filter(rec$ -> ((HistoryField)rec$).isTranslatable()).collect(ImmutableMap.toImmutableMap(rec$ -> ((HistoryField)rec$).fieldName(), item -> (HistoryField)item));
    private static final Iterable<Pair<EEntityClass, String>> PROTECTED_FIELDS_NAME = (Iterable)Streams.stream((Iterable)PROTECTED_FIELDS).map((? super T item) -> {
        if (item instanceof EStageHistoryField) {
            return Pair.of((Object)EEntityClass.STAGE, (Object)item.fieldName());
        }
        if (item instanceof EMeasurementHistoryField) {
            return Pair.of((Object)EEntityClass.MEASUREMENT, (Object)item.fieldName());
        }
        return Pair.of((Object)EEntityClass.NONE, (Object)item.fieldName());
    }).collect(ImmutableSet.toImmutableSet());
    private final MessageService messageService;
    private final UserService userService;

    @Nonnull
    public HistoryItemCommon map(@NonNull HistoryItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        HistoryItemCommon common = new HistoryItemCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setEntityId(item.getEntityId());
        common.setOperation(item.getOperation().getValue());
        EHistoryEntityAction entityAction = item.getEntityAction();
        if (null != entityAction) {
            common.setEntityAction(entityAction.getValue());
        }
        EEntityClass entityClass = item.getEntityClass();
        String entityNameTranslated = this.messageService.get((Translatable)entityClass, new Object[0]);
        common.setEntityClass(entityNameTranslated);
        String fieldNameOriginal = item.getField();
        EStageHistoryField historyField = entityClass == EEntityClass.STAGE ? EStageHistoryField.lookup((String)fieldNameOriginal) : EMeasurementHistoryField.lookup((String)fieldNameOriginal);
        String fieldNameTranslated = this.messageService.get((HistoryField)historyField);
        common.setAspect(fieldNameOriginal);
        common.setField(fieldNameTranslated);
        String valueOld = StringUtils.trimToEmpty((String)item.getValueOld());
        String valueNew = StringUtils.trimToEmpty((String)item.getValueNew());
        if (null != entityAction && entityAction != EHistoryEntityAction.NONE) {
            String translate = this.messageService.get((Translatable)entityAction, new Object[]{valueOld, valueNew});
            common.setDetails(translate);
        } else {
            common.setDetails(item.getDetails());
        }
        common.setReferenceClearText(StringUtils.trimToEmpty((String)item.getReferenceClearText()));
        if (TRANSLATABLE_FIELDS_MAP.containsKey(fieldNameOriginal)) {
            HistoryField field = (HistoryField)TRANSLATABLE_FIELDS_MAP.get(fieldNameOriginal);
            String valueOldTranslated = StringUtils.isNotBlank((CharSequence)valueOld) ? this.messageService.translateEnum(field.translationPrefix(), valueOld) : null;
            common.setValueOld(valueOldTranslated);
            String valueNewTranslated = StringUtils.isNotBlank((CharSequence)valueNew) ? this.messageService.translateEnum(field.translationPrefix(), valueNew) : null;
            common.setValueNew(valueNewTranslated);
        } else {
            common.setValueOld(item.getValueOld());
            common.setValueNew(item.getValueNew());
        }
        return common;
    }

    @Nonnull
    public HistoryItemPageCommon map(@NonNull Page<HistoryItem> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        boolean allAttributesVisible = this.userService.hasPrivilege(EPrivilege.MEASUREMENT__ALL_ATTRIBUTES_VISIBLE);
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        Pageable pageable = page.getPageable();
        int pageSize = pageable.getPageSize();
        int pageNumber = pageable.getPageNumber();
        List content = page.getContent();
        List itemsCommon = (List)content.stream().filter(item -> allAttributesVisible || !Iterables.contains((Iterable)PROTECTED_FIELDS_NAME, (Object)Pair.of((Object)item.getEntityClass(), (Object)StringUtils.trimToEmpty((String)item.getField())))).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
        return new HistoryItemPageCommon(pageNumber, pageSize, totalPages, totalElements, itemsCommon);
    }

    public HistoryItemMapper(EntityFactory entityFactory, MessageService messageService, UserService userService) {
        this.entityFactory = entityFactory;
        this.messageService = messageService;
        this.userService = userService;
    }
}

