/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.helper.BidderComplementHelper;
import de.qfm.erp.service.helper.GaebHelper;
import de.qfm.erp.service.model.external.gaeb.generic.ComplBody;
import de.qfm.erp.service.model.external.gaeb.generic.ComplCaption;
import de.qfm.erp.service.model.external.gaeb.generic.ComplTail;
import de.qfm.erp.service.model.external.gaeb.generic.ListOrdered;
import de.qfm.erp.service.model.external.gaeb.generic.ListUnordered;
import de.qfm.erp.service.model.external.gaeb.generic.Paragraph;
import de.qfm.erp.service.model.external.gaeb.generic.Span;
import de.qfm.erp.service.model.external.gaeb.generic.Text;
import de.qfm.erp.service.model.external.gaeb.generic.TextComplement;
import de.qfm.erp.service.model.external.gaeb.x83.AddText;
import de.qfm.erp.service.model.external.gaeb.x83.Award;
import de.qfm.erp.service.model.external.gaeb.x83.BoQBody;
import de.qfm.erp.service.model.external.gaeb.x83.BoQCtgy;
import de.qfm.erp.service.model.external.gaeb.x83.CompleteText;
import de.qfm.erp.service.model.external.gaeb.x83.Description;
import de.qfm.erp.service.model.external.gaeb.x83.DetailAddText;
import de.qfm.erp.service.model.external.gaeb.x83.DetailTxt;
import de.qfm.erp.service.model.external.gaeb.x83.Item;
import de.qfm.erp.service.model.external.gaeb.x83.LblTx;
import de.qfm.erp.service.model.external.gaeb.x83.ListItem;
import de.qfm.erp.service.model.external.gaeb.x83.OutlTxt;
import de.qfm.erp.service.model.external.gaeb.x83.OutlineAddText;
import de.qfm.erp.service.model.external.gaeb.x83.OutlineText;
import de.qfm.erp.service.model.external.gaeb.x83.Remark;
import de.qfm.erp.service.model.external.gaeb.x83.STLBBau;
import de.qfm.erp.service.model.external.gaeb.x83.STLBBauCtlg;
import de.qfm.erp.service.model.external.gaeb.x83.TextOutlTxt;
import de.qfm.erp.service.model.external.gaeb.x83.WrappedItem;
import de.qfm.erp.service.model.internal.gaeb.EGaebPositionType;
import de.qfm.erp.service.model.internal.gaeb.GaebPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import java.math.BigDecimal;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GaebX83Mapper {
    private static final Logger log = LogManager.getLogger(GaebX83Mapper.class);
    public static final Joiner JOINER = Joiner.on((String)"n");

    @Nonnull
    public List<GaebPosition> positions(@NonNull BoQBody boQBody, @NonNull List<Pair<String, String>> categoriesIndexes) {
        if (boQBody == null) {
            throw new NullPointerException("boQBody is marked non-null but is null");
        }
        if (categoriesIndexes == null) {
            throw new NullPointerException("categoriesIndexes is marked non-null but is null");
        }
        ImmutableList.Builder gaebPositionsBuilder = ImmutableList.builder();
        List categories = (List)MoreObjects.firstNonNull((Object)boQBody.getCategories(), (Object)ImmutableList.of());
        Iterable remarksOnly = (Iterable)MoreObjects.firstNonNull((Object)boQBody.getRemarksOnly(), (Object)ImmutableList.of());
        Iterable wrappedItems = (Iterable)MoreObjects.firstNonNull((Object)boQBody.getWrappedItems(), (Object)ImmutableList.of());
        Iterable allWrappedItems = Iterables.concat((Iterable)remarksOnly, (Iterable)wrappedItems);
        for (WrappedItem wrappedItem : allWrappedItems) {
            if (wrappedItem instanceof Remark) {
                Remark remark = (Remark)wrappedItem;
                gaebPositionsBuilder.addAll(GaebX83Mapper.handleRemarks(categoriesIndexes, (List)ImmutableList.of((Object)remark)));
                continue;
            }
            if (!(wrappedItem instanceof Item)) continue;
            Item item = (Item)wrappedItem;
            gaebPositionsBuilder.addAll(GaebX83Mapper.handlePositions(categoriesIndexes, (List)ImmutableList.of((Object)item)));
        }
        for (BoQCtgy category : categories) {
            String categoryIndex = category.getRowNumberPart();
            String categoryLabel = GaebX83Mapper.plainText((LblTx)category.getLblTx());
            ImmutableList localCategoriesIndexes = ImmutableList.builder().addAll(categoriesIndexes).add((Object)Pair.of((Object)categoryLabel, (Object)categoryIndex)).build();
            GaebPosition gaebPosition = new GaebPosition();
            int i = 0;
            for (Pair localCategoriesIndex : localCategoriesIndexes) {
                if (1 == ++i) {
                    gaebPosition.setL1(localCategoriesIndex);
                    continue;
                }
                if (2 == i) {
                    gaebPosition.setL2(localCategoriesIndex);
                    continue;
                }
                if (3 == i) {
                    gaebPosition.setL3(localCategoriesIndex);
                    continue;
                }
                if (4 == i) {
                    gaebPosition.setL4(localCategoriesIndex);
                    continue;
                }
                if (5 != i) continue;
                gaebPosition.setL5(localCategoriesIndex);
            }
            gaebPosition.setStructureLvl(true);
            gaebPosition.setAlternativePositionType(EAlternativePositionType.NO);
            gaebPosition.setShortText(categoryLabel);
            gaebPosition.setLongText("");
            gaebPositionsBuilder.add((Object)gaebPosition);
            List bodies = (List)MoreObjects.firstNonNull((Object)category.getBodies(), (Object)ImmutableList.of());
            for (BoQBody body : bodies) {
                List childPositions = this.positions(body, (List)localCategoriesIndexes);
                gaebPositionsBuilder.addAll((Iterable)childPositions);
            }
        }
        return gaebPositionsBuilder.build();
    }

    @Nonnull
    private static Iterable<GaebPosition> handlePositions(@NonNull List<Pair<String, String>> categoriesIndexes, @NonNull List<Item> items) {
        if (categoriesIndexes == null) {
            throw new NullPointerException("categoriesIndexes is marked non-null but is null");
        }
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        ImmutableList.Builder gaebPositionsBuilder = ImmutableList.builder();
        for (Item item : items) {
            String id = item.getId();
            String rnoPart = item.getRNoPart();
            BigDecimal amount = item.getAmount();
            String provisionalStr = item.getProvisional();
            String unit = item.getUnit();
            List descriptions = item.getDescriptions();
            BigDecimal pricePerUnit = item.getPricePerUnit();
            BigDecimal priceOverall = item.getPriceOverall();
            String shortText = GaebX83Mapper.shortText((List)descriptions);
            EAlternativePositionType alternativePositionType = GaebHelper.alternatePositionType((String)provisionalStr);
            Triple bidderText = GaebX83Mapper.bidderText((List)descriptions);
            boolean hasBidderComplement = (Boolean)bidderText.getLeft();
            String longText = (String)bidderText.getMiddle();
            String bidderComplement = (String)bidderText.getRight();
            GaebPosition gaebPosition = new GaebPosition();
            int i = 0;
            for (Pair<String, String> categoriesIndex : categoriesIndexes) {
                if (1 == ++i) {
                    gaebPosition.setL1(categoriesIndex);
                    continue;
                }
                if (2 == i) {
                    gaebPosition.setL2(categoriesIndex);
                    continue;
                }
                if (3 == i) {
                    gaebPosition.setL3(categoriesIndex);
                    continue;
                }
                if (4 == i) {
                    gaebPosition.setL4(categoriesIndex);
                    continue;
                }
                if (5 != i) continue;
                gaebPosition.setL5(categoriesIndex);
            }
            gaebPosition.setStructureLvl(false);
            gaebPosition.setPositionType(EGaebPositionType.ITEM);
            gaebPosition.setId(id);
            gaebPosition.setRno(rnoPart);
            gaebPosition.setAlternativePositionType(alternativePositionType);
            gaebPosition.setAmount(amount);
            gaebPosition.setPricePerUnit(pricePerUnit);
            gaebPosition.setPriceOverall(priceOverall);
            gaebPosition.setUnit(unit);
            gaebPosition.setShortText(shortText);
            gaebPosition.setLongText(longText);
            gaebPosition.setHasBidderComplement(hasBidderComplement);
            gaebPosition.setBidderComplement(bidderComplement);
            gaebPositionsBuilder.add((Object)gaebPosition);
        }
        return gaebPositionsBuilder.build();
    }

    @Nonnull
    private static Iterable<GaebPosition> handleRemarks(@NonNull List<Pair<String, String>> categoriesIndexes, @NonNull List<Remark> remarks) {
        if (categoriesIndexes == null) {
            throw new NullPointerException("categoriesIndexes is marked non-null but is null");
        }
        if (remarks == null) {
            throw new NullPointerException("remarks is marked non-null but is null");
        }
        ImmutableList.Builder gaebPositionsBuilder = ImmutableList.builder();
        for (Remark remark : remarks) {
            String id = remark.getId();
            String rnoPart = remark.getRNoPart();
            BigDecimal amount = remark.getAmount();
            String provisionalStr = remark.getProvisional();
            String unit = remark.getUnit();
            List descriptions = (List)MoreObjects.firstNonNull((Object)remark.getDescriptions(), (Object)ImmutableList.of());
            BigDecimal pricePerUnit = remark.getPricePerUnit();
            BigDecimal priceOverall = remark.getPriceOverall();
            String shortText = GaebX83Mapper.shortText((List)descriptions);
            EAlternativePositionType alternativePositionType = GaebHelper.alternatePositionType((String)provisionalStr);
            Triple bidderText = GaebX83Mapper.bidderText((List)descriptions);
            boolean hasBidderComplement = (Boolean)bidderText.getLeft();
            String longText = (String)bidderText.getMiddle();
            String bidderComplement = (String)bidderText.getRight();
            GaebPosition gaebPosition = new GaebPosition();
            int i = 0;
            for (Pair<String, String> categoriesIndex : categoriesIndexes) {
                if (1 == ++i) {
                    gaebPosition.setL1(categoriesIndex);
                    continue;
                }
                if (2 == i) {
                    gaebPosition.setL2(categoriesIndex);
                    continue;
                }
                if (3 == i) {
                    gaebPosition.setL3(categoriesIndex);
                    continue;
                }
                if (4 == i) {
                    gaebPosition.setL4(categoriesIndex);
                    continue;
                }
                if (5 != i) continue;
                gaebPosition.setL5(categoriesIndex);
            }
            gaebPosition.setStructureLvl(false);
            gaebPosition.setPositionType(EGaebPositionType.REMARK);
            gaebPosition.setId(id);
            gaebPosition.setRno(rnoPart);
            gaebPosition.setAlternativePositionType(alternativePositionType);
            gaebPosition.setAmount(amount);
            gaebPosition.setPricePerUnit(pricePerUnit);
            gaebPosition.setPriceOverall(priceOverall);
            gaebPosition.setUnit(unit);
            gaebPosition.setShortText(shortText);
            gaebPosition.setLongText(longText);
            gaebPosition.setHasBidderComplement(hasBidderComplement);
            gaebPosition.setBidderComplement(bidderComplement);
            gaebPositionsBuilder.add((Object)gaebPosition);
        }
        return gaebPositionsBuilder.build();
    }

    @Nonnull
    private static Triple<Boolean, String, String> bidderText(@NonNull List<Description> descriptions) {
        if (descriptions == null) {
            throw new NullPointerException("descriptions is marked non-null but is null");
        }
        boolean hasBidderComplement = false;
        ArrayList bidderComplement = Lists.newArrayList();
        ArrayList plainTexts = Lists.newArrayList();
        for (Description description : descriptions) {
            STLBBau stlbBau = description.getStlbBau();
            if (null != stlbBau) {
                List stlbBauCtlgList = (List)MoreObjects.firstNonNull((Object)stlbBau.getStlbBauCtlgList(), (Object)ImmutableList.of());
                for (STLBBauCtlg stlbBauCtlg : stlbBauCtlgList) {
                    String catalogName = StringUtils.trimToEmpty((String)stlbBauCtlg.getCatalogName());
                    String versDate = YearMonth.parse(StringUtils.trimToEmpty((String)stlbBauCtlg.getVersDate())).format(DateTimeFormatter.ofPattern("MM/yyyy"));
                    String wctg = StringUtils.trimToEmpty((String)stlbBauCtlg.getWctg());
                    String group = StringUtils.trimToEmpty((String)stlbBauCtlg.getGroup());
                    String stlbBauTxt = StringUtils.joinWith((String)" ", (Object[])new Object[]{catalogName, versDate, wctg});
                    plainTexts.add(stlbBauTxt);
                }
            }
            List completeTexts = (List)MoreObjects.firstNonNull((Object)description.getCompleteTexts(), (Object)ImmutableList.of());
            for (CompleteText completeText : completeTexts) {
                String complTSB = (String)MoreObjects.firstNonNull((Object)completeText.getComplTSB(), (Object)"");
                hasBidderComplement |= StringUtils.equalsIgnoreCase((CharSequence)StringUtils.trimToEmpty((String)complTSB), (CharSequence)"yes");
                List detailTxts = (List)MoreObjects.firstNonNull((Object)completeText.getDetailTxts(), (Object)ImmutableList.of());
                for (DetailTxt detailTxt : detailTxts) {
                    List objects = (List)MoreObjects.firstNonNull((Object)detailTxt.getObjects(), (Object)ImmutableList.of());
                    for (Object object : objects) {
                        if (object instanceof Text) {
                            Text text = (Text)object;
                            List parts = text.getObjects();
                            for (Object o : parts) {
                                List listItems;
                                if (o instanceof Paragraph) {
                                    Paragraph p = (Paragraph)o;
                                    List pObjects = (List)MoreObjects.firstNonNull((Object)p.getObjects(), (Object)ImmutableList.of());
                                    for (Object pObject : pObjects) {
                                        if (pObject instanceof String) {
                                            String s = StringUtils.trimToEmpty((String)((String)pObject));
                                            plainTexts.add(s);
                                            continue;
                                        }
                                        if (pObject instanceof TextComplement) {
                                            TextComplement tc = (TextComplement)pObject;
                                            Pair extractBidderComplement = GaebX83Mapper.extractBidderComplement((TextComplement)tc);
                                            ((Iterable)extractBidderComplement.getLeft()).forEach(plainTexts::add);
                                            ((Iterable)extractBidderComplement.getRight()).forEach(bidderComplement::add);
                                            hasBidderComplement = true;
                                            continue;
                                        }
                                        throw new NotImplementedException("TODO");
                                    }
                                    continue;
                                }
                                if (o instanceof ListUnordered) {
                                    ListUnordered ol = (ListUnordered)o;
                                    listItems = (List)MoreObjects.firstNonNull((Object)ol.getListItems(), (Object)ImmutableList.of());
                                    GaebX83Mapper.createListItem((List)listItems, () -> "- ").forEach(plainTexts::add);
                                    continue;
                                }
                                if (o instanceof ListOrdered) {
                                    ListOrdered ul = (ListOrdered)o;
                                    listItems = (List)MoreObjects.firstNonNull((Object)ul.getListItems(), (Object)ImmutableList.of());
                                    AtomicInteger atomicInteger = new AtomicInteger(1);
                                    GaebX83Mapper.createListItem((List)listItems, () -> atomicInteger.getAndIncrement() + ". ").forEach(plainTexts::add);
                                    continue;
                                }
                                if (!(o instanceof TextComplement)) continue;
                                TextComplement textComplement = (TextComplement)o;
                                Pair extractBidderComplement = GaebX83Mapper.extractBidderComplement((TextComplement)textComplement);
                                ((Iterable)extractBidderComplement.getLeft()).forEach(plainTexts::add);
                                ((Iterable)extractBidderComplement.getRight()).forEach(bidderComplement::add);
                                hasBidderComplement = true;
                            }
                            continue;
                        }
                        if (object instanceof TextComplement) {
                            TextComplement textComplement = (TextComplement)object;
                            Pair extractBidderComplement = GaebX83Mapper.extractBidderComplement((TextComplement)textComplement);
                            ((Iterable)extractBidderComplement.getLeft()).forEach(plainTexts::add);
                            ((Iterable)extractBidderComplement.getRight()).forEach(bidderComplement::add);
                            hasBidderComplement = true;
                            continue;
                        }
                        log.warn("Unknown Object Type: {}", object.getClass());
                    }
                }
            }
        }
        String bidderComplementString = Joiner.on((String)"\n").join((Iterable)bidderComplement);
        String plainTextsString = Joiner.on((String)"\n").join((Iterable)plainTexts);
        return Triple.of((Object)hasBidderComplement, (Object)plainTextsString, (Object)bidderComplementString);
    }

    @Nonnull
    private static Pair<Iterable<String>, Iterable<String>> extractBidderComplement(@NonNull TextComplement textComplement) {
        ImmutableList allStrings;
        Iterable spanStrings;
        List spans;
        Iterable pStrings;
        List paragraphs;
        if (textComplement == null) {
            throw new NullPointerException("textComplement is marked non-null but is null");
        }
        ArrayList bidderComplement = Lists.newArrayList();
        ArrayList plainTexts = Lists.newArrayList();
        String kind = textComplement.getKind();
        String markLabel = textComplement.getMarkLabel();
        plainTexts.add(BidderComplementHelper.bidderComplementPlaceHolder((String)markLabel));
        bidderComplement.add(String.format("{{%s | %s}}", markLabel, kind));
        List complBodies = (List)MoreObjects.firstNonNull((Object)textComplement.getBodies(), (Object)ImmutableList.of());
        List complCaptions = (List)MoreObjects.firstNonNull((Object)textComplement.getCaptions(), (Object)ImmutableList.of());
        List complTails = (List)MoreObjects.firstNonNull((Object)textComplement.getTails(), (Object)ImmutableList.of());
        for (ComplCaption complCaption : complCaptions) {
            paragraphs = (List)MoreObjects.firstNonNull((Object)complCaption.getParagraphs(), (Object)ImmutableList.of());
            pStrings = (Iterable)paragraphs.stream().flatMap(item -> GaebHelper.asString((Object)item).stream()).collect(ImmutableList.toImmutableList());
            spans = (List)MoreObjects.firstNonNull((Object)complCaption.getSpans(), (Object)ImmutableList.of());
            spanStrings = (Iterable)spans.stream().flatMap(item -> GaebHelper.asString((Object)item).stream()).collect(ImmutableList.toImmutableList());
            allStrings = ImmutableList.builder().addAll(pStrings).addAll(spanStrings).build();
            bidderComplement.addAll(allStrings);
        }
        for (ComplBody complBody : complBodies) {
            paragraphs = (List)MoreObjects.firstNonNull((Object)complBody.getParagraphs(), (Object)ImmutableList.of());
            pStrings = (Iterable)paragraphs.stream().flatMap(item -> GaebHelper.asString((Object)item).stream()).collect(ImmutableList.toImmutableList());
            spans = (List)MoreObjects.firstNonNull((Object)complBody.getSpans(), (Object)ImmutableList.of());
            spanStrings = (Iterable)spans.stream().flatMap(item -> GaebHelper.asString((Object)item).stream()).collect(ImmutableList.toImmutableList());
            allStrings = ImmutableList.builder().addAll(pStrings).addAll(spanStrings).build();
            bidderComplement.addAll(allStrings);
        }
        for (ComplTail complTail : complTails) {
            paragraphs = (List)MoreObjects.firstNonNull((Object)complTail.getParagraphs(), (Object)ImmutableList.of());
            pStrings = (Iterable)paragraphs.stream().flatMap(item -> GaebHelper.asString((Object)item).stream()).collect(ImmutableList.toImmutableList());
            spans = (List)MoreObjects.firstNonNull((Object)complTail.getSpans(), (Object)ImmutableList.of());
            spanStrings = (Iterable)spans.stream().flatMap(item -> GaebHelper.asString((Object)item).stream()).collect(ImmutableList.toImmutableList());
            allStrings = ImmutableList.builder().addAll(pStrings).addAll(spanStrings).build();
            bidderComplement.addAll(allStrings);
        }
        return Pair.of((Object)plainTexts, (Object)bidderComplement);
    }

    @Nonnull
    private static Iterable<String> createListItem(List<ListItem> listItems, Supplier<String> prefix) {
        ImmutableList.Builder plainTexts = ImmutableList.builder();
        for (ListItem listItem : listItems) {
            List paragraphs;
            String paragraphStrings;
            List spans = (List)MoreObjects.firstNonNull((Object)listItem.getSpans(), (Object)ImmutableList.of());
            String spanStrings = spans.stream().map(Span::getContent).filter(Objects::nonNull).collect(Collectors.joining(" "));
            if (StringUtils.isNotBlank((CharSequence)spanStrings)) {
                plainTexts.add((Object)((String)prefix.get() + spanStrings));
            }
            if (!StringUtils.isNotBlank((CharSequence)(paragraphStrings = (paragraphs = (List)MoreObjects.firstNonNull((Object)listItem.getParagraphs(), (Object)ImmutableList.of())).stream().flatMap(item -> GaebHelper.asString((Object)item).stream()).filter(Objects::nonNull).collect(Collectors.joining(" "))))) continue;
            plainTexts.add((Object)((String)prefix.get() + paragraphStrings));
        }
        return plainTexts.build();
    }

    @Nonnull
    private static String shortText(@NonNull List<Description> descriptions) {
        if (descriptions == null) {
            throw new NullPointerException("descriptions is marked non-null but is null");
        }
        ArrayList plainTexts = Lists.newArrayList();
        for (Description description : descriptions) {
            List completeTexts = (List)MoreObjects.firstNonNull((Object)description.getCompleteTexts(), (Object)ImmutableList.of());
            for (CompleteText completeText : completeTexts) {
                List outlineText = (List)MoreObjects.firstNonNull((Object)completeText.getOutlineText(), (Object)ImmutableList.of());
                for (OutlineText text : outlineText) {
                    List outlTxts = (List)MoreObjects.firstNonNull((Object)text.getOutlTxts(), (Object)ImmutableList.of());
                    for (OutlTxt outlTxt : outlTxts) {
                        List textOutlTxts = (List)MoreObjects.firstNonNull((Object)outlTxt.getTextOutlTxts(), (Object)ImmutableList.of());
                        for (TextOutlTxt textOutlTxt : textOutlTxts) {
                            List paragraphs = (List)MoreObjects.firstNonNull((Object)textOutlTxt.getParagraphs(), (Object)ImmutableList.of());
                            String p = GaebX83Mapper.plainText((List)paragraphs);
                            plainTexts.add(p);
                        }
                    }
                }
            }
        }
        return Joiner.on((String)"\n").join((Iterable)plainTexts);
    }

    private static String plainText(@NonNull LblTx lblTx) {
        if (lblTx == null) {
            throw new NullPointerException("lblTx is marked non-null but is null");
        }
        List paragraphs = (List)MoreObjects.firstNonNull((Object)lblTx.getParagraphs(), (Object)ImmutableList.of());
        return GaebX83Mapper.plainText((List)paragraphs);
    }

    @Nonnull
    private static String plainText(@NonNull List<Paragraph> paragraphs) {
        if (paragraphs == null) {
            throw new NullPointerException("paragraphs is marked non-null but is null");
        }
        ArrayList spansContent = Lists.newArrayList();
        for (Paragraph paragraph : paragraphs) {
            List texts = GaebHelper.asString((Object)paragraph);
            for (String text : texts) {
                String textTrimmed = StringUtils.trimToEmpty((String)text);
                if (!StringUtils.isNotBlank((CharSequence)textTrimmed)) continue;
                spansContent.add(textTrimmed);
            }
        }
        return Joiner.on((String)"\n").join((Iterable)spansContent);
    }

    @Nonnull
    public Iterable<Pair<String, String>> descriptions(@Nullable Award award) {
        ImmutableList.Builder descriptionsBuilder = ImmutableList.builder();
        if (null != award) {
            List textList = (List)MoreObjects.firstNonNull((Object)award.getTextList(), (Object)ImmutableList.of());
            for (AddText addText : textList) {
                List outline = (List)MoreObjects.firstNonNull((Object)addText.getOutline(), (Object)ImmutableList.of());
                ArrayList outLineTexts = Lists.newArrayList();
                for (OutlineAddText outlineAddText : outline) {
                    List paragraphs = (List)MoreObjects.firstNonNull((Object)outlineAddText.getParagraphs(), (Object)ImmutableList.of());
                    String p = GaebX83Mapper.plainText((List)paragraphs);
                    outLineTexts.add(p);
                }
                List detail = (List)MoreObjects.firstNonNull((Object)addText.getDetail(), (Object)ImmutableList.of());
                ArrayList detailTexts = Lists.newArrayList();
                for (DetailAddText detailAddText : detail) {
                    List paragraphs = detailAddText.getParagraphs();
                    String p = GaebX83Mapper.plainText((List)paragraphs);
                    detailTexts.add(p);
                }
                String outlineString = JOINER.join((Iterable)outLineTexts);
                String detailString = JOINER.join((Iterable)detailTexts);
                descriptionsBuilder.add((Object)Pair.of((Object)outlineString, (Object)detailString));
            }
        }
        return descriptionsBuilder.build();
    }
}

