/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.dashboard.DashboardFilterDateRange;
import de.qfm.erp.common.request.dashboard.DashboardFilterMeasurement;
import de.qfm.erp.common.request.dashboard.DashboardFilterRequest;
import de.qfm.erp.common.response.dashboard.DashboardTableResponse;
import de.qfm.erp.common.response.dashboard.ECellType;
import de.qfm.erp.common.response.dashboard.EDashboardFeature;
import de.qfm.erp.common.response.dashboard.EDashboardKey;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.model.internal.costcenter.CostCenterFilter;
import de.qfm.erp.service.model.internal.dashboard.EUseCase;
import de.qfm.erp.service.model.internal.dashboard.NotAccountedMeasurementGrouped;
import de.qfm.erp.service.model.internal.dashboard.NotAccountedMeasurementUngrouped;
import de.qfm.erp.service.model.internal.measurement.MeasurementDashboard;
import de.qfm.erp.service.model.internal.measurement.MeasurementFilter;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.mapper.DashboardMapper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DashboardMapper {
    private final MessageService messageService;
    private final UserService userService;
    private static final Map<EDashboardKey, Iterable<DashboardMeasurementColumn>> COLUMN_SORT_MAPPING = ImmutableMap.of((Object)EDashboardKey.CONSTRUCTION_SITES, (Object)ImmutableList.of((Object)DashboardMeasurementColumn.MEASUREMENT_NUMBER, (Object)DashboardMeasurementColumn.MEASUREMENT_STATE, (Object)DashboardMeasurementColumn.MEASUREMENT__MEASUREMENT_TYPE, (Object)DashboardMeasurementColumn.ASSIGNED_USER__COST_CENTER, (Object)DashboardMeasurementColumn.ASSIGNED_USER__FULL_NAME, (Object)DashboardMeasurementColumn.CONSTRUCTION_SITE, (Object)DashboardMeasurementColumn.RELEASE_ORDER_NAME, (Object)DashboardMeasurementColumn.MEASUREMENT__PSS_ID, (Object)DashboardMeasurementColumn.MEASUREMENT__PSS_STATE, (Object)DashboardMeasurementColumn.ACCOUNTING_MONTH, (Object)DashboardMeasurementColumn.ACCOUNTING_MONTH_PLANNED, (Object)DashboardMeasurementColumn.PROJECT_EXECUTION_START_DATE, (Object[])new DashboardMeasurementColumn[]{DashboardMeasurementColumn.PROJECT_EXECUTION_END_DATE, DashboardMeasurementColumn.CUSTOMER_NAME, DashboardMeasurementColumn.PERSON_RESPONSIBLE_AT_CUSTOMER, DashboardMeasurementColumn.PROJECT_NAME, DashboardMeasurementColumn.PROJECT_REFERENCE_ID, DashboardMeasurementColumn.STAGE_QNUMBER, DashboardMeasurementColumn.STAGE_ALIAS, DashboardMeasurementColumn.STAGE_VERSION, DashboardMeasurementColumn.QENTITY_QNUMBER, DashboardMeasurementColumn.QENTITY_ALIAS, DashboardMeasurementColumn.WAGE_OVERALL, DashboardMeasurementColumn.WAGE_FACTOR, DashboardMeasurementColumn.COMPANY_WAGE_OVERALL, DashboardMeasurementColumn.MATERIAL_PURCHASE_PRICE_OVERALL, DashboardMeasurementColumn.MATERIAL_SELLING_PRICE_OVERALL, DashboardMeasurementColumn.EXTERNAL_SERVICE_PURCHASE_PRICE_OVERALL, DashboardMeasurementColumn.EXTERNAL_SERVICE_SELLING_PRICE_OVERALL, DashboardMeasurementColumn.NAL_PURCHASE_PRICE_OVERALL, DashboardMeasurementColumn.NAL_SELLING_PRICE_OVERALL, DashboardMeasurementColumn.VALUE_OVERALL, DashboardMeasurementColumn.STAGE__ORDER_NUMBER, DashboardMeasurementColumn.INVOICE__INVOICE_DATE, DashboardMeasurementColumn.INVOICE__INVOICE_POSTING_DATE, DashboardMeasurementColumn.INVOICE__INVOICE_NUMBER, DashboardMeasurementColumn.INVOICE__INVOICE_RESPONSIBLE_PERSON, DashboardMeasurementColumn.MEASUREMENT_LAST_STATE_CHANGE_ON, DashboardMeasurementColumn.MEASUREMENT_LAST_STATE_CHANGE_BY, DashboardMeasurementColumn.MEASUREMENT_CREATED_ON, DashboardMeasurementColumn.MEASUREMENT_CREATED_BY, DashboardMeasurementColumn.MEASUREMENT_UPDATED_ON, DashboardMeasurementColumn.MEASUREMENT_UPDATED_BY, DashboardMeasurementColumn.REMARKS, DashboardMeasurementColumn.REMARKS_INTERNAL}), (Object)EDashboardKey.NOT_ACCOUNTED_MEASUREMENTS, (Object)ImmutableList.of((Object)DashboardMeasurementColumn.MEASUREMENT_NUMBER, (Object)DashboardMeasurementColumn.MEASUREMENT_STATE, (Object)DashboardMeasurementColumn.MEASUREMENT__MEASUREMENT_TYPE, (Object)DashboardMeasurementColumn.ASSIGNED_USER__COST_CENTER, (Object)DashboardMeasurementColumn.ASSIGNED_USER__FULL_NAME, (Object)DashboardMeasurementColumn.CONSTRUCTION_SITE, (Object)DashboardMeasurementColumn.RELEASE_ORDER_NAME, (Object)DashboardMeasurementColumn.MEASUREMENT__PSS_ID, (Object)DashboardMeasurementColumn.MEASUREMENT__PSS_STATE, (Object)DashboardMeasurementColumn.ACCOUNTING_MONTH, (Object)DashboardMeasurementColumn.ACCOUNTING_MONTH_PLANNED, (Object)DashboardMeasurementColumn.PROJECT_EXECUTION_START_DATE, (Object[])new DashboardMeasurementColumn[]{DashboardMeasurementColumn.PROJECT_EXECUTION_END_DATE, DashboardMeasurementColumn.CUSTOMER_NAME, DashboardMeasurementColumn.PERSON_RESPONSIBLE_AT_CUSTOMER, DashboardMeasurementColumn.PROJECT_NAME, DashboardMeasurementColumn.PROJECT_REFERENCE_ID, DashboardMeasurementColumn.STAGE_QNUMBER, DashboardMeasurementColumn.STAGE_ALIAS, DashboardMeasurementColumn.STAGE_VERSION, DashboardMeasurementColumn.QENTITY_QNUMBER, DashboardMeasurementColumn.QENTITY_ALIAS, DashboardMeasurementColumn.WAGE_OVERALL, DashboardMeasurementColumn.WAGE_FACTOR, DashboardMeasurementColumn.COMPANY_WAGE_OVERALL, DashboardMeasurementColumn.MATERIAL_PURCHASE_PRICE_OVERALL, DashboardMeasurementColumn.MATERIAL_SELLING_PRICE_OVERALL, DashboardMeasurementColumn.EXTERNAL_SERVICE_PURCHASE_PRICE_OVERALL, DashboardMeasurementColumn.EXTERNAL_SERVICE_SELLING_PRICE_OVERALL, DashboardMeasurementColumn.NAL_PURCHASE_PRICE_OVERALL, DashboardMeasurementColumn.NAL_SELLING_PRICE_OVERALL, DashboardMeasurementColumn.VALUE_OVERALL, DashboardMeasurementColumn.STAGE__ORDER_NUMBER, DashboardMeasurementColumn.INVOICE__INVOICE_DATE, DashboardMeasurementColumn.INVOICE__INVOICE_POSTING_DATE, DashboardMeasurementColumn.INVOICE__INVOICE_NUMBER, DashboardMeasurementColumn.INVOICE__INVOICE_RESPONSIBLE_PERSON, DashboardMeasurementColumn.MEASUREMENT_LAST_STATE_CHANGE_ON, DashboardMeasurementColumn.MEASUREMENT_LAST_STATE_CHANGE_BY, DashboardMeasurementColumn.MEASUREMENT_CREATED_ON, DashboardMeasurementColumn.MEASUREMENT_CREATED_BY, DashboardMeasurementColumn.MEASUREMENT_UPDATED_ON, DashboardMeasurementColumn.MEASUREMENT_UPDATED_BY, DashboardMeasurementColumn.REMARKS, DashboardMeasurementColumn.REMARKS_INTERNAL}));
    @Nonnull
    private static final Iterable<EDashboardKey> HIDE_TECH_COLS = ImmutableSet.of((Object)EDashboardKey.CONSTRUCTION_SITES, (Object)EDashboardKey.NOT_ACCOUNTED_MEASUREMENTS);

    @Nonnull
    public DashboardTableResponse map(@NonNull EDashboardKey dashboardKey, @NonNull Page<MeasurementDashboard> measurementDashboards, @NonNull Iterable<EDashboardFeature> dashboardFeatures, @NonNull EUseCase useCase) {
        if (dashboardKey == null) {
            throw new NullPointerException("dashboardKey is marked non-null but is null");
        }
        if (measurementDashboards == null) {
            throw new NullPointerException("measurementDashboards is marked non-null but is null");
        }
        if (dashboardFeatures == null) {
            throw new NullPointerException("dashboardFeatures is marked non-null but is null");
        }
        if (useCase == null) {
            throw new NullPointerException("useCase is marked non-null but is null");
        }
        boolean showTechColumns = !Iterables.contains((Iterable)HIDE_TECH_COLS, (Object)dashboardKey);
        boolean showAssignedUserColumns = !Iterables.contains(dashboardFeatures, (Object)EDashboardFeature.HIDE_ASSIGNED_USER_COLUMNS);
        Iterable dashboardMeasurementColumns = COLUMN_SORT_MAPPING.getOrDefault(dashboardKey, Arrays.asList(DashboardMeasurementColumn.values()));
        Iterable columnsAllowed = (Iterable)Streams.stream((Iterable)dashboardMeasurementColumns).filter(item -> showTechColumns || !Iterables.contains((Iterable)DashboardMeasurementColumn.TECH_COLS, (Object)item)).filter(item -> showAssignedUserColumns || !Iterables.contains((Iterable)DashboardMeasurementColumn.ASSIGNED_USER_COLS, (Object)item)).filter(item -> Iterables.contains((Iterable)item.getPrivileges(), (Object)EPrivilege.IGNORE) || this.userService.hasAnyPrivilege(item.getPrivileges())).filter(item -> Iterables.contains((Iterable)item.getUseCases(), (Object)useCase)).collect(ImmutableSet.toImmutableSet());
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (DashboardMeasurementColumn column : columnsAllowed) {
            Iterable privilegeNeeded = column.getPrivileges();
            if (!Iterables.contains((Iterable)privilegeNeeded, (Object)EPrivilege.IGNORE) && !this.userService.hasAnyPrivilege(privilegeNeeded)) continue;
            columnsBuilder.add((Object)DashboardTableResponse.Column.of((String)column.getId(), (String)column.getField().getValue(), (ECellType)column.getCellType()));
        }
        ImmutableList columns = columnsBuilder.build();
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (MeasurementDashboard measurementDashboard : measurementDashboards) {
            ImmutableMap.Builder cellsBuilder = ImmutableMap.builder();
            for (DashboardMeasurementColumn column : columnsAllowed) {
                Object value = column.getValueFn().apply(measurementDashboard);
                cellsBuilder.put((Object)column.getId(), (Object)DashboardTableResponse.Cell.of((ECellType)column.cellType, value));
            }
            ImmutableMap cells = cellsBuilder.build();
            long id = measurementDashboard.getId();
            DashboardTableResponse.Row row = DashboardTableResponse.Row.of((Long)id, (String)EEntityClass.MEASUREMENT.getValue(), (Map)cells);
            rowsBuilder.add((Object)row);
        }
        ImmutableList rows = rowsBuilder.build();
        long totalElements = measurementDashboards.getTotalElements();
        Pageable pageable = measurementDashboards.getPageable();
        long offset = pageable.isPaged() ? pageable.getOffset() : 0L;
        long size = pageable.isPaged() ? (long)pageable.getPageSize() : Long.MAX_VALUE;
        long numberOfElements = offset + size;
        boolean moreResults = numberOfElements < totalElements;
        return DashboardTableResponse.of((EDashboardKey)dashboardKey, (List)columns, (List)rows, (Boolean)moreResults);
    }

    @Nonnull
    public MeasurementFilter measurementFilter(@NonNull Pageable pageRequest, @NonNull DashboardFilterRequest dashboardFilterRequest, @NonNull Iterable<EMeasurementState> measurementStates, boolean flagInvoiceDateLaterThanProjectExecutionBegin, boolean flagNAL) {
        if (pageRequest == null) {
            throw new NullPointerException("pageRequest is marked non-null but is null");
        }
        if (dashboardFilterRequest == null) {
            throw new NullPointerException("dashboardFilterRequest is marked non-null but is null");
        }
        if (measurementStates == null) {
            throw new NullPointerException("measurementStates is marked non-null but is null");
        }
        DashboardFilterMeasurement dashboardFilterMeasurement = dashboardFilterRequest.getMeasurement();
        if (null != dashboardFilterMeasurement) {
            DashboardFilterDateRange dashboardFilterDateRange = dashboardFilterMeasurement.getAccountingMonth();
            Iterable assignedUserIds = (Iterable)MoreObjects.firstNonNull((Object)dashboardFilterMeasurement.getAssignedUserIds(), (Object)ImmutableSet.of());
            Range accountingMonth = null != dashboardFilterDateRange ? this.filterDateRange(dashboardFilterDateRange) : Range.all();
            String costCenter = StringUtils.trimToEmpty((String)dashboardFilterMeasurement.getCostCenter());
            String quotationNumber = StringUtils.trimToEmpty((String)dashboardFilterMeasurement.getQuotationNumber());
            Long entityId = dashboardFilterMeasurement.getEntityId();
            Long stageId = dashboardFilterMeasurement.getStageId();
            Long projectId = dashboardFilterMeasurement.getProjectId();
            ImmutableSet quotationNumbers = StringUtils.isNotBlank((CharSequence)quotationNumber) ? ImmutableSet.of((Object)quotationNumber) : ImmutableSet.of();
            ImmutableSet entityIds = null != entityId ? ImmutableSet.of((Object)entityId) : ImmutableSet.of();
            ImmutableSet stageIds = null != stageId ? ImmutableSet.of((Object)stageId) : ImmutableSet.of();
            ImmutableSet projectsIds = null != projectId ? ImmutableSet.of((Object)projectId) : ImmutableSet.of();
            CostCenterFilter costCenterFilter = CostCenterFilter.from((String)costCenter);
            ImmutableSet currentPersonCostCenters = costCenterFilter != CostCenterFilter.EMPTY ? ImmutableSet.of((Object)costCenterFilter) : ImmutableSet.of();
            return MeasurementFilter.of((boolean)true, (boolean)flagInvoiceDateLaterThanProjectExecutionBegin, (boolean)flagNAL, (String)"", (String)"", (Iterable)ImmutableList.of(), (Iterable)quotationNumbers, (Iterable)currentPersonCostCenters, (Iterable)ImmutableList.of(), (Iterable)entityIds, (Iterable)stageIds, (Iterable)projectsIds, (Pageable)pageRequest, (Iterable)assignedUserIds, (Range)accountingMonth, (Range)Range.all(), (Range)Range.all(), (Iterable)ImmutableList.of(), (Iterable)ImmutableSet.copyOf(measurementStates));
        }
        return MeasurementFilter.of((boolean)true, (boolean)flagInvoiceDateLaterThanProjectExecutionBegin, (boolean)flagNAL, (String)"", (String)"", (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Pageable)pageRequest, (Iterable)ImmutableList.of(), (Range)Range.all(), (Range)Range.all(), (Range)Range.all(), (Iterable)ImmutableList.of(), (Iterable)ImmutableSet.copyOf(measurementStates));
    }

    @Nonnull
    private Range<LocalDate> filterDateRange(@NonNull DashboardFilterDateRange dashboardFilterDateRange) {
        if (dashboardFilterDateRange == null) {
            throw new NullPointerException("dashboardFilterDateRange is marked non-null but is null");
        }
        LocalDate from = dashboardFilterDateRange.getFrom();
        LocalDate to = dashboardFilterDateRange.getTo();
        if (null != from && null != to) {
            return Range.closed((Comparable)YearMonth.from(from).atDay(1), (Comparable)YearMonth.from(to).atEndOfMonth());
        }
        if (null != from) {
            return Range.atLeast((Comparable)YearMonth.from(from).atDay(1));
        }
        if (null != to) {
            return Range.atMost((Comparable)YearMonth.from(to).atEndOfMonth());
        }
        return Range.all();
    }

    @Nonnull
    public Iterable<NotAccountedMeasurementUngrouped> mapToXLSUngrouped(@NonNull Page<MeasurementDashboard> measurementsPage) {
        if (measurementsPage == null) {
            throw new NullPointerException("measurementsPage is marked non-null but is null");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MeasurementDashboard measurement : measurementsPage) {
            NotAccountedMeasurementUngrouped nalUngrouped = new NotAccountedMeasurementUngrouped();
            BigDecimal nalPurchasePrice = (BigDecimal)DashboardMeasurementColumn.NAL_PURCHASE_PRICE_OVERALL.getValueFn().apply(measurement);
            BigDecimal nalSellingPrice = (BigDecimal)DashboardMeasurementColumn.NAL_SELLING_PRICE_OVERALL.getValueFn().apply(measurement);
            nalUngrouped.setCreatedOn(measurement.getCreatedOn());
            nalUngrouped.setCreatedBy(measurement.getCreatedBy());
            nalUngrouped.setUpdatedOn(measurement.getUpdatedOn());
            nalUngrouped.setUpdatedBy(measurement.getUpdatedBy());
            nalUngrouped.setEntityNumber(StringUtils.trimToEmpty((String)measurement.getEntityQNumber()));
            nalUngrouped.setEntityAlias(StringUtils.trimToEmpty((String)measurement.getEntityAlias()));
            nalUngrouped.setStageNumber(StringUtils.trimToEmpty((String)measurement.getStageQNumber()));
            nalUngrouped.setStageAlias(StringUtils.trimToEmpty((String)measurement.getStageAlias()));
            nalUngrouped.setStageVersion(measurement.getStageVersion());
            nalUngrouped.setCustomerName(StringUtils.trimToEmpty((String)measurement.getStageCustomerName()));
            nalUngrouped.setProjectName(StringUtils.trimToEmpty((String)measurement.getProjectName()));
            nalUngrouped.setProjectReferenceId(StringUtils.trimToEmpty((String)measurement.getProjectReferenceId()));
            nalUngrouped.setCostCenter(StringUtils.trimToEmpty((String)measurement.getAssignedUserCostCenter()));
            nalUngrouped.setMeasurementNumber(StringUtils.trimToEmpty((String)measurement.getMeasurementNumber()));
            nalUngrouped.setReleaseOrderName(StringUtils.trimToEmpty((String)measurement.getReleaseOrderName()));
            nalUngrouped.setConstructionSite(StringUtils.trimToEmpty((String)measurement.getConstructionSite()));
            nalUngrouped.setWageOverall((BigDecimal)MoreObjects.firstNonNull((Object)measurement.getSquadWageOverall(), (Object)BigDecimal.ZERO));
            nalUngrouped.setCompanyWageOverall((BigDecimal)MoreObjects.firstNonNull((Object)measurement.getCompanyWageOverall(), (Object)BigDecimal.ZERO));
            nalUngrouped.setMaterialPurchasePriceOverall((BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialPurchasePriceOverall(), (Object)BigDecimal.ZERO));
            nalUngrouped.setMaterialSellingPriceOverall((BigDecimal)MoreObjects.firstNonNull((Object)measurement.getMaterialSellingPriceOverall(), (Object)BigDecimal.ZERO));
            nalUngrouped.setNalPurchasePriceOverall((BigDecimal)MoreObjects.firstNonNull((Object)nalPurchasePrice, (Object)BigDecimal.ZERO));
            nalUngrouped.setNalSellingPriceOverall((BigDecimal)MoreObjects.firstNonNull((Object)nalSellingPrice, (Object)BigDecimal.ZERO));
            nalUngrouped.setExternalServicePurchasePriceOverall((BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServicePurchasePriceOverall(), (Object)BigDecimal.ZERO));
            nalUngrouped.setExternalServiceSellingPriceOverall((BigDecimal)MoreObjects.firstNonNull((Object)measurement.getExternalServiceSellingPriceOverall(), (Object)BigDecimal.ZERO));
            nalUngrouped.setValueOverall((BigDecimal)MoreObjects.firstNonNull((Object)measurement.getValueOverall(), (Object)BigDecimal.ZERO));
            nalUngrouped.setProjectExecutionStartDate(measurement.getProjectExecutionStartDate());
            nalUngrouped.setProjectExecutionEndDate(measurement.getProjectExecutionEndDate());
            nalUngrouped.setAccountingMonth(measurement.getAccountingMonth());
            nalUngrouped.setAccountingMonthPlanned(measurement.getAccountingMonthPlanned());
            EMeasurementState measurementState = measurement.getMeasurementState();
            String measurementStateDE = this.messageService.getDE((Translatable)measurementState, new Object[0]);
            nalUngrouped.setMeasurementStateDE(measurementStateDE);
            EMeasurementType measurementType = (EMeasurementType)MoreObjects.firstNonNull((Object)measurement.getMeasurementType(), (Object)EMeasurementType.NONE);
            String measurementTypeDE = this.messageService.getDE((Translatable)measurementType, new Object[0]);
            nalUngrouped.setMeasurementTypeDE(measurementTypeDE);
            nalUngrouped.setMeasurementStateOn(measurement.getMeasurementStateOn());
            nalUngrouped.setPssId(measurement.getPssId());
            nalUngrouped.setPssState(measurement.getPssState());
            nalUngrouped.setInvoiceDate(measurement.getInvoiceDate());
            nalUngrouped.setInvoicePostingDate(measurement.getInvoicePostingDate());
            nalUngrouped.setInvoiceNumber(measurement.getInvoiceNumber());
            nalUngrouped.setInvoiceOrderNumber(measurement.getInvoiceOrderNumber());
            nalUngrouped.setInvoiceResponsiblePersonFullName(measurement.getInvoiceResponsiblePersonFullName());
            nalUngrouped.setAssignedUserFullName(measurement.getAssignedUserFullName());
            nalUngrouped.setRemarks(measurement.getRemarks());
            nalUngrouped.setRemarksInternal(measurement.getRemarksInternal());
            builder.add((Object)nalUngrouped);
        }
        return builder.build();
    }

    @Nonnull
    public Iterable<NotAccountedMeasurementGrouped> mapToXLSGroupedByStageNumber(@NonNull Page<MeasurementDashboard> measurementsPage) {
        if (measurementsPage == null) {
            throw new NullPointerException("measurementsPage is marked non-null but is null");
        }
        Function keyFN = MeasurementDashboard::getStageQuotationNumber;
        ImmutableListMultimap groupedByQuotationNumber = Multimaps.index(measurementsPage, (Function)keyFN);
        Map stageNumberByKey = MapsHelper.mapFirst(measurementsPage, (java.util.function.Function)keyFN, MeasurementDashboard::getStageQNumber);
        Map aliasByKey = MapsHelper.mapFirst(measurementsPage, (java.util.function.Function)keyFN, MeasurementDashboard::getStageAlias);
        TreeSet sortedKeys = Sets.newTreeSet((Iterable)groupedByQuotationNumber.keySet());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : sortedKeys) {
            Collection measurementDashboards = groupedByQuotationNumber.get((Object)key);
            NotAccountedMeasurementGrouped nalGrouped = new NotAccountedMeasurementGrouped();
            nalGrouped.setQuotationNumber(key);
            nalGrouped.setStageNumber(stageNumberByKey.getOrDefault(key, ""));
            nalGrouped.setStageAlias(aliasByKey.getOrDefault(key, ""));
            String projectName = measurementDashboards.stream().map(MeasurementDashboard::getProjectName).findFirst().orElse("");
            String projectReferenceId = measurementDashboards.stream().map(MeasurementDashboard::getProjectReferenceId).findFirst().orElse("");
            nalGrouped.setProjectName(projectName);
            nalGrouped.setProjectReferenceId(projectReferenceId);
            BigDecimal wageOverall = DashboardMapper.sum((Collection)measurementDashboards, MeasurementDashboard::getSquadWageOverall);
            nalGrouped.setWageOverall(wageOverall);
            BigDecimal companyWageOverall = DashboardMapper.sum((Collection)measurementDashboards, MeasurementDashboard::getCompanyWageOverall);
            nalGrouped.setCompanyWageOverall(companyWageOverall);
            BigDecimal materialPurchasePriceOverall = DashboardMapper.sum((Collection)measurementDashboards, MeasurementDashboard::getMaterialPurchasePriceOverall);
            nalGrouped.setMaterialPurchasePriceOverall(materialPurchasePriceOverall);
            BigDecimal materialSellingPriceOverall = DashboardMapper.sum((Collection)measurementDashboards, MeasurementDashboard::getMaterialSellingPriceOverall);
            nalGrouped.setMaterialSellingPriceOverall(materialSellingPriceOverall);
            BigDecimal externalServicePurchasePriceSum = DashboardMapper.sum((Collection)measurementDashboards, MeasurementDashboard::getExternalServicePurchasePriceOverall);
            nalGrouped.setExternalServicePurchasePriceOverall(externalServicePurchasePriceSum);
            BigDecimal externalServiceSellingPriceSum = DashboardMapper.sum((Collection)measurementDashboards, MeasurementDashboard::getExternalServiceSellingPriceOverall);
            nalGrouped.setExternalServiceSellingPriceOverall(externalServiceSellingPriceSum);
            BigDecimal nalPurchasePriceOverall = measurementDashboards.stream().map(item -> this.safeAdd(item.getCompanyWageOverall(), item.getMaterialPurchasePriceOverall(), item.getExternalServicePurchasePriceOverall())).reduce(BigDecimal.ZERO, BigDecimal::add);
            nalGrouped.setNalPurchasePriceOverall(nalPurchasePriceOverall);
            BigDecimal nalSellingPriceOverall = measurementDashboards.stream().map(item -> this.safeAdd(item.getCompanyWageOverall(), item.getMaterialSellingPriceOverall(), item.getExternalServiceSellingPriceOverall())).reduce(BigDecimal.ZERO, BigDecimal::add);
            nalGrouped.setNalSellingPriceOverall(nalSellingPriceOverall);
            builder.add((Object)nalGrouped);
        }
        return builder.build();
    }

    @Nonnull
    private static BigDecimal sum(@NonNull Collection<MeasurementDashboard> measurementDashboards, @NonNull java.util.function.Function<MeasurementDashboard, BigDecimal> fn) {
        if (measurementDashboards == null) {
            throw new NullPointerException("measurementDashboards is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        return measurementDashboards.stream().map(fn).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Nonnull
    private BigDecimal safeAdd(@Nullable BigDecimal first, @Nullable BigDecimal second, @Nullable BigDecimal third) {
        BigDecimal safeFirst = (BigDecimal)MoreObjects.firstNonNull((Object)first, (Object)BigDecimal.ZERO);
        BigDecimal safeSecond = (BigDecimal)MoreObjects.firstNonNull((Object)second, (Object)BigDecimal.ZERO);
        BigDecimal safeThird = (BigDecimal)MoreObjects.firstNonNull((Object)third, (Object)BigDecimal.ZERO);
        return safeFirst.add(safeSecond).add(safeThird);
    }

    public DashboardMapper(MessageService messageService, UserService userService) {
        this.messageService = messageService;
        this.userService = userService;
    }
}

