/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.request.customer.v2.CustomerUpdateRequest;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.customer.AddressAutoCompleteItemCommon;
import de.qfm.erp.common.response.customer.AddressAutoCompleteResponse;
import de.qfm.erp.common.response.customer.AddressCommon;
import de.qfm.erp.common.response.customer.ContactPersonAutoCompleteItemCommon;
import de.qfm.erp.common.response.customer.ContactPersonAutoCompleteResponse;
import de.qfm.erp.common.response.customer.ContactPersonCommon;
import de.qfm.erp.common.response.customer.CustomerAutoCompleteItemCommon;
import de.qfm.erp.common.response.customer.CustomerAutoCompleteResponse;
import de.qfm.erp.common.response.customer.CustomerCommon;
import de.qfm.erp.common.response.customer.CustomerPageCommon;
import de.qfm.erp.common.response.customer.CustomerQEntitiesPageCommon;
import de.qfm.erp.common.response.customer.CustomerQEntityCommon;
import de.qfm.erp.common.response.search.CustomerSearchItem;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.helper.CustomerHelper;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.internal.customer.AddressUpdateBucket;
import de.qfm.erp.service.model.internal.customer.ContactPersonUpdateBucket;
import de.qfm.erp.service.model.internal.customer.CustomerUpdateBucket;
import de.qfm.erp.service.model.internal.search.CustomerSearchItemBucket;
import de.qfm.erp.service.model.internal.search.Highlight;
import de.qfm.erp.service.model.internal.sharepoint.ESharepointState;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.customer.EAddressType;
import de.qfm.erp.service.model.jpa.customer.ECustomerState;
import de.qfm.erp.service.model.jpa.customer.ECustomerType;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.model.search.CustomerIndexEntry;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.mapper.BaseMapper;
import de.qfm.erp.service.service.mapper.HighlightMapper;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

@Service
public class CustomerMapper {
    private final ApplicationConfig applicationConfig;
    private final ConfigService configService;
    private final MessageService messageService;
    private final AuthenticationHelper authenticationHelper;
    private final EntityFactory entityFactory;
    private final HighlightMapper highlightMapper;
    private final CompanyConfig companyConfig;
    private static final BiConsumer<Address, AddressUpdateBucket> NO_CALLBACK_CA = (x, y) -> {};
    private static final BiConsumer<ContactPerson, ContactPersonUpdateBucket> NO_CALLBACK_CP = (x, y) -> {};

    @Nonnull
    public CustomerCommon map(@NonNull Customer item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return this.map(item, true, true);
    }

    @Nonnull
    public CustomerCommon map(@NonNull Customer item, boolean mapAddresses, boolean mapContactPersons) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        CustomerCommon common = new CustomerCommon();
        BaseMapper.map((EntityBase)item, (EntityBaseCommon)common);
        common.setId(item.getId());
        common.setName(StringUtils.trimToEmpty((String)item.getName()));
        ECustomerState customerState = (ECustomerState)MoreObjects.firstNonNull((Object)item.getCustomerState(), (Object)ECustomerState.UNKNOWN);
        common.setCustomerState(customerState.name());
        ECustomerType customerType = (ECustomerType)MoreObjects.firstNonNull((Object)item.getCustomerType(), (Object)ECustomerType.UNKNOWN);
        common.setCustomerType(customerType.name());
        common.setRemarks(StringUtils.trimToEmpty((String)item.getRemarks()));
        common.setDebtorAccountNumber(StringUtils.trimToEmpty((String)item.getDebtorAccountNumber()));
        common.setFlagSecurityRetention(item.getFlagSecurityRetention());
        common.setFlagSubContractorAsExternalServiceAccounting(item.getFlagSubContractorAsExternalServiceAccounting());
        common.setFlagCompanyGroup(item.getFlagCompanyGroup());
        ESharepointState sharepointState = (ESharepointState)MoreObjects.firstNonNull((Object)item.getSharepointState(), (Object)ESharepointState.UNKNOWN);
        common.setSharepointState(sharepointState.name());
        common.setSharepointUrl(item.getSharepointUrl());
        common.setSharepointSiteId(item.getSharepointSiteId());
        common.setSharepointDriveId(item.getSharepointDriveId());
        common.setSharepointDriveItemId(item.getSharepointDriveItemId());
        if (mapAddresses) {
            Iterable addresses = (Iterable)MoreObjects.firstNonNull((Object)item.getAddresses(), (Object)ImmutableSet.of());
            List addressCommons = (List)Streams.stream((Iterable)addresses).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
            common.setAddresses(addressCommons);
        }
        if (mapContactPersons) {
            Iterable contactPerson = (Iterable)MoreObjects.firstNonNull((Object)item.getContactPersons(), (Object)ImmutableSet.of());
            ImmutableList contactPersonCommons = (ImmutableList)Streams.stream((Iterable)contactPerson).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
            common.setContactPersons((List)contactPersonCommons);
        }
        String text = CustomerHelper.customerText((MessageService)this.messageService, (Customer)item);
        common.setText(text);
        return common;
    }

    @Nonnull
    public CustomerPageCommon map(@NonNull Page<Customer> page) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        return (CustomerPageCommon)BaseMapper.map(page, arg_0 -> this.map(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new CustomerPageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public Customer merge(@NonNull CustomerUpdateBucket updateBucket, boolean append) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Customer customer = updateBucket.getCustomer();
        CustomerUpdateRequest updateRequest = updateBucket.getUpdateRequest();
        ECustomerType customerType = updateBucket.getCustomerType();
        List addressUpdateBuckets = updateBucket.getAddressUpdateBuckets();
        List contactPersonUpdateBuckets = updateBucket.getContactPersonUpdateBuckets();
        customer.setName(updateRequest.getName());
        customer.setCustomerType(customerType);
        customer.setRemarks(updateRequest.getRemarks());
        customer.setDebtorAccountNumber(updateRequest.getDebtorAccountNumber());
        customer.setFlagSecurityRetention((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagSecurityRetention(), (Object)false));
        customer.setFlagSubContractorAsExternalServiceAccounting((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagSubContractorAsExternalServiceAccounting(), (Object)false));
        customer.setFlagCompanyGroup((Boolean)MoreObjects.firstNonNull((Object)updateRequest.getFlagCompanyGroup(), (Object)false));
        MergedBucket addressedMergedBucket = BaseMapper.merge((EntityBase)customer, Customer::getAddresses, arg_0 -> ((Customer)customer).setAddresses(arg_0), (Iterable)addressUpdateBuckets, AddressUpdateBucket::getId, Address::getId, () -> ((EntityFactory)this.entityFactory).address(), (arg_0, arg_1) -> this.mergeAddress(arg_0, arg_1), Address::setCustomer, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NO_CALLBACK_CA, (boolean)append);
        MergedBucket.printMergeBucket((Object)customer, Address.class, (MergedBucket)addressedMergedBucket);
        MergedBucket contactPersonMergedBucket = BaseMapper.merge((EntityBase)customer, Customer::getContactPersons, arg_0 -> ((Customer)customer).setContactPersons(arg_0), (Iterable)contactPersonUpdateBuckets, ContactPersonUpdateBucket::getId, ContactPerson::getId, () -> ((EntityFactory)this.entityFactory).contactPerson(), (arg_0, arg_1) -> this.mergeContactPerson(arg_0, arg_1), ContactPerson::setCustomer, () -> ((AuthenticationHelper)this.authenticationHelper).currentUserName(), (BiConsumer)NO_CALLBACK_CP, (boolean)append);
        MergedBucket.printMergeBucket((Object)customer, ContactPerson.class, (MergedBucket)contactPersonMergedBucket);
        return customer;
    }

    @Nonnull
    public Address mergeAddress(@NonNull Address entity, @NonNull AddressUpdateBucket updateBucket) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        EAddressType addressType = updateBucket.getAddressType();
        entity.setAddressType(addressType);
        entity.setName(StringUtils.trimToEmpty((String)updateBucket.getName()));
        entity.setAddressSuffix(StringUtils.trimToEmpty((String)updateBucket.getAddressSuffix()));
        entity.setPoBox(StringUtils.trimToEmpty((String)updateBucket.getPoBox()));
        entity.setStreet(StringUtils.trimToEmpty((String)updateBucket.getStreet()));
        entity.setStreetNo(StringUtils.trimToEmpty((String)updateBucket.getStreetNo()));
        entity.setCity(StringUtils.trimToEmpty((String)updateBucket.getCity()));
        entity.setZipCode(StringUtils.trimToEmpty((String)updateBucket.getZipCode()));
        entity.setEmail(StringUtils.trimToEmpty((String)updateBucket.getEmail()));
        entity.setPortal(StringUtils.trimToEmpty((String)updateBucket.getPortal()));
        entity.setRemarks(StringUtils.trimToEmpty((String)updateBucket.getRemarks()));
        entity.setValidBegin(updateBucket.getValidBegin());
        entity.setValidEnd(updateBucket.getValidEnd());
        entity.setReferenceAddress(updateBucket.getReferenceAddress());
        return entity;
    }

    @Nonnull
    public ContactPerson mergeContactPerson(@NonNull ContactPerson entity, @NonNull ContactPersonUpdateBucket updateBucket) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        entity.setTitle(StringUtils.trimToEmpty((String)updateBucket.getTitle()));
        entity.setSalutation(StringUtils.trimToEmpty((String)updateBucket.getSalutation()));
        entity.setFirstName(StringUtils.trimToEmpty((String)updateBucket.getFirstName()));
        entity.setLastName(StringUtils.trimToEmpty((String)updateBucket.getLastName()));
        entity.setDepartment(StringUtils.trimToEmpty((String)updateBucket.getDepartment()));
        entity.setPosition(StringUtils.trimToEmpty((String)updateBucket.getPosition()));
        entity.setPhone(StringUtils.trimToEmpty((String)updateBucket.getPhone()));
        entity.setCellular(StringUtils.trimToEmpty((String)updateBucket.getCellular()));
        entity.setEmail(StringUtils.trimToEmpty((String)updateBucket.getEmail()));
        entity.setRemarks(StringUtils.trimToEmpty((String)updateBucket.getRemarks()));
        entity.setBirthDayDate(updateBucket.getBirthDayDate());
        entity.setValidBegin(updateBucket.getValidBegin());
        entity.setValidEnd(updateBucket.getValidEnd());
        return entity;
    }

    @Nonnull
    public CustomerQEntitiesPageCommon mapCustomerQEntity(@NonNull Page<QEntity> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        return (CustomerQEntitiesPageCommon)BaseMapper.map(entities, arg_0 -> this.mapCustomerQEntity(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new CustomerQEntitiesPageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public CustomerQEntityCommon mapCustomerQEntity(@NonNull QEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        CustomerQEntityCommon common = new CustomerQEntityCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        common.setQentityNumber(entity.getQNumber());
        common.setAlias(entity.getAlias());
        Quotation primaryStage = entity.getPrimaryStage();
        if (null != primaryStage) {
            User firstResponsibleUser;
            Optional<StageResponsibleUser> firstResponsible;
            Set stageResponsibleUsers;
            EQStageType stageType = primaryStage.getStageType();
            EQStageState stageState = (EQStageState)MoreObjects.firstNonNull((Object)primaryStage.getStageState(), (Object)EQStageState.UNKNOWN);
            common.setQentityState(stageState.name());
            common.setPrimaryStageId(primaryStage.getId());
            common.setPrimaryStageAlias(primaryStage.getAlias());
            common.setPrimaryStageType(stageType.name());
            common.setPrimaryStageState(stageState.name());
            BigDecimal priceWithoutDiscountSum = (BigDecimal)MoreObjects.firstNonNull((Object)primaryStage.getPriceWithoutDiscountSum(), (Object)BigDecimal.ZERO);
            common.setPriceWithoutDiscountSum(priceWithoutDiscountSum);
            BigDecimal priceWithDiscountSum = (BigDecimal)MoreObjects.firstNonNull((Object)primaryStage.getPriceWithDiscountSum(), (Object)BigDecimal.ZERO);
            common.setPriceWithDiscountSum(priceWithDiscountSum);
            Customer customer = primaryStage.getCustomer();
            if (null != customer) {
                common.setCustomerId(customer.getId());
                common.setCustomerName(customer.getName());
            }
            if (!(stageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)primaryStage.getStageResponsibleUsers(), (Object)ImmutableSet.of())).isEmpty() && (firstResponsible = stageResponsibleUsers.stream().filter(item -> null != item.getUser()).findFirst()).isPresent() && null != (firstResponsibleUser = (User)firstResponsible.map(StageResponsibleUser::getUser).orElse(null))) {
                common.setResponsibleUserId(firstResponsibleUser.getId());
                common.setResponsibleUserFullName(firstResponsibleUser.getFullName());
            }
        } else {
            common.setQentityState("");
            common.setPrimaryStageId(null);
            common.setPrimaryStageAlias("");
            common.setPrimaryStageType("");
            common.setPrimaryStageState("");
            common.setPriceWithoutDiscountSum(BigDecimal.ZERO);
            common.setPriceWithDiscountSum(BigDecimal.ZERO);
            common.setCustomerId(null);
            common.setCustomerName("");
            common.setResponsibleUserId(null);
            common.setResponsibleUserFullName("");
        }
        common.setDegreeOfFulfilment(BigDecimal.ONE.negate());
        return common;
    }

    @Nonnull
    public CustomerAutoCompleteResponse mapAutoComplete(@NonNull Page<Customer> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        ImmutableList common = (ImmutableList)entities.stream().map(arg_0 -> this.mapAutoComplete(arg_0)).sorted((l, r) -> StringUtils.compareIgnoreCase((String)l.getText(), (String)r.getText())).collect(ImmutableList.toImmutableList());
        return new CustomerAutoCompleteResponse(entities.getSize(), (List)common);
    }

    @Nonnull
    public CustomerAutoCompleteItemCommon mapAutoComplete(@NonNull Customer entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        CustomerAutoCompleteItemCommon common = new CustomerAutoCompleteItemCommon();
        String textWithState = CustomerHelper.customerText((MessageService)this.messageService, (Customer)entity);
        common.setId(entity.getId());
        common.setText(textWithState);
        common.setName(StringUtils.trimToEmpty((String)entity.getName()));
        common.setDebtorAccountNumber(StringUtils.trimToEmpty((String)entity.getDebtorAccountNumber()));
        common.setRemarks(StringUtils.trimToEmpty((String)entity.getRemarks()));
        common.setFlagCompanyGroup(entity.getFlagCompanyGroup());
        common.setFlagSubContractorAsExternalServiceAccounting(entity.getFlagSubContractorAsExternalServiceAccounting());
        ECustomerState customerState = (ECustomerState)MoreObjects.firstNonNull((Object)entity.getCustomerState(), (Object)ECustomerState.UNKNOWN);
        common.setCustomerState(customerState.name());
        ECustomerType customerType = (ECustomerType)MoreObjects.firstNonNull((Object)entity.getCustomerType(), (Object)ECustomerType.UNKNOWN);
        common.setCustomerType(customerType.name());
        return common;
    }

    @Nonnull
    public AddressCommon map(@NonNull Address entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        AddressCommon common = new AddressCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        String addressText = CustomerHelper.addressText((Address)entity);
        common.setText(addressText);
        EAddressType addressType = (EAddressType)MoreObjects.firstNonNull((Object)entity.getAddressType(), (Object)EAddressType.UNKNOWN);
        common.setAddressType(addressType.name());
        common.setName(entity.getName());
        common.setAddressSuffix(entity.getAddressSuffix());
        common.setPoBox(entity.getPoBox());
        common.setStreet(entity.getStreet());
        common.setStreetNo(entity.getStreetNo());
        common.setZipCode(entity.getZipCode());
        common.setCity(entity.getCity());
        common.setEmail(entity.getEmail());
        common.setPortal(entity.getPortal());
        common.setRemarks(entity.getRemarks());
        common.setValidBegin(entity.getValidBegin());
        LocalDate validEnd = entity.getValidEnd();
        if (Objects.equals(this.applicationConfig.getDefaultEndDate(), validEnd)) {
            common.setValidEnd(null);
        } else {
            common.setValidEnd(entity.getValidEnd());
        }
        Customer customer = entity.getCustomer();
        if (null != customer) {
            common.setCustomerId(customer.getId());
        }
        return common;
    }

    @Nonnull
    public ContactPersonCommon map(@NonNull ContactPerson entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        ContactPersonCommon common = new ContactPersonCommon();
        BaseMapper.map((EntityBase)entity, (EntityBaseCommon)common);
        common.setId(entity.getId());
        String text = CustomerHelper.contactPersonText((ContactPerson)entity, (boolean)false);
        common.setText(text);
        common.setSalutation(entity.getSalutation());
        common.setTitle(entity.getTitle());
        common.setFirstName(entity.getFirstName());
        common.setLastName(entity.getLastName());
        common.setDepartment(entity.getDepartment());
        common.setPosition(entity.getPosition());
        common.setPhone(entity.getPhone());
        common.setCellular(entity.getCellular());
        common.setEmail(entity.getEmail());
        common.setRemarks(entity.getRemarks());
        common.setBirthDayDate(entity.getBirthDayDate());
        common.setValidBegin(entity.getValidBegin());
        LocalDate validEnd = entity.getValidEnd();
        if (Objects.equals(this.applicationConfig.getDefaultEndDate(), validEnd)) {
            common.setValidEnd(null);
        } else {
            common.setValidEnd(entity.getValidEnd());
        }
        Customer customer = entity.getCustomer();
        if (null != customer) {
            common.setCustomerId(customer.getId());
        }
        return common;
    }

    @Nonnull
    public AddressAutoCompleteResponse mapAddressAutoComplete(@NonNull Page<Address> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        ImmutableList common = (ImmutableList)entities.stream().map(arg_0 -> this.mapAddressAutoComplete(arg_0)).sorted((l, r) -> StringUtils.compareIgnoreCase((String)l.getText(), (String)r.getText())).collect(ImmutableList.toImmutableList());
        return new AddressAutoCompleteResponse(entities.getSize(), (List)common);
    }

    @Nonnull
    public AddressAutoCompleteItemCommon mapAddressAutoComplete(@NonNull Address entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        AddressAutoCompleteItemCommon common = new AddressAutoCompleteItemCommon();
        String text = CustomerHelper.addressText((Address)entity);
        common.setId(entity.getId());
        Customer customer = entity.getCustomer();
        if (null != customer) {
            common.setCustomerId(customer.getId());
        }
        common.setText(text);
        EAddressType addressType = (EAddressType)MoreObjects.firstNonNull((Object)entity.getAddressType(), (Object)EAddressType.UNKNOWN);
        common.setAddressType(addressType.name());
        common.setName(entity.getName());
        common.setAddressSuffix(entity.getAddressSuffix());
        common.setPoBox(entity.getPoBox());
        common.setStreet(entity.getStreet());
        common.setStreetNo(entity.getStreetNo());
        common.setZipCode(entity.getZipCode());
        common.setCity(entity.getCity());
        return common;
    }

    @Nonnull
    public ContactPersonAutoCompleteResponse mapContactPersonAutoComplete(@NonNull Page<ContactPerson> entities) {
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        ImmutableList common = (ImmutableList)entities.stream().map(arg_0 -> this.mapContactPersonAutoComplete(arg_0)).sorted((l, r) -> StringUtils.compareIgnoreCase((String)l.getText(), (String)r.getText())).collect(ImmutableList.toImmutableList());
        return new ContactPersonAutoCompleteResponse(entities.getSize(), (List)common);
    }

    @Nonnull
    public ContactPersonAutoCompleteItemCommon mapContactPersonAutoComplete(@NonNull ContactPerson entity) {
        if (entity == null) {
            throw new NullPointerException("entity is marked non-null but is null");
        }
        ContactPersonAutoCompleteItemCommon common = new ContactPersonAutoCompleteItemCommon();
        common.setId(entity.getId());
        Customer customer = entity.getCustomer();
        if (null != customer) {
            common.setCustomerId(customer.getId());
        }
        String text = CustomerHelper.contactPersonText((ContactPerson)entity, (boolean)false);
        common.setText(text);
        common.setDepartment(entity.getDepartment());
        common.setPosition(entity.getPosition());
        common.setFirstName(entity.getFirstName());
        common.setLastName(entity.getLastName());
        return common;
    }

    @Nonnull
    public PageCommon<CustomerSearchItem> mapToSearchItem(@NonNull Page<CustomerSearchItemBucket> buckets) {
        if (buckets == null) {
            throw new NullPointerException("buckets is marked non-null but is null");
        }
        return BaseMapper.map(buckets, arg_0 -> this.mapToSearchItem(arg_0), (pageNumber, pageSize, totalElements, totalPages, items) -> new PageCommon(pageNumber, pageSize, totalPages, totalElements, items));
    }

    @Nonnull
    public CustomerSearchItem mapToSearchItem(@NonNull CustomerSearchItemBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        CustomerIndexEntry customerIndexEntry = bucket.getCustomerIndexEntry();
        String details = bucket.getDetails();
        Highlight rootHighlight = bucket.getRootHighlight();
        Highlight detailHighlight = bucket.getDetailHighlight();
        String companyName = this.companyConfig.getCompanyName();
        String stageOrEntityNumberPrefix = this.configService.getStageOrEntityNumberPrefix();
        IndexField field = detailHighlight.getField();
        String fieldName = this.messageService.get(field, new Object[]{companyName, stageOrEntityNumberPrefix});
        Iterable rootHighlightCommon = this.highlightMapper.map(rootHighlight);
        Iterable detailHighlightCommon = this.highlightMapper.map(detailHighlight);
        return CustomerSearchItem.of((long)customerIndexEntry.getId(), (String)customerIndexEntry.getName(), (Iterable)rootHighlightCommon, (String)details, (String)field.fieldName(), (String)fieldName, (Iterable)detailHighlightCommon);
    }

    public CustomerMapper(ApplicationConfig applicationConfig, ConfigService configService, MessageService messageService, AuthenticationHelper authenticationHelper, EntityFactory entityFactory, HighlightMapper highlightMapper, CompanyConfig companyConfig) {
        this.applicationConfig = applicationConfig;
        this.configService = configService;
        this.messageService = messageService;
        this.authenticationHelper = authenticationHelper;
        this.entityFactory = entityFactory;
        this.highlightMapper = highlightMapper;
        this.companyConfig = companyConfig;
    }
}

