/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.helper.UserHelper;
import de.qfm.erp.service.model.internal.role.CachedRole;
import de.qfm.erp.service.model.internal.user.CachedAutoCompleteUser;
import de.qfm.erp.service.model.internal.user.CachedUser;
import de.qfm.erp.service.model.internal.user.UserCacheUpdateBucket;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionWageGroup;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.model.jpa.user.RolePrivilege;
import de.qfm.erp.service.model.jpa.user.User;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class CacheMapper {
    @Nonnull
    public CachedUser map(@NonNull UserCacheUpdateBucket bucket) {
        if (bucket == null) {
            throw new NullPointerException("bucket is marked non-null but is null");
        }
        User user = bucket.getUser();
        LaborUnionContract laborUnionContract = bucket.getLaborUnionContract();
        LaborUnionWageGroup laborUnionWageGroup = bucket.getLaborUnionWageGroup();
        String costCenter = bucket.getCostCenter();
        CachedUser cachedUser = new CachedUser();
        cachedUser.setId(user.getId());
        cachedUser.setCreatedOn(user.getCreatedOn());
        cachedUser.setUpdatedOn(user.getUpdatedOn());
        cachedUser.setDeletedOn(user.getDeletedOn());
        cachedUser.setCreatedBy(user.getCreatedBy());
        cachedUser.setUpdatedBy(user.getUpdatedBy());
        cachedUser.setDeletedBy(user.getDeletedBy());
        cachedUser.setEntityState(user.getEntityState());
        cachedUser.setRowVersion(Integer.valueOf(user.getRowVersion()));
        cachedUser.setReferenceId(user.getReferenceId());
        cachedUser.setUsername(user.getUsername());
        cachedUser.setSalutation(user.getSalutation());
        cachedUser.setFirstName(user.getFirstName());
        cachedUser.setLastName(user.getLastName());
        cachedUser.setFullName(user.getFullName());
        cachedUser.setRole(user.getRoleDeprecated());
        Iterable allRoles = UserHelper.allRoles((User)user);
        Set allRoleIds = (Set)IterableHelper.stream((Iterable)allRoles).map(Role::getId).collect(ImmutableSet.toImmutableSet());
        Set allRoleNames = (Set)IterableHelper.stream((Iterable)allRoles).map((? super T item) -> StringUtils.trimToEmpty((String)item.getName())).collect(ImmutableSet.toImmutableSet());
        cachedUser.setRoleIds(allRoleIds);
        cachedUser.setRoleNames(allRoleNames);
        cachedUser.setSocialSecurityNumber(user.getSocialSecurityNumber());
        cachedUser.setPersonalNumber(user.getPersonalNumber());
        cachedUser.setSquadNumber(user.getSquadNumber());
        cachedUser.setSquadName(user.getSquadName());
        cachedUser.setSquadReferenceId(user.getSquadReferenceId());
        User squadLeader = user.getSquadLeader();
        if (null != squadLeader) {
            cachedUser.setCurrentSquadLeaderUserId(squadLeader.getId());
            cachedUser.setCurrentSquadLeaderPersonalNumber(squadLeader.getPersonalNumber());
            cachedUser.setCurrentSquadLeaderFullName(squadLeader.getFullName());
        }
        cachedUser.setCurrentCostCenter(costCenter);
        if (null != laborUnionContract) {
            cachedUser.setCurrentLaborUnionContractId(laborUnionContract.getId());
            cachedUser.setCurrentLaborUnionContractName(laborUnionContract.getName());
        }
        if (null != laborUnionWageGroup) {
            cachedUser.setCurrentLaborUnionWageGroupId(laborUnionWageGroup.getId());
            cachedUser.setCurrentLaborUnionWageGroupName(laborUnionWageGroup.getName());
        }
        return cachedUser;
    }

    @Nonnull
    public Iterable<CachedUser> map(@NonNull Iterable<UserCacheUpdateBucket> buckets) {
        if (buckets == null) {
            throw new NullPointerException("buckets is marked non-null but is null");
        }
        return (Iterable)Streams.stream(buckets).map(arg_0 -> this.map(arg_0)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public CachedRole map(@NonNull Role role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        CachedRole cachedRole = new CachedRole();
        cachedRole.setId(role.getId());
        cachedRole.setName(role.getName());
        List rolePrivileges = (List)MoreObjects.firstNonNull((Object)role.getRolePrivileges(), (Object)ImmutableList.of());
        ImmutableSet privileges = (ImmutableSet)rolePrivileges.stream().map(RolePrivilege::getPrivilege).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        cachedRole.setPrivileges((Set)privileges);
        return cachedRole;
    }

    @Nonnull
    public CachedAutoCompleteUser mapAutoComplete(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        CachedAutoCompleteUser cachedUser = new CachedAutoCompleteUser();
        cachedUser.setId(user.getId());
        cachedUser.setFirstName(StringUtils.trimToEmpty((String)user.getFirstName()));
        cachedUser.setLastName(StringUtils.trimToEmpty((String)user.getLastName()));
        cachedUser.setFullName(StringUtils.trimToEmpty((String)user.getFullName()));
        cachedUser.setPersonalNumber(user.getPersonalNumber());
        User squadLeader = user.getSquadLeader();
        if (null != squadLeader) {
            cachedUser.setSquadLeaderUserId(squadLeader.getId());
            cachedUser.setSquadLeaderPersonalNumber(squadLeader.getPersonalNumber());
            cachedUser.setSquadLeaderFullName(StringUtils.trimToEmpty((String)squadLeader.getFullName()));
        }
        return cachedUser;
    }

    @Nonnull
    public Iterable<CachedAutoCompleteUser> mapAutoComplete(@NonNull Iterable<User> users) {
        if (users == null) {
            throw new NullPointerException("users is marked non-null but is null");
        }
        return (Iterable)Streams.stream(users).map(arg_0 -> this.mapAutoComplete(arg_0)).collect(ImmutableList.toImmutableList());
    }
}

