/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.mapper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.response.PageCommon;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.model.internal.MergedBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.service.mapper.BaseMapper;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BaseMapper {
    private static final Logger log = LogManager.getLogger(BaseMapper.class);

    @Nonnull
    public static <T extends EntityBase, V extends EntityBaseCommon> V map(@NonNull T from, @NonNull V to) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        to.setCreatedBy(from.getCreatedBy());
        to.setCreatedOn(from.getCreatedOn());
        to.setUpdatedBy(from.getUpdatedBy());
        to.setUpdatedOn(from.getUpdatedOn());
        to.setDeletedBy(from.getDeletedBy());
        to.setDeletedOn(from.getDeletedOn());
        to.setEntityState(from.getEntityState() != null ? from.getEntityState().name() : null);
        to.setRowVersion(Integer.valueOf(from.getRowVersion()));
        return to;
    }

    @Nonnull
    public static <W, T, V extends PageCommon<W>> V map(@NonNull Page<T> page, @NonNull Function<T, W> fn, @NonNull PageFunction<W, V> fn2) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        if (fn2 == null) {
            throw new NullPointerException("fn2 is marked non-null but is null");
        }
        Pageable pageable = page.getPageable();
        int pageNumber = pageable.getPageNumber();
        int pageSize = pageable.getPageSize();
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        List items = page.getContent();
        List itemsCommon = (List)items.stream().map(fn).collect(ImmutableList.toImmutableList());
        return (V)((PageCommon)fn2.apply(pageNumber, pageSize, totalElements, totalPages, itemsCommon));
    }

    @Nonnull
    public static <W extends EntityBaseCommon, T extends EntityBase, V extends PageCommon<W>> V map(@NonNull Page<T> page, @NonNull Function<T, W> fn, @NonNull PageFunction<W, V> fn2, @NonNull Comparator<W> comp) {
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        if (fn2 == null) {
            throw new NullPointerException("fn2 is marked non-null but is null");
        }
        if (comp == null) {
            throw new NullPointerException("comp is marked non-null but is null");
        }
        Pageable pageable = page.getPageable();
        int pageNumber = pageable.getPageNumber();
        int pageSize = pageable.getPageSize();
        long totalElements = page.getTotalElements();
        int totalPages = page.getTotalPages();
        List items = page.getContent();
        List itemsCommon = (List)items.stream().map(fn).sorted(comp).collect(ImmutableList.toImmutableList());
        return (V)((PageCommon)fn2.apply(pageNumber, pageSize, totalElements, totalPages, itemsCommon));
    }

    @Nonnull
    public static <S, T, V extends EntityBase, W extends EntityBase> MergedBucket<W> merge(@NonNull V root, @NonNull Function<V, Set<W>> rootRelationFn, @NonNull Consumer<Set<W>> rootRelationInitFn, @NonNull Iterable<T> updateItems, @NonNull Function<T, S> updateItemIdFn, @NonNull Function<W, S> entityIdFn, @NonNull Supplier<W> entityFactorySupplier, @NonNull BiFunction<W, T, W> mergeFn, @NonNull BiConsumer<W, V> relationRootFn, @NonNull Supplier<String> currentUserNameSupplier, @NonNull BiConsumer<W, T> callbackFn) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (rootRelationFn == null) {
            throw new NullPointerException("rootRelationFn is marked non-null but is null");
        }
        if (rootRelationInitFn == null) {
            throw new NullPointerException("rootRelationInitFn is marked non-null but is null");
        }
        if (updateItems == null) {
            throw new NullPointerException("updateItems is marked non-null but is null");
        }
        if (updateItemIdFn == null) {
            throw new NullPointerException("updateItemIdFn is marked non-null but is null");
        }
        if (entityIdFn == null) {
            throw new NullPointerException("entityIdFn is marked non-null but is null");
        }
        if (entityFactorySupplier == null) {
            throw new NullPointerException("entityFactorySupplier is marked non-null but is null");
        }
        if (mergeFn == null) {
            throw new NullPointerException("mergeFn is marked non-null but is null");
        }
        if (relationRootFn == null) {
            throw new NullPointerException("relationRootFn is marked non-null but is null");
        }
        if (currentUserNameSupplier == null) {
            throw new NullPointerException("currentUserNameSupplier is marked non-null but is null");
        }
        if (callbackFn == null) {
            throw new NullPointerException("callbackFn is marked non-null but is null");
        }
        return BaseMapper.merge(root, rootRelationFn, rootRelationInitFn, updateItems, updateItemIdFn, entityIdFn, entityFactorySupplier, mergeFn, relationRootFn, currentUserNameSupplier, callbackFn, (boolean)false);
    }

    @Nonnull
    public static <S, T, V extends EntityBase, W extends EntityBase> MergedBucket<W> merge(@NonNull V root, @NonNull Function<V, Set<W>> rootRelationFn, @NonNull Consumer<Set<W>> rootRelationInitFn, @NonNull Iterable<T> updateItems, @NonNull Function<T, S> updateItemIdFn, @NonNull Function<W, S> entityIdFn, @NonNull Supplier<W> entityFactorySupplier, @NonNull BiFunction<W, T, W> mergeFn, @NonNull BiConsumer<W, V> relationRootFn, @NonNull Supplier<String> currentUserNameSupplier, @NonNull BiConsumer<W, T> callbackFn, boolean append) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (rootRelationFn == null) {
            throw new NullPointerException("rootRelationFn is marked non-null but is null");
        }
        if (rootRelationInitFn == null) {
            throw new NullPointerException("rootRelationInitFn is marked non-null but is null");
        }
        if (updateItems == null) {
            throw new NullPointerException("updateItems is marked non-null but is null");
        }
        if (updateItemIdFn == null) {
            throw new NullPointerException("updateItemIdFn is marked non-null but is null");
        }
        if (entityIdFn == null) {
            throw new NullPointerException("entityIdFn is marked non-null but is null");
        }
        if (entityFactorySupplier == null) {
            throw new NullPointerException("entityFactorySupplier is marked non-null but is null");
        }
        if (mergeFn == null) {
            throw new NullPointerException("mergeFn is marked non-null but is null");
        }
        if (relationRootFn == null) {
            throw new NullPointerException("relationRootFn is marked non-null but is null");
        }
        if (currentUserNameSupplier == null) {
            throw new NullPointerException("currentUserNameSupplier is marked non-null but is null");
        }
        if (callbackFn == null) {
            throw new NullPointerException("callbackFn is marked non-null but is null");
        }
        String currentUsername = currentUserNameSupplier.get();
        Set<W> rootRelations = rootRelationFn.apply(root);
        if (null == rootRelations) {
            rootRelationInitFn.accept(Sets.newHashSet());
        }
        Set existingChildren = rootRelationFn.apply(root);
        ImmutableList updateItemsWithId = ImmutableList.copyOf(Streams.stream(updateItems).filter(item -> updateItemIdFn.apply(item) != null).iterator());
        ImmutableList updateItemsWithoutId = ImmutableList.copyOf(Streams.stream(updateItems).filter(item -> updateItemIdFn.apply(item) == null).iterator());
        ImmutableMap updateItemsById = Maps.uniqueIndex((Iterable)updateItemsWithId, updateItemIdFn::apply);
        ImmutableMap entitiesById = Maps.uniqueIndex(existingChildren, entityIdFn::apply);
        if (!Iterables.isEmpty(updateItems) || !Iterables.isEmpty(existingChildren)) {
            Set idsExisting = entitiesById.keySet();
            Set idsToUpdate = updateItemsById.keySet();
            Sets.SetView toAdd = Sets.difference(idsToUpdate, idsExisting);
            Sets.SetView toUpdate = Sets.intersection(idsToUpdate, idsExisting);
            Sets.SetView toRemove = Sets.difference(idsExisting, idsToUpdate);
            ImmutableList.Builder relationsAddedBuilder = ImmutableList.builder();
            for (Object itemToAdd : updateItemsWithoutId) {
                EntityBase relation = (EntityBase)entityFactorySupplier.get();
                mergeFn.apply(relation, itemToAdd);
                relationsAddedBuilder.add((Object)relation);
                callbackFn.accept(relation, itemToAdd);
            }
            ImmutableList relationsAdded = relationsAddedBuilder.build();
            ImmutableList.Builder relationsUpdatedBuilder = ImmutableList.builder();
            for (Object idToUpdate : toUpdate) {
                EntityBase relation = (EntityBase)entitiesById.get(idToUpdate);
                Object updateItem = updateItemsById.get(idToUpdate);
                mergeFn.apply(relation, updateItem);
                relationsUpdatedBuilder.add((Object)relation);
                callbackFn.accept(relation, updateItem);
            }
            ImmutableList relationsUpdated = relationsUpdatedBuilder.build();
            ImmutableList.Builder relationDeletedBuilder = ImmutableList.builder();
            if (!append) {
                for (Object idToRemove : toRemove) {
                    EntityBase relation = (EntityBase)entitiesById.get(idToRemove);
                    relation.setDeletedOn(DateTimeHelper.now());
                    relation.setDeletedBy(currentUsername);
                    relation.setEntityState(EntityState.DELETED);
                    relationDeletedBuilder.add((Object)relation);
                }
            }
            ImmutableList relationDeleted = relationDeletedBuilder.build();
            relationsAdded.forEach(relationToAdd -> {
                relationRootFn.accept(relationToAdd, root);
                existingChildren.add(relationToAdd);
            });
            relationDeleted.forEach(relationToRemove -> {
                relationRootFn.accept(relationToRemove, null);
                existingChildren.remove(relationToRemove);
            });
            return MergedBucket.of((Iterable)relationsAdded, (Iterable)relationsUpdated, (Iterable)relationDeleted);
        }
        return MergedBucket.of((Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
    }

    @Nonnull
    public static <S, V extends EntityBase, W extends EntityBase> MergedBucket<W> merge(@NonNull V root, @NonNull Function<V, Set<W>> rootRelationFn, @NonNull Consumer<Set<W>> rootRelationInitFn, @NonNull Iterable<W> entitiesToAttach, @NonNull Function<W, S> entityIdFn, @NonNull BiConsumer<W, V> relationRootFn) {
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        if (rootRelationFn == null) {
            throw new NullPointerException("rootRelationFn is marked non-null but is null");
        }
        if (rootRelationInitFn == null) {
            throw new NullPointerException("rootRelationInitFn is marked non-null but is null");
        }
        if (entitiesToAttach == null) {
            throw new NullPointerException("entitiesToAttach is marked non-null but is null");
        }
        if (entityIdFn == null) {
            throw new NullPointerException("entityIdFn is marked non-null but is null");
        }
        if (relationRootFn == null) {
            throw new NullPointerException("relationRootFn is marked non-null but is null");
        }
        Set<W> rootRelations = rootRelationFn.apply(root);
        if (null == rootRelations) {
            rootRelationInitFn.accept(Sets.newHashSet());
        }
        Set existingChildren = rootRelationFn.apply(root);
        Set entityIdsExisting = (Set)existingChildren.stream().map(entityIdFn).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Set entityIdsToAttach = (Set)Streams.stream(entitiesToAttach).map(entityIdFn).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        Iterable entitiesToAttachWithId = (Iterable)Streams.stream(entitiesToAttach).filter(item -> null != entityIdFn.apply(item)).collect(ImmutableSet.toImmutableSet());
        Iterable entitiesToAttachWithoutId = (Iterable)Streams.stream(entitiesToAttach).filter(item -> null == entityIdFn.apply(item)).collect(ImmutableSet.toImmutableSet());
        ImmutableList allEntities = ImmutableList.builder().addAll(existingChildren).addAll(entitiesToAttachWithId).build();
        Map allEntitiesById = MapsHelper.mapFirst((Iterable)allEntities, entityIdFn);
        if (!Iterables.isEmpty(entitiesToAttach) || !Iterables.isEmpty(existingChildren)) {
            Sets.SetView toAdd = Sets.difference((Set)entityIdsToAttach, (Set)entityIdsExisting);
            Sets.SetView toUpdate = Sets.intersection((Set)entityIdsToAttach, (Set)entityIdsExisting);
            Sets.SetView toRemove = Sets.difference((Set)entityIdsExisting, (Set)entityIdsToAttach);
            ImmutableList.Builder relationsAddedBuilder = ImmutableList.builder();
            for (Object idToAdd : toAdd) {
                EntityBase relation = (EntityBase)allEntitiesById.get(idToAdd);
                if (null == relation) continue;
                relationsAddedBuilder.add((Object)relation);
            }
            for (EntityBase entityToAdd : entitiesToAttachWithoutId) {
                if (null == entityToAdd) continue;
                relationsAddedBuilder.add((Object)entityToAdd);
            }
            ImmutableList relationsAdded = relationsAddedBuilder.build();
            ImmutableList.Builder relationsUpdatedBuilder = ImmutableList.builder();
            for (Object idToUpdate : toUpdate) {
                EntityBase relation = (EntityBase)allEntitiesById.get(idToUpdate);
                if (null == relation) continue;
                relationsUpdatedBuilder.add((Object)relation);
            }
            ImmutableList relationsUpdated = relationsUpdatedBuilder.build();
            ImmutableList.Builder relationDeletedBuilder = ImmutableList.builder();
            for (Object idToRemove : toRemove) {
                EntityBase relation = (EntityBase)allEntitiesById.get(idToRemove);
                if (null == relation) continue;
                relationDeletedBuilder.add((Object)relation);
            }
            ImmutableList relationDeleted = relationDeletedBuilder.build();
            relationsAdded.forEach(relationToAdd -> {
                relationRootFn.accept(relationToAdd, root);
                existingChildren.add(relationToAdd);
            });
            relationDeleted.forEach(relationToRemove -> {
                relationRootFn.accept(relationToRemove, null);
                existingChildren.remove(relationToRemove);
            });
            return MergedBucket.of((Iterable)relationsAdded, (Iterable)relationsUpdated, (Iterable)relationDeleted);
        }
        return MergedBucket.of((Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of());
    }

    public static <T> boolean mergeIfDifferent(@NonNull Supplier<T> supplierOld, @NonNull Supplier<T> supplierNew, @NonNull Consumer<T> consumer) {
        if (supplierOld == null) {
            throw new NullPointerException("supplierOld is marked non-null but is null");
        }
        if (supplierNew == null) {
            throw new NullPointerException("supplierNew is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        T valueOld = supplierOld.get();
        T valueNew = supplierNew.get();
        if (valueOld instanceof BigDecimal && valueNew instanceof BigDecimal) {
            BigDecimal valueOldBD = (BigDecimal)valueOld;
            BigDecimal valueNewBD = (BigDecimal)valueNew;
            if (valueOldBD.compareTo(valueNewBD) != 0) {
                consumer.accept(supplierNew.get());
                return true;
            }
            return false;
        }
        if (valueOld instanceof String && (valueNew instanceof String || null == valueNew)) {
            String valueNewStr;
            String valueOldStr = StringUtils.trimToEmpty((String)((String)valueOld));
            if (!StringUtils.equals((CharSequence)valueOldStr, (CharSequence)(valueNewStr = StringUtils.trimToEmpty((String)((String)valueNew))))) {
                consumer.accept(supplierNew.get());
                return true;
            }
            return false;
        }
        if (!Objects.equals(valueOld, valueNew)) {
            consumer.accept(supplierNew.get());
            return true;
        }
        return false;
    }

    public static <T> void apply(@NonNull Supplier<T> supplier, @NonNull Consumer<T> consumer) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        consumer.accept(supplier.get());
    }

    public static <T> void apply(@NonNull Supplier<T> supplier, @NonNull Consumer<T> consumer, @NonNull T valueOnNull) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        if (valueOnNull == null) {
            throw new NullPointerException("valueOnNull is marked non-null but is null");
        }
        T t = supplier.get();
        T safe = null == t ? valueOnNull : t;
        consumer.accept(safe);
    }
}

