/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.job;

import de.qfm.erp.service.service.route.StagePropagationRoute;
import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class StagePropagationJob {
    private static final Logger log = LogManager.getLogger(StagePropagationJob.class);
    private final StagePropagationRoute route;

    @Scheduled(initialDelayString="${scheduler.stage.propagation.ms}", fixedDelayString="${scheduler.stage.propagation.ms}")
    @Transactional(readOnly=false)
    public boolean trigger() {
        log.debug("Triggering Stage Propagation");
        Optional stagePropagationCommon = this.route.processNext();
        return true;
    }

    @Scheduled(cron="${scheduler.heartbeat.cron}")
    public void schedulerHeartbeat() {
        log.info("Stage Propagation Heartbeat at {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
    }

    public StagePropagationJob(StagePropagationRoute route) {
        this.route = route;
    }
}

