/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.job;

import com.google.common.base.Stopwatch;
import de.qfm.erp.service.service.route.QueueRoute;
import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class QueueProcessingJob {
    private static final Logger log = LogManager.getLogger(QueueProcessingJob.class);
    private final QueueRoute queueRoute;

    @Scheduled(initialDelayString="${scheduler.queue.processing.ms}", fixedDelayString="${scheduler.queue.processing.ms}")
    @Transactional(readOnly=false)
    public void trigger() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this.queueRoute.processNextItem();
        long timeTakenInMS = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
        log.debug("Queue Item Processed in {} msec", (Object)timeTakenInMS);
    }

    @Scheduled(cron="${scheduler.heartbeat.cron}")
    public void schedulerHeartbeat() {
        log.info("Queue Processing Heartbeat at {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
    }

    public QueueProcessingJob(QueueRoute queueRoute) {
        this.queueRoute = queueRoute;
    }
}

