/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.job;

import de.qfm.erp.service.service.route.SharepointRoute;
import java.sql.Date;
import java.time.Clock;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.transaction.annotation.Transactional;

public class DirtySharepointSyncRefreshJob {
    private static final Logger log = LogManager.getLogger(DirtySharepointSyncRefreshJob.class);
    private final SharepointRoute sharepointRoute;

    @Scheduled(initialDelayString="5000", fixedDelayString="1000")
    @Transactional(readOnly=false)
    public boolean triggerCustomer() {
        log.debug("Triggering Dirty Sharepoint Customer Sync");
        return this.sharepointRoute.processNextCustomer();
    }

    @Scheduled(cron="${scheduler.heartbeat.cron}")
    public void schedulerHeartbeat() {
        log.info("Sharepoint Sync Heartbeat at {}", (Object)Date.from(Instant.now(Clock.systemUTC())));
    }

    public DirtySharepointSyncRefreshJob(SharepointRoute sharepointRoute) {
        this.sharepointRoute = sharepointRoute;
    }
}

