/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.history;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.HistoryHelper;
import de.qfm.erp.service.model.internal.history.EStageHistoryField;
import de.qfm.erp.service.model.internal.history.HistoryField;
import de.qfm.erp.service.model.internal.history.StageHistorySnapShot;
import de.qfm.erp.service.model.internal.snapshot.StageSnapShotDifference;
import de.qfm.erp.service.model.jpa.customer.Address;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.history.HistoryItem;
import de.qfm.erp.service.model.jpa.history.type.EEntityClass;
import de.qfm.erp.service.model.jpa.history.type.EHistoryEntityAction;
import de.qfm.erp.service.model.jpa.history.type.EHistoryOperation;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.history.HistoryPreparer;
import de.qfm.erp.service.service.service.MessageService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class StageHistoryPreparer
extends HistoryPreparer<Quotation, StageHistorySnapShot> {
    private final EntityFactory entityFactory;
    private final MessageService messageService;

    @Nonnull
    public StageHistorySnapShot snapShot(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        LinkedHashMap historyState = Maps.newLinkedHashMap();
        historyState.put(EStageHistoryField.STAGE__Q_NUMBER, stage.getQNumber());
        historyState.put(EStageHistoryField.STAGE__ALIAS, stage.getAlias());
        historyState.put(EStageHistoryField.STAGE__ORDER_VALUE, stage.getOrderValue());
        historyState.put(EStageHistoryField.STAGE__ORDER_VALUE_ESTIMATE, stage.getOrderValueEstimate());
        historyState.put(EStageHistoryField.STAGE__BUDGET_OVERDRAFT_PERCENT, stage.getBudgetAllowedOverdraftPercent());
        historyState.put(EStageHistoryField.STAGE__BUDGET_OVERDRAFT_VALUE, stage.getBudgetAllowedOverdraftValue());
        historyState.put(EStageHistoryField.STAGE__ORDER_VALUE_WITH_DISCOUNT, stage.getOrderValueWithDiscount());
        historyState.put(EStageHistoryField.STAGE__GENERAL_DISCOUNT, stage.getGeneralDiscount());
        historyState.put(EStageHistoryField.STAGE__MATERIAL_PERCENTAGE_MIN, stage.getMaterialPercentageMin());
        historyState.put(EStageHistoryField.STAGE__MATERIAL_PERCENTAGE_STANDARD, stage.getMaterialPercentageStandard());
        historyState.put(EStageHistoryField.STAGE__WAGE_PERCENTAGE_MIN, stage.getWagePercentageMin());
        historyState.put(EStageHistoryField.STAGE__WAGE_PERCENTAGE_STANDARD, stage.getWagePercentageStandard());
        historyState.put(EStageHistoryField.STAGE__QUOTATION_DATE, stage.getQuotationDate());
        historyState.put(EStageHistoryField.STAGE__QUOTATION_OPENING_DATE, stage.getQuotationOpeningDate());
        historyState.put(EStageHistoryField.STAGE__INQUIRY_DATE, stage.getInquiryDate());
        historyState.put(EStageHistoryField.STAGE__PROCUREMENT_NUMBER, stage.getProcurementNumber());
        historyState.put(EStageHistoryField.STAGE__SUBMISSION_DATE_TIME, stage.getSubmissionDateTime());
        historyState.put(EStageHistoryField.STAGE__FLAG_WITHOUT_SUBMISSION_DEADLINE, stage.getFlagWithoutSubmissionDeadline());
        historyState.put(EStageHistoryField.STAGE__PLANNED_SUBMISSION_DATE, stage.getPlannedSubmissionDate());
        historyState.put(EStageHistoryField.STAGE__SUBMISSION_OF_BID_DATE, stage.getSubmissionOfBidDate());
        historyState.put(EStageHistoryField.STAGE__PLACEMENT_OF_ORDER_DUTY_DATE, stage.getPlacementOfOrderDutyDate());
        historyState.put(EStageHistoryField.STAGE__BINDING_PERIOD_DATE, stage.getBindingPeriodDate());
        historyState.put(EStageHistoryField.STAGE__COMMISSION_TYPE, stage.getCommissionType());
        historyState.put(EStageHistoryField.STAGE__INQUIRY_TYPE, stage.getInquiryType());
        historyState.put(EStageHistoryField.STAGE__INQUIRY_RECEIVE_TYPE, stage.getInquiryReceiveType());
        historyState.put(EStageHistoryField.STAGE__QUOTATION_SUBMISSION_TYPE, stage.getQuotationSubmissionType());
        historyState.put(EStageHistoryField.STAGE__COMMISSION_DATE, stage.getCommissionDate());
        historyState.put(EStageHistoryField.STAGE__ORDER_NUMBER, stage.getOrderNumber());
        historyState.put(EStageHistoryField.STAGE__PROJECT_EXECUTION_START_DATE, stage.getProjectExecutionStartDate());
        historyState.put(EStageHistoryField.STAGE__PROJECT_EXECUTION_END_DATE, stage.getProjectExecutionEndDate());
        historyState.put(EStageHistoryField.STAGE__HEADLINE_G1, stage.getHeadlineG1());
        historyState.put(EStageHistoryField.STAGE__HEADLINE_G2, stage.getHeadlineG2());
        historyState.put(EStageHistoryField.STAGE__HEADLINE_G3, stage.getHeadlineG3());
        historyState.put(EStageHistoryField.STAGE__HEADLINE_G4, stage.getHeadlineG4());
        historyState.put(EStageHistoryField.STAGE__FLAG_MEASUREMENT_WITHOUT_COMMISSION_NUMBER_ALLOWED, stage.getFlagMeasurementWithoutCommissionNumberAllowed());
        historyState.put(EStageHistoryField.STAGE__FLAG_DISCOUNT_FEE_POSITIONS, stage.getFlagDiscountFeePositions());
        historyState.put(EStageHistoryField.STAGE__FLAG_B2B, stage.getFlagB2B());
        historyState.put(EStageHistoryField.STAGE__ORDER_DESCRIPTION_CUSTOMER, stage.getOrderDescriptionCustomer());
        historyState.put(EStageHistoryField.STAGE__ORDER_DESCRIPTION_INTERNAL, stage.getOrderDescriptionInternal());
        historyState.put(EStageHistoryField.STAGE__FINANCE_TIME_FOR_PAYMENT, stage.getFinanceTimeForPayment());
        historyState.put(EStageHistoryField.STAGE__FINANCE_CASH_DISCOUNT_TIME1, stage.getFinanceCashDiscountTime1());
        historyState.put(EStageHistoryField.STAGE__FINANCE_CASH_DISCOUNT1, stage.getFinanceCashDiscount1());
        historyState.put(EStageHistoryField.STAGE__FINANCE_CASH_DISCOUNT_TIME2, stage.getFinanceCashDiscountTime2());
        historyState.put(EStageHistoryField.STAGE__FINANCE_CASH_DISCOUNT2, stage.getFinanceCashDiscount2());
        historyState.put(EStageHistoryField.STAGE__FINANCE_VAT, stage.getVatPercent());
        historyState.put(EStageHistoryField.STAGE__FINANCE_DEFAULT_INVOICE_TYPE, stage.getFinanceDefaultInvoiceType());
        historyState.put(EStageHistoryField.STAGE__FINANCE_FLAG_SUBCONTRACTOR, stage.getFinanceFlagSubcontractor());
        historyState.put(EStageHistoryField.STAGE__FINANCE_ROUTING_REFERENCE_ID, stage.getFinanceRoutingReferenceId());
        historyState.put(EStageHistoryField.STAGE__PDF_EXTRACTOR_TYPE, stage.getPdfExtractType());
        historyState.put(EStageHistoryField.STAGE__STAGE_TYPE, stage.getStageType());
        historyState.put(EStageHistoryField.STAGE__STAGE_STATE, stage.getStageState());
        historyState.put(EStageHistoryField.STAGE__ARCHIVE_REASON, stage.getArchiveReason());
        historyState.put(EStageHistoryField.STAGE__PRICE_WITHOUT_DISCOUNT_SUM, stage.getPriceWithoutDiscountSum());
        historyState.put(EStageHistoryField.STAGE__PRICE_WITH_DISCOUNT_SUM, stage.getPriceWithDiscountSum());
        historyState.put(EStageHistoryField.STAGE__SQUAD_WAGE_SUM, stage.getSquadWageSum());
        historyState.put(EStageHistoryField.STAGE__COMPANY_WAGE_SUM, stage.getCompanyWageSum());
        historyState.put(EStageHistoryField.STAGE__MATERIAL_PURCHASE_PRICE_SUM, stage.getMaterialPurchasePriceSum());
        historyState.put(EStageHistoryField.STAGE__MATERIAL_SELLING_PRICE_SUM, stage.getMaterialSellingPriceSum());
        historyState.put(EStageHistoryField.STAGE__EXTERNAL_SERVICE_PURCHASE_PRICE_SUM, stage.getExternalServicePurchasePriceSum());
        historyState.put(EStageHistoryField.STAGE__EXTERNAL_SERVICE_SELLING_PRICE_SUM, stage.getExternalServiceSellingPriceSum());
        historyState.put(EStageHistoryField.STAGE__WAGE_PERCENTAGE_WEIGHTED_AVERAGE, stage.getWagePercentageWeightedAverage());
        historyState.put(EStageHistoryField.STAGE__MATERIAL_PERCENTAGE_WEIGHTED_AVERAGE, stage.getMaterialPercentageWeightedAverage());
        historyState.put(EStageHistoryField.STAGE__EXTERNAL_SERVICE_PERCENTAGE_WEIGHTED_AVERAGE, stage.getExternalServicePercentageWeightedAverage());
        historyState.put(EStageHistoryField.STAGE__VAT_VALUE_WITHOUT_DISCOUNT_SUM, stage.getVatValueWithoutDiscountSum());
        historyState.put(EStageHistoryField.STAGE__VAT_VALUE_WITH_DISCOUNT_SUM, stage.getVatValueWithDiscountSum());
        historyState.put(EStageHistoryField.STAGE__PRICE_GROSS_WITHOUT_DISCOUNT_SUM, stage.getPriceGrossWithoutDiscountSum());
        historyState.put(EStageHistoryField.STAGE__PRICE_GROSS_WITH_DISCOUNT_SUM, stage.getPriceGrossWithDiscountSum());
        Customer customer = stage.getCustomer();
        Map customerSnapshot = this.customer(customer, EStageHistoryField.STAGE__CUSTOMER_TEXT);
        Address address = stage.getAddress();
        Map addressSnapshot = this.address(address, EStageHistoryField.STAGE__ADDRESS_TEXT);
        Customer customerInvoice = stage.getCustomerInvoice();
        Map customerInvoiceSnapshot = this.customer(customerInvoice, EStageHistoryField.STAGE__CUSTOMER_INVOICE_TEXT);
        Address customerInvoiceAddress = stage.getCustomerInvoiceAddress();
        Map customerInvoiceAddressSnapshot = this.address(customerInvoiceAddress, EStageHistoryField.STAGE__INVOICE_ADDRESS_TEXT);
        ContactPerson contactPerson = stage.getContactPerson();
        Map contactPersonSnapshot = this.contactPerson(contactPerson, EStageHistoryField.STAGE__CONTACT_PERSON_TEXT);
        TaxKey financeTaxKey = stage.getFinanceTaxKey();
        Map financeTaxKeySnapshot = this.taxKey(financeTaxKey);
        Set stageNotifyUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageNotifyUsers(), (Object)ImmutableSet.of());
        Set stageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageResponsibleUsers(), (Object)ImmutableSet.of());
        Set stageSignatureUsers = (Set)MoreObjects.firstNonNull((Object)stage.getStageSignatureUsers(), (Object)ImmutableSet.of());
        Set positions = (Set)MoreObjects.firstNonNull((Object)stage.getQuotationPositions(), (Object)ImmutableSet.of());
        Map positionsState = this.positions((Iterable)positions);
        return StageHistorySnapShot.of((Map)historyState, (Map)positionsState);
    }

    @Nonnull
    private Map<EStageHistoryField, Object> taxKey(@Nullable TaxKey financeTaxKey) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (null != financeTaxKey) {
            builder.put((Object)EStageHistoryField.STAGE__FINANCE_TAX_KEY_NAME, (Object)financeTaxKey.getName());
            builder.put((Object)EStageHistoryField.STAGE__FINANCE_TAX_KEY_VALUE, (Object)financeTaxKey.getTaxKey());
            builder.put((Object)EStageHistoryField.STAGE__FINANCE_TAX_KEY_VAT, (Object)financeTaxKey.getVat());
        }
        return builder.build();
    }

    @Nonnull
    private Map<EStageHistoryField, Object> contactPerson(@Nullable ContactPerson contactPerson, @NonNull EStageHistoryField textField) {
        if (textField == null) {
            throw new NullPointerException("textField is marked non-null but is null");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (null != contactPerson) {
            String text = String.format("%s %s", contactPerson.getFirstName(), contactPerson.getLastName());
            builder.put((Object)textField, (Object)text);
        }
        return builder.build();
    }

    @Nonnull
    private Map<EStageHistoryField, Object> address(@Nullable Address address, @NonNull EStageHistoryField textField) {
        if (textField == null) {
            throw new NullPointerException("textField is marked non-null but is null");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (null != address) {
            String text = String.format("%s %s %s", address.getStreet(), address.getStreetNo(), address.getZipCode());
            builder.put((Object)textField, (Object)text);
        }
        return builder.build();
    }

    @Nonnull
    private Map<EStageHistoryField, Object> customer(@Nullable Customer customer, @NonNull EStageHistoryField textField) {
        if (textField == null) {
            throw new NullPointerException("textField is marked non-null but is null");
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (null != customer) {
            builder.put((Object)textField, (Object)customer.getName());
        }
        return builder.build();
    }

    @Nonnull
    public List<HistoryItem> difference(@NonNull StageHistorySnapShot snapshotPrevious, @NonNull Quotation stage) {
        if (snapshotPrevious == null) {
            throw new NullPointerException("snapshotPrevious is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        StageHistorySnapShot snapshotCurrent = this.snapShot(stage);
        Map statePrevious = snapshotPrevious.getStageState();
        Map stateCurrent = snapshotCurrent.getStageState();
        Long stageId = stage.getId();
        ImmutableList.Builder historyItemBuilder = ImmutableList.builder();
        Iterable headDifference = this.snapShotDifferences(statePrevious, stateCurrent);
        historyItemBuilder.addAll(this.historyItems(stageId, "", "", headDifference));
        Map positionsStatePrevious = snapshotPrevious.getPositionsState();
        Map positionsStateCurrent = snapshotCurrent.getPositionsState();
        Sets.SetView allIDs = Sets.union(positionsStatePrevious.keySet(), positionsStateCurrent.keySet());
        for (Long id : allIDs) {
            String details = Long.toString(id);
            Map positionStatePrevious = (Map)positionsStatePrevious.getOrDefault(id, ImmutableMap.of());
            Map positionStateCurrent = (Map)positionsStateCurrent.getOrDefault(id, ImmutableMap.of());
            String previousSPN = StringUtils.trimToEmpty((String)positionStatePrevious.getOrDefault(EStageHistoryField.STAGE__POSITION__SPN, ""));
            String previousShortText = StringUtils.trimToEmpty((String)positionStatePrevious.getOrDefault(EStageHistoryField.STAGE__POSITION__SHORT_TEXT, ""));
            String currentSPN = StringUtils.trimToEmpty((String)positionStateCurrent.getOrDefault(EStageHistoryField.STAGE__POSITION__SPN, ""));
            String currentShortText = StringUtils.trimToEmpty((String)positionStateCurrent.getOrDefault(EStageHistoryField.STAGE__POSITION__SHORT_TEXT, ""));
            boolean hasPreviousId = positionsStatePrevious.containsKey(id);
            boolean hasCurrentId = positionsStateCurrent.containsKey(id);
            String previousText = String.format("%s: %s", previousSPN, previousShortText);
            String currentText = String.format("%s: %s", currentSPN, currentShortText);
            if (!hasPreviousId && hasCurrentId) {
                historyItemBuilder.add((Object)this.historyItem(stageId, EHistoryOperation.NOTE, EHistoryEntityAction.STAGE_POSITION__CREATE, currentText, EStageHistoryField.NOTE, "", currentText, currentSPN));
            } else if (hasPreviousId && !hasCurrentId) {
                historyItemBuilder.add((Object)this.historyItem(stageId, EHistoryOperation.NOTE, EHistoryEntityAction.STAGE_POSITION__DELETE, previousText, EStageHistoryField.NOTE, previousText, "", currentSPN));
            }
            Iterable positionDifference = this.snapShotDifferences(positionStatePrevious, positionStateCurrent);
            historyItemBuilder.addAll(this.historyItems(stageId, details, currentSPN, positionDifference));
        }
        return historyItemBuilder.build();
    }

    @Nonnull
    private Map<Long, Map<EStageHistoryField, Object>> positions(@NonNull Iterable<QuotationPosition> positions) {
        if (positions == null) {
            throw new NullPointerException("positions is marked non-null but is null");
        }
        LinkedHashMap positionsState = Maps.newLinkedHashMap();
        positions.forEach(position -> positionsState.put(position.getId(), this.positionState(position)));
        return positionsState;
    }

    @Nonnull
    private Map<EStageHistoryField, Object> positionState(@NonNull QuotationPosition position) {
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        LinkedHashMap positionState = Maps.newLinkedHashMap();
        positionState.put(EStageHistoryField.STAGE__POSITION__G1, position.getGroupingElementLevel1());
        positionState.put(EStageHistoryField.STAGE__POSITION__G2, position.getGroupingElementLevel2());
        positionState.put(EStageHistoryField.STAGE__POSITION__G3, position.getGroupingElementLevel3());
        positionState.put(EStageHistoryField.STAGE__POSITION__G4, position.getGroupingElementLevel4());
        positionState.put(EStageHistoryField.STAGE__POSITION__POSNR, position.getPositionNumber());
        positionState.put(EStageHistoryField.STAGE__POSITION__ALT, position.getAlternativePositionType());
        positionState.put(EStageHistoryField.STAGE__POSITION__SPN, position.getSurrogatePositionNumber());
        positionState.put(EStageHistoryField.STAGE__POSITION__ORDERED_AMOUNT, position.getOrderedAmount());
        positionState.put(EStageHistoryField.STAGE__POSITION__SHORT_TEXT, position.getShortText());
        positionState.put(EStageHistoryField.STAGE__POSITION__LONG_TEXT, position.getLongText());
        positionState.put(EStageHistoryField.STAGE__POSITION__MATERIAL_PP_PU, position.getMaterialWholesalePriceIncludingDiscountPerItem());
        positionState.put(EStageHistoryField.STAGE__POSITION__MATERIAL_PP_AGG, position.getMaterialWholesalePriceIncludingDiscountAggregated());
        positionState.put(EStageHistoryField.STAGE__POSITION__MATERIAL_PERCENTAGE, position.getMaterialPercentage());
        positionState.put(EStageHistoryField.STAGE__POSITION__MATERIAL_SP_PU, position.getMaterialSellingPricePerUnit());
        positionState.put(EStageHistoryField.STAGE__POSITION__MATERIAL_SP_AGG, position.getMaterialSellingPriceAggregated());
        positionState.put(EStageHistoryField.STAGE__POSITION__WAGE_PU, position.getSquadWagePerUnit());
        positionState.put(EStageHistoryField.STAGE__POSITION__WAGE_AGG, position.getSquadWageAggregated());
        positionState.put(EStageHistoryField.STAGE__POSITION__WAGE_FACTOR, position.getWagePercentage());
        positionState.put(EStageHistoryField.STAGE__POSITION__COMPANY_WAGE_PU, position.getCompanyWagePerItem());
        positionState.put(EStageHistoryField.STAGE__POSITION__COMPANY_WAGE_AGG, position.getCompanyWageAggregated());
        positionState.put(EStageHistoryField.STAGE__POSITION__ES_PP_PU, position.getExternalServicePurchasePricePerUnit());
        positionState.put(EStageHistoryField.STAGE__POSITION__ES_PP_AGG, position.getExternalServicePurchasePriceAggregated());
        positionState.put(EStageHistoryField.STAGE__POSITION__ES_SURPLUS, position.getExternalServicePercentage());
        positionState.put(EStageHistoryField.STAGE__POSITION__ES_SP_PU, position.getExternalServiceSellingPricePerUnit());
        positionState.put(EStageHistoryField.STAGE__POSITION__ES_SP_AGG, position.getExternalServiceSellingPriceAggregated());
        positionState.put(EStageHistoryField.STAGE__POSITION__PRICE_PU, position.getPricePerUnit());
        positionState.put(EStageHistoryField.STAGE__POSITION__PRICE_AGG, position.getPriceAggregated());
        positionState.put(EStageHistoryField.STAGE__POSITION__FEE_POSITION, position.getFlagFeePosition());
        positionState.put(EStageHistoryField.STAGE__POSITION__REMARKS, position.getRemarks());
        positionState.put(EStageHistoryField.STAGE__POSITION__BIDDER_COMPLEMENT, position.getBidderComplement());
        positionState.put(EStageHistoryField.STAGE__POSITION__EXTERNAL_POSITION_NUMBER, position.getPositionNumberExternal());
        return positionState;
    }

    @Nonnull
    private Iterable<HistoryItem> historyItems(@NonNull Long entityId, @NonNull String details, @NonNull String referenceClearText, @NonNull Iterable<StageSnapShotDifference> differences) {
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (details == null) {
            throw new NullPointerException("details is marked non-null but is null");
        }
        if (referenceClearText == null) {
            throw new NullPointerException("referenceClearText is marked non-null but is null");
        }
        if (differences == null) {
            throw new NullPointerException("differences is marked non-null but is null");
        }
        return (Iterable)Streams.stream(differences).map(item -> this.historyItem(entityId, item.getOperation(), EHistoryEntityAction.NONE, details, item.getField(), item.getValueOldS(), item.getValueNewS(), referenceClearText)).collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    public HistoryItem historyItem(@NonNull Long entityId, @NonNull EHistoryOperation operation, @NonNull EHistoryEntityAction entityOperation, @NonNull String details, @NonNull EStageHistoryField field, @NonNull String valueOldS, @NonNull String valueNewS, @NonNull String referenceClearText) {
        if (entityId == null) {
            throw new NullPointerException("entityId is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (entityOperation == null) {
            throw new NullPointerException("entityOperation is marked non-null but is null");
        }
        if (details == null) {
            throw new NullPointerException("details is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (valueOldS == null) {
            throw new NullPointerException("valueOldS is marked non-null but is null");
        }
        if (valueNewS == null) {
            throw new NullPointerException("valueNewS is marked non-null but is null");
        }
        if (referenceClearText == null) {
            throw new NullPointerException("referenceClearText is marked non-null but is null");
        }
        HistoryItem historyItem = this.entityFactory.historyItem();
        historyItem.setEntityClass(EEntityClass.STAGE);
        historyItem.setEntityId(entityId);
        historyItem.setOperation(operation);
        historyItem.setEntityAction(entityOperation);
        historyItem.setField(HistoryHelper.fieldName((HistoryField)field));
        historyItem.setDetails(StringUtils.left((String)details, (int)250));
        historyItem.setValueOld(StringUtils.left((String)valueOldS, (int)250));
        historyItem.setValueNew(StringUtils.left((String)valueNewS, (int)250));
        historyItem.setReferenceClearText(StringUtils.left((String)referenceClearText, (int)250));
        return historyItem;
    }

    @Nonnull
    public Iterable<StageSnapShotDifference> snapShotDifferences(@NonNull Map<EStageHistoryField, Object> statePrevious, @NonNull Map<EStageHistoryField, Object> stateCurrent) {
        if (statePrevious == null) {
            throw new NullPointerException("statePrevious is marked non-null but is null");
        }
        if (stateCurrent == null) {
            throw new NullPointerException("stateCurrent is marked non-null but is null");
        }
        ImmutableList.Builder historyItemBuilder = ImmutableList.builder();
        MapDifference difference = Maps.difference(statePrevious, stateCurrent);
        Map differenceRemoved = difference.entriesOnlyOnLeft();
        differenceRemoved.forEach((field, value) -> {
            String valueOld = StringUtils.trimToEmpty((String)MoreObjects.firstNonNull((Object)value, (Object)"").toString());
            this.stageSnapShotDifference(EHistoryOperation.DELETE, field, (Object)valueOld, (Object)"").ifPresent(arg_0 -> ((ImmutableList.Builder)historyItemBuilder).add(arg_0));
        });
        Map differenceAdded = difference.entriesOnlyOnRight();
        differenceAdded.forEach((field, value) -> {
            String valueNew = StringUtils.trimToEmpty((String)MoreObjects.firstNonNull((Object)value, (Object)"").toString());
            this.stageSnapShotDifference(EHistoryOperation.CREATE, field, (Object)"", (Object)valueNew).ifPresent(arg_0 -> ((ImmutableList.Builder)historyItemBuilder).add(arg_0));
        });
        Map differenceUpdated = difference.entriesDiffering();
        differenceUpdated.forEach((field, value) -> {
            Object valueOld = value.leftValue();
            Object valueNew = value.rightValue();
            this.stageSnapShotDifference(EHistoryOperation.UPDATE, field, valueOld, valueNew).ifPresent(arg_0 -> ((ImmutableList.Builder)historyItemBuilder).add(arg_0));
        });
        return historyItemBuilder.build();
    }

    @Nonnull
    private Optional<StageSnapShotDifference> stageSnapShotDifference(@NonNull EHistoryOperation operation, @NonNull EStageHistoryField field, @Nullable Object valueOld, @Nullable Object valueNew) {
        String valueNewS;
        String valueOldS;
        boolean isEqual;
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (Iterables.contains((Iterable)EStageHistoryField.FIELDS_NOT_PERSISTED_IN_HISTORY, (Object)field)) {
            return Optional.empty();
        }
        if (valueOld instanceof BigDecimal && valueNew instanceof BigDecimal) {
            BigDecimal valueOldBD = (BigDecimal)valueOld;
            BigDecimal valueNewBD = (BigDecimal)valueNew;
            isEqual = valueOldBD.compareTo(valueNewBD) == 0;
            valueOldS = BigDecimalHelper.asString((BigDecimal)valueOldBD);
            valueNewS = BigDecimalHelper.asString((BigDecimal)valueNewBD);
        } else if (valueOld instanceof LocalDate && valueNew instanceof LocalDate) {
            LocalDate valueOldLD = (LocalDate)valueOld;
            LocalDate valueNewLD = (LocalDate)valueNew;
            isEqual = valueOldLD.isEqual(valueNewLD);
            valueOldS = DateTimeHelper.toIsoDate((LocalDate)valueOldLD);
            valueNewS = DateTimeHelper.toIsoDate((LocalDate)valueNewLD);
        } else if (valueOld instanceof LocalDateTime && valueNew instanceof LocalDateTime) {
            LocalDateTime valueOldLDT = (LocalDateTime)valueOld;
            LocalDateTime valueNewLDT = (LocalDateTime)valueNew;
            isEqual = valueOldLDT.isEqual(valueNewLDT);
            valueOldS = DateTimeHelper.toIsoDateTime((LocalDateTime)valueOldLDT);
            valueNewS = DateTimeHelper.toIsoDateTime((LocalDateTime)valueNewLDT);
        } else {
            valueOldS = StringUtils.trimToEmpty((String)MoreObjects.firstNonNull((Object)valueOld, (Object)"").toString());
            valueNewS = StringUtils.trimToEmpty((String)MoreObjects.firstNonNull((Object)valueNew, (Object)"").toString());
            isEqual = StringUtils.equalsIgnoreCase((CharSequence)valueOldS, (CharSequence)valueNewS);
        }
        if (!isEqual) {
            StageSnapShotDifference stageSnapShotDifference = StageSnapShotDifference.of((EHistoryOperation)operation, (EStageHistoryField)field, (Object)valueOld, (Object)valueNew, (String)valueOldS, (String)valueNewS);
            return Optional.of(stageSnapShotDifference);
        }
        return Optional.empty();
    }

    public StageHistoryPreparer(EntityFactory entityFactory, MessageService messageService) {
        this.entityFactory = entityFactory;
        this.messageService = messageService;
    }
}

