/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler.impl;

import de.qfm.erp.service.model.jpa.profile.UserSetting;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.UserConfigurationRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import de.qfm.erp.service.service.handler.UserSettingHandler;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class UserSettingHandlerImpl
extends BaseHandler<UserSetting>
implements UserSettingHandler {
    private final UserConfigurationRepository repository;

    @Autowired
    public UserSettingHandlerImpl(@NonNull StandardPersistenceHelper standardPersistenceHelper, @NonNull UserConfigurationRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        if (standardPersistenceHelper == null) {
            throw new NullPointerException("standardPersistenceHelper is marked non-null but is null");
        }
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        this.repository = repository;
    }

    protected Class<UserSetting> clazz() {
        return UserSetting.class;
    }

    @Nonnull
    protected UserSetting beforeUpdate(@NonNull UserSetting item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected UserSetting beforeDelete(@NonNull UserSetting item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected UserSetting afterUpdate(@NonNull UserSetting item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected UserSetting afterDelete(@NonNull UserSetting item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<UserSetting> allForUser(@NonNull User user) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        return this.repository.findAllByUser(user);
    }

    @Nonnull
    public Optional<UserSetting> byKeyNotFailing(@NonNull User user, @NonNull String key) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        return this.repository.findByUserAndKey(user, key);
    }
}

