/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler.impl;

import de.qfm.erp.service.repository.MeasurementRepository;
import de.qfm.erp.service.repository.QuotationRepository;
import de.qfm.erp.service.service.handler.PersonAutoCompleteHandler;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PersonAutoCompleteHandlerImpl
implements PersonAutoCompleteHandler {
    private static final Logger log = LogManager.getLogger(PersonAutoCompleteHandlerImpl.class);
    private final MeasurementRepository measurementRepository;
    private final QuotationRepository quotationRepository;

    @Nonnull
    public List<String> quotationContactPerson(long quotationId, @NonNull String filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return this.quotationRepository.personAutoComplete(quotationId, StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)filter)));
    }

    @Nonnull
    public List<String> personResponsibleAtClientInMeasurementWithQuotation(long quotationId, @NonNull String filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return this.measurementRepository.personAutoComplete(quotationId, StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)filter)));
    }

    public PersonAutoCompleteHandlerImpl(MeasurementRepository measurementRepository, QuotationRepository quotationRepository) {
        this.measurementRepository = measurementRepository;
        this.quotationRepository = quotationRepository;
    }
}

