/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler.impl;

import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.repository.BusinessUnitRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.BusinessUnitHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class BusinessUnitHandlerImpl
extends BaseHandler<BusinessUnit>
implements BusinessUnitHandler {
    private static final Logger log = LogManager.getLogger(BusinessUnitHandlerImpl.class);
    private final BusinessUnitRepository repository;

    @Autowired
    public BusinessUnitHandlerImpl(@NonNull StandardPersistenceHelper standardPersistenceHelper, @NonNull BusinessUnitRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        if (standardPersistenceHelper == null) {
            throw new NullPointerException("standardPersistenceHelper is marked non-null but is null");
        }
        if (repository == null) {
            throw new NullPointerException("repository is marked non-null but is null");
        }
        this.repository = repository;
    }

    @Nonnull
    protected Class<BusinessUnit> clazz() {
        return BusinessUnit.class;
    }

    @Nonnull
    protected BusinessUnit beforeUpdate(@NonNull BusinessUnit item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BusinessUnit beforeDelete(@NonNull BusinessUnit item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BusinessUnit afterUpdate(@NonNull BusinessUnit item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BusinessUnit afterDelete(@NonNull BusinessUnit item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<BusinessUnit> findAll(boolean includeDeleted) {
        if (includeDeleted) {
            return this.repository.findAllIncludeDeleted();
        }
        return this.repository.findAllExcludeDeleted();
    }

    @Nonnull
    public BusinessUnit root() {
        Optional parentCandidate = this.repository.findRoot();
        if (parentCandidate.isEmpty()) {
            throw ResourceNotFoundException.of((String)BusinessUnit.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.BUSINESS_UNIT__PARENT_ID), (String)"<null>");
        }
        return (BusinessUnit)parentCandidate.get();
    }
}

