/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.repository.TaxKeyRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.math.BigDecimal;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class TaxKeyHandler
extends BaseHandler<TaxKey> {
    private static final Logger log = LogManager.getLogger(TaxKeyHandler.class);
    private final TaxKeyRepository repository;

    @Autowired
    public TaxKeyHandler(StandardPersistenceHelper standardPersistenceHelper, TaxKeyRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<TaxKey> clazz() {
        return TaxKey.class;
    }

    @Nonnull
    protected TaxKey beforeUpdate(@NonNull TaxKey item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected TaxKey beforeDelete(@NonNull TaxKey item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected TaxKey afterUpdate(@NonNull TaxKey item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected TaxKey afterDelete(@NonNull TaxKey item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Page<TaxKey> page(int page, int size, @NonNull EInvoiceType invoiceType, boolean flagSubContractorAsExternalServiceAccounting, boolean flagCompanyGroup) {
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        return this.repository.findAllByInvoiceTypeAndFlagsOrderById((Pageable)PageRequest.of((int)page, (int)size), invoiceType, flagSubContractorAsExternalServiceAccounting, flagCompanyGroup);
    }

    @Nonnull
    public Optional<TaxKey> byInvoiceTypeAndVAT(@NonNull EInvoiceType supposedInvoiceType, BigDecimal vat, boolean flagSubContractorAsExternalServiceAccounting, boolean flagCompanyGroup) {
        if (supposedInvoiceType == null) {
            throw new NullPointerException("supposedInvoiceType is marked non-null but is null");
        }
        return this.repository.findFirstByInvoiceTypeAndVat(supposedInvoiceType, vat, flagSubContractorAsExternalServiceAccounting, flagCompanyGroup);
    }

    public void realDelete(@NonNull TaxKey taxKey) {
        if (taxKey == null) {
            throw new NullPointerException("taxKey is marked non-null but is null");
        }
        this.repository.delete((Object)taxKey);
    }
}

