/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.user.Role;
import de.qfm.erp.service.repository.RoleRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class RoleHandler
extends BaseHandler<Role> {
    private static final Logger log = LogManager.getLogger(RoleHandler.class);
    private final RoleRepository repository;

    @Autowired
    public RoleHandler(StandardPersistenceHelper standardPersistenceHelper, RoleRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<Role> clazz() {
        return Role.class;
    }

    @Nonnull
    protected Role beforeUpdate(@NonNull Role item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Role beforeDelete(@NonNull Role item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Role afterUpdate(@NonNull Role item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Role afterDelete(@NonNull Role item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    public boolean anotherRoleWithSameName(@NonNull Role role, @NonNull String name) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Long id = role.getId();
        String safeUserName = StringUtils.lowerCase((String)StringUtils.trimToEmpty((String)name));
        if (null != id) {
            return this.repository.findOneByNameIgnoreCaseAndIdNot(safeUserName, id).isPresent();
        }
        return this.repository.findOneByNameIgnoreCase(safeUserName).isPresent();
    }

    @Nonnull
    public Role byNameFailing(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional entityByName = this.byName(name);
        if (entityByName.isPresent()) {
            return (Role)entityByName.get();
        }
        throw ResourceNotFoundException.of((String)Role.class.getName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ROLE__NAME), (String)name);
    }

    @Nonnull
    public Optional<Role> byName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.repository.findOneByNameIgnoreCase(name);
    }

    @Nonnull
    public Iterable<Role> byIdsFailing(@NonNull Iterable<Long> givenIDs) {
        if (givenIDs == null) {
            throw new NullPointerException("givenIDs is marked non-null but is null");
        }
        List rolesByIds = this.repository.findAllById(givenIDs);
        Iterable foundIDs = IterableHelper.stream((Iterable)rolesByIds).map(Role::getId).collect(Collectors.toSet());
        ImmutableSet difference = Sets.difference((Set)ImmutableSet.copyOf(givenIDs), (Set)ImmutableSet.copyOf((Iterable)foundIDs)).immutableCopy();
        if (!difference.isEmpty()) {
            String idsNotFound = ID_JOINER.join((Iterable)difference);
            throw ResourceNotFoundException.of((String)Role.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsNotFound);
        }
        return ImmutableList.copyOf((Collection)rolesByIds);
    }
}

