/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.security.core.userdetails.User;

public abstract class PersistenceHelper {
    private final AuthenticationHelper authenticationHelper;

    @Nonnull
    public <V extends EntityBase> V deleted(@NonNull V entityBase) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        return (V)this.deleted(entityBase, true);
    }

    @Nonnull
    public <V extends EntityBase> V deleted(@NonNull V entityBase, boolean refreshDeleted) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        if (refreshDeleted) {
            User currentUser = this.authenticationHelper.currentUser();
            String username = currentUser.getUsername();
            entityBase.setDeletedOn(DateTimeHelper.now());
            entityBase.setDeletedBy(username);
        }
        return entityBase;
    }

    @Nonnull
    public <V extends EntityBase> V updated(@NonNull V entityBase) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        return (V)this.updated(entityBase, true);
    }

    @Nonnull
    public <V extends EntityBase> V updated(@NonNull V entityBase, boolean refreshUpdated) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        if (refreshUpdated) {
            User currentUser = this.authenticationHelper.currentUser();
            String username = currentUser.getUsername();
            entityBase.setUpdatedOn(DateTimeHelper.now());
            entityBase.setUpdatedBy(username);
        }
        return entityBase;
    }

    @Nonnull
    public <V extends EntityBase> V created(@NonNull V entityBase) {
        if (entityBase == null) {
            throw new NullPointerException("entityBase is marked non-null but is null");
        }
        User currentUser = this.authenticationHelper.currentUser();
        String username = currentUser.getUsername();
        entityBase.setCreatedBy(username);
        entityBase.setCreatedOn(DateTimeHelper.now());
        return entityBase;
    }

    protected PersistenceHelper(AuthenticationHelper authenticationHelper) {
        this.authenticationHelper = authenticationHelper;
    }
}

