/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.internal.WageMoveBucket;
import de.qfm.erp.service.model.internal.payroll.EPayrollItemClazzFilterOption;
import de.qfm.erp.service.model.internal.payroll.EPayrollItemFilterOption;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemClazz;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.PayrollMonthItemRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class PayrollMonthItemHandler
extends BaseHandler<PayrollMonthItem> {
    private static final Logger log = LogManager.getLogger(PayrollMonthItemHandler.class);
    private final PayrollMonthItemRepository repository;

    @Autowired
    public PayrollMonthItemHandler(StandardPersistenceHelper standardPersistenceHelper, PayrollMonthItemRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<PayrollMonthItem> clazz() {
        return PayrollMonthItem.class;
    }

    @Nonnull
    protected PayrollMonthItem beforeUpdate(@NonNull PayrollMonthItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollMonthItem beforeDelete(@NonNull PayrollMonthItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollMonthItem afterUpdate(@NonNull PayrollMonthItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollMonthItem afterDelete(@NonNull PayrollMonthItem item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<PayrollMonthItem> auxiliaryWagesAssignedToPayroll(@NonNull User user, @NonNull YearMonth accountingMonth, @NonNull Predicate<PayrollMonthItem> fn) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        return (Iterable)Streams.stream((Iterable)this.repository.wagesAssignedToPayroll(EPayrollItemClazz.AUXILIARY_WAGE, accountingMonth.atDay(1), user)).filter(fn).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    public Iterable<PayrollMonthItem> incentiveWagesAssignedToPayroll(@NonNull User user, @NonNull YearMonth accountingMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return this.repository.wagesAssignedToPayroll(EPayrollItemClazz.INCENTIVE_PAYMENT, accountingMonth.atDay(1), user);
    }

    @Nonnull
    public Iterable<PayrollMonthItem> wageAccountAssignedToPayroll(@NonNull User user, @NonNull YearMonth accountingMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return this.repository.wagesAssignedToPayroll(EPayrollItemClazz.WAGE_ACCOUNT, accountingMonth.atDay(1), user);
    }

    @Nonnull
    public Iterable<PayrollMonthItem> routedIncentiveWagesAssignedToPayroll(@NonNull User user, @NonNull YearMonth accountingMonth) {
        if (user == null) {
            throw new NullPointerException("user is marked non-null but is null");
        }
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        return this.repository.routedWagesAssignedToPayroll(EPayrollItemClazz.AUXILIARY_WAGE, accountingMonth.atDay(1), user);
    }

    @Nonnull
    public Iterable<String> quotationNumbersFromPaymentsForSender(@NonNull PayrollMonth payrollMonth) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        User assignedUser = payrollMonth.getUser();
        LocalDate referenceDate = DateTimeHelper.today().minusYears(1L);
        return ImmutableSet.copyOf((Collection)this.repository.quotationNumbersFromPaymentsForSenderBesideMeasurement(assignedUser, referenceDate));
    }

    @Nonnull
    public Page<PayrollMonthItem> payrollMonthItemPage(int page, int size, @NonNull YearMonth accountingMonth, @NonNull Iterable<User> senders, @NonNull Iterable<User> recipients, @NonNull EPayrollItemFilterOption payrollItemFilterOption, @NonNull EPayrollItemClazzFilterOption payrollItemClazzFilterOption) {
        if (accountingMonth == null) {
            throw new NullPointerException("accountingMonth is marked non-null but is null");
        }
        if (senders == null) {
            throw new NullPointerException("senders is marked non-null but is null");
        }
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (payrollItemFilterOption == null) {
            throw new NullPointerException("payrollItemFilterOption is marked non-null but is null");
        }
        if (payrollItemClazzFilterOption == null) {
            throw new NullPointerException("payrollItemClazzFilterOption is marked non-null but is null");
        }
        Specification specification = PayrollMonthItemRepository.filter((YearMonth)accountingMonth, (Collection)((Collection)senders), (Collection)((Collection)recipients), (EPayrollItemFilterOption)payrollItemFilterOption, (EPayrollItemClazzFilterOption)payrollItemClazzFilterOption);
        PageRequest pageRequest = PageRequest.of((int)page, (int)size);
        return this.repository.findAll(Specification.where((Specification)specification), (Pageable)pageRequest);
    }

    public int patchStage(@NonNull WageMoveBucket wageMoveBucket) {
        if (wageMoveBucket == null) {
            throw new NullPointerException("wageMoveBucket is marked non-null but is null");
        }
        Quotation sourceStage = wageMoveBucket.getSourceStage();
        Quotation targetStage = wageMoveBucket.getTargetStage();
        return this.repository.patchStage(sourceStage, targetStage, targetStage.getQuotationNumber());
    }

    @Nonnull
    public Iterable<PayrollMonthItem> allByQuotation(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        return this.repository.findAllByQuotation(quotation);
    }
}

