/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.payroll.PayrollItemTypeFilter;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.repository.PayrollItemTypeRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class PayrollItemTypeHandler
extends BaseHandler<PayrollItemType> {
    private static final Logger log = LogManager.getLogger(PayrollItemTypeHandler.class);
    private final PayrollItemTypeRepository repository;

    @Autowired
    public PayrollItemTypeHandler(StandardPersistenceHelper standardPersistenceHelper, PayrollItemTypeRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<PayrollItemType> clazz() {
        return PayrollItemType.class;
    }

    @Nonnull
    protected PayrollItemType beforeUpdate(@NonNull PayrollItemType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollItemType beforeDelete(@NonNull PayrollItemType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollItemType afterUpdate(@NonNull PayrollItemType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected PayrollItemType afterDelete(@NonNull PayrollItemType item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<PayrollItemType> relevantUnique(@NonNull LaborUnionContract laborUnionContract) {
        if (laborUnionContract == null) {
            throw new NullPointerException("laborUnionContract is marked non-null but is null");
        }
        Iterable payrollItemTypesContract = (Iterable)MoreObjects.firstNonNull((Object)laborUnionContract.getPayrollItemTypes(), (Object)ImmutableSet.of());
        Iterable payrollItemTypesWithoutContract = this.repository.findAllByLaborUnionContractIsNull();
        return ImmutableList.builder().addAll(payrollItemTypesContract).addAll(payrollItemTypesWithoutContract).build();
    }

    @Nonnull
    public Page<PayrollItemType> all(@NonNull PayrollItemTypeFilter payrollItemTypeFilter) {
        if (payrollItemTypeFilter == null) {
            throw new NullPointerException("payrollItemTypeFilter is marked non-null but is null");
        }
        int page = payrollItemTypeFilter.getPage();
        int size = payrollItemTypeFilter.getSize();
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"});
        return this.repository.findAll(Specification.where((Specification)PayrollItemTypeRepository.filter((PayrollItemTypeFilter)payrollItemTypeFilter)), (Pageable)pageRequest);
    }
}

