/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.repository.MeasurementPositionRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class MeasurementPositionHandler
extends BaseHandler<MeasurementPosition> {
    private static final Logger log = LogManager.getLogger(MeasurementPositionHandler.class);
    private final MeasurementPositionRepository repository;

    @Autowired
    public MeasurementPositionHandler(StandardPersistenceHelper standardPersistenceHelper, MeasurementPositionRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<MeasurementPosition> clazz() {
        return MeasurementPosition.class;
    }

    @Nonnull
    protected MeasurementPosition beforeUpdate(@NonNull MeasurementPosition item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected MeasurementPosition beforeDelete(@NonNull MeasurementPosition item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected MeasurementPosition afterUpdate(@NonNull MeasurementPosition item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected MeasurementPosition afterDelete(@NonNull MeasurementPosition item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public List<MeasurementPosition> allForQuotationNumberAndSurrogate(@NonNull String quotationNumber, @NonNull Iterable<EMeasurementState> measurementStates, @NonNull Iterable<String> surrogatePositionNumbers) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        if (measurementStates == null) {
            throw new NullPointerException("measurementStates is marked non-null but is null");
        }
        if (surrogatePositionNumbers == null) {
            throw new NullPointerException("surrogatePositionNumbers is marked non-null but is null");
        }
        return this.repository.allForQuotationNumberAndSurrogate(quotationNumber, measurementStates, surrogatePositionNumbers);
    }
}

