/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.dashboard.ReportDateBigDecimal;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.invoice.EEndOfDayType;
import de.qfm.erp.service.model.internal.invoice.EInvoiceSortOption;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceExportState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.invoice.TaxKey;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.repository.BaseRepository;
import de.qfm.erp.service.repository.InvoiceRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.InvoiceHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class InvoiceHandler
extends BaseHandler<Invoice> {
    private static final Logger log = LogManager.getLogger(InvoiceHandler.class);
    private static final ImmutableSet<EInvoiceState> INTERNAL_NUMBER_ALLOWED_STATES = ImmutableSet.of((Object)EInvoiceState.ACCOUNTED);
    private final EntityManager em;
    private final InvoiceRepository repository;
    private static final Set<EInvoiceExportState> NOT_EXPORTED_INVOICE_EXPORT_STATES = ImmutableSet.of((Object)EInvoiceExportState.NOT_EXPORTED);

    @Autowired
    public InvoiceHandler(StandardPersistenceHelper standardPersistenceHelper, EntityManager em, InvoiceRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.em = em;
        this.repository = repository;
    }

    protected Class<Invoice> clazz() {
        return Invoice.class;
    }

    @Nonnull
    protected Invoice beforeUpdate(@NonNull Invoice item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        return item;
    }

    @Nonnull
    protected Invoice afterUpdate(@NonNull Invoice item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Invoice afterDelete(@NonNull Invoice item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected Invoice beforeDelete(@NonNull Invoice item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        item.setSearchIndexState(ESearchIndexState.NOT_INDEXED);
        return item;
    }

    @Nonnull
    public Iterable<Invoice> cumulativeInvoices(@NonNull Invoice invoice, @NonNull Iterable<Quotation> quotations) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (quotations == null) {
            throw new NullPointerException("quotations is marked non-null but is null");
        }
        LocalDate invoiceDate = (LocalDate)MoreObjects.firstNonNull((Object)invoice.getInvoiceDate(), (Object)DateTimeHelper.today());
        Page secondaryInvoices = this.page(0, 10000, "", null, invoiceDate, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false), EEndOfDayType.NONE, quotations, (Iterable)ImmutableSet.of(), EInvoiceState.INVOICE_STATES_FOR_SECONDARY_INVOICES, EInvoiceType.INVOICE_TYPES_FOR_SECONDARY_INVOICES, EInvoiceSortOption.INVOICE_DATE_ASC);
        return ImmutableList.copyOf((Collection)Streams.stream((Iterable)secondaryInvoices).filter(item -> item != invoice).collect(Collectors.toList()));
    }

    public Page<Invoice> page(int page, int size, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        return this.page(page, size, filterText, null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false), EEndOfDayType.NONE, (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), (Iterable)ImmutableSet.of(), EInvoiceSortOption.INVOICE_DATE_DESC);
    }

    @Nonnull
    public Page<Invoice> page(int page, int size, @NonNull String filterText, @Nullable LocalDate invoiceDateFrom, @Nullable LocalDate invoiceDateTo, @Nullable LocalDate postingDateFrom, @Nullable LocalDate postingDateTo, @Nullable LocalDate cancellationDateFrom, @Nullable LocalDate cancellationDateTo, @Nullable LocalDate updatedOnDateFrom, @Nullable LocalDate updatedOnDateTo, @Nullable LocalDate invoiceStateSinceFrom, @Nullable LocalDate invoiceStateSinceTo, @Nullable Boolean filterER2Downloaded, @NonNull Boolean optionEndOfDay, @NonNull EEndOfDayType endOfDayType, @NonNull Iterable<Quotation> filterQuotations, @NonNull Iterable<User> filterPrimaryResponsibleUsers, @NonNull Iterable<EInvoiceState> invoiceStates, @NonNull Iterable<EInvoiceType> invoiceTypes, @NonNull EInvoiceSortOption invoiceSortOption) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        if (optionEndOfDay == null) {
            throw new NullPointerException("optionEndOfDay is marked non-null but is null");
        }
        if (endOfDayType == null) {
            throw new NullPointerException("endOfDayType is marked non-null but is null");
        }
        if (filterQuotations == null) {
            throw new NullPointerException("filterQuotations is marked non-null but is null");
        }
        if (filterPrimaryResponsibleUsers == null) {
            throw new NullPointerException("filterPrimaryResponsibleUsers is marked non-null but is null");
        }
        if (invoiceStates == null) {
            throw new NullPointerException("invoiceStates is marked non-null but is null");
        }
        if (invoiceTypes == null) {
            throw new NullPointerException("invoiceTypes is marked non-null but is null");
        }
        if (invoiceSortOption == null) {
            throw new NullPointerException("invoiceSortOption is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        Range invoiceDateRange = this.dateRange(invoiceDateFrom, invoiceDateTo);
        Range postingDateRange = this.dateRange(postingDateFrom, postingDateTo);
        Range cancellationDatePeriodRange = this.dateRange(cancellationDateFrom, cancellationDateTo);
        Range updatedOnDateRange = this.dateRange(updatedOnDateFrom, updatedOnDateTo);
        Range invoiceStateSinceRange = this.dateRange(invoiceStateSinceFrom, invoiceStateSinceTo);
        InvoiceRepository.InvoiceSpecifications.entityStateIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.invoiceDateBetween((Range)invoiceDateRange).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.updatedOnBetween((Range)updatedOnDateRange).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.quotationNumberIn(filterQuotations).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.primaryResponsibleUserIn(filterPrimaryResponsibleUsers).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.invoiceStateIn(invoiceStates).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.invoiceTypeIn(invoiceTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.text((String)filterText).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        if (optionEndOfDay.booleanValue()) {
            InvoiceRepository.InvoiceSpecifications.notAccountedAndCancelledAtSameDay().ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        }
        if (optionEndOfDay.booleanValue() && endOfDayType == EEndOfDayType.MONTH) {
            Specification disjunction;
            Optional invoiceSpecification1 = InvoiceRepository.InvoiceSpecifications.postingDateBetween((Range)postingDateRange);
            Optional invoiceSpecification2 = InvoiceRepository.InvoiceSpecifications.cancellationDatePeriodBetween((Range)cancellationDatePeriodRange);
            if (invoiceSpecification1.isPresent() && invoiceSpecification2.isPresent() && null != (disjunction = ((Specification)invoiceSpecification1.get()).or(((Specification)invoiceSpecification2.get()).or(null)))) {
                specsBuilder.add((Object)disjunction);
            }
        } else {
            InvoiceRepository.InvoiceSpecifications.postingDateBetween((Range)postingDateRange).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.invoiceStateSinceBetween((Range)invoiceStateSinceRange).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        }
        InvoiceRepository.InvoiceSpecifications.er2Download((Boolean)filterER2Downloaded).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList specs = specsBuilder.build();
        Sort sort = this.sortBy(invoiceSortOption);
        PageRequest pageRequest = PageRequest.of((int)page, (int)size, (Sort)sort);
        Specification conjunction = InvoiceRepository.InvoiceSpecifications.conjunction((Specification)InvoiceRepository.InvoiceSpecifications.identity((boolean)true), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }

    @Nullable
    public Integer currentSequentialNumber(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation quotation = invoice.getQuotation();
        String quotationNumber = quotation.getQuotationNumber();
        return this.repository.currentSequentialNumber((Set)ImmutableSet.of((Object)quotationNumber), (Set)INTERNAL_NUMBER_ALLOWED_STATES);
    }

    @Nullable
    public Integer currentPartialNumber(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation quotation = invoice.getQuotation();
        String quotationNumber = quotation.getQuotationNumber();
        return this.repository.currentPartialNumber((Set)ImmutableSet.of((Object)quotationNumber), (Set)ImmutableSet.of((Object)EInvoiceType.PARTIAL_INVOICE), (Set)INTERNAL_NUMBER_ALLOWED_STATES);
    }

    @Nullable
    public Integer currentPartialFinalNumber(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation quotation = invoice.getQuotation();
        String quotationNumber = quotation.getQuotationNumber();
        return this.repository.currentPartialFinalNumber((Set)ImmutableSet.of((Object)quotationNumber), (Set)ImmutableSet.of((Object)EInvoiceType.PARTIAL_FINAL_INVOICE), (Set)INTERNAL_NUMBER_ALLOWED_STATES);
    }

    @Nonnull
    public Iterable<Invoice> byIdsFailing(@NonNull Iterable<Long> idsRequested) {
        if (idsRequested == null) {
            throw new NullPointerException("idsRequested is marked non-null but is null");
        }
        Iterable items = this.allByIds(idsRequested);
        Map<Long, Invoice> itemsExistingById = Streams.stream((Iterable)items).collect(Collectors.toMap(Invoice::getId, item -> item));
        Set<Long> idsExisting = itemsExistingById.keySet();
        Sets.SetView idsMissing = Sets.difference(idsExisting, (Set)ImmutableSet.copyOf(idsRequested));
        if (!idsMissing.isEmpty()) {
            String idsMissingMsg = ID_JOINER.join((Iterable)idsMissing);
            throw ResourceNotFoundException.of((String)Invoice.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.ID), (String)idsMissingMsg);
        }
        return ImmutableList.copyOf((Iterable)items);
    }

    @Nonnull
    public Iterable<Invoice> closingInvoices(@NonNull Iterable<Quotation> quotations) {
        if (quotations == null) {
            throw new NullPointerException("quotations is marked non-null but is null");
        }
        ImmutableSet selectableInvoiceTypes = ImmutableSet.of((Object)EInvoiceType.PARTIAL_INVOICE);
        if (!Iterables.isEmpty((Iterable)selectableInvoiceTypes)) {
            ImmutableList.Builder specsBuilder = ImmutableList.builder();
            InvoiceRepository.InvoiceSpecifications.entityStateIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.invoiceStateIn((Iterable)ImmutableSet.of((Object)EInvoiceState.ACCOUNTED)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.quotationNumberIn(quotations).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.invoiceTypesIn((Iterable)selectableInvoiceTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.flagClosed((Boolean)false).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            ImmutableList specs = specsBuilder.build();
            Sort sort = this.sortBy(EInvoiceSortOption.INVOICE_NUMBER_ASC);
            PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort)sort);
            Specification conjunction = InvoiceRepository.InvoiceSpecifications.conjunction((Specification)InvoiceRepository.InvoiceSpecifications.identity((boolean)true), (Iterable)specs);
            return this.repository.findAll(conjunction, (Pageable)pageRequest);
        }
        return ImmutableList.of();
    }

    @Nonnull
    public Iterable<Invoice> finalInvoices(@NonNull Iterable<Quotation> quotations, @NonNull LocalDate minDateToValidate) {
        if (quotations == null) {
            throw new NullPointerException("quotations is marked non-null but is null");
        }
        if (minDateToValidate == null) {
            throw new NullPointerException("minDateToValidate is marked non-null but is null");
        }
        ImmutableSet selectableInvoiceTypes = ImmutableSet.of((Object)EInvoiceType.FINAL_INVOICE);
        if (!Iterables.isEmpty((Iterable)selectableInvoiceTypes)) {
            ImmutableList.Builder specsBuilder = ImmutableList.builder();
            InvoiceRepository.InvoiceSpecifications.entityStateIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.invoiceStateIn((Iterable)ImmutableSet.of((Object)EInvoiceState.ACCOUNTED)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.quotationNumberIn(quotations).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.invoiceTypesIn((Iterable)selectableInvoiceTypes).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.flagClosed((Boolean)false).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            InvoiceRepository.InvoiceSpecifications.invoiceDateBetween((Range)Range.atLeast((Comparable)minDateToValidate)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
            ImmutableList specs = specsBuilder.build();
            Sort sort = this.sortBy(EInvoiceSortOption.INVOICE_NUMBER_ASC);
            PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort)sort);
            Specification conjunction = InvoiceRepository.InvoiceSpecifications.conjunction((Specification)InvoiceRepository.InvoiceSpecifications.identity((boolean)true), (Iterable)specs);
            return this.repository.findAll(conjunction, (Pageable)pageRequest);
        }
        return ImmutableList.of();
    }

    @Nonnull
    private Range<LocalDate> dateRange(@Nullable LocalDate invoiceDateFrom, @Nullable LocalDate invoiceDateTo) {
        Range invoiceDateRange = null != invoiceDateFrom && null != invoiceDateTo ? Range.closed((Comparable)invoiceDateFrom, (Comparable)invoiceDateTo) : (null != invoiceDateFrom ? Range.atLeast((Comparable)invoiceDateFrom) : (null != invoiceDateTo ? Range.atMost((Comparable)invoiceDateTo) : Range.all()));
        return invoiceDateRange;
    }

    @Nonnull
    private Sort sortBy(@NonNull EInvoiceSortOption invoiceSortOption) {
        if (invoiceSortOption == null) {
            throw new NullPointerException("invoiceSortOption is marked non-null but is null");
        }
        return switch (1.$SwitchMap$de$qfm$erp$service$model$internal$invoice$EInvoiceSortOption[invoiceSortOption.ordinal()]) {
            case 1 -> Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"invoiceNumber")});
            case 2 -> Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.asc((String)"invoiceDate")});
            case 3 -> Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"invoiceDate")});
            default -> Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"id")});
        };
    }

    @Nonnull
    public Iterable<Invoice> notExportedToDMS(@NonNull Set<EInvoiceState> dmsPushInvoiceStates, @NonNull Set<EInvoiceType> dmsPushInvoiceTypes, int amount) {
        if (dmsPushInvoiceStates == null) {
            throw new NullPointerException("dmsPushInvoiceStates is marked non-null but is null");
        }
        if (dmsPushInvoiceTypes == null) {
            throw new NullPointerException("dmsPushInvoiceTypes is marked non-null but is null");
        }
        PageRequest pageable = PageRequest.of((int)0, (int)amount, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"}));
        return this.repository.notExportedToDMS(NOT_EXPORTED_INVOICE_EXPORT_STATES, dmsPushInvoiceTypes, dmsPushInvoiceStates, (Pageable)pageable);
    }

    @Nonnull
    public Iterable<Invoice> notExportedToDMSCompanyGroup(@NonNull Set<EInvoiceState> dmsPushInvoiceStates, @NonNull Set<EInvoiceType> dmsPushInvoiceTypes, int amount) {
        if (dmsPushInvoiceStates == null) {
            throw new NullPointerException("dmsPushInvoiceStates is marked non-null but is null");
        }
        if (dmsPushInvoiceTypes == null) {
            throw new NullPointerException("dmsPushInvoiceTypes is marked non-null but is null");
        }
        PageRequest pageable = PageRequest.of((int)0, (int)amount, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"}));
        return this.repository.notExportedToDMSCompanyGroup(NOT_EXPORTED_INVOICE_EXPORT_STATES, dmsPushInvoiceTypes, dmsPushInvoiceStates, (Pageable)pageable);
    }

    @Nonnull
    public Iterable<Invoice> notExportedToStore(@NonNull Set<EInvoiceState> storePushInvoiceStates, @NonNull Set<EInvoiceType> storePushInvoiceTypes, int amount) {
        if (storePushInvoiceStates == null) {
            throw new NullPointerException("storePushInvoiceStates is marked non-null but is null");
        }
        if (storePushInvoiceTypes == null) {
            throw new NullPointerException("storePushInvoiceTypes is marked non-null but is null");
        }
        PageRequest pageable = PageRequest.of((int)0, (int)amount, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"}));
        return this.repository.notExportedToStore(NOT_EXPORTED_INVOICE_EXPORT_STATES, storePushInvoiceTypes, storePushInvoiceStates, (Pageable)pageable);
    }

    @Nonnull
    public Optional<Long> findHolesWithPrefixLength1(@NonNull String invoicePrefix) {
        if (invoicePrefix == null) {
            throw new NullPointerException("invoicePrefix is marked non-null but is null");
        }
        String s = String.format("%s/%%", invoicePrefix);
        return this.repository.findHolesWithPrefixLength1(s);
    }

    @Nonnull
    public Optional<Long> findHolesWithPrefixLength2(@NonNull String invoicePrefix) {
        if (invoicePrefix == null) {
            throw new NullPointerException("invoicePrefix is marked non-null but is null");
        }
        String s = String.format("%s/%%", invoicePrefix);
        return this.repository.findHolesWithPrefixLength2(s);
    }

    public int count(@NonNull TaxKey taxKey) {
        if (taxKey == null) {
            throw new NullPointerException("taxKey is marked non-null but is null");
        }
        return this.repository.countByFinanceTaxKey(taxKey);
    }

    @Nonnull
    public Page<Invoice> notAccounted(@NonNull Iterable<Quotation> stages) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        InvoiceRepository.InvoiceSpecifications.stageIn((Iterable)ImmutableSet.copyOf(stages)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.invoiceStateIn((Iterable)ImmutableSet.of((Object)EInvoiceState.IN_ACCOUNTING)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.entityStateIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList specs = specsBuilder.build();
        Sort sort = this.sortBy(EInvoiceSortOption.INVOICE_NUMBER_ASC);
        PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort)sort);
        Specification conjunction = InvoiceRepository.InvoiceSpecifications.conjunction((Specification)InvoiceRepository.InvoiceSpecifications.identity((boolean)true), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }

    @Nonnull
    public Page<Invoice> partialWithoutFinal(@NonNull Iterable<Quotation> stages) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        InvoiceRepository.InvoiceSpecifications.entityStateIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.stageIn((Iterable)ImmutableSet.copyOf(stages)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.invoiceStateIn((Iterable)ImmutableSet.of((Object)EInvoiceState.ACCOUNTED, (Object)EInvoiceState.IN_ACCOUNTING)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.invoiceTypeIn((Iterable)ImmutableSet.of((Object)EInvoiceType.PARTIAL_INVOICE)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.notClosed().ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList specs = specsBuilder.build();
        Sort sort = this.sortBy(EInvoiceSortOption.INVOICE_NUMBER_ASC);
        PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort)sort);
        Specification conjunction = InvoiceRepository.InvoiceSpecifications.conjunction((Specification)InvoiceRepository.InvoiceSpecifications.identity((boolean)true), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }

    @Nonnull
    public Page<Invoice> invoiceWithDateGreaterThanOrInAccounting(@NonNull Iterable<Quotation> stages, @NonNull LocalDate referenceDate) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        ImmutableList.Builder specsBuilder = ImmutableList.builder();
        InvoiceRepository.InvoiceSpecifications.stageIn((Iterable)ImmutableSet.copyOf(stages)).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        Specification inAccountingInvoiceStateSpec = (Specification)InvoiceRepository.InvoiceSpecifications.invoiceStateIn((Iterable)ImmutableSet.of((Object)EInvoiceState.IN_ACCOUNTING)).orElseThrow();
        Specification accountedInvoiceStateSpec = (Specification)InvoiceRepository.InvoiceSpecifications.invoiceStateIn((Iterable)ImmutableSet.of((Object)EInvoiceState.ACCOUNTED)).orElseThrow();
        Specification invoiceDateSpec = (Specification)InvoiceRepository.InvoiceSpecifications.invoiceDateBetween((Range)Range.greaterThan((Comparable)referenceDate)).orElseThrow();
        Specification disjunction = accountedInvoiceStateSpec.and(invoiceDateSpec).or(inAccountingInvoiceStateSpec);
        specsBuilder.add((Object)disjunction);
        InvoiceRepository.InvoiceSpecifications.entityStateIn((Iterable)EntityState.ENTITY_STATES__NOT_DELETED).ifPresent(arg_0 -> ((ImmutableList.Builder)specsBuilder).add(arg_0));
        ImmutableList specs = specsBuilder.build();
        Sort sort = this.sortBy(EInvoiceSortOption.INVOICE_NUMBER_ASC);
        PageRequest pageRequest = PageRequest.of((int)0, (int)100, (Sort)sort);
        Specification conjunction = InvoiceRepository.InvoiceSpecifications.conjunction((Specification)InvoiceRepository.InvoiceSpecifications.identity((boolean)true), (Iterable)specs);
        return this.repository.findAll(conjunction, (Pageable)pageRequest);
    }

    @Nonnull
    public Iterable<ReportDateBigDecimal> valueOverallOverTime(@NonNull Long stageId) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        CriteriaBuilder criteriaBuilder = this.em.getCriteriaBuilder();
        CriteriaQuery fetchQuery = criteriaBuilder.createQuery(ReportDateBigDecimal.class);
        Root fetchRoot = fetchQuery.from(Invoice.class);
        Join childrenProd_M_Q = fetchRoot.join("quotation", JoinType.LEFT);
        ImmutableList.Builder predicatesBuilder = ImmutableList.builder();
        InvoiceRepository.InvoiceSpecifications.stageIn((Join)childrenProd_M_Q, (Iterable)ImmutableSet.of((Object)stageId)).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        InvoiceRepository.InvoiceSpecifications.invoiceStateIn((Root)fetchRoot, (Iterable)ImmutableSet.of((Object)EInvoiceState.ACCOUNTED)).ifPresent(arg_0 -> ((ImmutableList.Builder)predicatesBuilder).add(arg_0));
        ImmutableList predicates = predicatesBuilder.build();
        Predicate predicate = criteriaBuilder.and((Predicate[])predicates.toArray(Predicate[]::new));
        Expression invoiceDateMM = BaseRepository.truncToMonth((CriteriaBuilder)criteriaBuilder, (Path)fetchRoot.get("invoiceDate"));
        CriteriaQuery amountPriceWageQuery = fetchQuery.multiselect(new Selection[]{invoiceDateMM, criteriaBuilder.sum((Expression)fetchRoot.get("financeValueOverallNet"))}).where((Expression)predicate).groupBy(new Expression[]{invoiceDateMM});
        TypedQuery query = this.em.createQuery(amountPriceWageQuery);
        return query.getResultList();
    }

    @Nonnull
    public Optional<Invoice> byInvoiceNumberNotFailing(@NonNull String invoiceNumber) {
        if (invoiceNumber == null) {
            throw new NullPointerException("invoiceNumber is marked non-null but is null");
        }
        return this.repository.findByInvoiceNumber(invoiceNumber);
    }

    public boolean dirty() {
        return !this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)1)).isEmpty();
    }

    @Nonnull
    public Iterable<Invoice> dirtyPage(int max) {
        return this.repository.findAllUnIndexed((Iterable)ImmutableSet.of((Object)ESearchIndexState.UNKNOWN, (Object)ESearchIndexState.NOT_INDEXED), (Pageable)PageRequest.of((int)0, (int)max, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"updatedOn", "id"})));
    }

    public int markIndexed(@NonNull Iterable<Invoice> itemsProcessed) {
        if (itemsProcessed == null) {
            throw new NullPointerException("itemsProcessed is marked non-null but is null");
        }
        ImmutableSet invoiceIds = (ImmutableSet)Streams.stream(itemsProcessed).map(Invoice::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        return this.repository.updateSearchIndexState(ESearchIndexState.INDEXED, (Iterable)invoiceIds);
    }

    @Nonnull
    public Invoice patchFileStore(@NonNull Invoice invoice, @NonNull LocalDateTime exportDateTime, @NonNull String fullPath, @NonNull EInvoiceExportState invoiceExportState) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (exportDateTime == null) {
            throw new NullPointerException("exportDateTime is marked non-null but is null");
        }
        if (fullPath == null) {
            throw new NullPointerException("fullPath is marked non-null but is null");
        }
        if (invoiceExportState == null) {
            throw new NullPointerException("invoiceExportState is marked non-null but is null");
        }
        long invoiceId = invoice.getId();
        this.repository.patchFileStore(invoiceId, exportDateTime, fullPath, invoiceExportState);
        invoice.setFileStoreExportState(invoiceExportState);
        invoice.setFileStoreExportedOn(exportDateTime);
        invoice.setFileStoreExportedToPath(fullPath);
        return invoice;
    }

    @Nonnull
    public Invoice patchFileStore(@NonNull Invoice invoice, @NonNull EInvoiceExportState invoiceExportState) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (invoiceExportState == null) {
            throw new NullPointerException("invoiceExportState is marked non-null but is null");
        }
        long invoiceId = invoice.getId();
        this.repository.patchFileStore(invoiceId, null, "", invoiceExportState);
        invoice.setFileStoreExportState(invoiceExportState);
        invoice.setFileStoreExportedOn(null);
        invoice.setFileStoreExportedToPath("");
        return invoice;
    }

    @Nonnull
    public Invoice patchDMSStore(@NonNull Invoice invoice, @NonNull User exportedBy, @NonNull LocalDateTime exportedOn, @NonNull String exportedToPath, @NonNull BigDecimal financeValueOverallNet, @NonNull EInvoiceExportState dmsExportState) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (exportedBy == null) {
            throw new NullPointerException("exportedBy is marked non-null but is null");
        }
        if (exportedOn == null) {
            throw new NullPointerException("exportedOn is marked non-null but is null");
        }
        if (exportedToPath == null) {
            throw new NullPointerException("exportedToPath is marked non-null but is null");
        }
        if (financeValueOverallNet == null) {
            throw new NullPointerException("financeValueOverallNet is marked non-null but is null");
        }
        if (dmsExportState == null) {
            throw new NullPointerException("dmsExportState is marked non-null but is null");
        }
        long invoiceId = invoice.getId();
        this.repository.patchDMSStore(invoiceId, exportedOn, exportedBy, exportedToPath, financeValueOverallNet, dmsExportState);
        invoice.setDmsExportedBy(exportedBy);
        invoice.setDmsExportedOn(exportedOn);
        invoice.setDmsExportedToPath(exportedToPath);
        invoice.setDmsExportedValue(financeValueOverallNet);
        invoice.setDmsExportState(dmsExportState);
        return invoice;
    }

    @Nonnull
    public Invoice patchDMSCompanyGroupStore(@NonNull Invoice invoice, @NonNull User exportedBy, @NonNull LocalDateTime exportedOn, @NonNull String exportedToPath, @NonNull BigDecimal financeValueOverallNet, @NonNull EInvoiceExportState dmsExportState) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (exportedBy == null) {
            throw new NullPointerException("exportedBy is marked non-null but is null");
        }
        if (exportedOn == null) {
            throw new NullPointerException("exportedOn is marked non-null but is null");
        }
        if (exportedToPath == null) {
            throw new NullPointerException("exportedToPath is marked non-null but is null");
        }
        if (financeValueOverallNet == null) {
            throw new NullPointerException("financeValueOverallNet is marked non-null but is null");
        }
        if (dmsExportState == null) {
            throw new NullPointerException("dmsExportState is marked non-null but is null");
        }
        long invoiceId = invoice.getId();
        this.repository.patchDMSStore(invoiceId, exportedOn, exportedBy, exportedToPath, financeValueOverallNet, dmsExportState);
        invoice.setDmsCompanyGroupExportedOn(exportedOn);
        invoice.setDmsCompanyGroupExportedToPath(exportedToPath);
        invoice.setDmsCompanyGroupExportState(dmsExportState);
        return invoice;
    }

    @Nonnull
    public Invoice patchDMSStore(@NonNull Invoice invoice, @NonNull EInvoiceExportState dmsExportState) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (dmsExportState == null) {
            throw new NullPointerException("dmsExportState is marked non-null but is null");
        }
        long invoiceId = invoice.getId();
        this.repository.patchDMSStore(invoiceId, null, null, "", null, dmsExportState);
        invoice.setDmsExportedBy(null);
        invoice.setDmsExportedOn(null);
        invoice.setDmsExportedToPath("");
        invoice.setDmsExportedValue(null);
        invoice.setDmsExportState(dmsExportState);
        return invoice;
    }

    @Nonnull
    public Invoice patchDMSCompanyGroupStore(@NonNull Invoice invoice, @NonNull EInvoiceExportState dmsExportState) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        if (dmsExportState == null) {
            throw new NullPointerException("dmsExportState is marked non-null but is null");
        }
        long invoiceId = invoice.getId();
        this.repository.patchDMSStore(invoiceId, null, null, "", null, dmsExportState);
        invoice.setDmsCompanyGroupExportedOn(null);
        invoice.setDmsCompanyGroupExportedToPath("");
        invoice.setDmsCompanyGroupExportState(dmsExportState);
        return invoice;
    }
}

