/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.repository.FileStoreRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class FileStoreHandler
extends BaseHandler<FileStore> {
    private static final Logger log = LogManager.getLogger(FileStoreHandler.class);
    private final FileStoreRepository repository;

    @Autowired
    public FileStoreHandler(StandardPersistenceHelper standardPersistenceHelper, FileStoreRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<FileStore> clazz() {
        return FileStore.class;
    }

    @Nonnull
    protected FileStore beforeUpdate(@NonNull FileStore item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected FileStore beforeDelete(@NonNull FileStore item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected FileStore afterUpdate(@NonNull FileStore item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected FileStore afterDelete(@NonNull FileStore item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public FileStore byUuidFailing(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        Optional entityById = this.byUUIDNotFailing(uuid);
        if (entityById.isPresent()) {
            return (FileStore)entityById.get();
        }
        throw ResourceNotFoundException.of((String)this.clazz().getName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.UUID), (String)uuid.toString());
    }

    @Nonnull
    public Optional<FileStore> byUUIDNotFailing(@NonNull UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("uuid is marked non-null but is null");
        }
        return this.repository.findByUuid(uuid.toString());
    }
}

