/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.EntityState;
import de.qfm.erp.service.model.jpa.generic.BankingHoliday;
import de.qfm.erp.service.model.jpa.generic.EFederalState;
import de.qfm.erp.service.repository.BankingHolidayRepository;
import de.qfm.erp.service.service.handler.BaseHandler;
import de.qfm.erp.service.service.handler.PersistenceHelper;
import de.qfm.erp.service.service.handler.StandardPersistenceHelper;
import java.io.Serializable;
import java.time.YearMonth;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
public class BankingHolidayHandler
extends BaseHandler<BankingHoliday> {
    private static final Logger log = LogManager.getLogger(BankingHolidayHandler.class);
    private static final ImmutableSet<EntityState> VALID_ENTITY_STATES = ImmutableSet.of((Object)EntityState.VALID);
    private final BankingHolidayRepository repository;

    @Autowired
    public BankingHolidayHandler(StandardPersistenceHelper standardPersistenceHelper, BankingHolidayRepository repository) {
        super((PersistenceHelper)standardPersistenceHelper, (JpaRepository)repository);
        this.repository = repository;
    }

    protected Class<BankingHoliday> clazz() {
        return BankingHoliday.class;
    }

    @Nonnull
    protected BankingHoliday beforeUpdate(@NonNull BankingHoliday item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BankingHoliday afterUpdate(@NonNull BankingHoliday item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BankingHoliday afterDelete(@NonNull BankingHoliday item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    protected BankingHoliday beforeDelete(@NonNull BankingHoliday item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return item;
    }

    @Nonnull
    public Iterable<BankingHoliday> findByFederalStateAndYearMonthNotFailing(@NonNull EFederalState federalState, @NonNull YearMonth yearMonth) {
        if (federalState == null) {
            throw new NullPointerException("federalState is marked non-null but is null");
        }
        if (yearMonth == null) {
            throw new NullPointerException("yearMonth is marked non-null but is null");
        }
        ImmutableSet federalStates = ImmutableSet.of((Object)EFederalState.ALL, (Object)federalState);
        int year = yearMonth.getYear();
        int month = yearMonth.getMonthValue();
        return ImmutableList.copyOf((Iterable)this.repository.relevantBankingHolidays((Iterable)VALID_ENTITY_STATES, (Iterable)federalStates, month, year));
    }

    @Nonnull
    public Page<BankingHoliday> page(@NonNull Pageable pageable) {
        if (pageable == null) {
            throw new NullPointerException("pageable is marked non-null but is null");
        }
        Optional bankingHolidaySpecification = BankingHolidayRepository.onlyValid();
        if (bankingHolidaySpecification.isPresent()) {
            return this.repository.findAll((Specification)bankingHolidaySpecification.get(), pageable);
        }
        return this.repository.findAll(pageable);
    }

    @Nonnull
    public static Specification<BankingHoliday> identity() {
        return (Specification & Serializable)(root, query, builder) -> root.isNotNull();
    }
}

