/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StandardWage_WageTypeCalculator
extends WageTypeCalculator {
    public StandardWage_WageTypeCalculator() {
        super(EWageType.STANDARD_WAGE);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        List payrollMonthItems = payrollMonth.getPayrollMonthItems();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        User employee = payrollMonth.getUser();
        List attendances = payrollMonth.getAttendances();
        Iterable relevantAttendances = this.workingAttendances((Iterable)attendances);
        Duration workDuration = WageCalculatorHelper.durationInHours((Iterable)relevantAttendances, Attendance::getWorkDuration);
        BigDecimal workingHours = WageCalculatorHelper.hours((Duration)workDuration);
        BigDecimal effectiveWagePerHour = WageCalculatorHelper.effectiveWagePerHour((YearMonth)yearMonth, (User)employee);
        BigDecimal deductibleHours = StandardWage_WageTypeCalculator.deductibleHours((Iterable)payrollMonthItems);
        BigDecimal workingHoursWithDeduct = workingHours.subtract(deductibleHours);
        BigDecimal wageTotalWithDeduct = StandardWage_WageTypeCalculator.effectiveWageTotal((BigDecimal)workingHoursWithDeduct, (BigDecimal)effectiveWagePerHour);
        return ImmutableList.of((Object)WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)"", (BigDecimal)BigDecimal.ZERO, (BigDecimal)workingHoursWithDeduct, (BigDecimal)effectiveWagePerHour, (BigDecimal)wageTotalWithDeduct, (String)""));
    }
}

