/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.YearMonth;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SquadLeaderBonus_WageTypeCalculator
extends WageTypeCalculator {
    public SquadLeaderBonus_WageTypeCalculator() {
        super(EWageType.SQUAD_LEADER_BONUS);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        Iterable squadLeaderAttendances = payrollMonthCalculationBucket.getSquadLeaderAttendances();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        BigDecimal squadLeaderAmountPerItem = ((BigDecimal)MoreObjects.firstNonNull((Object)payrollItemType.getValue(), (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        BigDecimal squadLeaderCount = BigDecimal.valueOf(Iterables.size((Iterable)squadLeaderAttendances)).setScale(2, RoundingMode.HALF_UP);
        BigDecimal squadLeaderAmountAggregated = squadLeaderAmountPerItem.multiply(squadLeaderCount).setScale(2, RoundingMode.HALF_UP);
        String description = StringUtils.trimToEmpty((String)payrollItemType.getDescription());
        return ImmutableList.of((Object)WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)description, (BigDecimal)BigDecimal.ZERO, (BigDecimal)squadLeaderCount, (BigDecimal)squadLeaderAmountPerItem, (BigDecimal)squadLeaderAmountAggregated, (String)""));
    }
}

