/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.calculator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageCalculatorHelper;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDate;
import java.time.YearMonth;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PresentDaysWorkingHours_WageTypeCalculator
extends WageTypeCalculator {
    public static final BigDecimal EFFECTIVE_WAGE_PER_HOUR = BigDecimal.ONE;
    private static final Function<Iterable<Attendance>, BigDecimal> WORK_TIMES_FUNCTION = relatedAttendances -> WageCalculatorHelper.hours((Duration)WageCalculatorHelper.durationInHours((Iterable)relatedAttendances, Attendance::getWorkDuration));
    private static final Function<Attendance, BigDecimal> WORK_TIME_FUNCTION = attendance -> WageCalculatorHelper.hours((Duration)((Duration)MoreObjects.firstNonNull((Object)attendance.getWorkDuration(), (Object)Duration.ZERO)));
    private static final Iterable<EAttendanceDayType> ATTENDANCE_DAY_TYPES = ImmutableSet.of((Object)EAttendanceDayType.STANDARD);

    public PresentDaysWorkingHours_WageTypeCalculator() {
        super(EWageType.PRESENT_DAYS__WORKING_HOURS);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonthCalculationBucket payrollMonthCalculationBucket) {
        if (payrollMonthCalculationBucket == null) {
            throw new NullPointerException("payrollMonthCalculationBucket is marked non-null but is null");
        }
        ImmutableList.Builder wageTypeCalculationResultBuilder = ImmutableList.builder();
        PayrollMonth payrollMonth = payrollMonthCalculationBucket.getPayrollMonth();
        PayrollItemType payrollItemType = payrollMonthCalculationBucket.getPayrollItemType();
        YearMonth yearMonth = WageCalculatorHelper.yearMonth((PayrollMonth)payrollMonth);
        List attendances = payrollMonth.getAttendances();
        Iterable relevantWorkingAttendancesUnfiltered = PresentDaysWorkingHours_WageTypeCalculator.attendances((Iterable)attendances, (Iterable)ATTENDANCE_DAY_TYPES);
        ImmutableList relevantWorkingAttendancesWithValidDate = (ImmutableList)Streams.stream((Iterable)relevantWorkingAttendancesUnfiltered).collect(ImmutableList.toImmutableList());
        Duration duration = WageCalculatorHelper.durationInHours((Iterable)relevantWorkingAttendancesWithValidDate, Attendance::getWorkDuration);
        BigDecimal durationInHours = WageCalculatorHelper.hours((Duration)duration);
        BigDecimal total = PresentDaysWorkingHours_WageTypeCalculator.effectiveWageTotal((BigDecimal)durationInHours, (BigDecimal)EFFECTIVE_WAGE_PER_HOUR);
        WageTypeCalculationResult aggregationRow = WageTypeCalculationResult.of((EWageType)this.getWageType(), (PayrollItemType)payrollItemType, (LocalDate)yearMonth.atEndOfMonth(), (EWageTypeCalculationResultType)EWageTypeCalculationResultType.STANDARD, (Integer)0, (String)"", (BigDecimal)BigDecimal.ZERO, (BigDecimal)durationInHours, (BigDecimal)EFFECTIVE_WAGE_PER_HOUR, (BigDecimal)total, (String)"");
        Iterable groupedAttendances = PresentDaysWorkingHours_WageTypeCalculator.group((Iterable)relevantWorkingAttendancesWithValidDate);
        ImmutableList.Builder detailRowsBuilder = ImmutableList.builder();
        AtomicInteger counter = new AtomicInteger();
        for (Pair groupedAttendance : groupedAttendances) {
            detailRowsBuilder.add((Object)PresentDaysWorkingHours_WageTypeCalculator.groupedDetails((EWageType)this.getWageType(), (AtomicInteger)counter, (LocalDate)yearMonth.atEndOfMonth(), (PayrollItemType)payrollItemType, (Pair)groupedAttendance, relatedAttendances -> BigDecimal.valueOf(Iterables.size((Iterable)relatedAttendances)), (Function)WORK_TIMES_FUNCTION, relatedAttendances -> BigDecimal.ZERO, relatedAttendances -> BigDecimal.ZERO));
            detailRowsBuilder.addAll(PresentDaysWorkingHours_WageTypeCalculator.ungroupedDetails((EWageType)this.getWageType(), (AtomicInteger)counter, (PayrollItemType)payrollItemType, (Pair)groupedAttendance, relatedAttendances -> BigDecimal.ONE, (Function)WORK_TIME_FUNCTION, relatedAttendances -> BigDecimal.ZERO, relatedAttendances -> BigDecimal.ZERO, (boolean)false, relatedAttendance -> BigDecimal.ZERO));
        }
        ImmutableList detailRows = detailRowsBuilder.build();
        wageTypeCalculationResultBuilder.add((Object)aggregationRow).addAll((Iterable)detailRows);
        return wageTypeCalculationResultBuilder.build();
    }
}

