/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype.aggregator;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.service.calculator.wagetype.aggregator.AttendanceDurationAggregator;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class WorkAttendanceDurationAggregator
extends AttendanceDurationAggregator {
    private static final Iterable<EAttendanceDayType> ATTENDANCE_DAY_TYPES = ImmutableSet.of((Object)EAttendanceDayType.ON_DUTY, (Object)EAttendanceDayType.STANDARD, (Object)EAttendanceDayType.BAD_WEATHER, (Object)EAttendanceDayType.BAD_WEATHER_SICK);

    public WorkAttendanceDurationAggregator() {
        super(EAggregatedAttendanceDayType.AGG_WORK);
    }

    @Nonnull
    public Map<EAggregatedAttendanceDayType, Duration> duration(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        EAttendanceDayType employeeDayType = attendance.getEmployeeDayType();
        Duration workDuration = (Duration)MoreObjects.firstNonNull((Object)attendance.getWorkDuration(), (Object)Duration.ZERO);
        if (!workDuration.isZero() && Iterables.contains((Iterable)ATTENDANCE_DAY_TYPES, (Object)employeeDayType)) {
            return ImmutableMap.of((Object)EAggregatedAttendanceDayType.AGG_WORK, (Object)workDuration);
        }
        return ImmutableMap.of();
    }
}

