/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.wagetype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.comparator.WageTypeCalculationResultComparator;
import de.qfm.erp.service.model.internal.employee.payroll.WageTypeCalculationResult;
import de.qfm.erp.service.model.internal.payroll.PayrollMonthCalculationBucket;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonth;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollMonthItem;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.calculator.wagetype.calculator.WageTypeCalculator;
import de.qfm.erp.service.service.handler.AttendanceHandler;
import de.qfm.erp.service.service.handler.PayrollMonthItemHandler;
import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WageTypeCalculators {
    private final AttendanceHandler attendanceHandler;
    private final PayrollMonthItemHandler payrollMonthItemHandler;
    private final Map<EWageType, WageTypeCalculator> wageTypeCalculatorsByWageType;

    @Autowired
    public WageTypeCalculators(AttendanceHandler attendanceHandler, PayrollMonthItemHandler payrollMonthItemHandler, List<WageTypeCalculator> wageTypeCalculators) {
        this.attendanceHandler = attendanceHandler;
        this.payrollMonthItemHandler = payrollMonthItemHandler;
        this.wageTypeCalculatorsByWageType = MapsHelper.mapFirst(wageTypeCalculators, WageTypeCalculator::getWageType);
    }

    @Nonnull
    public Iterable<WageTypeCalculationResult> calculate(@NonNull PayrollMonth payrollMonth, @NonNull Iterable<PayrollItemType> allPayrollItemTypes) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (allPayrollItemTypes == null) {
            throw new NullPointerException("allPayrollItemTypes is marked non-null but is null");
        }
        User user = payrollMonth.getUser();
        YearMonth accountingMonth = YearMonth.from(payrollMonth.getAccountingMonth());
        List payrollMonthItems = payrollMonth.getPayrollMonthItems();
        Iterable safePayrollMonthItems = (Iterable)IterableHelper.stream((Iterable)payrollMonthItems).filter(item -> null != item.getPayrollItemType()).collect(ImmutableList.toImmutableList());
        Multimap payrollMonthItemsByPayrollItemType = MapsHelper.map((Iterable)safePayrollMonthItems, PayrollMonthItem::getPayrollItemType, item -> item);
        Iterable incentivePayrollMonthItems = this.payrollMonthItemHandler.incentiveWagesAssignedToPayroll(user, accountingMonth);
        Iterable squadLeaderAttendances = this.attendanceHandler.findSquadLeaderAttendances(payrollMonth);
        ImmutableList.Builder allResultsBuilder = ImmutableList.builder();
        for (PayrollItemType allPayrollItemType : allPayrollItemTypes) {
            EWageType wageType = allPayrollItemType.getWageType();
            WageTypeCalculator wageTypeCalculator = (WageTypeCalculator)this.wageTypeCalculatorsByWageType.get(wageType);
            PayrollMonthCalculationBucket bucket = PayrollMonthCalculationBucket.of((PayrollMonth)payrollMonth, (PayrollItemType)allPayrollItemType, (Multimap)payrollMonthItemsByPayrollItemType, (Iterable)squadLeaderAttendances, (Iterable)incentivePayrollMonthItems);
            Iterable calculationResults = wageTypeCalculator.calculate(bucket);
            allResultsBuilder.addAll(calculationResults);
        }
        ImmutableList allResults = allResultsBuilder.build();
        return ImmutableList.sortedCopyOf((Comparator)WageTypeCalculationResultComparator.INSTANCE, (Iterable)allResults);
    }

    @Nonnull
    public BigDecimal summarizedWage(@NonNull PayrollMonth payrollMonth, @NonNull Iterable<PayrollItemType> allPayrollItemTypes) {
        if (payrollMonth == null) {
            throw new NullPointerException("payrollMonth is marked non-null but is null");
        }
        if (allPayrollItemTypes == null) {
            throw new NullPointerException("allPayrollItemTypes is marked non-null but is null");
        }
        Iterable calculate = this.calculate(payrollMonth, allPayrollItemTypes);
        BigDecimal incentiveWage = IterableHelper.stream((Iterable)calculate).filter(item -> EWageType.INCENTIVE_WAGE == item.getWageCalculation()).map(WageTypeCalculationResult::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal otherWage = IterableHelper.stream((Iterable)calculate).filter(item -> EWageType.INCENTIVE_WAGE != item.getWageCalculation()).map(WageTypeCalculationResult::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        return incentiveWage.add(otherWage);
    }
}

