/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.measurement;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.MapperHelper;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.measurement.MeasurementPositionCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=3)
public class MeasurementPositionWageCalculator
extends MeasurementPositionCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);
    static final int ORDERING = 3;

    public MeasurementPositionWageCalculator() {
        super(PROPERTIES, 3);
    }

    public void calculateAndApply(@NonNull MeasurementPosition measurementPosition) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        BigDecimal product = measurementPosition.getProduct();
        BigDecimal internalSquadWagePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getInternalSquadWagePerUnit());
        BigDecimal internalSquadWageAggregated = product.multiply(internalSquadWagePerUnit);
        BigDecimal companyWagePerItem = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getCompanyWagePerUnit());
        BigDecimal companyWageAggregated = product.multiply(companyWagePerItem);
        BigDecimal internalWagePerUnit = MapperHelper.safeBigDecimal((BigDecimal)measurementPosition.getInternalWagePerUnit());
        BigDecimal internalWageAggregated = product.multiply(internalWagePerUnit);
        measurementPosition.setInternalWageAggregated(internalWageAggregated.setScale(2, RoundingMode.HALF_UP));
        measurementPosition.setInternalSquadWageAggregated(internalSquadWageAggregated.setScale(2, RoundingMode.HALF_UP));
        measurementPosition.setCompanyWageAggregated(companyWageAggregated.setScale(2, RoundingMode.HALF_UP));
    }
}

