/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.invoice;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.ProductCalculatorHelper;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.invoice.InvoicePositionCalculator;
import java.math.BigDecimal;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=2)
public class InvoicePositionProductCalculator
extends InvoicePositionCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD, (Object)ECalculatorProperty.SYNC);
    static final int ORDERING = 2;

    public InvoicePositionProductCalculator() {
        super(PROPERTIES, 2);
    }

    public void calculateAndApply(@NonNull InvoicePosition invoicePosition) {
        if (invoicePosition == null) {
            throw new NullPointerException("invoicePosition is marked non-null but is null");
        }
        BigDecimal amount = invoicePosition.getAmount();
        BigDecimal factor1 = invoicePosition.getFactor1();
        BigDecimal factor2 = invoicePosition.getFactor2();
        BigDecimal factor3 = invoicePosition.getFactor3();
        BigDecimal product = ProductCalculatorHelper.product((BigDecimal)amount, (BigDecimal)factor1, (BigDecimal)factor2, (BigDecimal)factor3);
        invoicePosition.setProduct(product);
    }
}

