/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.invoice;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.helper.MapperHelper;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.invoice.InvoicePositionCalculator;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=5)
public class InvoicePositionPriceCalculator
extends InvoicePositionCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);
    static final int ORDERING = 5;

    public InvoicePositionPriceCalculator() {
        super(PROPERTIES, 5);
    }

    public void calculateAndApply(@NonNull InvoicePosition invoicePosition) {
        if (invoicePosition == null) {
            throw new NullPointerException("invoicePosition is marked non-null but is null");
        }
        BigDecimal pricePerUnit = MapperHelper.safeBigDecimal((BigDecimal)invoicePosition.getPricePerUnit());
        BigDecimal priceAggregated = MapperHelper.safeBigDecimal((BigDecimal)invoicePosition.getPriceAggregated());
        BigDecimal product = MapperHelper.safeBigDecimal((BigDecimal)invoicePosition.getProduct());
        boolean pricePerUnitIsSet = pricePerUnit.compareTo(BigDecimal.ZERO) != 0;
        boolean perAggregatedIsSet = priceAggregated.compareTo(BigDecimal.ZERO) != 0;
        BigDecimal discount = MapperHelper.safeBigDecimal((BigDecimal)invoicePosition.getDiscount());
        if (pricePerUnitIsSet && !perAggregatedIsSet) {
            BigDecimal priceAggregatedNew = product.multiply(pricePerUnit).setScale(2, RoundingMode.HALF_UP);
            invoicePosition.setPriceAggregated(priceAggregatedNew);
            BigDecimal discountValueAggregated = priceAggregatedNew.multiply(discount.divide(BigDecimal.valueOf(100L))).setScale(2, RoundingMode.HALF_UP);
            BigDecimal priceAggregatedWithDiscount = priceAggregatedNew.subtract(discountValueAggregated);
            invoicePosition.setDiscountValueAggregated(discountValueAggregated);
            invoicePosition.setPriceAggregatedWithDiscount(priceAggregatedWithDiscount);
        } else {
            BigDecimal discountValueAggregated = priceAggregated.multiply(discount.divide(BigDecimal.valueOf(100L))).setScale(2, RoundingMode.HALF_UP);
            BigDecimal priceAggregatedWithDiscount = priceAggregated.subtract(discountValueAggregated);
            invoicePosition.setDiscountValueAggregated(discountValueAggregated);
            invoicePosition.setPriceAggregatedWithDiscount(priceAggregatedWithDiscount);
        }
    }
}

