/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator.attendance;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.jpa.employee.attendance.Attendance;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import de.qfm.erp.service.service.calculator.attendance.AttendanceDurationCalculator;
import java.time.Duration;
import java.time.LocalTime;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Order(value=2)
public class AttendanceBadWeatherDurationCalculator
extends AttendanceDurationCalculator {
    static final Iterable<ECalculatorProperty> PROPERTIES = ImmutableSet.of((Object)ECalculatorProperty.STANDARD);
    static final int ORDERING = 2;

    public AttendanceBadWeatherDurationCalculator() {
        super(PROPERTIES, 2);
    }

    void calculateAndApply(@NonNull Attendance attendance) {
        if (attendance == null) {
            throw new NullPointerException("attendance is marked non-null but is null");
        }
        EAttendanceDayType employeeDayType = attendance.getEmployeeDayType();
        Duration contractualWorkTimeDuration = attendance.getContractualWorkTimeDuration();
        LocalTime workStart = attendance.getWorkStart();
        LocalTime workEnd = attendance.getWorkEnd();
        Duration breakDuration = attendance.getBreakDuration();
        Optional calculate = this.calculate(employeeDayType, contractualWorkTimeDuration, workStart, workEnd, breakDuration);
        Duration badWeatherDuration = calculate.orElse(null);
        attendance.setBadWeatherDuration(badWeatherDuration);
    }

    @Nonnull
    public Optional<Duration> calculate(@NonNull EAttendanceDayType attendanceDayType, @Nullable Duration contractualWorkTimeDuration, @Nullable LocalTime workStart, @Nullable LocalTime workEnd, @Nullable Duration breakDuration) {
        if (attendanceDayType == null) {
            throw new NullPointerException("attendanceDayType is marked non-null but is null");
        }
        if (EAttendanceDayType.BAD_WEATHER == attendanceDayType || EAttendanceDayType.BAD_WEATHER_SICK == attendanceDayType) {
            Duration effectiveWorkingTime;
            Duration contractualWorkTimeDurationSafe = (Duration)MoreObjects.firstNonNull((Object)contractualWorkTimeDuration, (Object)Duration.ZERO);
            Duration safeBreakDuration = (Duration)MoreObjects.firstNonNull((Object)breakDuration, (Object)Duration.ZERO);
            if (null != workStart && null != workEnd) {
                Duration difference = AttendanceBadWeatherDurationCalculator.difference((LocalTime)workStart, (LocalTime)workEnd);
                effectiveWorkingTime = difference.minus(safeBreakDuration);
            } else {
                effectiveWorkingTime = Duration.ZERO;
            }
            Duration badWeatherDuration = contractualWorkTimeDurationSafe.minus(effectiveWorkingTime);
            Duration badWeatherDurationCleared = badWeatherDuration.isNegative() ? Duration.ZERO : badWeatherDuration;
            return Optional.of(badWeatherDurationCleared);
        }
        return Optional.empty();
    }
}

