/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.calculator;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.service.calculator.ECalculatorProperty;
import lombok.NonNull;

public abstract class Calculator {
    private final Iterable<ECalculatorProperty> properties;
    private final int ordering;

    protected Calculator(@NonNull Iterable<ECalculatorProperty> properties, int ordering) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        this.properties = ImmutableSet.copyOf(properties);
        this.ordering = ordering;
    }

    public boolean hasProperty(@NonNull ECalculatorProperty property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return Iterables.contains((Iterable)this.properties, (Object)property);
    }

    public Iterable<ECalculatorProperty> getProperties() {
        return this.properties;
    }

    public int getOrdering() {
        return this.ordering;
    }
}

