/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.request.project.SubProjectUpdateRequest;
import de.qfm.erp.common.response.project.SubProjectCommon;
import de.qfm.erp.common.response.project.SubProjectPageCommon;
import de.qfm.erp.service.service.route.SubProjectRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="SubProject Management Resource", name="SubProjectResource")
@OpenAPIDefinition(tags={@Tag(name="SubProjectResource", description="All Operations around Projects")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/subprojects"})
public class SubProjectResource {
    private static final Logger log = LogManager.getLogger(SubProjectResource.class);
    private final SubProjectRoute route;

    @Operation(summary="SubProjects List / Paging")
    @GetMapping(value={"/"}, produces={"application/json"})
    public SubProjectPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @Parameter(description="Filter by QEntityId", example="") @RequestParam(value="q_entity_id", defaultValue="") Long qEntityId, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        ImmutableSet entityIdFilter = null != qEntityId ? ImmutableSet.of((Object)qEntityId) : ImmutableSet.of();
        return this.route.page(page, size, (Iterable)entityIdFilter, StringUtils.trimToEmpty((String)filterText));
    }

    @Operation(summary="SubProject by Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public SubProjectCommon getById(@Parameter(description="Dictionary Item Id of the Entity to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Create a SubProject for QEntityId")
    @PostMapping(value={"/q_entity_id={q_entity_id}/"}, consumes={"application/json"}, produces={"application/json"})
    public SubProjectCommon create(@PathVariable(value="q_entity_id") Long qEntityId, @RequestBody SubProjectUpdateRequest request) {
        return this.route.create(qEntityId, request);
    }

    @Operation(summary="Update a SubProject by ID")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public SubProjectCommon update(@PathVariable(value="id") Long id, @RequestBody SubProjectUpdateRequest request) {
        return this.route.update(id, request);
    }

    public SubProjectResource(SubProjectRoute route) {
        this.route = route;
    }
}

