/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.contract.LaborUnionContractUpdateRequest;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupRatesUpdateRequest;
import de.qfm.erp.common.request.contract.LaborUnionWageGroupsUpdateRequest;
import de.qfm.erp.common.response.contract.LaborUnionContractCommon;
import de.qfm.erp.common.response.contract.LaborUnionContractPageCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupListCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupRateCommon;
import de.qfm.erp.common.response.contract.LaborUnionWageGroupRateListCommon;
import de.qfm.erp.service.service.route.LaborUnionContractRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.time.LocalDate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Labor Union Contracts Management Resource", name="LaborUnionContractsResource")
@OpenAPIDefinition(tags={@Tag(name="LaborUnionContractsResource", description="All Operations around Labor Union Contracts")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="401", description="You are not authorized to view the resource", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden", content={@Content(mediaType="application/json")}), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found", content={@Content(mediaType="application/json")})})
@RestController
@RequestMapping(value={"/api/v1/erp/labor_union_contracts"})
public class LaborUnionContractResource {
    private static final Logger log = LogManager.getLogger(LaborUnionContractResource.class);
    private final LaborUnionContractRoute route;

    @Operation(summary="Labor Union Contracts List / Paging")
    @GetMapping(value={"/"}, produces={"application/json"})
    public LaborUnionContractPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.page(page, size);
    }

    @Operation(summary="LaborUnionContract Create")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public LaborUnionContractCommon create(@RequestBody @Valid LaborUnionContractUpdateRequest laborUnionContractUpdateRequest) {
        return this.route.create(laborUnionContractUpdateRequest);
    }

    @Operation(summary="LaborUnionContract Update")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public LaborUnionContractCommon create(@Parameter(description="LaborUnionContract Id of the Entity to update", required=true) @PathVariable(value="id") long id, @RequestBody @Valid LaborUnionContractUpdateRequest laborUnionContractUpdateRequest) {
        return this.route.update(id, laborUnionContractUpdateRequest);
    }

    @Operation(summary="LaborUnionContract for Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public LaborUnionContractCommon getById(@Parameter(description="LaborUnionContract Id of the Entity to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="LaborUnionContract.WageGroups for Contract.Id")
    @GetMapping(value={"/{id}/wage_groups/"}, produces={"application/json"})
    public LaborUnionWageGroupListCommon wageGroupsByContractId(@Parameter(description="LaborUnionContract Id of the WageGroups to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.route.wageGroupsByContractId(id);
    }

    @Operation(summary="LaborUnionContract.WageGroups for Contract.Id")
    @PostMapping(value={"/{id}/wage_groups/"}, consumes={"application/json"}, produces={"application/json"})
    public LaborUnionWageGroupListCommon updateWageGroupsByContractId(@Parameter(description="LaborUnionContract Id of the WageGroups to retrieve", required=true) @PathVariable(value="id") long id, @RequestBody @Valid LaborUnionWageGroupsUpdateRequest updateRequest) {
        return this.route.update(id, updateRequest);
    }

    @Operation(summary="LaborUnionContract.WageGroups for Contract.Id")
    @GetMapping(value={"/{id}/wage_groups/{reference_date}/"}, produces={"application/json"})
    public LaborUnionWageGroupListCommon wageGroupsByContractId(@Parameter(description="LaborUnionContract Id of the WageGroups to retrieve", required=true) @PathVariable(value="id") long id, @Parameter(description="The Reference Date to determine the current Wage Group Rate", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @PathVariable(value="reference_date") LocalDate referenceDate) {
        return this.route.wageGroupsByContractIdAndReferenceDate(id, referenceDate);
    }

    @Operation(summary="LaborUnionContract.WageGroups for Contract.Id")
    @GetMapping(value={"/wage_groups/{wage_group_rate_id}/wage_group_rates/"}, produces={"application/json"})
    public LaborUnionWageGroupRateListCommon wageGroupRatesByWageGroupId(@Parameter(description="Wage Group Id of the Wage Group Rates to retrieve", required=true) @PathVariable(value="wage_group_rate_id") long wageGroupId) {
        return this.route.wageGroupRatesByWageGroupId(wageGroupId);
    }

    @Operation(summary="LaborUnionContract.WageGroups for Contract.Id")
    @PostMapping(value={"/wage_groups/{wage_group_rate_id}/wage_group_rates/"}, consumes={"application/json"}, produces={"application/json"})
    public LaborUnionWageGroupRateListCommon updateWageGroupRatesByWageGroupId(@Parameter(description="Wage Group Id of the Wage Group Rates to retrieve", required=true) @PathVariable(value="wage_group_rate_id") long wageGroupId, @RequestBody @Valid LaborUnionWageGroupRatesUpdateRequest updateRequest) {
        return this.route.update(wageGroupId, updateRequest);
    }

    @Operation(summary="WageGroups.Rate for Contract.Id")
    @GetMapping(value={"/wage_groups/{wage_group_rate_id}/wage_group_rates/{reference_date}/"}, produces={"application/json"})
    public LaborUnionWageGroupRateCommon wageGroupRatesByWageGroupIdAtDate(@Parameter(description="Wage Group Id of the Wage Group Rates to retrieve", required=true) @PathVariable(value="wage_group_rate_id") long wageGroupId, @Parameter(description="The Reference Date to determine the current Wage Group Rate", required=true) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @PathVariable(value="reference_date") LocalDate referenceDate) {
        return this.route.wageGroupRatesByWageGroupIdAndReferenceDate(wageGroupId, referenceDate);
    }

    public LaborUnionContractResource(LaborUnionContractRoute route) {
        this.route = route;
    }
}

