/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.request.invoice.InvoiceAccountRequest;
import de.qfm.erp.common.request.invoice.InvoiceBatchPrintRequest;
import de.qfm.erp.common.request.invoice.InvoiceCancelRequest;
import de.qfm.erp.common.request.invoice.InvoiceER2BatchExportRequest;
import de.qfm.erp.common.request.invoice.InvoiceUpdateRequest;
import de.qfm.erp.common.request.invoice.InvoiceXLSBatchExportRequest;
import de.qfm.erp.common.request.invoice.MeasurementValidationRequest;
import de.qfm.erp.common.response.invoice.ClosingInvoiceListCommon;
import de.qfm.erp.common.response.invoice.CreditVoucherImportResultListCommon;
import de.qfm.erp.common.response.invoice.InvoiceAttachmentListCommon;
import de.qfm.erp.common.response.invoice.InvoiceCommon;
import de.qfm.erp.common.response.invoice.InvoiceMeasurementAutoCompleteResponse;
import de.qfm.erp.common.response.invoice.InvoicePageCommon;
import de.qfm.erp.common.response.invoice.MeasurementValidationResponse;
import de.qfm.erp.common.response.invoice.NewInvoiceAutoCompleteResponse;
import de.qfm.erp.service.resource.AbstractResource;
import de.qfm.erp.service.service.route.InvoiceRoute;
import de.qfm.erp.service.service.route.MeasurementRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(description="Invoice Resource", name="InvoiceResource")
@OpenAPIDefinition(tags={@Tag(name="InvoiceResource", description="All Operations around Invoices")})
@RestController
@RequestMapping(value={"/api/v1/erp/invoices"})
public class InvoiceResource {
    private static final Logger log = LogManager.getLogger(InvoiceResource.class);
    private final MeasurementRoute measurementRoute;
    private final InvoiceRoute invoiceRoute;

    @Operation(summary="Invoice List / Paging")
    @GetMapping(value={"/"})
    public InvoicePageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="filter Invoices with Invoice-Date FROM") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="invoice_date_from", defaultValue="") LocalDate invoiceDateFrom, @Parameter(description="filter Invoices with Invoice-Date TO") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="invoice_date_to", defaultValue="") LocalDate invoiceDateTo, @Parameter(description="filter Invoices with Posting-Date FROM") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="posting_date_from", defaultValue="") LocalDate postingDateFrom, @Parameter(description="filter Invoices with Posting-Date TO") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="posting_date_to", defaultValue="") LocalDate postingDateTo, @Parameter(description="filter Invoices with Edit-Date FROM") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="updated_on_from", defaultValue="") LocalDate updatedOnFrom, @Parameter(description="filter Invoices with Edit-Date TO") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="updated_on_to", defaultValue="") LocalDate updatedOnTo, @Parameter(description="Include / Exclude ER2 already Downloaded (null == no filter, true = already downloaded, false = not downloaded") @RequestParam(name="option_end_of_day", defaultValue="false") Boolean optionEndOfDay, @Parameter(description="Type of End Of Day, must be set, if 'option_end_of_day' is true", example="[DAY, MONTH]") @RequestParam(name="end_of_day_type", defaultValue="DAY") String endOfDayType, @Parameter(description="filter Invoices with End-of-Day Date, must be set, if 'option_end_of_day' is true") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) @RequestParam(value="end_of_day_date", defaultValue="") LocalDate endOfDayDate, @Parameter(description="Include / Exclude ER2 already Downloaded (null == no filter, true = already downloaded, false = not downloaded") @RequestParam(name="filter_er2_downloaded", defaultValue="") Boolean filterER2Downloaded, @Parameter(description="The Invoice States to be returned", example="IN_ACCOUNTING,ACCOUNTED,CANCELLED") @RequestParam(value="filter_invoice_state", defaultValue="") String filterInvoiceStateCandidate, @Parameter(description="Filter by Stage Id", example="LONG") @RequestParam(value="filter_stage_id", defaultValue="") Long filterStageId, @Parameter(description="Filter by Primary Responsible User Id", example="LONG") @RequestParam(value="filter_primary_responsible_user_id", defaultValue="") Long filterPrimaryResponsibleUserId, @Parameter(description="Sort Option", example="ID_DESC,INVOICE_DATE_DESC") @RequestParam(value="sort_option", defaultValue="ID_DESC") String sortOptionCandidate) {
        return this.invoiceRoute.page(page, size, StringUtils.trimToEmpty((String)filterText), invoiceDateFrom, invoiceDateTo, postingDateFrom, postingDateTo, updatedOnFrom, updatedOnTo, filterER2Downloaded, ((Boolean)MoreObjects.firstNonNull((Object)optionEndOfDay, (Object)false)).booleanValue(), StringUtils.trimToEmpty((String)endOfDayType), endOfDayDate, filterInvoiceStateCandidate, filterStageId, filterPrimaryResponsibleUserId, sortOptionCandidate);
    }

    @Operation(summary="Invoice List of related and available Closing Invoices")
    @GetMapping(value={"/_closing_invoices/"})
    public ClosingInvoiceListCommon closingList(@Parameter(description="Filter by Stage Id", example="LONG") @RequestParam(value="filter_stage_id", defaultValue="") Long filterStageId, @Parameter(description="Current Invoice Type", example="PARTIAL_FINAL_INVOICE, FINAL_INVOICE") @RequestParam(value="current_invoice_type", defaultValue="") String currentInvoiceTypeCandidate, @Parameter(description="Current closing Invoice Ids comma separated", example="1,2,3") @RequestParam(value="current_closing_invoice_ids", defaultValue="") String currentClosingInvoicesIdsCandidate) {
        return this.invoiceRoute.closingList(filterStageId, StringUtils.trimToEmpty((String)currentInvoiceTypeCandidate), StringUtils.trimToEmpty((String)currentClosingInvoicesIdsCandidate));
    }

    @Operation(summary="Invoice for Id")
    @GetMapping(value={"/{id}/"})
    public InvoiceCommon getById(@PathVariable(value="id") long id) {
        return this.invoiceRoute.byId(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Print Invoice for Id into PDF")
    @GetMapping(value={"/{id}/_print/"})
    public void printById(@PathVariable(value="id") long id, @Parameter(description="Option enable/disable Print 13b Paragraph", example="false") @RequestParam(name="option_print_13b_paragraph", defaultValue="false") boolean optionPrint13bParagraph, @Parameter(description="Option enable/disable Print Subcontractor Paragraph", example="false") @RequestParam(name="option_print_subcontractor_paragraph", defaultValue="false") boolean optionPrintSubcontractorParagraph, @Parameter(description="Option enable/disable Print Stromnetz Paragraph", example="false") @RequestParam(name="option_print_stromnetz", defaultValue="false") boolean optionPrintStromnetzParagraph, @Parameter(description="Option enable/disable Print a cumulative Invoice", example="false") @RequestParam(name="option_print_cumulative", defaultValue="false") boolean optionCumulativePrint, @Parameter(description="Option enable/disable Print measurements", example="false") @RequestParam(name="option_print_measurements", defaultValue="false") boolean optionMeasurementPrint, @Parameter(description="Option enable/disable Print cumulative measurements", example="false") @RequestParam(name="options_print_cumulative_measurements", defaultValue="false") boolean optionsPrintCumulativeMeasurements, @Parameter(description="Option enable/disable Remarks in cumulative measurements", example="false") @RequestParam(name="options_print_cumulative_measurements_consider_remarks", defaultValue="false") boolean optionsPrintCumulativeMeasurementsConsiderRemarks, @Parameter(description="Option include InvoiceAttachment (Ids) in Print (comma separated list)", example="1,2,3") @RequestParam(name="option_print_invoice_attachment_ids", defaultValue="") String optionPrintInvoiceAttachmentIds, @Parameter(description="Option changes wording of 'addendum' false = addendum / true = additional Position", example="false") @RequestParam(name="option_addendum_position_wording", defaultValue="false") boolean optionAddendumPositionWording, @Parameter(description="Option changes treatment of 'addendum' positions false = addendum as addendum position / true = addendum as normal position", example="false") @RequestParam(name="option_ignore_addendum", defaultValue="false") boolean optionIgnoreAddendum, @Parameter(description="Option for selected Attachments", example="") @RequestParam(name="attachments", defaultValue="") String attachments, @Parameter(description="Option for non selectable (custom text) attachments", example="") @RequestParam(name="additional_attachments", defaultValue="") String additionalAttachments, @Parameter(description="Additional footer text", example="") @RequestParam(name="footer_text", defaultValue="") String footerText, HttpServletResponse response) throws IOException {
        Class<InvoiceResource> clazz = InvoiceResource.class;
        synchronized (InvoiceResource.class) {
            Pair pdfContent = this.invoiceRoute.print(id, optionPrint13bParagraph, optionPrintSubcontractorParagraph, optionPrintStromnetzParagraph, optionCumulativePrint, optionMeasurementPrint, StringUtils.trimToEmpty((String)attachments), StringUtils.trimToEmpty((String)additionalAttachments), StringUtils.trimToEmpty((String)footerText), optionsPrintCumulativeMeasurements, optionsPrintCumulativeMeasurementsConsiderRemarks, (Boolean)MoreObjects.firstNonNull((Object)optionAddendumPositionWording, (Object)false) != false || (Boolean)MoreObjects.firstNonNull((Object)optionIgnoreAddendum, (Object)false) != false, optionPrintInvoiceAttachmentIds);
            AbstractResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/pdf");
            // ** MonitorExit[var17_16] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Print Invoice (PDF+XML+...) for Id into ZIP")
    @GetMapping(value={"/{id}/_print/zip/"}, produces={"application/octet-stream"})
    public void printByIdAsZip(@PathVariable(value="id") long id, @Parameter(description="Option enable/disable Print 13b Paragraph", example="false") @RequestParam(name="option_print_13b_paragraph", defaultValue="false") boolean optionPrint13bParagraph, @Parameter(description="Option enable/disable Print Subcontractor Paragraph", example="false") @RequestParam(name="option_print_subcontractor_paragraph", defaultValue="false") boolean optionPrintSubcontractorParagraph, @Parameter(description="Option enable/disable Print Stromnetz Paragraph", example="false") @RequestParam(name="option_print_stromnetz", defaultValue="false") boolean optionPrintStromnetzParagraph, @Parameter(description="Option enable/disable Print a cumulative Invoice", example="false") @RequestParam(name="option_print_cumulative", defaultValue="false") boolean optionCumulativePrint, @Parameter(description="Option enable/disable Print measurements", example="false") @RequestParam(name="option_print_measurements", defaultValue="false") boolean optionMeasurementPrint, @Parameter(description="Option enable/disable Print cumulative measurements", example="false") @RequestParam(name="options_print_cumulative_measurements", defaultValue="false") boolean optionsPrintCumulativeMeasurements, @Parameter(description="Option enable/disable Remarks in cumulative measurements", example="false") @RequestParam(name="options_print_cumulative_measurements_consider_remarks", defaultValue="false") boolean optionsPrintCumulativeMeasurementsConsiderRemarks, @Parameter(description="Option include InvoiceAttachment (Ids) in Print (comma separated list)", example="1,2,3") @RequestParam(name="option_print_invoice_attachment_ids", defaultValue="") String optionPrintInvoiceAttachmentIds, @Parameter(description="Option changes wording of 'addendum' false = addendum / true = additional Position", example="false") @RequestParam(name="option_addendum_position_wording", defaultValue="false") boolean optionAddendumPositionWording, @Parameter(description="Option for selected Attachments", example="") @RequestParam(name="attachments", defaultValue="") String attachments, @Parameter(description="Option for non selectable (custom text) attachments", example="") @RequestParam(name="additional_attachments", defaultValue="") String additionalAttachments, @Parameter(description="Additional footer text", example="") @RequestParam(name="footer_text", defaultValue="") String footerText, HttpServletResponse response) throws IOException, SQLException {
        Class<InvoiceResource> clazz = InvoiceResource.class;
        synchronized (InvoiceResource.class) {
            Pair pdfContent = this.invoiceRoute.printAsZip(id, optionPrint13bParagraph, optionPrintSubcontractorParagraph, optionPrintStromnetzParagraph, optionCumulativePrint, optionMeasurementPrint, StringUtils.trimToEmpty((String)attachments), StringUtils.trimToEmpty((String)additionalAttachments), StringUtils.trimToEmpty((String)footerText), optionsPrintCumulativeMeasurements, optionsPrintCumulativeMeasurementsConsiderRemarks, optionAddendumPositionWording, optionPrintInvoiceAttachmentIds);
            AbstractResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/octet-stream");
            // ** MonitorExit[var16_15] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Print Cumulative Measurement for Invoice-Id into PDF")
    @GetMapping(value={"/{id}/_print_measurements/"})
    public void printCumulativeMeasurementByInvoiceId(@PathVariable(value="id") long id, @Parameter(description="Option enable/disable Print a cumulative Invoice", example="false") @RequestParam(name="option_print_cumulative", defaultValue="false") boolean optionCumulativePrint, @RequestParam(name="option_print_cumulative_consider_remarks", defaultValue="false") boolean optionCumulativePrintConsiderRemarks, HttpServletResponse response) throws IOException {
        Class<InvoiceResource> clazz = InvoiceResource.class;
        synchronized (InvoiceResource.class) {
            Pair pdfContent = this.invoiceRoute.printAllMeasurements(id, optionCumulativePrint, optionCumulativePrintConsiderRemarks);
            AbstractResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/pdf");
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Print File(s) into ZIP by Invoice Ids")
    @PostMapping(value={"/_print/zip/"}, consumes={"application/json"}, produces={"application/zip"})
    public void printInvoicesIntoZIP(@Parameter(description="Invoice Ids to be printed") @Valid @RequestBody InvoiceBatchPrintRequest batchPrintRequest, HttpServletResponse response) throws IOException {
        Class<InvoiceResource> clazz = InvoiceResource.class;
        synchronized (InvoiceResource.class) {
            Iterable safeLongs = (Iterable)((Set)MoreObjects.firstNonNull((Object)batchPrintRequest.getInvoiceIds(), (Object)ImmutableSet.of())).stream().filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Pair content = this.invoiceRoute.printAsZIP(safeLongs);
            AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Operation(summary="Delete Invoice for Id")
    @DeleteMapping(value={"/{id}/"})
    public InvoiceCommon deleteById(@PathVariable(value="id") long id) {
        return this.invoiceRoute.delete(id);
    }

    @Operation(summary="Reset Invoice for Id")
    @PostMapping(value={"/{id}/_reset/"})
    public InvoiceCommon resetById(@PathVariable(value="id") long id) {
        return this.invoiceRoute.reset(id);
    }

    @Operation(summary="Create a Invoice")
    @PostMapping(value={"/"})
    public InvoiceCommon update(@RequestBody @Valid InvoiceUpdateRequest invoiceUpdateRequest) {
        return this.invoiceRoute.update(invoiceUpdateRequest);
    }

    @Operation(summary="Update Invoice for Id")
    @PostMapping(value={"/{id}/"})
    public InvoiceCommon updateForId(@PathVariable(value="id") long id, @RequestBody @Valid InvoiceUpdateRequest invoiceUpdateRequest) {
        return this.invoiceRoute.update(id, invoiceUpdateRequest);
    }

    @Deprecated(forRemoval=true)
    @Operation(summary="[DEPRECATED - use MeasurementResource.validate] Validate Measurements being accountable")
    @PostMapping(value={"/measurements/_validate/"})
    public MeasurementValidationResponse validate(@RequestBody @Valid MeasurementValidationRequest validationRequest) {
        return this.measurementRoute.validate(validationRequest);
    }

    @Operation(summary="Available Measurements for Stage")
    @GetMapping(value={"/measurements/_autocomplete/"})
    public InvoiceMeasurementAutoCompleteResponse autocomplete(@Parameter(description="Filter by StageId", example="1") @RequestParam(value="stage_id", required=false) Long stageId, @Parameter(description="Filter by 'any' Text", example="123abc") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.invoiceRoute.availableMeasurements(stageId, StringUtils.trimToEmpty((String)filterText));
    }

    @Operation(summary="Available Autocomplete Items for a new Invoice")
    @GetMapping(value={"/_new_invoice/_autocomplete/"})
    public NewInvoiceAutoCompleteResponse newInvoiceAutoComplete(@Parameter(description="Filter by 'any' Text", example="123abc") @RequestParam(value="filter_text", defaultValue="") String filterText) {
        return this.invoiceRoute.newInvoiceAutoComplete(StringUtils.trimToEmpty((String)filterText));
    }

    @Operation(summary="Create an initial Invoice Object based on PDF Upload")
    @PostMapping(value={"/_from_pdf/"})
    public CreditVoucherImportResultListCommon handleVoucherUpload(@RequestParam(value="multiPartFile") MultipartFile[] multiPartFiles) {
        return this.invoiceRoute.fromFile(multiPartFiles);
    }

    @Operation(summary="Create an Invoice Attachments for InvoiceId")
    @PostMapping(value={"/{id}/_attachments/"})
    public InvoiceAttachmentListCommon handleAttachmentUpload(@PathVariable(value="id") long id, @RequestParam(value="multiPartFile") MultipartFile[] multiPartFiles) throws IOException {
        return this.invoiceRoute.createAttachments(id, multiPartFiles);
    }

    @Operation(summary="Remove an Invoice Attachments for InvoiceId")
    @DeleteMapping(value={"/{invoiceId}/_attachments/{attachmentId}/"})
    public InvoiceAttachmentListCommon handleAttachmentRemove(@PathVariable(value="invoiceId") long invoiceId, @PathVariable(value="attachmentId") long attachmentId) {
        return this.invoiceRoute.deleteAttachment(invoiceId, attachmentId);
    }

    @Operation(summary="List Invoice Attachments by InvoiceId")
    @GetMapping(value={"/{id}/_attachments/"})
    public InvoiceAttachmentListCommon listAttachments(@PathVariable(value="id") long id) {
        return this.invoiceRoute.listAttachments(id);
    }

    @Operation(summary="Create an difference correction position, if needed")
    @PostMapping(value={"/{id}/_fix_difference/"})
    public InvoiceCommon fixDifference(@PathVariable(value="id") long id) {
        return this.invoiceRoute.fixDifference(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set new State for Invoice with Id")
    @PostMapping(value={"/{id}/_state/ACCOUNTED/"}, consumes={"application/json"}, produces={"application/json"})
    public InvoiceCommon updateStateForId(@Parameter(description="Id of the Invoice to Change State", required=true) @PathVariable(value="id") long id, @Parameter(description="optional payload for State Change") @RequestBody(required=false) @Valid InvoiceAccountRequest request) throws FileNotFoundException {
        Class<InvoiceResource> clazz = InvoiceResource.class;
        synchronized (InvoiceResource.class) {
            InvoiceAccountRequest safeRequest = (InvoiceAccountRequest)MoreObjects.firstNonNull((Object)request, (Object)InvoiceAccountRequest.empty());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return this.invoiceRoute.accountById(id, safeRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set new State for Invoice with Id")
    @PostMapping(value={"/{id}/_state/ACCOUNTED/_pdf/"}, consumes={"application/json"}, produces={"application/pdf"})
    public void updateStateForIdAndPrint(@Parameter(description="Id of the Invoice to Change State", required=true) @PathVariable(value="id") long id, @Parameter(description="optional payload for State Change") @RequestBody(required=false) @Valid InvoiceAccountRequest request, HttpServletResponse response) throws IOException {
        InvoiceAccountRequest safeRequest = (InvoiceAccountRequest)MoreObjects.firstNonNull((Object)request, (Object)InvoiceAccountRequest.empty());
        Class<InvoiceResource> clazz = InvoiceResource.class;
        synchronized (InvoiceResource.class) {
            Pair pdfContent = this.invoiceRoute.accountAndPrintById(id, safeRequest);
            AbstractResource.writeToStream((HttpServletResponse)response, (Pair)pdfContent, (String)"application/pdf");
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(summary="Set new State for Invoice with Id")
    @PostMapping(value={"/{id}/_state/CANCELLED/"}, consumes={"application/json"}, produces={"application/json"})
    public InvoiceCommon updateStateForId(@Parameter(description="Id of the Invoice to Change State", required=true) @PathVariable(value="id") long id, @Parameter(description="optional payload for State Change") @RequestBody(required=false) @Valid InvoiceCancelRequest request) {
        Class<InvoiceResource> clazz = InvoiceResource.class;
        synchronized (InvoiceResource.class) {
            InvoiceCancelRequest safeRequest = (InvoiceCancelRequest)MoreObjects.firstNonNull((Object)request, (Object)InvoiceCancelRequest.empty());
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return this.invoiceRoute.cancelById(id, safeRequest);
        }
    }

    @Operation(summary="Export File for Diamant by Invoice Ids")
    @PostMapping(value={"/_er2_export/zip/"}, consumes={"application/json"}, produces={"application/octet-stream"})
    public void exportToER2(@Parameter(description=" Invoice Ids to be exported") @Valid @RequestBody InvoiceER2BatchExportRequest request, HttpServletResponse response) throws IOException {
        Pair content = this.invoiceRoute.exportToER2AsZIP(request.getInvoiceIds());
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"text/plain");
    }

    @Operation(summary="XLS File for provided Invoice Ids")
    @PostMapping(value={"/_xls/"}, consumes={"application/json"}, produces={"application/octet-stream"})
    public void exportToXLS(@Parameter(description="Payroll Month Ids to be exported") @Valid @RequestBody InvoiceXLSBatchExportRequest batchExportRequest, HttpServletResponse response) throws IOException {
        Pair content = this.invoiceRoute.exportToXLS(batchExportRequest.getInvoiceIds());
        AbstractResource.writeToStream((HttpServletResponse)response, (Pair)content, (String)"application/octet-stream");
    }

    public InvoiceResource(MeasurementRoute measurementRoute, InvoiceRoute invoiceRoute) {
        this.measurementRoute = measurementRoute;
        this.invoiceRoute = invoiceRoute;
    }
}

