/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.response.history.v1.HistoryItemCommon;
import de.qfm.erp.common.response.history.v1.HistoryItemPageCommon;
import de.qfm.erp.service.service.route.HistoryItemRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="History Resource", name="HistoryResource")
@OpenAPIDefinition(tags={@Tag(name="HistoryResource", description="All Operations around History")})
@RestController
@RequestMapping(value={"/api/v1/erp/history"})
public class HistoryResourceV1 {
    private static final Logger log = LogManager.getLogger(HistoryResourceV1.class);
    private final HistoryItemRoute route;

    @Operation(summary="HistoryItem List / Paging")
    @GetMapping(value={"/"})
    public HistoryItemPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.page(page, size);
    }

    @Operation(summary="HistoryItem for Id")
    @GetMapping(value={"/{id}/"})
    public HistoryItemCommon getById(@PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Paged HistoryItems for Class and EntityId, sorted by Creation Date Descending")
    @GetMapping(value={"/{entity_clazz}/{entity_id}/"}, produces={"application/json"})
    public HistoryItemPageCommon getByClassAndId(@Parameter(example="MEASUREMENT", description="The Entity Class of the Required History", required=true) @PathVariable(value="entity_clazz") String entityClazzCandidate, @Parameter(description="The Entity Id of the Required History", required=true) @PathVariable(value="entity_id") long entityId, @Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="100") @RequestParam(value="size", defaultValue="100") int size) {
        return this.route.pageForEntity(entityClazzCandidate, entityId, page, size);
    }

    public HistoryResourceV1(HistoryItemRoute route) {
        this.route = route;
    }
}

