/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.resource;

import de.qfm.erp.common.request.generic.DictionaryItemUpdateRequest;
import de.qfm.erp.common.response.generic.DictionaryItemCommon;
import de.qfm.erp.common.response.generic.DictionaryItemPageCommon;
import de.qfm.erp.common.response.generic.DictionarySubItemListCommon;
import de.qfm.erp.service.service.route.DictionaryItemRoute;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(description="Dictionary Item Management Resource", name="DictionaryItemResource")
@OpenAPIDefinition(tags={@Tag(name="DictionaryItemResource", description="All Operations around Dictionary Items")})
@ApiResponses(value={@ApiResponse(responseCode="200", description="Successfully retrieved Entity / List"), @ApiResponse(responseCode="401", description="You are not authorized to view the resource"), @ApiResponse(responseCode="403", description="Accessing the resource you were trying to reach is forbidden"), @ApiResponse(responseCode="404", description="The resource you were trying to reach is not found")})
@RestController
@RequestMapping(value={"/api/v1/erp/dictionary_items"})
public class DictionaryItemResource {
    private static final Logger log = LogManager.getLogger(DictionaryItemResource.class);
    private final DictionaryItemRoute route;

    @Operation(summary="Dictionary Items List / Paging")
    @GetMapping(value={"/"}, produces={"application/json"})
    public DictionaryItemPageCommon list(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size, @Parameter(name="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(name="Include Hidden", example="false") @RequestParam(value="include_hidden", defaultValue="false") boolean includeHidden) {
        return this.route.page(page, size, StringUtils.trimToEmpty((String)filterText), includeHidden);
    }

    @Operation(summary="Dictionary Subtype Items List / Paging")
    @GetMapping(value={"/subtypes/{entity_clazz}/"}, produces={"application/json"})
    public DictionarySubItemListCommon listSubType(@Parameter(example="PAYROLL_ITEM_TYPE", name="The Entity Class of the Required Dictionary Item (EEntityClass.class)", required=true) @PathVariable(value="entity_clazz") String entityClazzCandidate) {
        return this.route.listSubType(entityClazzCandidate);
    }

    @Operation(summary="Dictionary Item for Id")
    @GetMapping(value={"/{id}/"}, produces={"application/json"})
    public DictionaryItemCommon getById(@Parameter(description="Dictionary Item Id of the Entity to retrieve", required=true) @PathVariable(value="id") long id) {
        return this.route.byId(id);
    }

    @Operation(summary="Create Dictionary Item")
    @PostMapping(value={"/"}, consumes={"application/json"}, produces={"application/json"})
    public DictionaryItemCommon create(@Valid @RequestBody DictionaryItemUpdateRequest updateRequest) {
        return this.route.create(updateRequest);
    }

    @Operation(summary="Update Dictionary Item by Id")
    @PostMapping(value={"/{id}/"}, consumes={"application/json"}, produces={"application/json"})
    public DictionaryItemCommon updateById(@Parameter(description="Dictionary Item Id of the Entity to update", required=true) @PathVariable(value="id") long id, @Valid @RequestBody DictionaryItemUpdateRequest updateRequest) {
        return this.route.update(id, updateRequest);
    }

    @Operation(summary="Paged Dictionary Items for Class and EntityId")
    @GetMapping(value={"/{entity_clazz}/{entity_id}/"}, produces={"application/json"})
    public DictionaryItemPageCommon getByClassAndId(@Parameter(example="PAYROLL_ITEM_TYPE", description="The Entity Class of the Required Dictionary Item (EEntityClass.class)", required=true) @PathVariable(value="entity_clazz") String entityClazzCandidate, @Parameter(description="The Entity Id of the Required Dictionary Items", required=true) @PathVariable(value="entity_id") long entityId, @Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="100") @RequestParam(value="size", defaultValue="100") int size, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="Include Hidden", example="false") @RequestParam(value="include_hidden", defaultValue="false") boolean includeHidden) {
        return this.route.pageForEntity(entityClazzCandidate, entityId, page, size, StringUtils.trimToEmpty((String)filterText), includeHidden);
    }

    @Operation(summary="Paged Dictionary Items for Class")
    @GetMapping(value={"/clazz={entity_clazz}/"}, produces={"application/json"})
    public DictionaryItemPageCommon getByClass(@Parameter(example="PAYROLL_ITEM_TYPE, CONSTRUCTION_SITE, SALUTATION, AUTHORITY_TO_SIGN", description="The Entity Class of the Required Dictionary Item", required=true) @PathVariable(value="entity_clazz") String entityClazzCandidate, @Parameter(description="The Page index starting at 0", example="0") @RequestParam(value="page", defaultValue="0") int page, @Parameter(description="The Page Size", example="100") @RequestParam(value="size", defaultValue="100") int size, @Parameter(description="Filter by 'any' Text", example="") @RequestParam(value="filter_text", defaultValue="") String filterText, @Parameter(description="Include Hidden", example="false") @RequestParam(value="include_hidden", defaultValue="false") boolean includeHidden) {
        return this.route.pageForEntity(entityClazzCandidate, page, size, StringUtils.trimToEmpty((String)filterText), includeHidden);
    }

    public DictionaryItemResource(DictionaryItemRoute route) {
        this.route = route;
    }
}

