/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.repository;

import de.qfm.erp.service.model.internal.invoice.AddendumDiscount;
import de.qfm.erp.service.model.internal.quotation.StageIdTypeState;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.EER2ExportState;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.search.ESearchIndexState;
import jakarta.persistence.QueryHint;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.repository.query.Param;

public interface QuotationRepository
extends JpaRepository<Quotation, Long>,
JpaSpecificationExecutor<Quotation> {
    @Query(value="select q from Quotation q")
    @QueryHints(value={@QueryHint(name="org.hibernate.fetchSize", value="25")})
    public Stream<Quotation> streamAll();

    @Nonnull
    public Optional<Quotation> findFirstQuotationByQuotationNumberOrderByAddendumNumberAsc(@NonNull String var1);

    @Nonnull
    public Optional<Quotation> findFirstQuotationByQuotationNumberAndVersionIsNullOrderByAddendumNumberAsc(@NonNull String var1);

    @Nonnull
    public Optional<Quotation> findFirstQuotationByQuotationNumberAndVersionOrderByAddendumNumberAsc(@NonNull String var1, @NonNull Integer var2);

    @Nonnull
    public Optional<Quotation> findQuotationByQuotationNumberEqualsAndAddendumNumberEquals(@NonNull String var1, @NonNull Long var2);

    @Query(value="select s from Quotation s where s.qNumber = :stageNumber")
    @Nonnull
    public List<Quotation> findByStageNumber(@Param(value="stageNumber") @NonNull String var1, @NonNull Pageable var2);

    @Nonnull
    public Optional<Quotation> findByReferenceId(@NonNull String var1);

    @Nonnull
    public List<Quotation> findAllByQuotationNumberAndVersionIsNull(@NonNull String var1);

    @Nonnull
    public List<Quotation> findAllByQuotationNumberAndVersion(@NonNull String var1, @NonNull Integer var2);

    @Nonnull
    @Query(value="select distinct concat(cp.firstName, ' ', cp.lastName) from Quotation q join q.contactPerson cp where q.id = :id AND (lower(cp.lastName) like %:filter% OR lower(cp.firstName) like %:filter%)")
    public List<String> personAutoComplete(@Param(value="id") long var1, @Param(value="filter") @NonNull String var3);

    @Nonnull
    @Query(value="select distinct new de.qfm.erp.service.model.internal.invoice.AddendumDiscount(q.id, q.quotationNumber, q.qNumber, q.addendumNumber, q.generalDiscount, q.otherDiscount, q.version) from  Quotation q where  q.id in (   select qi1.id    from Quotation qi1    where qi1.id = :stageId )  OR q.id in (  select si2.id   from Quotation qi2       left join qi2.qEntity qei2       left join qei2.stages si2  where        qi2.id = :stageId AND qi2.qEntity = si2.qEntity AND si2.stageType in :stageTypes AND si2.stageState in :stageStates )")
    public List<AddendumDiscount> allStageDiscountsOfTypeByStageId(@Param(value="stageId") Long var1, @Param(value="stageTypes") @NonNull Iterable<EQStageType> var2, @Param(value="stageStates") @NonNull Iterable<EQStageState> var3);

    @Nonnull
    @Query(value="select new de.qfm.erp.service.model.internal.quotation.StageIdTypeState(q.id, q.stageType, q.stageState) from  Quotation q  join q.qEntity e where  e.id = :entityId  AND  q.stageType in :stageTypes ")
    public List<StageIdTypeState> fetchStageIdTypeState(@Param(value="entityId") @NonNull Long var1, @Param(value="stageTypes") @NonNull Iterable<EQStageType> var2);

    @Nonnull
    @Query(value="select new de.qfm.erp.service.model.internal.invoice.AddendumDiscount(s.id, s.quotationNumber, s.qNumber, s.addendumNumber, s.generalDiscount, s.otherDiscount, s.version) from  QEntity qe  left join qe.stages s where  qe.id = :entityId  AND (s.stageType in :stageTypes AND s.stageState in :stageStates)")
    public List<AddendumDiscount> allStageDiscountsOfTypeByEntityId(@Param(value="entityId") Long var1, @Param(value="stageTypes") @NonNull Iterable<EQStageType> var2, @Param(value="stageStates") @NonNull Iterable<EQStageState> var3);

    @Modifying
    @Query(value="update Quotation q set q.alias = :alias, q.aliasChanged = :aliasChanged where q.id in :stageId")
    public int patchAlias(@Param(value="stageId") @NonNull Long var1, @Param(value="alias") @NonNull String var2, @Param(value="aliasChanged") @NonNull Boolean var3);

    @Modifying
    @Query(value="update Quotation q set q.er2ExportedOn = :er2ExportedOn, q.er2ExportedToPath = :er2ExportedToPath, q.er2ExportState = :er2ExportState where q.id in :stageId")
    public int patchER2(@Param(value="stageId") @NonNull Long var1, @Param(value="er2ExportedOn") @NonNull LocalDateTime var2, @Param(value="er2ExportedToPath") @NonNull String var3, @Param(value="er2ExportState") @NonNull EER2ExportState var4);

    @Modifying
    @Query(value="update Quotation q set q.project = :project where q.id in :stageId")
    public int patchProject(@Param(value="stageId") @NonNull Long var1, @Param(value="project") @NonNull Project var2);

    @Query(value="select max(q.version) from Quotation q join q.qEntity e where q.version IS NOT NULL AND e.id = :entityId")
    public Optional<Integer> maxVersion(@Param(value="entityId") Long var1);

    @Modifying
    @Query(value="update Quotation q set q.lastInvoice = :invoice where q = :stage")
    public void applyLastInvoice(@Param(value="stage") @NonNull Quotation var1, @Param(value="invoice") @NonNull Invoice var2);

    @Modifying
    @Query(value="update Quotation q set q.finalInvoice = :invoice where q = :stage")
    public void applyFinalInvoice(@Param(value="stage") @NonNull Quotation var1, @Param(value="invoice") @NonNull Invoice var2);

    @Query(value="select distinct qp.quotation from MeasurementPosition mp join mp.quotationPosition qp where  mp.measurement = :measurement AND   qp.quotation IS NOT NULL")
    public Iterable<Quotation> stagesUsedInPositions(@Param(value="measurement") @NonNull Measurement var1);

    @Query(value="select distinct q from  Quotation q   join q.quotationPositions qp where  qp.referencePosition in :referencePositions AND   q.qEntity = :entity AND   q.stageType in :propagationRecipientStageTypes ")
    public List<Quotation> allWithReferencePosition(@Param(value="entity") @NonNull QEntity var1, @Param(value="referencePositions") @NonNull Iterable<QuotationPosition> var2, @Param(value="propagationRecipientStageTypes") @NonNull Iterable<EQStageType> var3);

    @Nonnull
    public List<Quotation> findAllByEr2ExportState(@NonNull EER2ExportState var1, @NonNull Sort var2);

    @Query(value="select q from Quotation q where q.stageType = :stageType AND q.reference = :referenceStage")
    @Nonnull
    public Optional<Quotation> costUnitForCostEstimate(@NonNull EQStageType var1, @NonNull Quotation var2);

    @Query(value="SELECT q FROM Quotation q WHERE   q.searchIndexState in :searchIndexStates")
    @Nonnull
    public List<Quotation> findAllUnIndexed(@Param(value="searchIndexStates") @NonNull Iterable<ESearchIndexState> var1, @NonNull Pageable var2);

    @Modifying
    @Query(value="update Quotation q set q.searchIndexState = :searchIndexState where q.id in :stageIds")
    public int updateSearchIndexState(@Param(value="searchIndexState") @NonNull ESearchIndexState var1, @Param(value="stageIds") @NonNull Iterable<Long> var2);
}

